/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.databases;

import com.stimulsoft.base.StiBaseOptions;
import com.stimulsoft.base.StiJsonConverterVersion;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiJsonToDataSetConverter;
import com.stimulsoft.report.StiNameCreation;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataColumnsCollection;
import com.stimulsoft.report.dictionary.StiDatabaseInformation;
import com.stimulsoft.report.dictionary.adapters.StiAbstractAdapter;
import com.stimulsoft.report.dictionary.data.DataSet;
import com.stimulsoft.report.dictionary.data.DataTable;
import com.stimulsoft.report.dictionary.dataSources.StiDataStoreSource;
import com.stimulsoft.report.dictionary.dataSources.StiDataTableSource;
import com.stimulsoft.report.dictionary.databases.StiDatabase;
import com.stimulsoft.report.json.StiJsonToDataSetConverterV2;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.Iterator;

public class StiJsonDatabase
extends StiDatabase {
    private String pathData = null;
    private InputStream dataIS = null;
    private JSONObject jsonObject = null;
    private String jsonData = null;

    public StiJsonDatabase() {
        this("", "");
    }

    public StiJsonDatabase(String name) {
        super(name);
    }

    public StiJsonDatabase(String name, String pathData) {
        super(name);
        this.pathData = pathData;
    }

    public StiJsonDatabase(String name, File pathData) {
        super(name);
        this.pathData = pathData.getAbsolutePath();
    }

    public StiJsonDatabase(String name, InputStream dataIS) {
        super(name);
        this.dataIS = dataIS;
    }

    @Override
    public String getServiceName() {
        return "JSON";
    }

    @StiSerializable
    public final String getPathData() {
        return this.pathData;
    }

    public final void setPathData(String value) {
        this.pathData = value;
    }

    @Override
    public void connect(StiDataStoreSource source) {
        this.connect(source, true);
    }

    @Override
    public void connect(StiDataStoreSource source, Boolean fillTable) {
        try {
            if (this.jsonObject == null) {
                this.jsonObject = this.getJSONObject();
            }
            if (fillTable.booleanValue()) {
                this.fillTable(source);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getJsonData() {
        return this.jsonData;
    }

    public void setJsonData(String jsonData) {
        this.jsonData = jsonData;
    }

    @StiSerializable
    public String getEmbeddedData() {
        return this.jsonData;
    }

    public void setEmbeddedData(String embeddedData) {
        this.jsonData = embeddedData;
    }

    @Override
    public void disconnect() {
        this.jsonObject = null;
    }

    public void fillTable(StiDataStoreSource source) throws FileNotFoundException, JSONException, IOException {
        DataSet dataSet = StiBaseOptions.getDefaultJsonConverterVersion() == StiJsonConverterVersion.ConverterV1 ? StiJsonToDataSetConverter.getDataTable(this.getJSONObject()) : StiJsonToDataSetConverterV2.getDataSet(this.getJSONObject());
        for (DataTable table : dataSet.getTables()) {
            if (!source.getNameInSource().equals(table.getName()) && !source.getNameInSource().endsWith("." + table.getName())) continue;
            source.setDataTable(table);
        }
    }

    public JSONObject getJSONObject() throws FileNotFoundException, JSONException, IOException {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        if (StiValidationUtil.isNotNullOrEmpty((String)this.pathData)) {
            InputStream fos = this.getDataInputStream();
            JSONObject result = new JSONObject(StiIOUtil.toString((InputStream)fos));
            fos.close();
            return result;
        }
        if (this.dataIS != null && this.dataIS.markSupported()) {
            try {
                this.dataIS.reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.getEmbeddedData() != null) {
            return new JSONObject(this.getEmbeddedData());
        }
        return new JSONObject(StiIOUtil.toString((InputStream)this.dataIS));
    }

    public InputStream getDataInputStream() {
        try {
            InputStream result = null;
            result = StiValidationUtil.isNotNullOrEmpty((String)this.pathData) ? (new File(this.pathData).exists() ? new FileInputStream(this.pathData) : new URL(this.pathData).openStream()) : this.dataIS;
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public StiDatabaseInformation getDatabaseInformation(Connection con, StiAbstractAdapter adapter) throws Exception {
        StiDatabaseInformation info = new StiDatabaseInformation();
        DataSet dataSet = StiBaseOptions.getDefaultJsonConverterVersion() == StiJsonConverterVersion.ConverterV1 ? StiJsonToDataSetConverter.getDataTable(this.getJSONObject()) : StiJsonToDataSetConverterV2.getDataSet(this.getJSONObject());
        for (DataTable table : dataSet.getTables()) {
            if (table == null) continue;
            DataTable dTable = new DataTable(table.getName(), new StiDataColumnsCollection());
            Iterator i$ = table.getColumns().iterator();
            while (i$.hasNext()) {
                StiDataColumn field = (StiDataColumn)i$.next();
                dTable.getColumns().add(new StiDataColumn(field.getName(), field.getName(), field.getSystemType()));
            }
            info.getTables().add(dTable);
        }
        return info;
    }

    @Override
    public void applyDatabaseInformation(StiDatabaseInformation information, StiReport report, StiDatabaseInformation informationAll) {
        for (DataTable dataTable : information.getTables()) {
            StiDataTableSource source = new StiDataTableSource(this.getName() + "." + dataTable.getTableName(), StiNameCreation.createName(report, dataTable.getTableName(), false, false, true));
            Iterator i$ = dataTable.getColumns().iterator();
            while (i$.hasNext()) {
                StiDataColumn dataColumn = (StiDataColumn)i$.next();
                StiDataColumn column = new StiDataColumn(dataColumn.getName(), dataColumn.getName(), dataColumn.getSystemType());
                source.getColumns().add(column);
                column.setDataSource(source);
            }
            report.getDictionary().getDataSources().add(source);
            source.setDictionary(report.getDictionary());
        }
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyStringNullOfEmpty("PathData", this.getPathData());
        jObject.AddPropertyStringNullOfEmpty("EmbeddedData", this.getEmbeddedData());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("PathData")) {
                this.setPathData((String)property.Value);
                continue;
            }
            if (property.Name.equals("EmbeddedData")) {
                this.setEmbeddedData((String)property.Value);
                continue;
            }
            if (!property.Name.equals("XmlType")) continue;
        }
    }
}

