/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.databases;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.report.dictionary.adapters.StiAbstractAdapter;
import com.stimulsoft.report.dictionary.adapters.StiMsSqlAdapter;
import com.stimulsoft.report.dictionary.databases.StiJDBCDatabase;
import java.security.NoSuchAlgorithmException;

public class StiSqlDatabase
extends StiJDBCDatabase {
    public StiSqlDatabase() {
    }

    public StiSqlDatabase(String name, String connectionString) {
        super(name, connectionString);
    }

    public StiSqlDatabase(String name, String alias, String connectionString) {
        super(name, alias, connectionString);
    }

    @Override
    protected StiAbstractAdapter getAdapter(String connectionString) {
        return new StiMsSqlAdapter(connectionString);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        try {
            jObject.AddPropertyStringNullOfEmpty("ConnectionStringEncrypted", this.getConnectionStringEncrypted());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        jObject.AddPropertyBool("PromptUserNameAndPassword", this.getPromptUserNameAndPassword());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("ConnectionStringEncrypted")) {
                try {
                    this.setConnectionStringEncrypted((String)property.Value);
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!property.Name.equals("PromptUserNameAndPassword")) continue;
            this.setPromptUserNameAndPassword((Boolean)property.Value);
        }
    }
}

