/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine;

import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiImageProcessingDuplicatesType;
import com.stimulsoft.report.components.enums.StiProcessingDuplicatesType;
import com.stimulsoft.report.components.interfaces.IStiText;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;

public final class StiPostProcessDuplicatesHelper {
    private static boolean IsImageEqual(String image1, String image2) {
        return image1.equals(image2);
    }

    public static void PostProcessDuplicates(ArrayList<StiComponent> comps, Hashtable parentCont) {
        StiPostProcessDuplicatesHelper.PostProcessDuplicates(comps, parentCont, TypeOfDuplicates.Text);
        StiPostProcessDuplicatesHelper.PostProcessDuplicates(comps, parentCont, TypeOfDuplicates.Image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void PostProcessDuplicates(ArrayList<StiComponent> comps, Hashtable parentCont, TypeOfDuplicates typeOfDuplicates) {
        LinkedHashMap<Double, ArrayList<StiComponent>> coordX;
        LinkedHashMap widths = new LinkedHashMap();
        boolean requre = false;
        StiComponentsCollection components = new StiComponentsCollection();
        ArrayList<StiComponent> arrayList = comps;
        synchronized (arrayList) {
            for (StiComponent comp : comps) {
                ArrayList<StiComponent> coordY;
                if ((!(comp instanceof IStiText) || ((IStiText)((Object)comp)).getProcessingDuplicates() == StiProcessingDuplicatesType.None || typeOfDuplicates != TypeOfDuplicates.Text) && (!(comp instanceof StiImage) || ((StiImage)comp).getProcessingDuplicates() == StiImageProcessingDuplicatesType.None || typeOfDuplicates != TypeOfDuplicates.Image)) continue;
                requre = true;
                components.add(comp);
                LinkedHashMap<Double, ArrayList<StiComponent>> linkedHashMap = coordX = widths.get(comp.getWidth()) instanceof LinkedHashMap ? (LinkedHashMap<Double, ArrayList<StiComponent>>)widths.get(comp.getWidth()) : null;
                if (coordX == null) {
                    coordX = new LinkedHashMap<Double, ArrayList<StiComponent>>();
                    widths.put(comp.getWidth(), coordX);
                }
                if ((coordY = (ArrayList<StiComponent>)(coordX.get(comp.getLeft()) instanceof ArrayList ? coordX.get(comp.getLeft()) : null)) == null) {
                    coordY = new ArrayList<StiComponent>();
                    coordX.put(comp.getLeft(), coordY);
                }
                coordY.add(comp);
            }
        }
        if (!requre) {
            return;
        }
        Iterator i$ = widths.keySet().iterator();
        while (i$.hasNext()) {
            double wd = (Double)i$.next();
            coordX = widths.get(wd) instanceof LinkedHashMap ? (LinkedHashMap)widths.get(wd) : null;
            Iterator i$2 = coordX.keySet().iterator();
            while (i$2.hasNext()) {
                double cdX = (Double)i$2.next();
                ArrayList coordY = coordX.get(cdX) instanceof ArrayList ? (ArrayList)coordX.get(cdX) : null;
                Collections.sort(coordY, new StiMergeComparer());
                block6: for (int index = 0; index < coordY.size(); ++index) {
                    StiComponent component = coordY.get(index) instanceof StiComponent ? coordY.get(index) : null;
                    StiContainer cont = parentCont.get(component) instanceof StiContainer ? parentCont.get(component) : null;
                    double bottom = component.getBottom();
                    int startIndex = index + 1;
                    while (startIndex < coordY.size()) {
                        StiComponent componentTo = coordY.get(startIndex) instanceof StiComponent ? coordY.get(startIndex) : null;
                        StiContainer contTo = parentCont.get(componentTo) instanceof StiContainer ? parentCont.get(componentTo) : null;
                        boolean isGlobal = false;
                        if (typeOfDuplicates == TypeOfDuplicates.Text) {
                            isGlobal = ((IStiText)((Object)component)).getProcessingDuplicates() == StiProcessingDuplicatesType.GlobalHide || ((IStiText)((Object)component)).getProcessingDuplicates() == StiProcessingDuplicatesType.GlobalMerge || ((IStiText)((Object)component)).getProcessingDuplicates() == StiProcessingDuplicatesType.GlobalRemoveText;
                        } else {
                            boolean bl = isGlobal = ((StiImage)component).getProcessingDuplicates() == StiImageProcessingDuplicatesType.GlobalHide || ((StiImage)component).getProcessingDuplicates() == StiImageProcessingDuplicatesType.GlobalMerge || ((StiImage)component).getProcessingDuplicates() == StiImageProcessingDuplicatesType.GlobalRemoveImage;
                        }
                        if (componentTo.getName().equals(component.getName()) || isGlobal) {
                            if (StiMath.round((double)cont.getBottom(), (int)2) != StiMath.round((double)contTo.getTop(), (int)2) || !cont.getName().equals(contTo.getName()) && !isGlobal) continue block6;
                            if (typeOfDuplicates == TypeOfDuplicates.Text) {
                                String componentToString = ((IStiText)((Object)componentTo)).getTextInternal();
                                String componentString = ((IStiText)((Object)component)).getTextInternal();
                                if (((IStiText)((Object)component)).getProcessingDuplicates() == StiProcessingDuplicatesType.BasedOnTagHide || ((IStiText)((Object)component)).getProcessingDuplicates() == StiProcessingDuplicatesType.BasedOnTagMerge || ((IStiText)((Object)component)).getProcessingDuplicates() == StiProcessingDuplicatesType.BasedOnTagRemoveText) {
                                    componentToString = componentTo.getTagValue() == null ? "" : componentTo.getTagValue().toString();
                                    String string = componentString = component.getTagValue() == null ? "" : component.getTagValue().toString();
                                }
                                if (!((double)Math.round(componentTo.getTop() * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0) >= (double)Math.round(bottom * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0)) || !componentToString.equals(componentString)) continue block6;
                                if (((IStiText)((Object)component)).getProcessingDuplicates() == StiProcessingDuplicatesType.Merge || ((IStiText)((Object)component)).getProcessingDuplicates() == StiProcessingDuplicatesType.GlobalMerge || ((IStiText)((Object)component)).getProcessingDuplicates() == StiProcessingDuplicatesType.BasedOnTagMerge) {
                                    component.setHeight(component.getHeight() + componentTo.getBottom() - component.getBottom());
                                }
                                if (((IStiText)((Object)component)).getProcessingDuplicates() == StiProcessingDuplicatesType.RemoveText || ((IStiText)((Object)component)).getProcessingDuplicates() == StiProcessingDuplicatesType.GlobalRemoveText || ((IStiText)((Object)component)).getProcessingDuplicates() == StiProcessingDuplicatesType.BasedOnTagRemoveText) {
                                    ((IStiText)((Object)componentTo)).setTextInternal("");
                                    ++index;
                                    ++startIndex;
                                } else {
                                    bottom += componentTo.getHeight();
                                    componentTo.getParent().getComponents().remove(componentTo);
                                    coordY.remove(startIndex);
                                }
                            } else if (typeOfDuplicates == TypeOfDuplicates.Image) {
                                if (!((double)Math.round(componentTo.getTop() * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0) >= (double)Math.round(bottom * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0)) || !StiPostProcessDuplicatesHelper.IsImageEqual(((StiImage)componentTo).getImageBytesToDraw(), ((StiImage)component).getImageBytesToDraw())) continue block6;
                                if (((StiImage)component).getProcessingDuplicates() == StiImageProcessingDuplicatesType.Merge || ((StiImage)component).getProcessingDuplicates() == StiImageProcessingDuplicatesType.GlobalMerge) {
                                    component.setHeight(component.getHeight() + componentTo.getBottom() - component.getBottom());
                                }
                                if (((StiImage)component).getProcessingDuplicates() == StiImageProcessingDuplicatesType.RemoveImage || ((StiImage)component).getProcessingDuplicates() == StiImageProcessingDuplicatesType.GlobalRemoveImage) {
                                    ((StiImage)componentTo).setImageBytesToDraw(null);
                                    ++index;
                                    ++startIndex;
                                } else {
                                    bottom += componentTo.getHeight();
                                    componentTo.getParent().getComponents().remove(componentTo);
                                    coordY.remove(startIndex);
                                }
                            }
                        } else {
                            ++startIndex;
                        }
                        cont = contTo;
                    }
                }
            }
        }
    }

    public static void PostProcessDuplicates(StiComponentsCollection comps, Hashtable parentCont) {
        StiPostProcessDuplicatesHelper.PostProcessDuplicates(comps, parentCont, TypeOfDuplicates.Text);
        StiPostProcessDuplicatesHelper.PostProcessDuplicates(comps, parentCont, TypeOfDuplicates.Image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void PostProcessDuplicates(StiComponentsCollection comps, Hashtable parentCont, TypeOfDuplicates typeOfDuplicates) {
        LinkedHashMap<Double, ArrayList<StiComponent>> coordX;
        LinkedHashMap widths = new LinkedHashMap();
        boolean requre = false;
        StiComponentsCollection components = new StiComponentsCollection();
        StiComponentsCollection stiComponentsCollection = comps;
        synchronized (stiComponentsCollection) {
            for (StiComponent comp : comps) {
                ArrayList<StiComponent> coordY;
                if ((!(comp instanceof IStiText) || ((IStiText)((Object)comp)).getProcessingDuplicates() == StiProcessingDuplicatesType.None || typeOfDuplicates != TypeOfDuplicates.Text) && (!(comp instanceof StiImage) || ((StiImage)comp).getProcessingDuplicates() == StiImageProcessingDuplicatesType.None || typeOfDuplicates != TypeOfDuplicates.Image)) continue;
                requre = true;
                components.add(comp);
                LinkedHashMap<Double, ArrayList<StiComponent>> linkedHashMap = coordX = widths.get(comp.getWidth()) instanceof LinkedHashMap ? (LinkedHashMap<Double, ArrayList<StiComponent>>)widths.get(comp.getWidth()) : null;
                if (coordX == null) {
                    coordX = new LinkedHashMap<Double, ArrayList<StiComponent>>();
                    widths.put(comp.getWidth(), coordX);
                }
                if ((coordY = (ArrayList<StiComponent>)(coordX.get(comp.getLeft()) instanceof ArrayList ? coordX.get(comp.getLeft()) : null)) == null) {
                    coordY = new ArrayList<StiComponent>();
                    coordX.put(comp.getLeft(), coordY);
                }
                coordY.add(comp);
            }
        }
        if (!requre) {
            return;
        }
        Iterator i$ = widths.keySet().iterator();
        while (i$.hasNext()) {
            double wd = (Double)i$.next();
            coordX = widths.get(wd) instanceof LinkedHashMap ? (LinkedHashMap)widths.get(wd) : null;
            Iterator i$2 = coordX.keySet().iterator();
            while (i$2.hasNext()) {
                double cdX = (Double)i$2.next();
                ArrayList coordY = coordX.get(cdX) instanceof ArrayList ? (ArrayList)coordX.get(cdX) : null;
                Collections.sort(coordY, new StiMergeComparer());
                block6: for (int index = 0; index < coordY.size(); ++index) {
                    StiComponent component = coordY.get(index) instanceof StiComponent ? coordY.get(index) : null;
                    StiContainer cont = parentCont.get(component) instanceof StiContainer ? parentCont.get(component) : null;
                    double bottom = component.getBottom();
                    int startIndex = index + 1;
                    while (startIndex < coordY.size()) {
                        StiComponent componentTo = coordY.get(startIndex) instanceof StiComponent ? coordY.get(startIndex) : null;
                        StiContainer contTo = parentCont.get(componentTo) instanceof StiContainer ? parentCont.get(componentTo) : null;
                        StiProcessingDuplicatesType duplicatesType = StiProcessingDuplicatesType.None;
                        boolean isGlobal = false;
                        if (typeOfDuplicates == TypeOfDuplicates.Text) {
                            duplicatesType = ((IStiText)((Object)component)).getProcessingDuplicates();
                            if (duplicatesType == StiProcessingDuplicatesType.BasedOnValueRemoveText) {
                                duplicatesType = StiProcessingDuplicatesType.RemoveText;
                            }
                            if (duplicatesType == StiProcessingDuplicatesType.BasedOnValueAndTagHide) {
                                duplicatesType = StiProcessingDuplicatesType.BasedOnTagHide;
                            }
                            if (duplicatesType == StiProcessingDuplicatesType.BasedOnValueAndTagMerge) {
                                duplicatesType = StiProcessingDuplicatesType.BasedOnTagMerge;
                            }
                            isGlobal = duplicatesType == StiProcessingDuplicatesType.GlobalHide || duplicatesType == StiProcessingDuplicatesType.GlobalMerge || duplicatesType == StiProcessingDuplicatesType.GlobalRemoveText;
                        } else {
                            boolean bl = isGlobal = ((StiImage)component).getProcessingDuplicates() == StiImageProcessingDuplicatesType.GlobalHide || ((StiImage)component).getProcessingDuplicates() == StiImageProcessingDuplicatesType.GlobalMerge || ((StiImage)component).getProcessingDuplicates() == StiImageProcessingDuplicatesType.GlobalRemoveImage;
                        }
                        if (componentTo.getName().equals(component.getName()) || isGlobal) {
                            if (Math.round(contTo.top * 100.0) != Math.round(cont.getBottom() * 100.0) || !cont.getName().equals(contTo.getName()) && !isGlobal) continue block6;
                            if (typeOfDuplicates == TypeOfDuplicates.Text) {
                                String componentToString = ((IStiText)((Object)componentTo)).getTextInternal();
                                String componentString = ((IStiText)((Object)component)).getTextInternal();
                                if (duplicatesType == StiProcessingDuplicatesType.BasedOnTagHide || duplicatesType == StiProcessingDuplicatesType.BasedOnTagMerge || duplicatesType == StiProcessingDuplicatesType.BasedOnTagRemoveText) {
                                    componentToString = componentTo.getTagValue() == null ? "" : componentTo.getTagValue().toString();
                                    String string = componentString = component.getTagValue() == null ? "" : component.getTagValue().toString();
                                }
                                if (!(StiMath.round((double)componentTo.top, (int)2) >= StiMath.round((double)bottom, (int)2)) || !componentToString.equals(componentString)) continue block6;
                                if (duplicatesType == StiProcessingDuplicatesType.Merge || duplicatesType == StiProcessingDuplicatesType.GlobalMerge || duplicatesType == StiProcessingDuplicatesType.BasedOnTagMerge) {
                                    component.setHeight(component.getHeight() + componentTo.getBottom() - component.getBottom());
                                }
                                if (duplicatesType == StiProcessingDuplicatesType.RemoveText || duplicatesType == StiProcessingDuplicatesType.GlobalRemoveText || duplicatesType == StiProcessingDuplicatesType.BasedOnTagRemoveText) {
                                    ((IStiText)((Object)componentTo)).setTextInternal("");
                                    ++index;
                                    ++startIndex;
                                } else {
                                    bottom += componentTo.getHeight();
                                    componentTo.getParent().getComponents().remove(componentTo);
                                    coordY.remove(startIndex);
                                }
                            } else if (typeOfDuplicates == TypeOfDuplicates.Image) {
                                if (!(StiMath.round((double)componentTo.top, (int)2) >= StiMath.round((double)bottom, (int)2)) || !StiPostProcessDuplicatesHelper.IsImageEqual(((StiImage)componentTo).getImageBytesToDraw(), ((StiImage)component).getImageBytesToDraw())) continue block6;
                                if (((StiImage)component).getProcessingDuplicates() == StiImageProcessingDuplicatesType.Merge || ((StiImage)component).getProcessingDuplicates() == StiImageProcessingDuplicatesType.GlobalMerge) {
                                    component.setHeight(component.getHeight() + componentTo.getBottom() - component.getBottom());
                                }
                                if (((StiImage)component).getProcessingDuplicates() == StiImageProcessingDuplicatesType.RemoveImage || ((StiImage)component).getProcessingDuplicates() == StiImageProcessingDuplicatesType.GlobalRemoveImage) {
                                    ((StiImage)componentTo).setImageBytesToDraw(null);
                                    ++index;
                                    ++startIndex;
                                } else {
                                    bottom += componentTo.getHeight();
                                    componentTo.getParent().getComponents().remove(componentTo);
                                    coordY.remove(startIndex);
                                }
                            }
                        } else {
                            ++startIndex;
                        }
                        cont = contTo;
                    }
                }
            }
        }
    }

    private static class StiMergeComparer
    implements Comparator {
        private StiMergeComparer() {
        }

        public final int compare(Object x, Object y) {
            return Double.compare(((StiComponent)x).top, ((StiComponent)y).top);
        }
    }

    public static enum TypeOfDuplicates {
        Text,
        Image;


        public int getValue() {
            return this.ordinal();
        }

        public static TypeOfDuplicates forValue(int value) {
            return TypeOfDuplicates.values()[value];
        }
    }
}

