/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2;

import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.engine.engineV2.StiEngine;
import com.stimulsoft.report.engine.engineV2.StiPageNumber;
import com.stimulsoft.report.engine.engineV2.StiPageNumberCollection;

public class StiPageNumberHelper {
    public StiEngine engine = null;
    private boolean finished = false;
    private boolean clearPageNumbersOnFinish = true;
    StiPageNumberCollection pageNumbers = new StiPageNumberCollection();

    public final boolean getClearPageNumbersOnFinish() {
        return this.clearPageNumbersOnFinish;
    }

    public final void setClearPageNumbersOnFinish(boolean value) {
        this.clearPageNumbersOnFinish = value;
    }

    public final StiPageNumberCollection getPageNumbers() {
        return this.pageNumbers;
    }

    public final void setPageNumbers(StiPageNumberCollection value) {
        this.pageNumbers = value;
    }

    public final void ResetPageNumber() {
        this.ResetPageNumber(this.getPageNumbers().size() - 1);
    }

    public final void ResetPageNumber(int pageIndex) {
        if (pageIndex < this.getPageNumbers().size()) {
            ((StiPageNumber)this.getPageNumbers().get(pageIndex)).setResetPageNumber(true);
        }
    }

    public final void AddPageNumber(int pageIndex, int segmentPerWidth, int segmentPerHeight) {
        if (pageIndex >= this.getPageNumbers().size()) {
            StiPageNumber pageNumber = new StiPageNumber();
            pageNumber.setSegmentPerWidth(segmentPerWidth);
            pageNumber.setSegmentPerHeight(segmentPerHeight);
            this.getPageNumbers().add(pageNumber);
        }
    }

    public final int GetPageNumber(int pageIndex) {
        if (!this.finished) {
            if (this.engine.getReport().getRenderedPages().size() == 0) {
                return 1;
            }
            return this.engine.getReport().getRenderedPages().size();
        }
        if (this.getPageNumbers().size() == 0) {
            return pageIndex + 1;
        }
        pageIndex = Math.max(pageIndex, 0);
        pageIndex = Math.min(pageIndex, this.getPageNumbers().size() - 1);
        return ((StiPageNumber)this.getPageNumbers().get(pageIndex)).getPageNumber();
    }

    public final int GetPageNumber(StiPage page) {
        return this.GetPageNumber(this.engine.getReport().getRenderedPages().indexOf(page));
    }

    public final int GetTotalPageCount(int pageIndex) {
        if (this.getPageNumbers().size() == 0) {
            return 1;
        }
        pageIndex = Math.max(pageIndex, 0);
        pageIndex = Math.min(pageIndex, this.getPageNumbers().size() - 1);
        return ((StiPageNumber)this.getPageNumbers().get(pageIndex)).getTotalPageCount();
    }

    public final int GetPageNumberThrough(int pageIndex) {
        if (this.getPageNumbers().size() == 0) {
            return 1;
        }
        pageIndex = Math.max(pageIndex, 0);
        pageIndex = Math.min(pageIndex, this.getPageNumbers().size() - 1);
        return ((StiPageNumber)this.getPageNumbers().get(pageIndex)).getPageNumberThrough();
    }

    public final int GetPageNumberThrough(StiPage page) {
        return this.GetPageNumberThrough(this.engine.getReport().getRenderedPages().indexOf(page));
    }

    public final int GetTotalPageCountThrough(int pageIndex) {
        if (this.getPageNumbers().size() == 0) {
            return 1;
        }
        pageIndex = Math.max(pageIndex, 0);
        pageIndex = Math.min(pageIndex, this.getPageNumbers().size() - 1);
        return ((StiPageNumber)this.getPageNumbers().get(pageIndex)).getTotalPageCountThrough();
    }

    private void SetSystemVariables(int startIndex, int endIndex) {
        if (startIndex == endIndex) {
            return;
        }
        int totalPageCount = 0;
        for (int index = startIndex; index < endIndex; ++index) {
            totalPageCount += ((StiPageNumber)this.getPageNumbers().get(index)).getStep();
        }
        int pageNumber = 1;
        for (int index = startIndex; index < endIndex; ++index) {
            ((StiPageNumber)this.getPageNumbers().get(index)).setPageNumber(pageNumber);
            ((StiPageNumber)this.getPageNumbers().get(index)).setTotalPageCount(totalPageCount);
            pageNumber += ((StiPageNumber)this.getPageNumbers().get(index)).getStep();
        }
    }

    public final void ProcessPageNumbers() {
        if (this.engine != null && this.engine.getReport() != null && this.engine.getReport().getRenderedPages() != null) {
            while (this.pageNumbers.size() > this.engine.report.getRenderedPages().size()) {
                this.pageNumbers.remove(this.engine.report.getRenderedPages().size());
            }
        }
        int totalPageCountThrough = 0;
        int pageIndex = 0;
        for (StiPageNumber pageNumber : this.getPageNumbers()) {
            if (this.engine != null && this.engine.getReport() != null && this.engine.getReport().getRenderedPages() != null && pageIndex < this.engine.getReport().getRenderedPages().size()) {
                pageNumber.setSegmentPerWidth(((StiPage)this.engine.getReport().getRenderedPages().get(pageIndex)).getSegmentPerWidth());
                pageNumber.setSegmentPerHeight(((StiPage)this.engine.getReport().getRenderedPages().get(pageIndex)).getSegmentPerHeight());
            }
            totalPageCountThrough += pageNumber.getStep();
            ++pageIndex;
        }
        int pageNumberThrough = 1;
        int startIndex = 0;
        int endIndex = 0;
        for (StiPageNumber pageNumber : this.getPageNumbers()) {
            if (pageNumber.getResetPageNumber()) {
                this.SetSystemVariables(startIndex, endIndex);
                startIndex = endIndex;
            }
            pageNumber.setPageNumberThrough(pageNumberThrough++);
            pageNumber.setTotalPageCountThrough(totalPageCountThrough);
            ++endIndex;
        }
        this.SetSystemVariables(startIndex, endIndex);
        this.finished = true;
    }

    public final void Clear() {
        if (this.getClearPageNumbersOnFinish()) {
            this.getPageNumbers().clear();
        }
    }

    public final void ClearNotFixed() {
        if (this.getClearPageNumbersOnFinish() && this.getPageNumbers().size() > 0) {
            for (int pagePos = this.getPageNumbers().size() - 1; pagePos >= 0 && !((StiPageNumber)this.getPageNumbers().get((int)pagePos)).FixedPosition; --pagePos) {
                this.getPageNumbers().remove(pagePos);
            }
        }
    }

    public StiPageNumberHelper(StiEngine engine) {
        this.engine = engine;
    }

    public void clear() {
        this.Clear();
    }
}

