/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2;

import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.complexcomponents.StiPanel;
import com.stimulsoft.report.components.enums.StiDockStyle;
import com.stimulsoft.report.components.enums.StiImageProcessingDuplicatesType;
import com.stimulsoft.report.components.enums.StiPrintOnType;
import com.stimulsoft.report.components.enums.StiProcessingDuplicatesType;
import com.stimulsoft.report.components.interfaces.IStiText;
import com.stimulsoft.report.components.simplecomponents.StiCrossLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiEndPointPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiHorizontalLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiPointPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiRectanglePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiRoundedRectanglePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiStartPointPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.components.simplecomponents.StiVerticalLinePrimitive;
import com.stimulsoft.report.engine.StiPostProcessDuplicatesHelper;
import java.util.ArrayList;
import java.util.Hashtable;

public final class StiPostProcessProviderV2 {
    private static final String nullGuid = "nullGuid";

    public static void PostProcessPages(StiPagesCollection pages) {
        int totalPageCount = 0;
        for (StiPage page : pages) {
            totalPageCount += page.segmentPerWidth * page.segmentPerHeight;
        }
        int pageNumber = 1;
        for (StiPage page : pages) {
            StiPostProcessProviderV2.PostProcessPage(page, pageNumber == 1, pageNumber == totalPageCount);
            pageNumber += page.segmentPerWidth * page.segmentPerHeight;
        }
        StiPostProcessProviderV2.PostProcessPrimitives(pages);
    }

    private static void RemoveAllPointPrimitives(StiContainer container) {
        int index = 0;
        while (index < container.getComponents().size()) {
            if (container.getComponents().get(index) instanceof StiPointPrimitive) {
                container.getComponents().remove(index);
                continue;
            }
            StiContainer cont = (StiContainer)(container.getComponents().get(index) instanceof StiContainer ? (StiComponent)container.getComponents().get(index) : null);
            if (cont != null) {
                StiPostProcessProviderV2.RemoveAllPointPrimitives(cont);
            }
            ++index;
        }
    }

    public static void PostProcessPrimitives(StiPage page) {
        StiPagesCollection pages = new StiPagesCollection(null);
        pages.add(page);
        StiPostProcessProviderV2.PostProcessPrimitives(pages);
    }

    public static void PostProcessPrimitives(StiPagesCollection pages) {
        Hashtable startPointsHash = new Hashtable();
        Hashtable endPointsHash = new Hashtable();
        Hashtable lines = new Hashtable();
        ArrayList<StiEndPointPrimitive> endPoints = new ArrayList<StiEndPointPrimitive>();
        for (StiPage page : pages) {
            StiPostProcessProviderV2.PostProcessPrimitivesInContainer(page, pages, startPointsHash, endPointsHash, lines, endPoints);
        }
        for (StiPage page : pages) {
            StiPostProcessProviderV2.RemoveAllPointPrimitives(page);
        }
    }

    public static void PostProcessPrimitivesInContainer(StiContainer container) {
        Hashtable startPointsHash = new Hashtable();
        Hashtable endPointsHash = new Hashtable();
        Hashtable lines = new Hashtable();
        ArrayList<StiEndPointPrimitive> endPoints = new ArrayList<StiEndPointPrimitive>();
        StiPostProcessProviderV2.PostProcessPrimitivesInContainer(container, null, startPointsHash, endPointsHash, lines, endPoints);
        StiPostProcessProviderV2.RemoveAllPointPrimitives(container);
    }

    public static void PostProcessPrimitivesInContainer(StiContainer container, StiPagesCollection pages, Hashtable startPointsHash, Hashtable endPointsHash, Hashtable lines, ArrayList<StiEndPointPrimitive> endPoints) {
        StiComponentsCollection comps = new StiComponentsCollection();
        comps.AddRange(container.getComponents());
        for (StiComponent comp : comps) {
            StiCrossLinePrimitive line = (StiCrossLinePrimitive)(comp instanceof StiCrossLinePrimitive ? comp : null);
            if (line == null || line.getGuid() == null || nullGuid.equals(line.getGuid())) continue;
            lines.put(line.getGuid(), line);
            line.getParent().getComponents().remove(comp);
        }
        if (lines.size() > 0) {
            comps = container.GetComponents();
            endPoints.clear();
            for (StiComponent comp : comps) {
                if (!(comp instanceof StiPrimitive)) continue;
                StiStartPointPrimitive startPoint = (StiStartPointPrimitive)(comp instanceof StiStartPointPrimitive ? comp : null);
                if (startPoint != null) {
                    if (startPoint.getReferenceToGuid() == null) continue;
                    StiPanel panel = (StiPanel)(container instanceof StiPanel ? container : null);
                    ArrayList<StiStartPointPrimitive> list = startPointsHash.get(startPoint.getReferenceToGuid()) instanceof ArrayList ? startPointsHash.get(startPoint.getReferenceToGuid()) : null;
                    if (list == null) {
                        list = new ArrayList<StiStartPointPrimitive>();
                        startPointsHash.put(startPoint.getReferenceToGuid(), list);
                        if (panel != null && panel.getColumns() > 1) {
                            list.add(startPoint);
                        }
                    }
                    if ((panel == null || panel.getColumns() >= 2) && panel != null) continue;
                    list.add(startPoint);
                    continue;
                }
                StiEndPointPrimitive endPoint = (StiEndPointPrimitive)(comp instanceof StiEndPointPrimitive ? comp : null);
                if (endPoint == null || StiPostProcessProviderV2.ProcessOneEndPoint(startPointsHash, lines, container, pages, endPoint)) continue;
                endPoints.add(endPoint);
            }
            for (StiEndPointPrimitive endPoint : endPoints) {
                StiPostProcessProviderV2.ProcessOneEndPoint(startPointsHash, lines, container, pages, endPoint);
            }
        }
    }

    private static boolean ProcessOneEndPoint(Hashtable startPointsHash, Hashtable lines, StiContainer page, StiPagesCollection pages, StiEndPointPrimitive endPoint) {
        if (endPoint.referenceToGuid == null) {
            return false;
        }
        ArrayList startPointList = startPointsHash.get(endPoint.referenceToGuid) instanceof ArrayList ? startPointsHash.get(endPoint.referenceToGuid) : null;
        if (startPointList == null || startPointList.isEmpty()) {
            return false;
        }
        startPointsHash.remove(endPoint.referenceToGuid);
        StiStartPointPrimitive firstPoint = startPointList.get(0) instanceof StiStartPointPrimitive ? startPointList.get(0) : null;
        StiCrossLinePrimitive crossLine = lines.get(firstPoint.getReferenceToGuid()) instanceof StiCrossLinePrimitive ? lines.get(firstPoint.getReferenceToGuid()) : null;
        if (crossLine == null) {
            return true;
        }
        StiStartPointPrimitive startPoint = (StiStartPointPrimitive)startPointList.get(0);
        StiPrimitive nextStartPoint = null;
        StiPostProcessProviderV2.ProcessOnePrimitive(pages, page, crossLine, startPoint, nextStartPoint, endPoint);
        return true;
    }

    private static void ProcessOnePrimitive(StiPagesCollection pages, StiContainer page, StiCrossLinePrimitive crossLine, StiPrimitive startPoint, StiPrimitive nextStartPoint, StiPrimitive endPoint) {
        StiPoint startPos = startPoint.ComponentToPage(new StiPoint(startPoint.getLeft(), startPoint.top));
        StiPoint endPos = endPoint.ComponentToPage(new StiPoint(endPoint.getLeft(), endPoint.top));
        int startIndexColumn = ((StiPointPrimitive)startPoint).StoredColumn;
        int endIndexColumn = ((StiPointPrimitive)endPoint).StoredColumn;
        startIndexColumn = Math.max(1, startIndexColumn);
        endIndexColumn = Math.max(1, endIndexColumn);
        int nextStartIndexColumn = -1;
        if (nextStartPoint != null) {
            nextStartIndexColumn = ((StiPointPrimitive)nextStartPoint).StoredColumn;
            nextStartIndexColumn = Math.max(1, nextStartIndexColumn);
        }
        if (startPoint.getPage() != endPoint.getPage() || startIndexColumn != endIndexColumn) {
            int startIndexPage = pages == null ? 1 : pages.indexOf(startPoint.getPage());
            int endIndexPage = pages == null ? 1 : pages.indexOf(endPoint.getPage());
            int nextStartIndexPage = -1;
            if (nextStartPoint != null && pages != null) {
                nextStartIndexPage = pages.indexOf(nextStartPoint.getPage());
            }
            for (int indexPage = startIndexPage; indexPage <= endIndexPage; ++indexPage) {
                if (startIndexPage != endIndexPage && nextStartPoint != null && nextStartIndexPage == endIndexPage && indexPage == endIndexPage) continue;
                StiPage page2 = (StiPage)pages.get(indexPage);
                if (page2 != startPoint.getPage()) {
                    startIndexColumn = 1;
                }
                if (page2 != endPoint.getPage()) {
                    endIndexColumn = Math.max(page2.getColumns(), endIndexColumn);
                }
                double position = 0.0;
                for (int indexColumn = startIndexColumn; indexColumn <= endIndexColumn; ++indexColumn) {
                    double topPosition = page2.getPageInfoV2().PositionFromTop;
                    double bottomPosition = page2.getPageInfoV2().PositionFromBottom;
                    double columnWidth = page2.getColumnWidthM() + page2.getColumnGaps();
                    double stX = startPos.x;
                    double stY = startPos.y;
                    double enX = endPos.x;
                    double enY = endPos.y;
                    if (startIndexColumn != endIndexColumn) {
                        enX -= columnWidth * (double)Math.min(endIndexColumn - startIndexColumn, page2.getColumns());
                        while (enX < stX && columnWidth > 0.0) {
                            enX += columnWidth;
                        }
                    }
                    if (indexPage == startIndexPage && startIndexColumn == indexColumn) {
                        StiPostProcessProviderV2.AddPrimitive(crossLine, new StiPoint(position + stX, stY), new StiPoint(position + enX, bottomPosition), page2);
                    } else if (indexPage == endIndexPage && endIndexColumn == indexColumn) {
                        StiPostProcessProviderV2.AddPrimitive(crossLine, new StiPoint(position + stX, topPosition), new StiPoint(position + enX, enY), page2);
                    } else {
                        StiPostProcessProviderV2.AddPrimitive(crossLine, new StiPoint(position + stX, topPosition), new StiPoint(position + enX, bottomPosition), page2);
                    }
                    position += columnWidth;
                }
            }
        } else {
            StiPostProcessProviderV2.AddPrimitive(crossLine, startPos, endPos, page);
        }
    }

    public static void AddPrimitive(StiCrossLinePrimitive crossLine, StiPoint startPos, StiPoint endPos, StiContainer page) {
        if (crossLine instanceof StiRoundedRectanglePrimitive) {
            Object tempVar = crossLine.clone();
            StiCrossLinePrimitive newCrossLine = (StiCrossLinePrimitive)(tempVar instanceof StiCrossLinePrimitive ? tempVar : null);
            newCrossLine.setGuid(nullGuid);
            newCrossLine.setLeft(startPos.x);
            newCrossLine.top = startPos.y;
            newCrossLine.setWidth(endPos.x - startPos.x);
            newCrossLine.setHeight(endPos.y - startPos.y);
            page.getComponents().add(newCrossLine);
        } else if (crossLine instanceof StiRectanglePrimitive) {
            if (((StiRectanglePrimitive)crossLine).getLeftSide()) {
                StiVerticalLinePrimitive lineLeft = new StiVerticalLinePrimitive();
                lineLeft.setName(crossLine.getName() + "_Left");
                lineLeft.setGuid(nullGuid);
                lineLeft.setLeft(startPos.x);
                lineLeft.top = startPos.y;
                lineLeft.setHeight(endPos.y - startPos.y);
                lineLeft.setColor(crossLine.getColor());
                lineLeft.setStyle(crossLine.getStyle());
                lineLeft.setSize(crossLine.getSize());
                page.getComponents().add(lineLeft);
            }
            if (((StiRectanglePrimitive)crossLine).getRightSide()) {
                StiVerticalLinePrimitive lineRight = new StiVerticalLinePrimitive();
                lineRight.setName(crossLine.getName() + "_Right");
                lineRight.setGuid(nullGuid);
                lineRight.setLeft(endPos.x);
                lineRight.top = startPos.y;
                lineRight.setHeight(endPos.y - startPos.y);
                lineRight.setColor(crossLine.getColor());
                lineRight.setStyle(crossLine.getStyle());
                lineRight.setSize(crossLine.getSize());
                page.getComponents().add(lineRight);
            }
            if (((StiRectanglePrimitive)crossLine).getTopSide()) {
                StiHorizontalLinePrimitive lineTop = new StiHorizontalLinePrimitive();
                lineTop.setName(crossLine.getName() + "_Top");
                lineTop.setLeft(startPos.x);
                lineTop.top = startPos.y;
                lineTop.setHeight(crossLine.getPage().getUnit().ConvertFromHInches(1.0));
                lineTop.setWidth(endPos.x - startPos.x);
                lineTop.setColor(crossLine.getColor());
                lineTop.setStyle(crossLine.getStyle());
                lineTop.setSize(crossLine.getSize());
                page.getComponents().add(lineTop);
            }
            if (((StiRectanglePrimitive)crossLine).getBottomSide()) {
                StiHorizontalLinePrimitive lineBottom = new StiHorizontalLinePrimitive();
                lineBottom.setName(crossLine.getName() + "_Bottom");
                lineBottom.setLeft(startPos.x);
                lineBottom.top = endPos.y;
                lineBottom.setHeight(crossLine.getPage().getUnit().ConvertFromHInches(1.0));
                lineBottom.setWidth(endPos.x - startPos.x);
                lineBottom.setColor(crossLine.getColor());
                lineBottom.setStyle(crossLine.getStyle());
                lineBottom.setSize(crossLine.getSize());
                page.getComponents().add(lineBottom);
            }
        } else {
            Object tempVar2 = crossLine.clone();
            StiCrossLinePrimitive newCrossLine = (StiCrossLinePrimitive)(tempVar2 instanceof StiCrossLinePrimitive ? tempVar2 : null);
            newCrossLine.setGuid(nullGuid);
            newCrossLine.setLeft(startPos.x);
            newCrossLine.top = startPos.y;
            newCrossLine.setWidth(endPos.x - startPos.x);
            newCrossLine.setHeight(endPos.y - startPos.y);
            page.getComponents().add(newCrossLine);
        }
    }

    public static void CopyStyles(StiLinePrimitive dest, StiLinePrimitive source) {
        dest.setColor(source.getColor());
        dest.setStyle(source.getStyle());
        dest.setSize(source.getSize());
    }

    public static void PostProcessPage(StiPage page, boolean isFirstPage, boolean isLastPage) {
        StiPostProcessProviderV2.PostProcessPage(page, isFirstPage, isLastPage, true);
    }

    public static void PostProcessPage(StiPage page, boolean isFirstPage, boolean isLastPage, boolean clearPage) {
        page.packService();
        StiPostProcessProviderV2.PostProcessPrintOn(page, isFirstPage, isLastPage);
        StiComponentsCollection comps = page.GetComponents();
        page.DockToContainer();
        for (StiComponent comp : comps) {
            comp.setDockStyle(StiDockStyle.None);
            comp.setPage(page);
            comp.packService();
            StiText text = (StiText)(comp instanceof StiText ? comp : null);
            if (text == null || !text.getShrinkFontToFit()) continue;
            text.setFont(text.getActualFont(text.getText(), text.getShrinkFontToFitMinimumSize()));
        }
        Hashtable<StiComponent, StiContainer> parentCont = new Hashtable<StiComponent, StiContainer>();
        for (StiComponent comp : comps) {
            if (comp instanceof IStiText && ((IStiText)((Object)comp)).getProcessingDuplicates() != StiProcessingDuplicatesType.None) {
                parentCont.put(comp, comp.getParent());
            }
            if (!(comp instanceof StiImage) || ((StiImage)comp).getProcessingDuplicates() == StiImageProcessingDuplicatesType.None) continue;
            parentCont.put(comp, comp.getParent());
        }
        if (clearPage) {
            page.ClearPage();
        }
        StiPostProcessDuplicatesHelper.PostProcessDuplicates(comps, parentCont);
        parentCont.clear();
        parentCont = null;
    }

    private static void PostProcessPrintOn(StiPage page, boolean isFirstPage, boolean isLastPage) {
        StiPostProcessProviderV2.PostProcessPrintOn(page.getComponents(), isFirstPage, isLastPage);
    }

    private static void PostProcessPrintOn(StiComponentsCollection comps, boolean isFirstPage, boolean isLastPage) {
        int index = 0;
        while (index < comps.size()) {
            StiComponent comp = (StiComponent)comps.get(index);
            if (!StiPostProcessProviderV2.AllowPrintOn(comp, isFirstPage, isLastPage)) {
                comps.remove(index);
                continue;
            }
            StiContainer cont = (StiContainer)(comp instanceof StiContainer ? comp : null);
            if (cont != null) {
                StiPostProcessProviderV2.PostProcessPrintOn(cont.getComponents(), isFirstPage, isLastPage);
            }
            ++index;
        }
    }

    private static boolean AllowPrintOn(StiComponent comp, boolean isFirstPage, boolean isLastPage) {
        if (comp.getPrintOn() == StiPrintOnType.AllPages) {
            return true;
        }
        if ((comp.getPrintOn().getValue() & StiPrintOnType.ExceptFirstPage.getValue()) > 0 && isFirstPage) {
            return false;
        }
        if (comp.getPrintOn() == StiPrintOnType.OnlyFirstAndLastPage) {
            return isFirstPage || isLastPage;
        }
        if ((comp.getPrintOn().getValue() & StiPrintOnType.OnlyFirstPage.getValue()) > 0 && !isFirstPage) {
            return false;
        }
        if ((comp.getPrintOn().getValue() & StiPrintOnType.OnlyLastPage.getValue()) > 0 && !isLastPage) {
            return false;
        }
        return (comp.getPrintOn().getValue() & StiPrintOnType.ExceptLastPage.getValue()) <= 0 || !isLastPage;
    }
}

