/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2.builders;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.system.StiEventHandlerArgs;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentHelper;
import com.stimulsoft.report.components.bands.StiEmptyBand;
import com.stimulsoft.report.components.complexcomponents.StiSubReport;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiFont;
import com.stimulsoft.report.components.interfaces.IStiTextBrush;
import com.stimulsoft.report.engine.engineV2.builders.StiV2Builder;
import com.stimulsoft.report.styles.StiBaseStyle;
import java.util.Hashtable;

public class StiComponentV2Builder
extends StiV2Builder {
    @Override
    public void SetReportVariables(StiComponent masterComp) {
    }

    @Override
    public void Prepare(StiComponent masterComp) {
        StiComponentHelper.FillComponentPlacement(masterComp);
        if (StiOptions.Engine.getAllowResetValuesAtComponent()) {
            masterComp.setTagValue(null);
            masterComp.setToolTipValue(null);
            masterComp.setBookmarkValue(null);
            masterComp.setHyperlinkValue(null);
        }
    }

    @Override
    public void UnPrepare(StiComponent masterComp) {
    }

    @Override
    public StiComponent InternalRender(StiComponent masterComp) {
        Object tempVar = masterComp.clone(false);
        return (StiComponent)(tempVar instanceof StiComponent ? tempVar : null);
    }

    @Override
    public StiComponent Render(StiComponent masterComp) {
        IStiTextBrush renderedTextBrushObject;
        IStiTextBrush masterTextBrushObject;
        IStiBrush renderedBrushObject;
        IStiBrush masterBrushObject;
        IStiBorder renderedBorderObject;
        IStiBorder masterBorderObject;
        StiBaseStyle tempStyle;
        StiComponent renderedComponent = null;
        IStiTextBrush textBrush = (IStiTextBrush)((Object)(masterComp instanceof IStiTextBrush ? masterComp : null));
        IStiBrush brush = (IStiBrush)((Object)(masterComp instanceof IStiBrush ? masterComp : null));
        IStiFont font = (IStiFont)((Object)(masterComp instanceof IStiFont ? masterComp : null));
        IStiBorder border = (IStiBorder)((Object)(masterComp instanceof IStiBorder ? masterComp : null));
        StiBrush savedTextBrush = null;
        StiBrush savedBrush = null;
        StiFont savedFont = null;
        StiEnumSet savedBorderSides = StiEnumSet.of((Enum)StiBorderSides.None);
        if (textBrush != null) {
            savedTextBrush = textBrush.getTextBrush();
        }
        if (brush != null) {
            savedBrush = (StiBrush)brush.getBrush().clone();
        }
        if (font != null) {
            savedFont = (StiFont)font.getFont().clone();
        }
        if (border != null && border.getBorder() != null) {
            savedBorderSides = border.getBorder().getSide();
        }
        boolean savedEnabled = masterComp.getEnabled();
        masterComp.InvokeBeforePrint(masterComp, StiEventHandlerArgs.Empty);
        StiReport report = masterComp.getReport();
        boolean needUseParentStyles = false;
        if (masterComp.getUseParentStyles() && masterComp.getParent() != null) {
            tempStyle = null;
            if (report != null && report.getEngine() != null && report.getEngine().getHashParentStyles() != null && report.getEngine().getHashParentStyles().size() > 0) {
                tempStyle = report.getEngine().getHashParentStyles().get(masterComp.getParent());
            }
            if (tempStyle == null) {
                tempStyle = StiBaseStyle.getStyle(masterComp.getParent());
            }
            if (tempStyle != null) {
                tempStyle.SetStyleToComponent(masterComp);
                if (report.getEngine().getHashParentStyles() == null) {
                    report.getEngine().setHashParentStyles(new Hashtable<StiComponent, StiBaseStyle>());
                }
                report.getEngine().getHashParentStyles().put(masterComp, tempStyle);
                needUseParentStyles = true;
            }
        }
        if (!needUseParentStyles && report != null && report.getEngine() != null && report.getEngine().getHashUseParentStyles().containsKey(masterComp)) {
            tempStyle = StiBaseStyle.getStyle(masterComp);
            if (report.getEngine().getHashParentStyles() == null) {
                report.getEngine().setHashParentStyles(new Hashtable<StiComponent, StiBaseStyle>());
            }
            report.getEngine().getHashParentStyles().put(masterComp, tempStyle);
            needUseParentStyles = true;
        }
        if (masterComp.getIsEnabled()) {
            if (!(masterComp instanceof StiEmptyBand)) {
                masterComp.doBookmark();
            }
            if ((renderedComponent = masterComp.InternalRender()) != null) {
                renderedComponent.invokeEvents();
            }
        }
        masterComp.InvokeAfterPrint(masterComp, StiEventHandlerArgs.Empty);
        if (needUseParentStyles) {
            report.getEngine().getHashParentStyles().remove(masterComp);
        }
        if (textBrush != null) {
            textBrush.setTextBrush(savedTextBrush);
        }
        if (brush != null) {
            brush.setBrush(savedBrush);
        }
        if (font != null) {
            font.setFont(savedFont);
        }
        if (border != null && border.getBorder() != null) {
            border.getBorder().setSide(savedBorderSides);
        }
        if (!(masterComp instanceof StiSubReport)) {
            masterComp.setEnabled(savedEnabled);
        }
        if ((masterBorderObject = (IStiBorder)((Object)(masterComp instanceof IStiBorder ? masterComp : null))) != null && (renderedBorderObject = (IStiBorder)((Object)(renderedComponent instanceof IStiBorder ? renderedComponent : null))) != null && masterBorderObject.getBorder() != renderedBorderObject.getBorder() && masterBorderObject.getBorder().equals((Object)renderedBorderObject.getBorder())) {
            renderedBorderObject.setBorder(masterBorderObject.getBorder());
        }
        if ((masterBrushObject = (IStiBrush)((Object)(masterComp instanceof IStiBrush ? masterComp : null))) != null && (renderedBrushObject = (IStiBrush)((Object)(renderedComponent instanceof IStiBrush ? renderedComponent : null))) != null && masterBrushObject.getBrush() != renderedBrushObject.getBrush() && masterBrushObject.getBrush().equals(renderedBrushObject.getBrush())) {
            renderedBrushObject.setBrush(masterBrushObject.getBrush());
        }
        if ((masterTextBrushObject = (IStiTextBrush)((Object)(masterComp instanceof IStiTextBrush ? masterComp : null))) != null && (renderedTextBrushObject = (IStiTextBrush)((Object)(renderedComponent instanceof IStiTextBrush ? renderedComponent : null))) != null && masterTextBrushObject.getTextBrush() != renderedTextBrushObject.getTextBrush() && masterTextBrushObject.getTextBrush().equals(renderedTextBrushObject.getTextBrush())) {
            renderedTextBrushObject.setTextBrush(masterTextBrushObject.getTextBrush());
        }
        masterComp.isRendered = true;
        return renderedComponent;
    }
}

