/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2.builders;

import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiBandInteraction;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiDataHelper;
import com.stimulsoft.report.components.StiFilterHelper;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.bands.StiChildBand;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiDynamicBand;
import com.stimulsoft.report.components.bands.StiEmptyBand;
import com.stimulsoft.report.components.bands.StiFooterBand;
import com.stimulsoft.report.components.bands.StiGroupFooterBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.components.bands.StiHeaderBand;
import com.stimulsoft.report.components.bands.StiHierarchicalBand;
import com.stimulsoft.report.components.bands.StiReportSummaryBand;
import com.stimulsoft.report.components.bands.StiReportTitleBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.complexcomponents.StiSubReport;
import com.stimulsoft.report.components.crossBands.StiCrossDataBand;
import com.stimulsoft.report.components.enums.StiComponentType;
import com.stimulsoft.report.components.interfaces.IStiBusinessObject;
import com.stimulsoft.report.components.interfaces.IStiDataSource;
import com.stimulsoft.report.components.interfaces.IStiMasterComponent;
import com.stimulsoft.report.components.interfaces.IStiPageBreak;
import com.stimulsoft.report.components.interfaces.IStiPrintOnAllPages;
import com.stimulsoft.report.components.interfaces.IStiRenderMaster;
import com.stimulsoft.report.components.table.StiTable;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.engine.engineV2.builders.StiBandV2Builder;
import com.stimulsoft.report.engine.engineV2.builders.StiGroupHeaderBandV2Builder;
import com.stimulsoft.report.engine.engineV2.builders.StiHierarchicalBandV2Builder;
import com.stimulsoft.report.engine.engineV2.builders.StiV2Builder;
import com.stimulsoft.report.enums.StiKeepDetails;
import com.stimulsoft.report.events.StiValueEventArgs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

public class StiDataBandV2Builder
extends StiBandV2Builder {
    public final void FindHeaders(StiDataBand masterDataBand) {
        if (masterDataBand == null) {
            return;
        }
        if (masterDataBand.parent == null) {
            return;
        }
        if (masterDataBand.getDataBandInfoV2() == null) {
            return;
        }
        masterDataBand.getDataBandInfoV2().Headers = new ArrayList();
        for (int index = masterDataBand.parent.components.indexOf(masterDataBand) - 1; index >= 0; --index) {
            StiComponent comp = (StiComponent)masterDataBand.parent.components.get(index);
            if (comp instanceof StiGroupHeaderBand || comp instanceof StiChildBand || comp instanceof StiEmptyBand) continue;
            if (!(comp instanceof StiHeaderBand)) break;
            masterDataBand.getDataBandInfoV2().Headers.add(0, (StiHeaderBand)comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void FindHierarchicalHeaders(StiDataBand masterDataBand) {
        if (masterDataBand == null) {
            return;
        }
        if (masterDataBand.parent == null) {
            return;
        }
        if (masterDataBand.getDataBandInfoV2() == null) {
            return;
        }
        StiHierarchicalBand band = (StiHierarchicalBand)(masterDataBand instanceof StiHierarchicalBand ? masterDataBand : null);
        if (band == null || band.getHeaders().trim().length() <= 0) return;
        masterDataBand.getDataBandInfoV2().HierarchicalHeaders = new ArrayList();
        String[] headers = band.getHeaders().split("[;]", -1);
        Hashtable<String, String> headersHash = new Hashtable<String, String>();
        Object object = headers;
        synchronized (headers) {
            for (String header : headers) {
                String str = header.trim();
                headersHash.put(str, str);
            }
            // ** MonitorExit[var5_5 /* !! */ ] (shouldn't be in output)
            object = masterDataBand.getDataBandInfoV2().Headers;
            synchronized (object) {
                for (StiHeaderBand headerBand : masterDataBand.getDataBandInfoV2().Headers) {
                    if (headersHash.get(headerBand.getName()) == null) continue;
                    masterDataBand.getDataBandInfoV2().HierarchicalHeaders.add(headerBand);
                }
            }
            object = masterDataBand.getDataBandInfoV2().HierarchicalHeaders;
            synchronized (object) {
                for (StiHeaderBand headerBand : masterDataBand.getDataBandInfoV2().HierarchicalHeaders) {
                    if (!masterDataBand.getDataBandInfoV2().Headers.contains(headerBand)) continue;
                    masterDataBand.getDataBandInfoV2().Headers.remove(headerBand);
                }
                return;
            }
        }
    }

    public final void FindFooters(StiDataBand masterDataBand) {
        if (masterDataBand == null) {
            return;
        }
        if (masterDataBand.parent == null) {
            return;
        }
        if (masterDataBand.getDataBandInfoV2() == null) {
            return;
        }
        masterDataBand.getDataBandInfoV2().FootersOnAllPages = new ArrayList();
        masterDataBand.getDataBandInfoV2().FootersOnLastPage = new ArrayList();
        for (int index = masterDataBand.parent.components.indexOf(masterDataBand) + 1; index < masterDataBand.parent.components.size(); ++index) {
            StiComponent comp = (StiComponent)masterDataBand.parent.components.get(index);
            if (comp instanceof StiGroupFooterBand || comp instanceof StiChildBand || comp instanceof StiEmptyBand || comp instanceof StiTable && !((StiTable)(comp instanceof StiTable ? comp : null)).IsConverted) continue;
            if (!(comp instanceof StiFooterBand)) break;
            if (((StiFooterBand)comp).getPrintOnAllPages()) {
                masterDataBand.getDataBandInfoV2().FootersOnAllPages.add((StiFooterBand)comp);
                continue;
            }
            masterDataBand.getDataBandInfoV2().FootersOnLastPage.add((StiFooterBand)comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void FindHierarchicalFooters(StiDataBand masterDataBand) {
        if (masterDataBand == null) {
            return;
        }
        if (masterDataBand.parent == null) {
            return;
        }
        if (masterDataBand.getDataBandInfoV2() == null) {
            return;
        }
        StiHierarchicalBand band = (StiHierarchicalBand)(masterDataBand instanceof StiHierarchicalBand ? masterDataBand : null);
        if (band == null || band.getFooters().trim().length() <= 0) return;
        masterDataBand.getDataBandInfoV2().HierarchicalFooters = new ArrayList();
        String[] footers = band.getFooters().split("[;]", -1);
        Hashtable<String, String> footersHash = new Hashtable<String, String>();
        Object object = footers;
        synchronized (footers) {
            for (String footer : footers) {
                String str = footer.trim();
                footersHash.put(str, str);
            }
            // ** MonitorExit[var5_5 /* !! */ ] (shouldn't be in output)
            object = masterDataBand.getDataBandInfoV2().FootersOnAllPages;
            synchronized (object) {
                for (StiFooterBand footerBand : masterDataBand.getDataBandInfoV2().FootersOnAllPages) {
                    if (footersHash.get(footerBand.getName()) == null) continue;
                    masterDataBand.getDataBandInfoV2().HierarchicalFooters.add(footerBand);
                }
            }
            object = masterDataBand.getDataBandInfoV2().FootersOnLastPage;
            synchronized (object) {
                for (StiFooterBand footerBand : masterDataBand.getDataBandInfoV2().FootersOnLastPage) {
                    if (footersHash.get(footerBand.getName()) == null) continue;
                    masterDataBand.getDataBandInfoV2().HierarchicalFooters.add(footerBand);
                }
            }
            object = masterDataBand.getDataBandInfoV2().HierarchicalFooters;
            synchronized (object) {
                for (StiFooterBand footerBand : masterDataBand.getDataBandInfoV2().HierarchicalFooters) {
                    if (masterDataBand.getDataBandInfoV2().FootersOnAllPages.contains(footerBand)) {
                        masterDataBand.getDataBandInfoV2().FootersOnAllPages.remove(footerBand);
                    }
                    if (!masterDataBand.getDataBandInfoV2().FootersOnLastPage.contains(footerBand)) continue;
                    masterDataBand.getDataBandInfoV2().FootersOnLastPage.remove(footerBand);
                }
                return;
            }
        }
    }

    public final void FindEmptyBands(StiDataBand masterDataBand) {
        if (masterDataBand == null) {
            return;
        }
        if (masterDataBand.parent == null) {
            return;
        }
        if (masterDataBand.getDataBandInfoV2() == null) {
            return;
        }
        masterDataBand.getDataBandInfoV2().EmptyBands = new ArrayList();
        for (int index = masterDataBand.parent.components.indexOf(masterDataBand) + 1; index < masterDataBand.parent.components.size(); ++index) {
            StiComponent comp = (StiComponent)masterDataBand.parent.components.get(index);
            if (comp instanceof StiEmptyBand && comp.getEnabled()) {
                masterDataBand.getDataBandInfoV2().EmptyBands.add((StiEmptyBand)comp);
            }
            if (comp instanceof StiFooterBand || comp instanceof StiGroupFooterBand || comp instanceof StiHeaderBand || comp instanceof StiGroupHeaderBand || comp instanceof StiDataBand) break;
        }
    }

    public final void FindGroupHeaders(StiDataBand masterDataBand) {
        if (masterDataBand == null) {
            return;
        }
        if (masterDataBand.parent == null) {
            return;
        }
        if (masterDataBand.getDataBandInfoV2() == null) {
            return;
        }
        masterDataBand.getDataBandInfoV2().GroupHeaders = new ArrayList();
        for (int index = masterDataBand.parent.components.indexOf(masterDataBand) - 1; index >= 0; --index) {
            StiComponent comp = (StiComponent)masterDataBand.parent.components.get(index);
            if (comp instanceof StiHeaderBand || comp instanceof StiChildBand || comp instanceof StiEmptyBand) continue;
            if (!(comp instanceof StiGroupHeaderBand)) break;
            masterDataBand.getDataBandInfoV2().GroupHeaders.add(0, (StiGroupHeaderBand)comp);
        }
    }

    public final void FindGroupFooters(StiDataBand masterDataBand) {
        if (masterDataBand == null) {
            return;
        }
        if (masterDataBand.parent == null) {
            return;
        }
        if (masterDataBand.getDataBandInfoV2() == null) {
            return;
        }
        masterDataBand.getDataBandInfoV2().GroupFooters = new ArrayList();
        for (int index = masterDataBand.parent.components.indexOf(masterDataBand) + 1; index < masterDataBand.parent.components.size(); ++index) {
            StiComponent comp = (StiComponent)masterDataBand.parent.components.get(index);
            if (comp instanceof StiFooterBand || comp instanceof StiChildBand || comp instanceof StiEmptyBand || comp instanceof StiTable && !((StiTable)(comp instanceof StiTable ? comp : null)).IsConverted) continue;
            if (!(comp instanceof StiGroupFooterBand)) break;
            masterDataBand.getDataBandInfoV2().GroupFooters.add((StiGroupFooterBand)comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void FindDetailDataBands(StiDataBand masterDataBand) {
        if (masterDataBand == null) {
            return;
        }
        if (masterDataBand.parent == null) {
            return;
        }
        if (masterDataBand.getDataBandInfoV2() == null) {
            return;
        }
        masterDataBand.getDataBandInfoV2().DetailDataBands = new ArrayList();
        StiComponentsCollection comps = masterDataBand.page.GetComponents();
        if (masterDataBand.getIsBusinessObjectEmpty()) {
            StiComponentsCollection stiComponentsCollection = comps;
            synchronized (stiComponentsCollection) {
                for (StiComponent comp : comps) {
                    IStiMasterComponent masterComponent;
                    if (comp instanceof StiEmptyBand || comp == masterDataBand || (masterComponent = (IStiMasterComponent)((Object)(comp instanceof IStiMasterComponent ? comp : null))) == null || !(masterComponent instanceof StiDataBand) || masterComponent.getMasterComponent() != masterDataBand || ((StiDataBand)masterComponent).getDataSource() == masterDataBand.getDataSource() && (((StiDataBand)masterComponent).getDataSource() != null || masterDataBand.getDataSource() != null)) continue;
                    StiContainer parent = comp.parent;
                    while (parent != null && !(parent instanceof StiPage) && parent != masterDataBand) {
                        parent = parent.parent;
                    }
                    if (parent == masterDataBand) continue;
                    masterDataBand.getDataBandInfoV2().DetailDataBands.add((StiDataBand)comp);
                }
            }
        }
        StiComponentsCollection stiComponentsCollection = comps;
        synchronized (stiComponentsCollection) {
            for (StiComponent comp : comps) {
                StiDataBand detailBand;
                if (comp instanceof StiEmptyBand || comp == masterDataBand || (detailBand = (StiDataBand)(comp instanceof StiDataBand ? comp : null)) == null || detailBand.getIsBusinessObjectEmpty() || masterDataBand.getBusinessObject() != detailBand.getBusinessObject().getParentBusinessObject()) continue;
                StiContainer parent = comp.parent;
                while (parent != null && !(parent instanceof StiPage) && parent != masterDataBand) {
                    parent = parent.parent;
                }
                if (parent == masterDataBand) continue;
                masterDataBand.getDataBandInfoV2().DetailDataBands.add((StiDataBand)comp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void FindSubReports(StiDataBand masterDataBand) {
        StiComponentsCollection comps;
        if (masterDataBand == null) {
            return;
        }
        if (masterDataBand.parent == null) {
            return;
        }
        if (masterDataBand.getDataBandInfoV2() == null) {
            return;
        }
        masterDataBand.getDataBandInfoV2().SubReports = new ArrayList();
        StiComponentsCollection stiComponentsCollection = comps = masterDataBand.GetComponents();
        synchronized (stiComponentsCollection) {
            for (StiComponent comp : comps) {
                if (!(comp instanceof StiSubReport)) continue;
                masterDataBand.getDataBandInfoV2().SubReports.add((StiSubReport)comp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void FindDetails(StiDataBand masterDataBand) {
        StiComponentsCollection comps;
        if (masterDataBand == null) {
            return;
        }
        if (masterDataBand.parent == null) {
            return;
        }
        if (masterDataBand.getDataBandInfoV2() == null) {
            return;
        }
        masterDataBand.getDataBandInfoV2().Details = new StiComponentsCollection();
        StiComponentsCollection stiComponentsCollection = comps = masterDataBand.GetComponents();
        synchronized (stiComponentsCollection) {
            for (StiComponent comp : comps) {
                if (!(comp instanceof IStiMasterComponent) || comp instanceof StiSubReport) continue;
                masterDataBand.getDataBandInfoV2().Details.add(comp);
            }
        }
    }

    public final void ResetHeaders(StiDataBand masterDataBand) {
        masterDataBand.getDataBandInfoV2().Headers = null;
    }

    public final void ResetHierarchicalHeaders(StiDataBand masterDataBand) {
        masterDataBand.getDataBandInfoV2().HierarchicalHeaders = null;
    }

    public final void ResetFooters(StiDataBand masterDataBand) {
        masterDataBand.getDataBandInfoV2().FootersOnAllPages = null;
        masterDataBand.getDataBandInfoV2().FootersOnLastPage = null;
    }

    public final void ResetHierarchicalFooters(StiDataBand masterDataBand) {
        masterDataBand.getDataBandInfoV2().HierarchicalFooters = null;
    }

    public final void ResetEmptyBands(StiDataBand masterDataBand) {
        masterDataBand.getDataBandInfoV2().EmptyBands = null;
    }

    public final void ResetGroupHeaders(StiDataBand masterDataBand) {
        masterDataBand.getDataBandInfoV2().GroupHeaders = null;
    }

    public final void ResetGroupFooters(StiDataBand masterDataBand) {
        masterDataBand.getDataBandInfoV2().GroupFooters = null;
    }

    public final void ResetDetailDataBands(StiDataBand masterDataBand) {
        masterDataBand.getDataBandInfoV2().DetailDataBands = null;
    }

    public final void ResetDetails(StiDataBand masterDataBand) {
        masterDataBand.getDataBandInfoV2().Details = null;
    }

    public final void AddKeepLevelAtLatestDataBand(StiDataBand masterDataBand) {
        masterDataBand.getReport().engine.getThreads().SelectThreadFromContainer(masterDataBand);
        if (masterDataBand.getReport().engine.getContainerForRender() != null) {
            masterDataBand.getReport().engine.AddKeepLevelAtLatestDataBand();
        }
    }

    public final void AddKeepLevel(StiDataBand masterDataBand) {
        masterDataBand.getReport().engine.getThreads().SelectThreadFromContainer(masterDataBand);
        if (masterDataBand.getReport().engine.getContainerForRender() != null) {
            masterDataBand.getReport().engine.AddLevel();
        }
    }

    public final void RemoveKeepLevel(StiDataBand masterDataBand) {
        masterDataBand.getReport().engine.getThreads().SelectThreadFromContainer(masterDataBand);
        if (masterDataBand.getReport().engine.getContainerForRender() != null) {
            masterDataBand.getReport().engine.RemoveLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RemoveKeepGroupHeaders(StiDataBand masterDataBand) {
        int index = 0;
        ArrayList<StiGroupHeaderBand> arrayList = masterDataBand.getDataBandInfoV2().GroupHeaders;
        synchronized (arrayList) {
            for (StiGroupHeaderBand groupHeader : masterDataBand.getDataBandInfoV2().GroupHeaders) {
                if (masterDataBand.getDataBandInfoV2().GroupHeaderResults[index] && groupHeader.getKeepGroupHeaderTogether()) {
                    this.RemoveKeepLevel(masterDataBand);
                }
                ++index;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RemoveKeepHeaders(StiDataBand masterDataBand) {
        ArrayList<StiHeaderBand> arrayList = masterDataBand.getDataBandInfoV2().Headers;
        synchronized (arrayList) {
            for (StiHeaderBand header : masterDataBand.getDataBandInfoV2().Headers) {
                if (!header.keepHeaderTogether || masterDataBand.getPosition() != 0) continue;
                this.RemoveKeepLevel(masterDataBand);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean AllowKeepDetails(StiDataBand masterDataBand) {
        if (!this.AllowDetailDataBands(masterDataBand)) {
            return false;
        }
        if (masterDataBand.getKeepDetails() == StiKeepDetails.None) {
            return false;
        }
        ArrayList<StiDataBand> arrayList = masterDataBand.getDataBandInfoV2().DetailDataBands;
        synchronized (arrayList) {
            for (StiDataBand detailDataBand : masterDataBand.getDataBandInfoV2().DetailDataBands) {
                if (detailDataBand.getParent().getName() == masterDataBand.getParent().getName()) continue;
                return false;
            }
        }
        return true;
    }

    public final void AddKeepDetails(StiDataBand masterDataBand) {
        if (this.AllowKeepDetails(masterDataBand)) {
            if (masterDataBand.getKeepDetails() == StiKeepDetails.KeepFirstDetailTogether) {
                masterDataBand.getReport().getEngine().getKeepFirstDetailTogetherList().put(masterDataBand, masterDataBand);
            }
            this.AddKeepLevel(masterDataBand);
        }
    }

    public final void RemoveKeepDetails(StiDataBand masterDataBand) {
        if (this.AllowKeepDetails(masterDataBand)) {
            if (masterDataBand.getMasterComponent() != null && masterDataBand.getReport().getEngine().getKeepFirstDetailTogetherList().get(masterDataBand.getMasterComponent()) != null) {
                masterDataBand.getReport().getEngine().getKeepFirstDetailTogetherList().remove(masterDataBand.getMasterComponent());
            }
            this.RemoveKeepLevel(masterDataBand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void StartBands(StiDataBand masterDataBand, ArrayList<? extends StiBand> bands) {
        ArrayList<? extends StiBand> arrayList = bands;
        synchronized (arrayList) {
            for (StiBand stiBand : bands) {
                this.StartBand(masterDataBand, stiBand);
            }
        }
    }

    public final void StartBand(StiDataBand masterDataBand, StiBand band) {
        IStiPrintOnAllPages print = (IStiPrintOnAllPages)((Object)(band instanceof IStiPrintOnAllPages ? band : null));
        if (print != null && print.getPrintOnAllPages()) {
            masterDataBand.getReport().engine.getBandsOnAllPages().Add(masterDataBand, band);
        }
    }

    public final void EndBands(StiDataBand masterDataBand) {
        masterDataBand.getReport().engine.getBandsOnAllPages().Remove(masterDataBand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean GetGroupHeaderResult(StiDataBand masterDataBand, StiGroupHeaderBand groupHeaderBand) {
        int index = 0;
        ArrayList<StiGroupHeaderBand> arrayList = masterDataBand.getDataBandInfoV2().GroupHeaders;
        synchronized (arrayList) {
            for (StiGroupHeaderBand header : masterDataBand.getDataBandInfoV2().GroupHeaders) {
                if (header == groupHeaderBand) {
                    return masterDataBand.getDataBandInfoV2().GroupHeaderResults[index];
                }
                ++index;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean GetGroupFooterResult(StiDataBand masterDataBand, StiGroupHeaderBand groupHeaderBand) {
        int index = 0;
        ArrayList<StiGroupHeaderBand> arrayList = masterDataBand.getDataBandInfoV2().GroupHeaders;
        synchronized (arrayList) {
            for (StiGroupHeaderBand header : masterDataBand.getDataBandInfoV2().GroupHeaders) {
                if (header == groupHeaderBand) {
                    return masterDataBand.getDataBandInfoV2().GroupFooterResults[index];
                }
                ++index;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void LinkGroupHeadersAndGroupFooters(StiDataBand masterDataBand) {
        ArrayList<StiGroupHeaderBand> arrayList = masterDataBand.getDataBandInfoV2().GroupHeaders;
        synchronized (arrayList) {
            for (StiGroupHeaderBand band : masterDataBand.getDataBandInfoV2().GroupHeaders) {
                band.getGroupHeaderBandInfoV2().GroupFooter = null;
            }
        }
        for (int footerIndex = 0; footerIndex < masterDataBand.getDataBandInfoV2().GroupFooters.size(); ++footerIndex) {
            int headerIndex = masterDataBand.getDataBandInfoV2().GroupHeaders.size() - footerIndex - 1;
            if (headerIndex >= 0) {
                masterDataBand.getDataBandInfoV2().GroupFooters.get((int)footerIndex).getGroupFooterBandInfoV2().GroupHeader = masterDataBand.getDataBandInfoV2().GroupHeaders.get(headerIndex);
                masterDataBand.getDataBandInfoV2().GroupHeaders.get((int)headerIndex).getGroupHeaderBandInfoV2().GroupFooter = masterDataBand.getDataBandInfoV2().GroupFooters.get(footerIndex);
                continue;
            }
            masterDataBand.getDataBandInfoV2().GroupFooters.get((int)footerIndex).getGroupFooterBandInfoV2().GroupHeader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ResetLinkGroupHeadersAndGroupFooters(StiDataBand masterDataBand) {
        ArrayList<StiDynamicBand> arrayList;
        if (masterDataBand.getDataBandInfoV2().GroupHeaders != null) {
            arrayList = masterDataBand.getDataBandInfoV2().GroupHeaders;
            synchronized (arrayList) {
                for (StiGroupHeaderBand stiGroupHeaderBand : masterDataBand.getDataBandInfoV2().GroupHeaders) {
                    stiGroupHeaderBand.getGroupHeaderBandInfoV2().GroupFooter = null;
                }
            }
        }
        if (masterDataBand.getDataBandInfoV2().GroupFooters != null) {
            arrayList = masterDataBand.getDataBandInfoV2().GroupFooters;
            synchronized (arrayList) {
                for (StiGroupFooterBand stiGroupFooterBand : masterDataBand.getDataBandInfoV2().GroupFooters) {
                    stiGroupFooterBand.getGroupFooterBandInfoV2().GroupHeader = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void PrepareGroupResults(StiDataBand masterDataBand) {
        int index = 0;
        ArrayList<StiGroupHeaderBand> arrayList = masterDataBand.getDataBandInfoV2().GroupHeaders;
        synchronized (arrayList) {
            for (StiGroupHeaderBand header : masterDataBand.getDataBandInfoV2().GroupHeaders) {
                Object currentValue;
                Object currentValue2;
                StiBusinessObject businessObject;
                if (masterDataBand.getPosition() > 0) {
                    if (!masterDataBand.getIsBusinessObjectEmpty()) {
                        businessObject = masterDataBand.getBusinessObject();
                        businessObject.SetPrevValue();
                        Object prevValue = StiGroupHeaderBandV2Builder.GetCurrentConditionValue(header);
                        businessObject.RestoreCurrentValue();
                        currentValue2 = StiGroupHeaderBandV2Builder.GetCurrentConditionValue(header);
                        masterDataBand.getDataBandInfoV2().GroupHeaderResults[index] = !StiValidationUtil.equals((Object)prevValue, (Object)currentValue2);
                    } else {
                        masterDataBand.setPosition(masterDataBand.getPosition() - 1);
                        Object prevValue = StiGroupHeaderBandV2Builder.GetCurrentConditionValue(header);
                        masterDataBand.setPosition(masterDataBand.getPosition() + 1);
                        currentValue = StiGroupHeaderBandV2Builder.GetCurrentConditionValue(header);
                        masterDataBand.getDataBandInfoV2().GroupHeaderResults[index] = !StiValidationUtil.equals((Object)prevValue, (Object)currentValue);
                    }
                } else {
                    masterDataBand.getDataBandInfoV2().GroupHeaderResults[index] = true;
                }
                if (masterDataBand.getPosition() < masterDataBand.getCount() - 1) {
                    if (!masterDataBand.getIsBusinessObjectEmpty()) {
                        businessObject = masterDataBand.getBusinessObject();
                        businessObject.SetNextValue();
                        Object nextValue = StiGroupHeaderBandV2Builder.GetCurrentConditionValue(header);
                        businessObject.RestoreCurrentValue();
                        currentValue2 = StiGroupHeaderBandV2Builder.GetCurrentConditionValue(header);
                        masterDataBand.getDataBandInfoV2().GroupFooterResults[index] = !StiValidationUtil.equals((Object)nextValue, (Object)currentValue2);
                    } else {
                        masterDataBand.setPosition(masterDataBand.getPosition() + 1);
                        Object nextValue = StiGroupHeaderBandV2Builder.GetCurrentConditionValue(header);
                        masterDataBand.setPosition(masterDataBand.getPosition() - 1);
                        currentValue = StiGroupHeaderBandV2Builder.GetCurrentConditionValue(header);
                        masterDataBand.getDataBandInfoV2().GroupFooterResults[index] = !StiValidationUtil.equals((Object)nextValue, (Object)currentValue);
                    }
                } else {
                    masterDataBand.getDataBandInfoV2().GroupFooterResults[index] = true;
                }
                ++index;
            }
        }
        for (int indexHeader = 0; indexHeader < masterDataBand.getDataBandInfoV2().GroupHeaderResults.length; ++indexHeader) {
            if (!masterDataBand.getDataBandInfoV2().GroupHeaderResults[indexHeader]) continue;
            for (int index2 = indexHeader + 1; index2 < masterDataBand.getDataBandInfoV2().GroupHeaderResults.length; ++index2) {
                masterDataBand.getDataBandInfoV2().GroupHeaderResults[index2] = true;
            }
            break;
        }
        for (int indexFooter = 0; indexFooter < masterDataBand.getDataBandInfoV2().GroupFooterResults.length; ++indexFooter) {
            if (!masterDataBand.getDataBandInfoV2().GroupFooterResults[indexFooter]) continue;
            for (int index2 = indexFooter + 1; index2 < masterDataBand.getDataBandInfoV2().GroupFooterResults.length; ++index2) {
                masterDataBand.getDataBandInfoV2().GroupFooterResults[index2] = true;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RenderGroupHeaders(StiDataBand masterDataBand) {
        masterDataBand.parentBookmark = masterDataBand.getDataBandInfoV2().StoredParentBookmark;
        boolean isGroupRendered = false;
        int index = 0;
        ArrayList<StiGroupHeaderBand> arrayList = masterDataBand.getDataBandInfoV2().GroupHeaders;
        synchronized (arrayList) {
            for (StiGroupHeaderBand groupHeader : masterDataBand.getDataBandInfoV2().GroupHeaders) {
                groupHeader.parentBookmark = masterDataBand.parentBookmark;
                groupHeader.doBookmark();
                if (groupHeader.parentBookmark != groupHeader.getCurrentBookmark()) {
                    masterDataBand.parentBookmark = groupHeader.getCurrentBookmark();
                }
                if (masterDataBand.getDataBandInfoV2().GroupHeaderResults[index]) {
                    for (int index2 = index + 1; index2 < masterDataBand.getDataBandInfoV2().GroupHeaders.size(); ++index2) {
                        masterDataBand.getReport().engine.RemoveBandFromPageBreakSkipList(masterDataBand.getDataBandInfoV2().GroupHeaders.get(index2) instanceof IStiPageBreak ? masterDataBand.getDataBandInfoV2().GroupHeaders.get(index2) : null);
                    }
                    boolean bl = groupHeader.getGroupHeaderBandInfoV2().SkipKeepGroups = masterDataBand.getReport().engine.getIsFirstDataBandOnPage() && masterDataBand.getComponentType() == StiComponentType.Master && groupHeader.getLine() == 1;
                    if (!groupHeader.getGroupHeaderBandInfoV2().SkipKeepGroups && groupHeader.getKeepGroupTogether()) {
                        this.AddKeepLevel(masterDataBand);
                    }
                    if (groupHeader.getKeepGroupHeaderTogether()) {
                        this.AddKeepLevel(masterDataBand);
                    }
                    masterDataBand.setLine(1);
                    groupHeader.InvokeBeginRender();
                    groupHeader.setCollapsingIndex(groupHeader.getLine());
                    groupHeader.getReport().setGroupLine(groupHeader.getLine());
                    StiDataBandV2Builder.InvokeCollapsedEvent(groupHeader);
                    this.RenderBand(masterDataBand, groupHeader);
                    isGroupRendered = true;
                    if (StiDataBandV2Builder.IsCollapsed(groupHeader, true)) {
                        groupHeader.getGroupHeaderBandInfoV2().OldSilentMode = masterDataBand.getReport().engine.SilentMode;
                        masterDataBand.getReport().engine.SilentMode = true;
                        groupHeader.getGroupHeaderBandInfoV2().SilentModeEnabled = true;
                    }
                }
                ++index;
            }
        }
        if (isGroupRendered) {
            this.RenderColumns(masterDataBand);
        }
    }

    public final void RenderGroupFooters(StiDataBand masterDataBand) {
        for (int index = masterDataBand.getDataBandInfoV2().GroupHeaders.size() - 1; index >= 0; --index) {
            if (!masterDataBand.getDataBandInfoV2().GroupFooterResults[index]) continue;
            StiGroupHeaderBand groupHeader = masterDataBand.getDataBandInfoV2().GroupHeaders.get(index) instanceof StiGroupHeaderBand ? masterDataBand.getDataBandInfoV2().GroupHeaders.get(index) : null;
            StiGroupFooterBand groupFooter = groupHeader.getGroupHeaderBandInfoV2().GroupFooter;
            if (groupFooter != null) {
                boolean needKeepLevel = groupFooter.getKeepGroupFooterTogether();
                if (needKeepLevel) {
                    this.AddKeepLevelAtLatestDataBand(masterDataBand);
                }
                if (groupHeader.getGroupHeaderBandInfoV2().SilentModeEnabled && groupHeader.getInteraction() instanceof StiBandInteraction && !((StiBandInteraction)groupHeader.getInteraction()).getCollapseGroupFooter()) {
                    masterDataBand.getReport().engine.SilentMode = groupHeader.getGroupHeaderBandInfoV2().OldSilentMode;
                    groupHeader.getGroupHeaderBandInfoV2().SilentModeEnabled = false;
                }
                this.RenderBand(masterDataBand, groupFooter);
                if (groupHeader.getGroupHeaderBandInfoV2().SilentModeEnabled) {
                    masterDataBand.getReport().engine.SilentMode = groupHeader.getGroupHeaderBandInfoV2().OldSilentMode;
                    groupHeader.getGroupHeaderBandInfoV2().SilentModeEnabled = false;
                }
                if (needKeepLevel) {
                    this.RemoveKeepLevel(masterDataBand);
                }
            }
            groupHeader.InvokeEndRender();
            if (!groupHeader.getGroupHeaderBandInfoV2().SkipKeepGroups && groupHeader.getKeepGroupTogether()) {
                this.RemoveKeepLevel(masterDataBand);
            }
            ++groupHeader.line;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SetDetails(StiDataBand masterDataBand) {
        if (!masterDataBand.isDataSourceEmpty() || !masterDataBand.getIsBusinessObjectEmpty()) {
            ArrayList<StiComponent> arrayList;
            Hashtable<StiBusinessObject, StiBusinessObject> processed = new Hashtable<StiBusinessObject, StiBusinessObject>();
            if (masterDataBand.getDataBandInfoV2().DetailDataBands != null) {
                arrayList = masterDataBand.getDataBandInfoV2().DetailDataBands;
                synchronized (arrayList) {
                    for (StiDataBand comp : masterDataBand.getDataBandInfoV2().DetailDataBands) {
                        masterDataBand.getReport().engine.RemoveBandFromPageBreakSkipList(comp instanceof IStiPageBreak ? comp : null);
                        StiDataHelper.SetData(comp, false);
                        if (!(comp instanceof StiDataBand) || comp.getIsBusinessObjectEmpty()) continue;
                        StiBusinessObject businessObject = comp.getBusinessObject();
                        processed.put(businessObject, businessObject);
                    }
                }
            }
            if (!masterDataBand.getIsBusinessObjectEmpty()) {
                StiBusinessObject businessObject = masterDataBand.getBusinessObject();
                for (StiBusinessObject child : businessObject.getBusinessObjects()) {
                    if (processed.get((Object)child) != null) continue;
                    child.SetDetails();
                }
            }
            if (masterDataBand.getDataBandInfoV2().SubReports != null) {
                arrayList = masterDataBand.getDataBandInfoV2().SubReports;
                synchronized (arrayList) {
                    for (StiSubReport subReport : masterDataBand.getDataBandInfoV2().SubReports) {
                        StiComponentsCollection comps;
                        if (subReport.getSubReportPage() == null) continue;
                        StiComponentsCollection stiComponentsCollection = comps = subReport.getSubReportPage().GetComponents();
                        synchronized (stiComponentsCollection) {
                            for (StiComponent comp : comps) {
                                StiDataBand dataBand = comp instanceof StiDataBand ? (StiDataBand)comp : null;
                                boolean theSameDataSource = dataBand != null && dataBand.getDataSource() == masterDataBand.getDataSource();
                                if (theSameDataSource) continue;
                                StiDataHelper.SetData(comp, false);
                            }
                        }
                    }
                }
            }
            if (masterDataBand.getDataBandInfoV2().Details != null) {
                arrayList = masterDataBand.getDataBandInfoV2().Details;
                synchronized (arrayList) {
                    for (StiComponent detail : masterDataBand.getDataBandInfoV2().Details) {
                        StiDataHelper.SetData(detail, false);
                    }
                }
            }
        }
        StiDataBandV2Builder.PrepareGroupResults(masterDataBand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RenderDetailDataBands(StiDataBand masterDataBand) {
        if (this.AllowDetailDataBands(masterDataBand)) {
            ArrayList<StiDataBand> arrayList = masterDataBand.getDataBandInfoV2().DetailDataBands;
            synchronized (arrayList) {
                for (StiDataBand component : masterDataBand.getDataBandInfoV2().DetailDataBands) {
                    if (!component.getEnabled() || !this.IsAllow(masterDataBand, component instanceof StiDataBand ? component : null)) continue;
                    component.parentBookmark = masterDataBand.getCurrentBookmark();
                    IStiRenderMaster renderMaster = component instanceof IStiRenderMaster ? component : null;
                    if (renderMaster != null) {
                        renderMaster.renderMaster();
                        continue;
                    }
                    component.render();
                }
            }
        }
    }

    private StiDataBand GetParentDataBand(StiContainer cont) {
        StiContainer parent = cont.parent;
        while (parent != null && !(parent instanceof StiPage)) {
            StiBand band;
            if (parent instanceof StiDataBand) {
                return (StiDataBand)(parent instanceof StiDataBand ? parent : null);
            }
            if (parent instanceof StiChildBand && (band = ((StiChildBand)(parent instanceof StiChildBand ? parent : null)).GetMaster()) instanceof StiDataBand) {
                return (StiDataBand)(band instanceof StiDataBand ? band : null);
            }
            parent = parent.parent;
        }
        return null;
    }

    private boolean IsAllow(StiDataBand master, StiDataBand detail) {
        StiDataBand detailDataBand;
        if (master.parent == detail.parent) {
            return true;
        }
        StiDataBand masterDataBand = this.GetParentDataBand(master);
        return masterDataBand != (detailDataBand = this.GetParentDataBand(detail)) || masterDataBand == null;
    }

    public final boolean AllowDetailDataBands(StiDataBand masterDataBand) {
        return masterDataBand.getDataBandInfoV2().DetailDataBands.size() > 0 && masterDataBand.getColumns() < 2;
    }

    public final boolean IsDenyDetailsOnFirstPage(StiDataBand masterDataBand) {
        return masterDataBand.getReport().engine.getIsFirstDataBandOnPage() && masterDataBand.getComponentType() == StiComponentType.Master && masterDataBand.getLine() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean IsDetailDataSourcesEmpty(StiDataBand masterDataBand) {
        if (masterDataBand.getDataBandInfoV2().DetailDataBands == null || masterDataBand.getDataBandInfoV2().DetailDataBands.size() == 0) {
            return false;
        }
        ArrayList<StiDataBand> arrayList = masterDataBand.getDataBandInfoV2().DetailDataBands;
        synchronized (arrayList) {
            for (StiDataBand comp : masterDataBand.getDataBandInfoV2().DetailDataBands) {
                if (comp instanceof IStiDataSource && !((IStiDataSource)comp).getIsEmpty()) {
                    return false;
                }
                if (!(comp instanceof IStiBusinessObject) || ((IStiBusinessObject)comp).getIsEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean IsPrintIfDetailEmpty(StiDataBand masterDataBand) {
        if (masterDataBand.getPrintIfDetailEmpty()) {
            return true;
        }
        if (StiDataBandV2Builder.IsDetailDataSourcesEmpty(masterDataBand)) {
            return false;
        }
        boolean isNotEmpty = false;
        boolean flag = true;
        for (StiDataBand dataBand : masterDataBand.getDataBandInfoV2().DetailDataBands) {
            flag = false;
            if (StiOptions.Engine.isPrintIfDetailEmptyNesting()) {
                dataBand.saveState("CheckPrintIfDetailEmpty");
                dataBand.First();
                while (!dataBand.getIsEof()) {
                    if (StiDataBandV2Builder.IsPrintIfDetailEmpty(dataBand)) {
                        isNotEmpty = true;
                        break;
                    }
                    dataBand.Next();
                }
                dataBand.RestoreState("CheckPrintIfDetailEmpty");
            } else if (StiDataBandV2Builder.IsPrintIfDetailEmpty(dataBand)) {
                isNotEmpty = true;
            }
            if (!isNotEmpty) continue;
            break;
        }
        return flag || isNotEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RenderHeaders(StiDataBand masterDataBand) {
        ArrayList<StiHeaderBand> arrayList = masterDataBand.getDataBandInfoV2().Headers;
        synchronized (arrayList) {
            for (StiHeaderBand header : masterDataBand.getDataBandInfoV2().Headers) {
                if (masterDataBand.getIsEmpty() && !header.getPrintIfEmpty()) continue;
                if (!masterDataBand.getIsEmpty() && header.keepHeaderTogether) {
                    this.AddKeepLevel(masterDataBand);
                }
                this.RenderBand(masterDataBand, header);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RenderHierarchicalHeaders(StiDataBand masterDataBand, boolean allowIndent, int level) {
        if (masterDataBand.getDataBandInfoV2().HierarchicalHeaders == null) {
            return;
        }
        ArrayList<StiHeaderBand> arrayList = masterDataBand.getDataBandInfoV2().HierarchicalHeaders;
        synchronized (arrayList) {
            for (StiHeaderBand header : masterDataBand.getDataBandInfoV2().HierarchicalHeaders) {
                if (masterDataBand.getIsEmpty() && !header.getPrintIfEmpty()) continue;
                if (!masterDataBand.getIsEmpty() && header.keepHeaderTogether) {
                    this.AddKeepLevel(masterDataBand);
                }
                try {
                    if (allowIndent) {
                        StiHierarchicalBandV2Builder.CreateIndention((StiHierarchicalBand)(masterDataBand instanceof StiHierarchicalBand ? masterDataBand : null), header, level);
                    }
                    this.RenderBand(masterDataBand, header);
                    if (!allowIndent) continue;
                }
                catch (Throwable throwable) {
                    if (allowIndent) {
                        StiHierarchicalBandV2Builder.CreateIndention((StiHierarchicalBand)(masterDataBand instanceof StiHierarchicalBand ? masterDataBand : null), header, -level);
                    }
                    throw throwable;
                }
                StiHierarchicalBandV2Builder.CreateIndention((StiHierarchicalBand)(masterDataBand instanceof StiHierarchicalBand ? masterDataBand : null), header, -level);
            }
        }
    }

    public final void AddFooterMarker(StiDataBand masterDataBand, StiFooterBand footerMaster) {
        masterDataBand.getReport().engine.getThreads().SelectThreadFromContainer(masterDataBand);
        masterDataBand.getReport().engine.AddFooterMarker(footerMaster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RenderMarkerFootersOnAllPages(StiDataBand masterDataBand) {
        ArrayList<StiFooterBand> arrayList = masterDataBand.getDataBandInfoV2().FootersOnAllPages;
        synchronized (arrayList) {
            for (StiFooterBand band : masterDataBand.getDataBandInfoV2().FootersOnAllPages) {
                if (masterDataBand.getIsEmpty() && !band.getPrintIfEmpty()) continue;
                this.AddFooterMarker(masterDataBand, band);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RenderFootersOnLastPage(StiDataBand masterDataBand) {
        try {
            if (masterDataBand instanceof StiHierarchicalBand) {
                ((StiHierarchicalBand)masterDataBand).getHierarchicalBandInfoV2().FinalFooterCalculation = true;
            }
            ArrayList<StiFooterBand> arrayList = masterDataBand.getDataBandInfoV2().FootersOnLastPage;
            synchronized (arrayList) {
                for (StiFooterBand footer : masterDataBand.getDataBandInfoV2().FootersOnLastPage) {
                    boolean needKeepLevel;
                    if (masterDataBand.getIsEmpty() && !footer.getPrintIfEmpty()) continue;
                    boolean bl = needKeepLevel = !masterDataBand.getIsEmpty() && footer.getKeepFooterTogether();
                    if (needKeepLevel) {
                        this.AddKeepLevelAtLatestDataBand(masterDataBand);
                    }
                    this.RenderBand(masterDataBand, footer);
                    if (!needKeepLevel) continue;
                    this.RemoveKeepLevel(masterDataBand);
                }
            }
        }
        finally {
            if (masterDataBand instanceof StiHierarchicalBand) {
                ((StiHierarchicalBand)masterDataBand).getHierarchicalBandInfoV2().FinalFooterCalculation = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RenderFootersOnAllPages(StiDataBand masterDataBand) {
        ArrayList<StiFooterBand> arrayList = masterDataBand.getDataBandInfoV2().FootersOnAllPages;
        synchronized (arrayList) {
            for (StiFooterBand band : masterDataBand.getDataBandInfoV2().FootersOnAllPages) {
                if (masterDataBand.getIsEmpty() && !band.getPrintIfEmpty()) continue;
                this.RenderBand(masterDataBand, band);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void RenderHierarchicalFooters(StiDataBand masterDataBand, boolean allowIndent, int level) {
        if (masterDataBand.getDataBandInfoV2().HierarchicalFooters == null) {
            return;
        }
        ArrayList<StiFooterBand> arrayList = masterDataBand.getDataBandInfoV2().HierarchicalFooters;
        synchronized (arrayList) {
            Iterator<StiFooterBand> i$ = masterDataBand.getDataBandInfoV2().HierarchicalFooters.iterator();
            while (i$.hasNext()) {
                boolean needKeepLevel;
                block8: {
                    StiFooterBand footer = i$.next();
                    if (masterDataBand.getIsEmpty() && !footer.getPrintIfEmpty()) continue;
                    boolean bl = needKeepLevel = !masterDataBand.getIsEmpty() && footer.getKeepFooterTogether();
                    if (needKeepLevel) {
                        this.AddKeepLevelAtLatestDataBand(masterDataBand);
                    }
                    try {
                        if (allowIndent) {
                            StiHierarchicalBandV2Builder.CreateIndention((StiHierarchicalBand)(masterDataBand instanceof StiHierarchicalBand ? masterDataBand : null), footer, level);
                        }
                        this.RenderBand(masterDataBand, footer);
                        if (!allowIndent) break block8;
                    }
                    catch (Throwable throwable) {
                        if (!allowIndent) throw throwable;
                        StiHierarchicalBandV2Builder.CreateIndention((StiHierarchicalBand)(masterDataBand instanceof StiHierarchicalBand ? masterDataBand : null), footer, -level);
                        throw throwable;
                    }
                    StiHierarchicalBandV2Builder.CreateIndention((StiHierarchicalBand)(masterDataBand instanceof StiHierarchicalBand ? masterDataBand : null), footer, -level);
                }
                if (!needKeepLevel) continue;
                this.RemoveKeepLevel(masterDataBand);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RenderReportTitles(StiDataBand masterDataBand) {
        if (masterDataBand.getDataBandInfoV2().ReportTitles == null) {
            return;
        }
        ArrayList<StiReportTitleBand> arrayList = masterDataBand.getDataBandInfoV2().ReportTitles;
        synchronized (arrayList) {
            for (StiReportTitleBand title : masterDataBand.getDataBandInfoV2().ReportTitles) {
                if (masterDataBand.getIsEmpty() && !title.getPrintIfEmpty()) continue;
                this.RenderBand(masterDataBand, title);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RenderReportSummaries(StiDataBand masterDataBand) {
        if (masterDataBand.getDataBandInfoV2().ReportSummaries == null) {
            return;
        }
        ArrayList<StiReportSummaryBand> arrayList = masterDataBand.getDataBandInfoV2().ReportSummaries;
        synchronized (arrayList) {
            for (StiReportSummaryBand summary : masterDataBand.getDataBandInfoV2().ReportSummaries) {
                boolean needKeepLevel;
                if (masterDataBand.getIsEmpty() && !summary.getPrintIfEmpty()) continue;
                boolean bl = needKeepLevel = !masterDataBand.getIsEmpty() && summary.getKeepReportSummaryTogether();
                if (needKeepLevel) {
                    this.AddKeepLevelAtLatestDataBand(masterDataBand);
                }
                this.RenderBand(masterDataBand, summary);
                if (!needKeepLevel) continue;
                this.RemoveKeepLevel(masterDataBand);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean CheckKeepReportSummaryTogether(StiDataBand masterDataBand) {
        if (masterDataBand.getDataBandInfoV2().ReportSummaries == null) {
            return false;
        }
        boolean keepReportSummaryTogether = false;
        ArrayList<StiReportSummaryBand> arrayList = masterDataBand.getDataBandInfoV2().ReportSummaries;
        synchronized (arrayList) {
            for (StiReportSummaryBand summary : masterDataBand.getDataBandInfoV2().ReportSummaries) {
                if (masterDataBand.getIsEmpty() || !summary.getKeepReportSummaryTogether()) continue;
                keepReportSummaryTogether = true;
            }
        }
        return keepReportSummaryTogether;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Block(StiDataBand masterDataBand) {
        ArrayList<StiDynamicBand> arrayList = masterDataBand.getDataBandInfoV2().GroupHeaders;
        synchronized (arrayList) {
            for (StiGroupHeaderBand stiGroupHeaderBand : masterDataBand.getDataBandInfoV2().GroupHeaders) {
                stiGroupHeaderBand.setBlocked(true);
            }
        }
        arrayList = masterDataBand.getDataBandInfoV2().GroupFooters;
        synchronized (arrayList) {
            for (StiGroupFooterBand stiGroupFooterBand : masterDataBand.getDataBandInfoV2().GroupFooters) {
                stiGroupFooterBand.setBlocked(true);
            }
        }
        arrayList = masterDataBand.getDataBandInfoV2().Headers;
        synchronized (arrayList) {
            for (StiHeaderBand stiHeaderBand : masterDataBand.getDataBandInfoV2().Headers) {
                stiHeaderBand.setBlocked(true);
            }
        }
        arrayList = masterDataBand.getDataBandInfoV2().FootersOnAllPages;
        synchronized (arrayList) {
            for (StiFooterBand stiFooterBand : masterDataBand.getDataBandInfoV2().FootersOnAllPages) {
                stiFooterBand.setBlocked(true);
            }
        }
        arrayList = masterDataBand.getDataBandInfoV2().FootersOnLastPage;
        synchronized (arrayList) {
            for (StiFooterBand stiFooterBand : masterDataBand.getDataBandInfoV2().FootersOnLastPage) {
                stiFooterBand.setBlocked(true);
            }
        }
        if (masterDataBand.getDataBandInfoV2().ReportSummaries != null) {
            arrayList = masterDataBand.getDataBandInfoV2().ReportSummaries;
            synchronized (arrayList) {
                for (StiReportSummaryBand stiReportSummaryBand : masterDataBand.getDataBandInfoV2().ReportSummaries) {
                    stiReportSummaryBand.setBlocked(true);
                }
            }
        }
        masterDataBand.setBlocked(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void UnBlock(StiDataBand masterDataBand) {
        ArrayList<StiDynamicBand> arrayList = masterDataBand.getDataBandInfoV2().GroupHeaders;
        synchronized (arrayList) {
            for (StiGroupHeaderBand stiGroupHeaderBand : masterDataBand.getDataBandInfoV2().GroupHeaders) {
                stiGroupHeaderBand.setBlocked(false);
            }
        }
        arrayList = masterDataBand.getDataBandInfoV2().GroupFooters;
        synchronized (arrayList) {
            for (StiGroupFooterBand stiGroupFooterBand : masterDataBand.getDataBandInfoV2().GroupFooters) {
                stiGroupFooterBand.setBlocked(false);
            }
        }
        arrayList = masterDataBand.getDataBandInfoV2().Headers;
        synchronized (arrayList) {
            for (StiHeaderBand stiHeaderBand : masterDataBand.getDataBandInfoV2().Headers) {
                stiHeaderBand.setBlocked(false);
            }
        }
        arrayList = masterDataBand.getDataBandInfoV2().FootersOnAllPages;
        synchronized (arrayList) {
            for (StiFooterBand stiFooterBand : masterDataBand.getDataBandInfoV2().FootersOnAllPages) {
                stiFooterBand.setBlocked(false);
            }
        }
        arrayList = masterDataBand.getDataBandInfoV2().FootersOnLastPage;
        synchronized (arrayList) {
            for (StiFooterBand stiFooterBand : masterDataBand.getDataBandInfoV2().FootersOnLastPage) {
                stiFooterBand.setBlocked(false);
            }
        }
        masterDataBand.setBlocked(false);
    }

    public final void CheckHierarchicalHeaders(StiDataBand masterDataBand) {
        if (masterDataBand instanceof StiHierarchicalBand) {
            int currentLevel = 0;
            int position = 0;
            if (!masterDataBand.isDataSourceEmpty()) {
                currentLevel = masterDataBand.getDataSource().GetLevel();
                position = masterDataBand.getDataSource().getPositionValue();
            }
            if (!masterDataBand.getIsBusinessObjectEmpty()) {
                currentLevel = masterDataBand.getBusinessObject().getLevel();
                position = masterDataBand.getBusinessObject().Position;
            }
            if (position == 0) {
                for (int index = 0; index <= currentLevel; ++index) {
                    if (index != currentLevel) {
                        ((StiHierarchicalBand)masterDataBand).getHierarchicalBandInfoV2().SpecifiedLevel = index;
                    }
                    this.RenderHierarchicalHeaders(masterDataBand, true, index);
                    ((StiHierarchicalBand)masterDataBand).getHierarchicalBandInfoV2().SpecifiedLevel = -1;
                }
            } else {
                int prevLevel = 0;
                if (!masterDataBand.isDataSourceEmpty()) {
                    masterDataBand.getDataSource().setPositionValue(masterDataBand.getDataSource().getPositionValue() - 1);
                    prevLevel = masterDataBand.getDataSource().GetLevel();
                    masterDataBand.getDataSource().setPositionValue(masterDataBand.getDataSource().getPositionValue() + 1);
                }
                if (!masterDataBand.getIsBusinessObjectEmpty()) {
                    masterDataBand.getBusinessObject().SetPrevValue();
                    prevLevel = masterDataBand.getBusinessObject().getLevel();
                    masterDataBand.getBusinessObject().RestoreCurrentValue();
                }
                if (prevLevel < currentLevel) {
                    for (int index = currentLevel; index > prevLevel; --index) {
                        if (index != currentLevel) {
                            ((StiHierarchicalBand)masterDataBand).getHierarchicalBandInfoV2().SpecifiedLevel = index;
                        }
                        this.RenderHierarchicalHeaders(masterDataBand, true, index);
                        ((StiHierarchicalBand)masterDataBand).getHierarchicalBandInfoV2().SpecifiedLevel = -1;
                    }
                    ((StiHierarchicalBand)masterDataBand).getHierarchicalBandInfoV2().SpecifiedLevel = -1;
                }
            }
        }
    }

    public final void CheckHierarchicalFooters(StiDataBand masterDataBand) {
        if (masterDataBand instanceof StiHierarchicalBand) {
            int position = 0;
            int count = 0;
            int currentLevel = 0;
            if (!masterDataBand.isDataSourceEmpty()) {
                position = masterDataBand.getDataSource().getPositionValue();
                count = masterDataBand.getDataSource().getCount();
                currentLevel = masterDataBand.getDataSource().GetLevel();
            }
            if (!masterDataBand.getIsBusinessObjectEmpty()) {
                position = masterDataBand.getBusinessObject().getPosition();
                count = masterDataBand.getBusinessObject().size();
                currentLevel = masterDataBand.getBusinessObject().getLevel();
            }
            if (position == count - 1) {
                for (int index = currentLevel; index >= 0; --index) {
                    if (index != currentLevel) {
                        ((StiHierarchicalBand)masterDataBand).getHierarchicalBandInfoV2().SpecifiedLevel = index;
                    }
                    this.RenderHierarchicalFooters(masterDataBand, true, index);
                }
                ((StiHierarchicalBand)masterDataBand).getHierarchicalBandInfoV2().SpecifiedLevel = -1;
            } else {
                int nextLevel = 0;
                if (!masterDataBand.isDataSourceEmpty()) {
                    masterDataBand.getDataSource().setPositionValue(masterDataBand.getDataSource().getPositionValue() + 1);
                    nextLevel = masterDataBand.getDataSource().GetLevel();
                    masterDataBand.getDataSource().setPositionValue(masterDataBand.getDataSource().getPositionValue() - 1);
                }
                if (!masterDataBand.getIsBusinessObjectEmpty()) {
                    masterDataBand.getBusinessObject().SetNextValue();
                    nextLevel = masterDataBand.getBusinessObject().getLevel();
                    masterDataBand.getBusinessObject().RestoreCurrentValue();
                }
                if (nextLevel < currentLevel) {
                    for (int index = currentLevel; index > nextLevel; --index) {
                        if (index != currentLevel) {
                            ((StiHierarchicalBand)masterDataBand).getHierarchicalBandInfoV2().SpecifiedLevel = index;
                        }
                        this.RenderHierarchicalFooters(masterDataBand, true, index);
                    }
                    ((StiHierarchicalBand)masterDataBand).getHierarchicalBandInfoV2().SpecifiedLevel = -1;
                }
            }
        }
    }

    public final void RenderBand(StiDataBand masterDataBand, StiBand band) {
        this.RenderBand(masterDataBand, band, false, false);
    }

    public final void RenderBand(StiDataBand masterDataBand, StiBand band, boolean ignorePageBreaks, boolean allowRenderingEvents) {
        this.RegisterEmptyBands(masterDataBand);
        if (!(band instanceof StiGroupHeaderBand)) {
            if (band != masterDataBand) {
                band.parentBookmark = masterDataBand.parentBookmark;
            }
            band.doBookmark();
        }
        masterDataBand.getReport().engine.getThreads().SelectThreadFromContainer(band);
        if (masterDataBand.getReport().engine.getContainerForRender() != null) {
            masterDataBand.getReport().engine.RenderBand(band, ignorePageBreaks, allowRenderingEvents);
        }
    }

    public final void RenderColumns(StiDataBand masterDataBand) {
        masterDataBand.getReport().engine.getThreads().SelectThreadFromContainer(masterDataBand);
        masterDataBand.getReport().engine.getColumnsOnDataBand().RenderColumns(masterDataBand);
    }

    public final void RegisterEmptyBands(StiDataBand masterDataBand) {
        masterDataBand.getReport().engine.getEmptyBands().Register(masterDataBand.getDataBandInfoV2().EmptyBands);
    }

    public static boolean IsCollapsed(StiContainer masterDataBand, boolean isRendering) {
        boolean isCollapsed;
        boolean collapsingEnabled = false;
        if (masterDataBand.getInteraction() instanceof StiBandInteraction) {
            boolean bl = collapsingEnabled = !((StiBandInteraction)masterDataBand.getInteraction()).getCollapsingEnabled();
        }
        if (masterDataBand.getInteraction() == null || collapsingEnabled) {
            return false;
        }
        boolean bl = isCollapsed = masterDataBand.getCollapsedValue() instanceof Boolean ? (Boolean)masterDataBand.getCollapsedValue() : false;
        if (masterDataBand.getReport().interactionCollapsingStates == null) {
            return isCollapsed;
        }
        Hashtable list = (Hashtable)(masterDataBand.getReport().interactionCollapsingStates.get(masterDataBand.getName()) instanceof Hashtable ? masterDataBand.getReport().interactionCollapsingStates.get(masterDataBand.getName()) : null);
        if (masterDataBand.getCollapsingTreePath() != null) {
            list = (Hashtable)(masterDataBand.getReport().interactionCollapsingStates.get(masterDataBand.getCollapsingTreePath() + masterDataBand.getName()) instanceof Hashtable ? masterDataBand.getReport().interactionCollapsingStates.get(masterDataBand.getCollapsingTreePath() + masterDataBand.getName()) : null);
        }
        if (list == null) {
            list = (Hashtable)(masterDataBand.getReport().interactionCollapsingStates.get(masterDataBand.getName()) instanceof Hashtable ? masterDataBand.getReport().interactionCollapsingStates.get(masterDataBand.getName()) : null);
        }
        if (list == null) {
            return isCollapsed;
        }
        if (!(list.get(masterDataBand.getCollapsingIndex()) instanceof Boolean)) {
            return isCollapsed;
        }
        return (Boolean)list.get(masterDataBand.collapsingIndex);
    }

    @Override
    public void SetReportVariables(StiComponent masterComp) {
        StiDataBand masterDataBand = (StiDataBand)(masterComp instanceof StiDataBand ? masterComp : null);
        masterDataBand.getReport().setLine(masterDataBand.getLine());
        masterDataBand.getReport().LineThrough = masterDataBand.lineThrough;
    }

    @Override
    public void Prepare(StiComponent masterComp) {
        super.Prepare(masterComp);
        StiDataBand masterDataBand = (StiDataBand)(masterComp instanceof StiDataBand ? masterComp : null);
        this.FindHeaders(masterDataBand);
        this.FindHierarchicalHeaders(masterDataBand);
        this.FindFooters(masterDataBand);
        this.FindHierarchicalFooters(masterDataBand);
        this.FindEmptyBands(masterDataBand);
        this.FindDetailDataBands(masterDataBand);
        this.FindDetails(masterDataBand);
        this.FindSubReports(masterDataBand);
        this.FindGroupHeaders(masterDataBand);
        this.FindGroupFooters(masterDataBand);
        masterDataBand.getDataBandInfoV2().GroupHeaderResults = new boolean[masterDataBand.getDataBandInfoV2().GroupHeaders.size()];
        masterDataBand.getDataBandInfoV2().GroupFooterResults = new boolean[masterDataBand.getDataBandInfoV2().GroupHeaders.size()];
        StiFilterHelper.SetFilter(masterComp);
        if (!masterDataBand.getIsBusinessObjectEmpty() && (masterDataBand.getSort() != null && masterDataBand.getSort().size() > 0 || masterDataBand.getFilterOn() && masterDataBand.getFilterMethodHandler() != null || masterDataBand instanceof StiHierarchicalBand)) {
            masterDataBand.getBusinessObject().setOwnerBand(masterDataBand);
        }
    }

    @Override
    public void UnPrepare(StiComponent masterComp) {
        super.UnPrepare(masterComp);
        StiDataBand masterDataBand = (StiDataBand)(masterComp instanceof StiDataBand ? masterComp : null);
        masterDataBand.getDataBandInfoV2().Headers = null;
        masterDataBand.getDataBandInfoV2().HierarchicalHeaders = null;
        masterDataBand.getDataBandInfoV2().FootersOnAllPages = null;
        masterDataBand.getDataBandInfoV2().FootersOnLastPage = null;
        masterDataBand.getDataBandInfoV2().HierarchicalFooters = null;
        masterDataBand.getDataBandInfoV2().EmptyBands = null;
        masterDataBand.getDataBandInfoV2().FootersOnLastPage = null;
        masterDataBand.getDataBandInfoV2().DetailDataBands = null;
        masterDataBand.getDataBandInfoV2().SubReports = null;
        masterDataBand.getDataBandInfoV2().ReportTitles = null;
        masterDataBand.getDataBandInfoV2().ReportSummaries = null;
        masterDataBand.getDataBandInfoV2().Headers = null;
        masterDataBand.getDataBandInfoV2().GroupHeaders = null;
        masterDataBand.getDataBandInfoV2().GroupFooters = null;
    }

    private static void InvokeCollapsedEvent(StiContainer masterDataBand) {
        StiValueEventArgs e = new StiValueEventArgs();
        if (masterDataBand instanceof StiGroupHeaderBand) {
            StiGroupHeaderBand groupHeaderBand = (StiGroupHeaderBand)masterDataBand;
            groupHeaderBand.InvokeGetCollapsed(e);
            groupHeaderBand.setCollapsedValue(e.getValue());
        } else if (masterDataBand instanceof StiDataBand) {
            StiDataBand dataBand = (StiDataBand)masterDataBand;
            dataBand.InvokeGetCollapsed(e);
            dataBand.setCollapsedValue(e.getValue());
        }
        if (e.getValue() != null && masterDataBand.getReport().interactionCollapsingStates == null) {
            StiContainer cont;
            masterDataBand.getReport().interactionCollapsingStates = new HashMap();
            Hashtable<Integer, Object> list = new Hashtable<Integer, Object>();
            String collapsingName = masterDataBand.getName();
            StiContainer stiContainer = cont = masterDataBand instanceof StiContainer ? masterDataBand : null;
            if (cont != null && cont.getCollapsingTreePath() != null) {
                collapsingName = cont.getCollapsingTreePath() + masterDataBand.getName();
            }
            masterDataBand.getReport().interactionCollapsingStates.put(masterDataBand.getName(), list);
            list.put(masterDataBand.collapsingIndex, e.getValue());
        }
    }

    @Override
    public StiComponent Render(StiComponent masterComp) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RenderMaster(StiDataBand masterDataBand) {
        boolean storedIsCrossBandsMode = masterDataBand.getReport().engine.getIsCrossBandsMode();
        boolean newIsCrossBandsMode = masterDataBand instanceof StiCrossDataBand;
        masterDataBand.getReport().engine.getThreads().SelectThreadFromContainer(masterDataBand);
        masterDataBand.getReport().engine.isCrossBandsMode = newIsCrossBandsMode;
        masterDataBand.getDataBandInfoV2().StoredParentBookmark = masterDataBand.parentBookmark;
        masterDataBand.getReport().engine.isDynamicBookmarksMode = true;
        masterDataBand.InvokeBeginRender();
        this.Block(masterDataBand);
        this.LinkGroupHeadersAndGroupFooters(masterDataBand);
        try {
            masterDataBand.setLine(1);
            if (masterDataBand.getMasterComponent() == null) {
                masterDataBand.lineThrough = 1;
            }
            StiDataHelper.SetData(masterDataBand, false);
            masterDataBand.First();
            this.RenderReportTitles(masterDataBand);
            this.RenderHeaders(masterDataBand);
            this.RenderFootersOnAllPages(masterDataBand);
            this.StartBands(masterDataBand, masterDataBand.getDataBandInfoV2().Headers);
            this.StartBands(masterDataBand, masterDataBand.getDataBandInfoV2().FootersOnAllPages);
            this.StartBands(masterDataBand, masterDataBand.getDataBandInfoV2().GroupHeaders);
            this.StartBand(masterDataBand, masterDataBand);
            if (masterDataBand.getDataBandInfoV2().GroupHeaders.size() == 0) {
                this.RenderColumns(masterDataBand);
            }
            if (masterDataBand.getInteraction() instanceof StiBandInteraction && masterDataBand.getDataBandInfoV2().DetailDataBands.size() == 0 && !(masterDataBand instanceof StiHierarchicalBand)) {
                ((StiBandInteraction)masterDataBand.getInteraction()).setCollapsingEnabled(false);
            }
            masterDataBand.First();
            while (!masterDataBand.getIsEof()) {
                masterDataBand.collapsingIndex = masterDataBand.getPosition();
                if (masterDataBand.getInteraction() != null && ((StiBandInteraction)masterDataBand.getInteraction()).getCollapsingEnabled()) {
                    String collapsingPath = null;
                    StiDataBand collapsingMaster = masterDataBand;
                    while (collapsingMaster.getMasterComponent() != null && collapsingMaster.getMasterComponent() instanceof StiDataBand) {
                        collapsingMaster = (StiDataBand)collapsingMaster.getMasterComponent();
                        collapsingPath = collapsingMaster.getPosition() + ":" + collapsingPath;
                    }
                    if (collapsingPath != null) {
                        masterDataBand.setCollapsingTreePath(collapsingPath);
                    }
                }
                boolean denyGroups = this.IsDenyDetailsOnFirstPage(masterDataBand);
                this.RenderGroupHeaders(masterDataBand);
                boolean denyDetails = this.IsDenyDetailsOnFirstPage(masterDataBand);
                if (masterDataBand.getColumns() < 2) {
                    masterDataBand.getReport().engine.getColumnsOnDataBand().setEnabled(false);
                }
                if (!denyDetails) {
                    this.AddKeepDetails(masterDataBand);
                }
                masterDataBand.SetReportVariables();
                boolean flagIsPrintIfDetailEmpty = false;
                if (StiDataBandV2Builder.IsPrintIfDetailEmpty(masterDataBand)) {
                    StiDataBandV2Builder.InvokeCollapsedEvent(masterDataBand);
                    this.CheckHierarchicalHeaders(masterDataBand);
                    this.RenderBand(masterDataBand, masterDataBand, false, true);
                    flagIsPrintIfDetailEmpty = true;
                }
                this.RemoveKeepHeaders(masterDataBand);
                boolean oldSilentMode = masterDataBand.getReport().engine.SilentMode;
                if (StiDataBandV2Builder.IsCollapsed(masterDataBand, true)) {
                    masterDataBand.getReport().engine.SilentMode = true;
                }
                this.RenderDetailDataBands(masterDataBand);
                masterDataBand.getReport().engine.SilentMode = oldSilentMode;
                if (flagIsPrintIfDetailEmpty) {
                    this.CheckHierarchicalFooters(masterDataBand);
                }
                if (!denyDetails) {
                    this.RemoveKeepDetails(masterDataBand);
                }
                this.RemoveKeepGroupHeaders(masterDataBand);
                this.RenderGroupFooters(masterDataBand);
                masterDataBand.setLine(masterDataBand.getLine() + 1);
                if (masterDataBand.getDataBandInfoV2().DetailDataBands.size() == 0) {
                    ++masterDataBand.lineThrough;
                }
                masterDataBand.Next();
            }
            this.RenderMarkerFootersOnAllPages(masterDataBand);
            this.RenderFootersOnLastPage(masterDataBand);
            if (this.CheckKeepReportSummaryTogether(masterDataBand)) {
                this.RenderReportSummaries(masterDataBand);
                this.EndBands(masterDataBand);
            } else {
                this.EndBands(masterDataBand);
                this.RenderReportSummaries(masterDataBand);
            }
        }
        finally {
            this.ResetLinkGroupHeadersAndGroupFooters(masterDataBand);
            this.UnBlock(masterDataBand);
            masterDataBand.getReport().engine.setIsCrossBandsMode(storedIsCrossBandsMode);
            masterDataBand.getReport().engine.setIsDynamicBookmarksMode(false);
        }
        masterDataBand.InvokeEndRender();
    }

    public ArrayList<StiGroupHeaderBand> GetGroupHeaders(StiDataBand masterDataBand) {
        int index;
        ArrayList<StiGroupHeaderBand> comps = new ArrayList<StiGroupHeaderBand>();
        if (masterDataBand instanceof StiTable && !masterDataBand.getEnabled()) {
            String name = masterDataBand.getName() + "_";
            for (index = masterDataBand.getParent().getComponents().indexOf(masterDataBand) - 1; index >= 0 && ((StiComponent)masterDataBand.getParent().getComponents().get(index)).getName().startsWith(name); --index) {
            }
        }
        while (index >= 0) {
            StiComponent tempComp = (StiComponent)masterDataBand.getParent().getComponents().get(index);
            if (!(tempComp instanceof StiHeaderBand || tempComp instanceof StiChildBand || tempComp instanceof StiEmptyBand)) {
                if (!(tempComp instanceof StiGroupHeaderBand)) break;
                comps.add(0, (StiGroupHeaderBand)tempComp);
            }
            --index;
        }
        return comps;
    }

    public ArrayList<StiGroupFooterBand> GetGroupFooters(StiDataBand masterDataBand) {
        ArrayList<StiGroupFooterBand> comps = new ArrayList<StiGroupFooterBand>();
        for (int index = masterDataBand.getParent().getComponents().indexOf(masterDataBand) + 1; index < masterDataBand.getParent().getComponents().size(); ++index) {
            StiComponent component = (StiComponent)masterDataBand.getParent().getComponents().get(index);
            if (component instanceof StiFooterBand || component instanceof StiChildBand || component instanceof StiEmptyBand) continue;
            if (!(component instanceof StiGroupFooterBand)) break;
            comps.add((StiGroupFooterBand)component);
        }
        return comps;
    }

    public void GroupsComparison(StiDataBand masterDataBand) {
        for (StiGroupHeaderBand band : masterDataBand.getDataBandInfoV2().GroupHeaderComponents) {
            band.getGroupHeaderBandInfoV2().GroupFooter = null;
        }
        for (int footerIndex = 0; footerIndex < masterDataBand.getDataBandInfoV2().GroupFooterComponents.size(); ++footerIndex) {
            int headerIndex = masterDataBand.getDataBandInfoV2().GroupHeaderComponents.size() - footerIndex - 1;
            if (headerIndex >= 0) {
                masterDataBand.getDataBandInfoV2().GroupFooterComponents.get((int)footerIndex).getGroupFooterBandInfoV2().GroupHeader = masterDataBand.getDataBandInfoV2().GroupHeaderComponents.get(headerIndex);
                masterDataBand.getDataBandInfoV2().GroupHeaderComponents.get((int)headerIndex).getGroupHeaderBandInfoV2().GroupFooter = masterDataBand.getDataBandInfoV2().GroupFooterComponents.get(footerIndex);
                continue;
            }
            masterDataBand.getDataBandInfoV2().GroupFooterComponents.get((int)footerIndex).getGroupFooterBandInfoV2().GroupHeader = null;
        }
    }

    public static StiV2Builder getBuilder(Class<StiDataBand> class1) {
        return StiDataBandV2Builder.GetBuilder(class1);
    }
}

