/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2.builders;

import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiRuntimeVariables;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.engine.StiRenderState;
import com.stimulsoft.report.engine.engineV2.StiEngine;
import com.stimulsoft.report.engine.engineV2.StiPageNumber;
import com.stimulsoft.report.engine.engineV2.StiPostProcessProviderV2;
import com.stimulsoft.report.engine.engineV2.StiRenderProviderV2;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class StiReportV2Builder {
    public static void RenderSingleReport(StiReport masterReport, StiRenderState renderState) {
        StiEngine engineOnStart = masterReport.getEngine();
        StiReport reportOfEngineOnStart = null;
        if (engineOnStart != null) {
            reportOfEngineOnStart = masterReport.getEngine().getReport();
        }
        masterReport.setIsStopped(false);
        masterReport.IndexName = 1;
        masterReport.setIsRendered(false);
        if (engineOnStart != null) {
            masterReport.engine = engineOnStart;
            masterReport.engine.report = masterReport;
        } else {
            masterReport.engine = new StiEngine(masterReport);
        }
        masterReport.isRendering = true;
        StiRenderProviderV2.Render(masterReport, renderState);
        masterReport.invokeRefreshViewer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void RenderSubReports(StiReport ownerReport, StiRenderState renderState) {
        ownerReport.getRenderedPages().clear();
        ArrayList<StiReport> arrayList = ownerReport.getSubReports();
        // MONITORENTER : arrayList
        for (StiReport report : ownerReport.getSubReports()) {
            report.setRenderedPages(ownerReport.getRenderedPages());
        }
        // MONITOREXIT : arrayList
        Hashtable copiesOfReportsTotals = new Hashtable();
        ownerReport.isStopped = false;
        ownerReport.invokeBeginRender();
        StiEngine engine = null;
        StiReport masterReport = null;
        if (((StiPage)ownerReport.getPages().get(0)).GetComponents().size() > 0) {
            engine = new StiEngine(ownerReport);
            ownerReport.setEngine(engine);
            ownerReport.setCurrentPrintPage(0);
            ownerReport.SubReportsMasterReport = ownerReport;
            masterReport = ownerReport;
            if (ownerReport.getCompiledReport() != null) {
                masterReport = ownerReport.getCompiledReport();
                ownerReport.getCompiledReport().SubReportsMasterReport = ownerReport;
                ownerReport.getCompiledReport().getRenderedPages().clear();
            }
            ArrayList<StiReport> savedSubReports = ownerReport.getSubReports();
            ownerReport.setSubReports(null);
            renderState.setIsSubReportMode(true);
            ownerReport.Render(renderState);
            ownerReport.setSubReports(savedSubReports);
            ownerReport.SubReportsMasterReport = null;
        } else {
            engine = new StiEngine(ownerReport);
            ownerReport.setCurrentPrintPage(0);
            ownerReport.setEngine(engine);
            if (ownerReport.getCompiledReport() != null) {
                ownerReport.getCompiledReport().setEngine(engine);
            }
        }
        int reportIndex = 0;
        StiReport prevReport = null;
        StiPagesCollection stiPagesCollection = ownerReport.getSubReports();
        // MONITORENTER : stiPagesCollection
        for (StiReport report : ownerReport.getSubReports()) {
            try {
                report.SubReportsMasterReport = ownerReport;
                report.setEngine(engine);
                report.setCurrentPrintPage(ownerReport.getCurrentPrintPage());
                if (prevReport != null) {
                    ((StiPage)report.getPages().get(0)).setPrintOnPreviousPage(report.SubReportsPrintOnPreviousPage);
                }
                if (prevReport != null) {
                    ((StiPage)report.getPages().get(0)).setResetPageNumber(report.SubReportsResetPageNumber);
                }
                int renderedPagesCount = ownerReport.getRenderedPages().size();
                if (engine.getPageNumbers().getPageNumbers().size() > 0) {
                    ((StiPageNumber)engine.getPageNumbers().getPageNumbers().get((int)(engine.getPageNumbers().getPageNumbers().size() - 1))).FixedPosition = true;
                }
                report.setTotals(new Hashtable<String, Object>());
                StiRenderState subreportState = new StiRenderState(renderState.getShowProgress());
                subreportState.setIsSubReportMode(renderState.getIsSubReportMode());
                report.Render(subreportState);
                ownerReport.setCurrentPrintPage(report.getCurrentPrintPage());
                Hashtable copyOfTotals = new Hashtable();
                StiReport rep = report;
                Set<String> keySet = rep.getTotals().keySet();
                Object[] keys = new Object[keySet.size()];
                System.arraycopy(keySet.toArray(), 0, keys, 0, keySet.size());
                Object[] objectArray = keys;
                // MONITORENTER : keys
                for (Object key : keys) {
                    ArrayList values = (ArrayList)(rep.getTotals().get(key) instanceof ArrayList ? rep.getTotals().get(key) : null);
                    if (values == null) continue;
                    ArrayList<Object> newValues = new ArrayList<Object>();
                    copyOfTotals.put(key, newValues);
                    ArrayList arrayList2 = values;
                    // MONITORENTER : arrayList2
                    for (StiRuntimeVariables value : values) {
                        newValues.add(value.clone());
                    }
                    // MONITOREXIT : arrayList2
                }
                // MONITOREXIT : objectArray
                copiesOfReportsTotals.put(reportIndex++, copyOfTotals);
                if (report.getReportUnit() != ownerReport.getReportUnit()) {
                    for (int index = renderedPagesCount; index < ownerReport.getRenderedPages().size(); ++index) {
                        StiPage page = (StiPage)ownerReport.getRenderedPages().get(index);
                        page.convert(report.getUnit(), ownerReport.getUnit());
                    }
                }
            }
            finally {
                report.SubReportsMasterReport = null;
            }
            if (report.getIsStopped()) {
                ownerReport.isStopped = report.isStopped;
                break;
            }
            ownerReport.getBookmark().getBookmarks().AddRange(report.getBookmark().getBookmarks());
            prevReport = report;
        }
        // MONITOREXIT : stiPagesCollection
        engine.getPageNumbers().ProcessPageNumbers();
        reportIndex = 0;
        stiPagesCollection = ownerReport.getSubReports();
        // MONITORENTER : stiPagesCollection
        Iterator<StiReport> i$ = ownerReport.getSubReports().iterator();
        while (i$.hasNext()) {
            StiReport report;
            StiReport rep = report = i$.next();
            rep.setTotals(copiesOfReportsTotals.get(reportIndex++) instanceof Hashtable ? copiesOfReportsTotals.get(reportIndex++) : null);
            rep.InvokeEndRender();
        }
        // MONITOREXIT : stiPagesCollection
        stiPagesCollection = ownerReport.getSubReports();
        // MONITORENTER : stiPagesCollection
        for (StiReport report : ownerReport.getSubReports()) {
            report.setTotals(null);
        }
        // MONITOREXIT : stiPagesCollection
        if (masterReport != null) {
            masterReport.setEngine(engine);
            masterReport.InvokeEndRender();
            masterReport.setEngine(null);
        }
        if (masterReport == null || masterReport != ownerReport) {
            ownerReport.InvokeEndRender();
        }
        stiPagesCollection = ownerReport.getRenderedPages();
        // MONITORENTER : stiPagesCollection
        for (StiPage page : ownerReport.getRenderedPages()) {
            page.setReport(ownerReport);
        }
        // MONITOREXIT : stiPagesCollection
        ownerReport.setEngine(null);
        ownerReport.isRendered = true;
        ownerReport.setNeedsCompiling(false);
        if (ownerReport.getParentReport() != null) {
            ownerReport.getParentReport().setEngine(null);
            ownerReport.getParentReport().isRendered = true;
            ownerReport.getParentReport().setNeedsCompiling(false);
        }
        StiPostProcessProviderV2.PostProcessPages(ownerReport.getRenderedPages());
        if (ownerReport != null && ownerReport.getRenderedPages() != null) {
            for (StiPage page : ownerReport.getRenderedPages()) {
                page.setReport(ownerReport);
            }
        }
        renderState.setIsSubReportMode(false);
        ownerReport.invokeRefreshViewer();
    }
}

