/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.parser;

import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.lib.utils.StiCalendarUtil;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiTypeConverter;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.StiCustomFunction;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiTotals;
import com.stimulsoft.report.dictionary.StiFunctionsStrings;
import com.stimulsoft.report.dictionary.data.DBNull;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.engine.parser.StiParserData;
import com.stimulsoft.report.engine.parser.StiParserMethodInfo;
import com.stimulsoft.report.engine.parser.enums.StiFunctionType;
import com.stimulsoft.report.engine.parser.enums.StiParserDataType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

public class StiCallFunction {
    private static final Logger LOG = Logger.getLogger(StiCallFunction.class.getName());
    private static String[] errorsList = new String[]{"Syntax error", "", "The expression is empty", "Division by zero", "Unexpected end of expression", "The name '%s' does not exist in the current context", "Syntax error - unprocessed lexemes remain", "( expected", ") expected", "Field, method, or property is not found: '%s'", "Operator '%s' cannot be applied to operands of type '%s' and type '%s'", "The function is not found: '%s'", "No overload for method '%s' takes '%s' arguments", "The '%s' function has invalid argument '%s': cannot convert from '%s' to '%s'", "The '%s' function is not yet implemented", "The '%s' method has invalid argument '%s': cannot convert from '%s' to '%s'", "'%s' does not contain a definition for '%s'"};

    static Object callFunc(Object name, ArrayList argsList, StiReport report, StiParser parser, String customFunctionName) {
        try {
            int overload = StiCallFunction.checkParserMethodInfo((StiFunctionType)((Object)name), argsList);
            switch ((StiFunctionType)((Object)name)) {
                case Count: {
                    return StiTotals.Count(argsList.get(0));
                }
                case CountAllLevels: {
                    return StiTotals.Count(argsList.get(0));
                }
                case CountDistinct: {
                    return StiTotals.CountDistinct(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case Avg: {
                    return StiTotals.Avg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case AvgD: {
                    return StiTotals.AvgD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case AvgDate: {
                    return StiTotals.Avg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case AvgI: {
                    return StiTotals.AvgI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case AvgTime: {
                    return StiTotals.Avg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case Max: {
                    return StiTotals.Max(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MaxD: {
                    return StiTotals.MaxD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MaxDate: {
                    return StiTotals.MaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MaxI: {
                    return StiTotals.MaxI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MaxStr: {
                    return StiTotals.MaxStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MaxTime: {
                    return StiTotals.MaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case Median: {
                    return StiTotals.Median(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MedianD: {
                    return StiTotals.MedianD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MedianI: {
                    return StiTotals.MedianI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case Min: {
                    return StiTotals.Min(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MinD: {
                    return StiTotals.MinD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MinDate: {
                    return StiTotals.MinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MinI: {
                    return StiTotals.MinI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MinStr: {
                    return StiTotals.MinStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MinTime: {
                    return StiTotals.MinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case Mode: {
                    return StiTotals.Mode(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case ModeD: {
                    return StiTotals.ModeD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case ModeI: {
                    return StiTotals.ModeI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case Sum: {
                    return StiTotals.Sum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case SumD: {
                    return StiTotals.SumD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case SumDistinct: {
                    StiParserData dataSumDistinct = new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser);
                    dataSumDistinct.AsmList2 = (ArrayList)argsList.get(2);
                    return StiTotals.SumDistinct(dataSumDistinct, report, null);
                }
                case SumI: {
                    return StiTotals.SumI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case SumTime: {
                    return StiTotals.Sum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case First: {
                    return StiTotals.First(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case Last: {
                    return StiTotals.Last(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cCount: {
                    return StiTotals.cCount(argsList.get(0));
                }
                case cCountDistinct: {
                    return StiTotals.cCountDistinct(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cAvg: {
                    return StiTotals.cAvg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cAvgD: {
                    return StiTotals.cAvgD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cAvgDate: {
                    return StiTotals.cAvg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cAvgI: {
                    return StiTotals.cAvgI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cAvgTime: {
                    return StiTotals.cAvg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMax: {
                    return StiTotals.cMax(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMaxD: {
                    return StiTotals.cMaxD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMaxDate: {
                    return StiTotals.cMaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMaxI: {
                    return StiTotals.cMaxI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMaxStr: {
                    return StiTotals.cMaxStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMaxTime: {
                    return StiTotals.cMaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMedian: {
                    return StiTotals.cMedian(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMedianD: {
                    return StiTotals.cMedianD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMedianI: {
                    return StiTotals.cMedianI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMin: {
                    return StiTotals.cMin(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMinD: {
                    return StiTotals.cMinD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMinDate: {
                    return StiTotals.cMinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMinI: {
                    return StiTotals.cMinI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMinStr: {
                    return StiTotals.cMinStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMinTime: {
                    return StiTotals.cMinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMode: {
                    return StiTotals.cMode(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cModeD: {
                    return StiTotals.cModeD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cModeI: {
                    return StiTotals.cModeI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cSum: {
                    return StiTotals.cSum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cSumD: {
                    return StiTotals.cSumD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cSumDistinct: {
                    return StiTotals.cSum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cSumI: {
                    return StiTotals.cSumI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cSumTime: {
                    return StiTotals.cSum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cFirst: {
                    return StiTotals.cFirst(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cLast: {
                    return StiTotals.cLast(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rCount: {
                    return StiTotals.cCountRunning(argsList.get(0));
                }
                case rCountDistinct: {
                    return StiTotals.cCountDistinctRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rAvg: {
                    return StiTotals.cAvgRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rAvgD: {
                    return StiTotals.cAvgDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rAvgDate: {
                    return StiTotals.cAvgRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rAvgI: {
                    return StiTotals.cAvgIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rAvgTime: {
                    return StiTotals.cAvgRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMax: {
                    return StiTotals.cMaxRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMaxD: {
                    return StiTotals.cMaxDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMaxDate: {
                    return StiTotals.cMaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMaxI: {
                    return StiTotals.cMaxIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMaxStr: {
                    return StiTotals.cMaxStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMaxTime: {
                    return StiTotals.cMaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMedian: {
                    return StiTotals.cMedianRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMedianD: {
                    return StiTotals.cMedianDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMedianI: {
                    return StiTotals.cMedianIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMin: {
                    return StiTotals.cMinRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMinD: {
                    return StiTotals.cMinDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMinDate: {
                    return StiTotals.cMinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMinI: {
                    return StiTotals.cMinIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMinStr: {
                    return StiTotals.cMinStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMinTime: {
                    return StiTotals.cMinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMode: {
                    return StiTotals.cModeRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rModeD: {
                    return StiTotals.cModeDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rModeI: {
                    return StiTotals.cModeIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rSum: {
                    return StiTotals.cSumRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rSumD: {
                    return StiTotals.cSumDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rSumDistinct: {
                    return StiTotals.cSum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rSumI: {
                    return StiTotals.cSumIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rSumTime: {
                    return StiTotals.cSumRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rFirst: {
                    return StiTotals.cFirstRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rLast: {
                    return StiTotals.cLastRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case iCount: {
                    return StiTotals.Count(new StiParserData(argsList.get(0), null, parser, (ArrayList)argsList.get(1)), report, null);
                }
                case iCountDistinct: {
                    return StiTotals.CountDistinct(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iAvg: {
                    return StiTotals.Avg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iAvgD: {
                    return StiTotals.AvgD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iAvgDate: {
                    return StiTotals.Avg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iAvgI: {
                    return StiTotals.AvgI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iAvgTime: {
                    return StiTotals.Avg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMax: {
                    return StiTotals.Max(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMaxD: {
                    return StiTotals.MaxD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMaxDate: {
                    return StiTotals.MaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMaxI: {
                    return StiTotals.MaxI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMaxStr: {
                    return StiTotals.MaxStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMaxTime: {
                    return StiTotals.MaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMedian: {
                    return StiTotals.Median(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMedianD: {
                    return StiTotals.MedianD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMedianI: {
                    return StiTotals.MedianI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMin: {
                    return StiTotals.Min(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMinD: {
                    return StiTotals.MinD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMinDate: {
                    return StiTotals.MinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMinI: {
                    return StiTotals.MinI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMinStr: {
                    return StiTotals.MinStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMinTime: {
                    return StiTotals.MinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMode: {
                    return StiTotals.Mode(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iModeD: {
                    return StiTotals.ModeD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iModeI: {
                    return StiTotals.ModeI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iSum: {
                    return StiTotals.Sum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iSumD: {
                    return StiTotals.SumD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iSumDistinct: {
                    return StiTotals.SumDistinct(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iSumI: {
                    return StiTotals.SumI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iSumTime: {
                    return StiTotals.Sum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iFirst: {
                    return StiTotals.First(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iLast: {
                    return StiTotals.Last(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciCount: {
                    return StiTotals.cCount(new StiParserData(argsList.get(0), null, parser, (ArrayList)argsList.get(1)), report, null);
                }
                case ciCountDistinct: {
                    return StiTotals.cCountDistinct(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciAvg: {
                    return StiTotals.cAvg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciAvgD: {
                    return StiTotals.cAvgD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciAvgDate: {
                    return StiTotals.cAvg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciAvgI: {
                    return StiTotals.cAvgI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciAvgTime: {
                    return StiTotals.cAvg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMax: {
                    return StiTotals.cMax(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMaxD: {
                    return StiTotals.cMaxD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMaxDate: {
                    return StiTotals.cMaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMaxI: {
                    return StiTotals.cMaxI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMaxStr: {
                    return StiTotals.cMaxStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMaxTime: {
                    return StiTotals.cMaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMedian: {
                    return StiTotals.cMedian(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMedianD: {
                    return StiTotals.cMedianD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMedianI: {
                    return StiTotals.cMedianI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMin: {
                    return StiTotals.cMin(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMinD: {
                    return StiTotals.cMinD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMinDate: {
                    return StiTotals.cMinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMinI: {
                    return StiTotals.cMinI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMinStr: {
                    return StiTotals.cMinStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMinTime: {
                    return StiTotals.cMinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMode: {
                    return StiTotals.cMode(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciModeD: {
                    return StiTotals.cModeD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciModeI: {
                    return StiTotals.cModeI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciSum: {
                    return StiTotals.cSum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciSumD: {
                    return StiTotals.cSumD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciSumDistinct: {
                    return StiTotals.cSum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciSumI: {
                    return StiTotals.cSumI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciSumTime: {
                    return StiTotals.cSum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciFirst: {
                    return StiTotals.cFirst(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciLast: {
                    return StiTotals.cLast(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riCount: {
                    return StiTotals.cCountRunning(new StiParserData(argsList.get(0), null, parser, (ArrayList)argsList.get(1)), report, null);
                }
                case riCountDistinct: {
                    return StiTotals.cCountDistinctRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riAvg: {
                    return StiTotals.cAvgRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riAvgD: {
                    return StiTotals.cAvgDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riAvgDate: {
                    return StiTotals.cAvgRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riAvgI: {
                    return StiTotals.cAvgIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riAvgTime: {
                    return StiTotals.cAvgRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMax: {
                    return StiTotals.cMaxRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMaxD: {
                    return StiTotals.cMaxDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMaxDate: {
                    return StiTotals.cMaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMaxI: {
                    return StiTotals.cMaxIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMaxStr: {
                    return StiTotals.cMaxStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMaxTime: {
                    return StiTotals.cMaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMedian: {
                    return StiTotals.cMedianRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMedianD: {
                    return StiTotals.cMedianDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMedianI: {
                    return StiTotals.cMedianIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMin: {
                    return StiTotals.cMinRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMinD: {
                    return StiTotals.cMinDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMinDate: {
                    return StiTotals.cMinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMinI: {
                    return StiTotals.cMinIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMinStr: {
                    return StiTotals.cMinStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMinTime: {
                    return StiTotals.cMinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMode: {
                    return StiTotals.cModeRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riModeD: {
                    return StiTotals.cModeDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riModeI: {
                    return StiTotals.cModeIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riSum: {
                    return StiTotals.cSumRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riSumD: {
                    return StiTotals.cSumDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riSumDistinct: {
                    return StiTotals.cSum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riSumI: {
                    return StiTotals.cSumIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riSumTime: {
                    return StiTotals.cSumRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riFirst: {
                    return StiTotals.cFirstRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riLast: {
                    return StiTotals.cLastRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case Abs: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Abs", "1", argsList.get(0).getClass().toString(), "double");
                    } else {
                        if (category == 2) {
                            return StiTypeConverter.ToDecimal(argsList.get(0)).abs();
                        }
                        if (category == 3) {
                            return Math.abs(StiTypeConverter.parseDouble(argsList.get(0)));
                        }
                    }
                    return Math.abs(StiTypeConverter.parseInt(argsList.get(0)));
                }
                case Acos: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Acos", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    return Math.acos(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Asin: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Asin", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    return Math.asin(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Atan: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Atan", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    return Math.atan(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Ceiling: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Ceiling", "1", argsList.get(0).getClass().toString(), "double");
                    } else if (category == 2) {
                        return StiTypeConverter.ToDecimal(argsList.get(0)).setScale(0, RoundingMode.CEILING);
                    }
                    return Math.ceil(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Cos: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Cos", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    return Math.cos(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Div: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    int category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Div", "1", argsList.get(0).getClass().toString(), "double");
                    } else if (category2 <= 1 || category2 >= 8) {
                        StiCallFunction.ThrowError(13, "Div", "2", argsList.get(1).getClass().toString(), "double");
                    } else {
                        if (argsList.size() == 3) {
                            if (category == 2) {
                                BigDecimal value1 = StiTypeConverter.ToDouble(argsList.get(1));
                                if (value1.equals(BigDecimal.ZERO)) {
                                    return StiTypeConverter.ToDouble(argsList.get(2));
                                }
                                BigDecimal value0 = StiTypeConverter.ToDouble(argsList.get(0));
                                return value0.divide(value1, 32, RoundingMode.HALF_UP).doubleValue();
                            }
                            if (StiTypeConverter.parseDouble(argsList.get(1)) == 0.0) {
                                return StiTypeConverter.parseDouble(argsList.get(2));
                            }
                            return StiTypeConverter.parseDouble(argsList.get(0)) / StiTypeConverter.parseDouble(argsList.get(1));
                        }
                        if (argsList.size() == 2) {
                            BigDecimal value0 = StiTypeConverter.ToDouble(argsList.get(0));
                            BigDecimal value1 = StiTypeConverter.ToDouble(argsList.get(1));
                            if (value1.doubleValue() == 0.0) {
                                return 0.0;
                            }
                            return value0.divide(value1, 32, RoundingMode.HALF_UP).doubleValue();
                        }
                    }
                    StiCallFunction.ThrowError(12, "Div", argsList.size());
                    break;
                }
                case Exp: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Exp", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    return Math.exp(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Floor: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 4) {
                        StiCallFunction.ThrowError(13, "Floor", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    if (category == 2) {
                        return StiTypeConverter.ToDouble(argsList.get(0)).setScale(0, RoundingMode.FLOOR);
                    }
                    return Math.floor(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Log: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Log", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    return Math.log(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Maximum: {
                    if (argsList.size() != 2) {
                        StiCallFunction.ThrowError(12, "Maximum", argsList.size());
                    }
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    int category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Maximum", "1", argsList.get(0).getClass().toString(), "double");
                    } else if (category2 <= 1 || category2 >= 8) {
                        StiCallFunction.ThrowError(13, "Maximum", "2", argsList.get(1).getClass().toString(), "double");
                    } else {
                        if (category == 2) {
                            return StiTypeConverter.ToDouble(argsList.get(0)).max(StiTypeConverter.ToDouble(argsList.get(1)));
                        }
                        if (category == 3) {
                            return Math.max(StiTypeConverter.parseDouble(argsList.get(0)), StiTypeConverter.parseDouble(argsList.get(1)));
                        }
                    }
                    return Math.max(StiTypeConverter.parseLong(argsList.get(0)), StiTypeConverter.parseLong(argsList.get(1)));
                }
                case Minimum: {
                    if (argsList.size() != 2) {
                        StiCallFunction.ThrowError(12, "Minimum", argsList.size());
                    }
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    int category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Minimum", "1", argsList.get(0).getClass().toString(), "double");
                    } else if (category2 <= 1 || category2 >= 8) {
                        StiCallFunction.ThrowError(13, "Minimum", "2", argsList.get(1).getClass().toString(), "double");
                    } else {
                        if (category == 2) {
                            return StiTypeConverter.ToDecimal(argsList.get(0)).min(StiTypeConverter.ToDecimal(argsList.get(1)));
                        }
                        if (category == 3) {
                            return Math.min(StiTypeConverter.parseDouble(argsList.get(0)), StiTypeConverter.parseDouble(argsList.get(1)));
                        }
                    }
                    return Math.min(StiTypeConverter.parseLong(argsList.get(0)), StiTypeConverter.parseLong(argsList.get(1)));
                }
                case Round: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Round", "1", argsList.get(0).getClass().toString(), "double");
                    } else {
                        if (argsList.size() == 1) {
                            if (category == 2) {
                                return StiTypeConverter.ToDecimal(argsList.get(0)).setScale(0, RoundingMode.HALF_UP);
                            }
                            return Math.round(StiTypeConverter.parseDouble(argsList.get(0)));
                        }
                        if (argsList.size() == 2) {
                            int category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                            if (category2 < 4 || category2 > 7) {
                                StiCallFunction.ThrowError(13, "Round", "2", argsList.get(1).getClass().toString(), "int");
                            }
                            if (category == 2) {
                                BigDecimal value0 = StiTypeConverter.ToDecimal(argsList.get(0));
                                BigDecimal value1 = StiTypeConverter.ToDecimal(argsList.get(1));
                                return value0.setScale(value1.intValue(), RoundingMode.HALF_UP);
                            }
                            return (double)Math.round(StiTypeConverter.parseDouble(argsList.get(0)) * Math.pow(10.0, StiTypeConverter.parseInt(argsList.get(1)))) / Math.pow(10.0, StiTypeConverter.parseInt(argsList.get(1)));
                        }
                    }
                    StiCallFunction.ThrowError(12, "Round", argsList.size());
                    break;
                }
                case Sign: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Sign", "1", argsList.get(0).getClass().toString(), "double");
                    } else {
                        if (category == 2) {
                            return Math.sin(StiTypeConverter.ToDecimal(argsList.get(0)).doubleValue());
                        }
                        if (category == 3) {
                            return Math.sin(StiTypeConverter.parseDouble(argsList.get(0)));
                        }
                    }
                    return Math.sin(StiTypeConverter.parseInt(argsList.get(0)));
                }
                case Sin: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Sin", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    return Math.sin(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Sqrt: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Sqrt", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    return Math.sqrt(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Tan: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Tan", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    return Math.tan(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Truncate: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 4) {
                        StiCallFunction.ThrowError(13, "Truncate", "1", argsList.get(0).getClass().toString(), "double");
                    } else if (category == 2) {
                        return StiTypeConverter.ToDecimal(argsList.get(0)).setScale(0, 1);
                    }
                    return Math.round(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case DateDiff: {
                    if (argsList.size() != 2) {
                        StiCallFunction.ThrowError(12, "DateDiff", argsList.size());
                    }
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    int category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category != 8) {
                        StiCallFunction.ThrowError(13, "DateDiff", "1", argsList.get(0).getClass().toString(), "DateTime");
                        break;
                    }
                    if (category2 != 8) {
                        StiCallFunction.ThrowError(13, "DateDiff", "2", argsList.get(1).getClass().toString(), "DateTime");
                        break;
                    }
                    StiDateTime dateTime1 = StiCallFunction.toDateTime(argsList.get(0));
                    StiDateTime dateTime2 = StiCallFunction.toDateTime(argsList.get(1));
                    return dateTime1.subtract(dateTime2);
                }
                case DateSerial: {
                    if (argsList.size() != 3) {
                        StiCallFunction.ThrowError(12, "DateSerial", argsList.size());
                    }
                    int year = StiTypeConverter.parseInt(argsList.get(0));
                    int month = StiTypeConverter.parseInt(argsList.get(1));
                    int date = StiTypeConverter.parseInt(argsList.get(2));
                    return StiCalendarUtil.create((int)year, (int)month, (int)date);
                }
                case Day: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Day", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 8) {
                        StiCallFunction.ThrowError(13, "Day", "1", argsList.get(0).getClass().toString(), "DateTime");
                    }
                    return StiCallFunction.toDateTime(argsList.get(0)).get(5);
                }
                case DayOfWeek: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category != 8) {
                        StiCallFunction.ThrowError(13, "DayOfWeek", "1", argsList.get(0).getClass().toString(), "DateTime");
                    }
                    if (argsList.size() == 1) {
                        return StiCallFunction.toDateTime(argsList.get(0)).get(7);
                    }
                    if (argsList.size() == 2) {
                        category = StiTypeConverter.getCategoryClass(argsList.get(1));
                        if (category != 9) {
                            StiCallFunction.ThrowError(13, "DayOfWeek", "2", argsList.get(0).getClass().toString(), "Boolean");
                        }
                        return StiCallFunction.toDateTime(argsList.get(0)).get(7);
                    }
                    StiCallFunction.ThrowError(12, "DayOfWeek", argsList.size());
                    break;
                }
                case DayOfYear: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category != 8) {
                        StiCallFunction.ThrowError(13, "DayOfYear", "1", argsList.get(0).getClass().toString(), "DateTime");
                    }
                    if (argsList.size() == 1) {
                        return StiCallFunction.toDateTime(argsList.get(0)).get(6);
                    }
                    StiCallFunction.ThrowError(12, "DayOfYear", argsList.size());
                    break;
                }
                case Hour: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Hour", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 8) {
                        StiCallFunction.ThrowError(13, "Hour", "1", argsList.get(0).getClass().toString(), "DateTime");
                    }
                    return StiCallFunction.toDateTime(argsList.get(0)).get(11);
                }
                case Minute: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Minute", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 8) {
                        StiCallFunction.ThrowError(13, "Minute", "1", argsList.get(0).getClass().toString(), "DateTime");
                    }
                    return StiCallFunction.toDateTime(argsList.get(0)).get(12);
                }
                case Month: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Month", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 8) {
                        StiCallFunction.ThrowError(13, "Month", "1", argsList.get(0).getClass().toString(), "DateTime");
                    }
                    return StiCallFunction.toDateTime(argsList.get(0)).get(2) + 1;
                }
                case Second: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Second", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 8) {
                        StiCallFunction.ThrowError(13, "Second", "1", argsList.get(0).getClass().toString(), "DateTime");
                    }
                    return StiCallFunction.toDateTime(argsList.get(0)).get(13);
                }
                case TimeSerial: {
                    if (argsList.size() != 3) {
                        StiCallFunction.ThrowError(12, "TimeSerial", argsList.size());
                    }
                    if (!StiTypeConverter.isInegral(argsList.get(0))) {
                        StiCallFunction.ThrowError(13, "TimeSerial", "1", argsList.get(0).getClass().toString(), "int");
                    }
                    if (!StiTypeConverter.isInegral(argsList.get(1))) {
                        StiCallFunction.ThrowError(13, "TimeSerial", "2", argsList.get(0).getClass().toString(), "int");
                    }
                    if (!StiTypeConverter.isInegral(argsList.get(2))) {
                        StiCallFunction.ThrowError(13, "TimeSerial", "3", argsList.get(0).getClass().toString(), "int");
                    }
                    return new Date(StiTypeConverter.parseInt(argsList.get(0)), StiTypeConverter.parseInt(argsList.get(1)), StiTypeConverter.parseInt(argsList.get(2)));
                }
                case Year: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Year", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 8) {
                        StiCallFunction.ThrowError(13, "Year", "1", argsList.get(0).getClass().toString(), "DateTime");
                    }
                    return StiCallFunction.toDateTime(argsList.get(0)).get(1);
                }
                case DateToStr: {
                    StiCallFunction.ThrowError(14, "DateToStr");
                    break;
                }
                case Insert: {
                    int category;
                    if (argsList.size() != 3) {
                        StiCallFunction.ThrowError(12, "Insert", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 1) {
                        StiCallFunction.ThrowError(13, "Insert", "1", argsList.get(0).getClass().toString(), "string");
                    }
                    if (!StiTypeConverter.isInegral(argsList.get(1))) {
                        StiCallFunction.ThrowError(13, "Insert", "2", argsList.get(0).getClass().toString(), "int");
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(2))) != 1) {
                        StiCallFunction.ThrowError(13, "Insert", "3", argsList.get(0).getClass().toString(), "string");
                    }
                    return new StringBuffer((String)argsList.get(0)).insert(StiTypeConverter.parseInt(argsList.get(1)), String.valueOf(argsList.get(2))).toString();
                }
                case Length: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Length", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 1) {
                        StiCallFunction.ThrowError(13, "Length", "1", argsList.get(0).getClass().toString(), "string");
                    }
                    return String.valueOf(argsList.get(0)).length();
                }
                case Remove: {
                    int category;
                    if (argsList.size() != 3) {
                        StiCallFunction.ThrowError(12, "Remove", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 1) {
                        StiCallFunction.ThrowError(13, "Remove", "1", argsList.get(0).getClass().toString(), "string");
                    }
                    if (!StiTypeConverter.isInegral(argsList.get(1))) {
                        StiCallFunction.ThrowError(13, "Remove", "2", argsList.get(0).getClass().toString(), "int");
                    }
                    if (!StiTypeConverter.isInegral(argsList.get(2))) {
                        StiCallFunction.ThrowError(13, "Remove", "3", argsList.get(0).getClass().toString(), "int");
                    }
                    String tempVar = StiTypeConverter.ToString(argsList.get(0));
                    try {
                        return tempVar.substring(0, StiTypeConverter.parseInt(argsList.get(1))) + tempVar.substring(StiTypeConverter.parseInt(argsList.get(1)) + StiTypeConverter.parseInt(argsList.get(2)));
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel >= 10) {
                            e.printStackTrace();
                        }
                        return "";
                    }
                }
                case Replace: {
                    int category;
                    if (argsList.size() != 3) {
                        StiCallFunction.ThrowError(12, "Replace", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 1) {
                        StiCallFunction.ThrowError(13, "Replace", "1", argsList.get(0).getClass().toString(), "string");
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(1))) != 1) {
                        StiCallFunction.ThrowError(13, "Replace", "2", argsList.get(0).getClass().toString(), "string");
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(2))) != 1) {
                        StiCallFunction.ThrowError(13, "Replace", "3", argsList.get(0).getClass().toString(), "string");
                    }
                    try {
                        return String.valueOf(argsList.get(0)).replace(String.valueOf(argsList.get(1)), String.valueOf(argsList.get(2)));
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel >= 10) {
                            e.printStackTrace();
                        }
                        return "";
                    }
                }
                case Roman: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Roman", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) >= 4 && category <= 7) {
                        return StiFunctionsStrings.roman(StiTypeConverter.parseInt(argsList.get(0)));
                    }
                    StiCallFunction.ThrowError(13, "Roman", "1", argsList.get(0).getClass().toString(), "int");
                    break;
                }
                case Substring: {
                    int category;
                    if (argsList.size() != 3) {
                        StiCallFunction.ThrowError(12, "Substring", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 1) {
                        StiCallFunction.ThrowError(13, "Substring", "1", argsList.get(0).getClass().toString(), "string");
                    }
                    if (!StiTypeConverter.isInegral(argsList.get(1))) {
                        StiCallFunction.ThrowError(13, "Substring", "2", argsList.get(1).getClass().toString(), "int");
                    }
                    category = StiTypeConverter.getCategoryClass(argsList.get(2));
                    if (!StiTypeConverter.isInegral(argsList.get(2))) {
                        StiCallFunction.ThrowError(13, "Substring", "3", argsList.get(2).getClass().toString(), "int");
                    }
                    return String.valueOf(argsList.get(0)).substring(StiTypeConverter.parseInt(argsList.get(1)), StiTypeConverter.parseInt(argsList.get(1)) + StiTypeConverter.parseInt(argsList.get(2)));
                }
                case ToCurrencyWords: {
                    StiCallFunction.ThrowError(14, "ToCurrencyWords");
                    break;
                }
                case ToLowerCase: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "ToLowerCase", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 1) {
                        StiCallFunction.ThrowError(13, "ToLowerCase", "1", argsList.get(0).getClass().toString(), "string");
                    }
                    return String.valueOf(argsList.get(0)).toLowerCase();
                }
                case ToProperCase: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "ToProperCase", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 1) {
                        StiCallFunction.ThrowError(13, "ToProperCase", "1", argsList.get(0).getClass().toString(), "string");
                    }
                    return String.valueOf(argsList.get(0)).toLowerCase();
                }
                case ToUpperCase: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "ToUpperCase", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 1) {
                        StiCallFunction.ThrowError(13, "ToUpperCase", "1", argsList.get(0).getClass().toString(), "string");
                    }
                    return String.valueOf(argsList.get(0)).toUpperCase();
                }
                case ToWordsRu: {
                    switch (overload) {
                        case 1: 
                        case 2: 
                        case 3: {
                            return StiFunctionsStrings.toWordsRu(StiTypeConverter.ToDouble(argsList.get(0)));
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            return StiFunctionsStrings.toWordsRu(StiTypeConverter.ToDouble(argsList.get(0)), StiTypeConverter.parseBoolean(argsList.get(1)));
                        }
                    }
                    break;
                }
                case ToWordsUa: {
                    switch (overload) {
                        case 1: 
                        case 2: 
                        case 3: {
                            return StiFunctionsStrings.toWordsUa(StiTypeConverter.ToDouble(argsList.get(0)));
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            return StiFunctionsStrings.toWordsUa(StiTypeConverter.ToDouble(argsList.get(0)), StiTypeConverter.parseBoolean(argsList.get(1)));
                        }
                    }
                    break;
                }
                case Trim: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Trim", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 1) {
                        StiCallFunction.ThrowError(13, "Trim", "1", argsList.get(0).getClass().toString(), "string");
                    }
                    return String.valueOf(argsList.get(0)).trim();
                }
                case TryParseDecimal: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "TryParseDecimal", argsList.size());
                    }
                    try {
                        BigDecimal tempVar2 = new BigDecimal(String.valueOf(argsList.get(0)));
                        return true;
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel >= 10) {
                            e.printStackTrace();
                        }
                        return false;
                    }
                }
                case TryParseDouble: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "TryStiTypeConverter.parseDouble", argsList.size());
                    }
                    try {
                        StiTypeConverter.parseDouble((Object)String.valueOf(argsList.get(0)));
                        return true;
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel >= 10) {
                            e.printStackTrace();
                        }
                        return false;
                    }
                }
                case IsNullOrEmpty: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "IsNullOrEmpty", argsList.size());
                    }
                    return StiValidationUtil.isNullOrEmpty((String)String.valueOf(argsList.get(0)));
                }
                case ToDateTime: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "ToDateTime", argsList.size());
                    }
                    return new StiDateTime(new Date(String.valueOf(argsList.get(0))));
                }
                case ToChar: {
                    String val;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "ToChar", argsList.size());
                    }
                    return StiValidationUtil.isNotNullOrEmpty((String)(val = String.valueOf(argsList.get(0)))) && val.length() > 0 ? Character.valueOf(val.charAt(0)) : null;
                }
                case ToBoolean: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "ToBoolean", argsList.size());
                    }
                    return Boolean.parseBoolean(String.valueOf(argsList.get(0)).toLowerCase());
                }
                case IsNullOrWhiteSpace: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "IsNullOrWhiteSpace", argsList.size());
                    }
                    return StiValidationUtil.isNullOrWhiteSpace((String)String.valueOf(argsList.get(0)));
                }
                case TryParseLong: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "TryStiTypeConverter.parseLong", argsList.size());
                    }
                    try {
                        StiTypeConverter.parseLong((Object)String.valueOf(argsList.get(0)));
                        return true;
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel >= 10) {
                            e.printStackTrace();
                        }
                        return false;
                    }
                }
                case ToDecimal: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "TryParseDecimal", argsList.size());
                    }
                    BigDecimal tempToDecimal = new BigDecimal(0);
                    BigDecimal tempVar22 = new BigDecimal(String.valueOf(argsList.get(0)));
                    return tempVar22;
                }
                case ToDouble: 
                case ToSingle: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, ((StiFunctionType)((Object)name)).toString(), argsList.size());
                    }
                    Double tempVar33 = StiTypeConverter.parseDouble((Object)String.valueOf(argsList.get(0)));
                    return tempVar33;
                }
                case ToLong: 
                case ToByte: 
                case ToSByte: 
                case ToInt16: 
                case ToInt32: 
                case ToInt64: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, ((StiFunctionType)((Object)name)).toString(), argsList.size());
                    }
                    Long tempVar44 = StiTypeConverter.parseLong((Object)String.valueOf(argsList.get(0)));
                    return tempVar44;
                }
                case Arabic: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Arabic", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) == 1) {
                        return StiFunctionsStrings.arabic(String.valueOf(argsList.get(0)));
                    }
                    if (category >= 4 && category <= 7) {
                        return StiFunctionsStrings.arabic(StiTypeConverter.parseInt(argsList.get(0)));
                    }
                    StiCallFunction.ThrowError(13, "Arabic", "1", argsList.get(0).getClass().toString(), "string");
                    break;
                }
                case Persian: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Persian", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) == 1) {
                        return StiFunctionsStrings.persian(String.valueOf(argsList.get(0)));
                    }
                    if (category >= 4 && category <= 7) {
                        return StiFunctionsStrings.persian(StiTypeConverter.parseInt(argsList.get(0)));
                    }
                    StiCallFunction.ThrowError(13, "Persian", "1", argsList.get(0).getClass().toString(), "string");
                    break;
                }
                case ToOrdinal: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "ToOrdinal", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) >= 4 && category <= 7) {
                        return StiFunctionsStrings.toOrdinal(StiTypeConverter.parseLong(argsList.get(0)));
                    }
                    StiCallFunction.ThrowError(13, "ToOrdinal", "1", argsList.get(0).getClass().toString(), "int");
                    break;
                }
                case JoinColumnContent: {
                    if (argsList.size() != 3) {
                        StiCallFunction.ThrowError(12, "JoinColumnContent", argsList.size());
                    }
                    return Func.EngineHelper.joinColumnContent((StiDataSource)argsList.get(0), StiTypeConverter.parseString(argsList.get(1)), StiTypeConverter.parseString(argsList.get(2)));
                }
                case Left: {
                    if (overload == 1) {
                        return StiFunctionsStrings.left(String.valueOf(argsList.get(0)), StiTypeConverter.parseInt(argsList.get(1)));
                    }
                    break;
                }
                case Right: {
                    if (overload == 1) {
                        return StiFunctionsStrings.right(String.valueOf(argsList.get(0)), StiTypeConverter.parseInt(argsList.get(1)));
                    }
                    break;
                }
                case Mid: {
                    if (overload == 1) {
                        return StiFunctionsStrings.mid(String.valueOf(argsList.get(0)), StiTypeConverter.parseInt(argsList.get(1)), StiTypeConverter.parseInt(argsList.get(2)));
                    }
                    break;
                }
                case IIF: {
                    return StiTypeConverter.parseBoolean(argsList.get(0)) ? argsList.get(1) : argsList.get(2);
                }
                case Choose: {
                    int chooseIndex;
                    if (argsList.size() < 2) {
                        StiCallFunction.ThrowError(12, "Choose", argsList.size());
                    }
                    if (!StiTypeConverter.isInegral(argsList.get(0))) {
                        StiCallFunction.ThrowError(13, "Choose", "1", argsList.get(0).getClass().toString(), "int");
                    }
                    if ((chooseIndex = StiTypeConverter.parseInt(argsList.get(0))) > 0 && chooseIndex < argsList.size()) {
                        return argsList.get(chooseIndex);
                    }
                    return null;
                }
                case Switch: {
                    if (argsList.size() < 2) {
                        StiCallFunction.ThrowError(12, "Switch", argsList.size());
                    }
                    int switchIndex = 0;
                    while (switchIndex + 1 < argsList.size()) {
                        if (StiTypeConverter.parseBoolean(argsList.get(switchIndex))) {
                            return argsList.get(switchIndex + 1);
                        }
                        switchIndex += 2;
                    }
                    return null;
                }
                case ToString: {
                    if (argsList.get(0) == null || argsList.get(0) == DBNull.Value) {
                        return "";
                    }
                    return argsList.get(0).toString();
                }
                case EngineHelperToQueryString: {
                    switch (overload) {
                        case 1: {
                            if (!(argsList.get(0) instanceof List)) break;
                            try {
                                System.out.println("asfasfasf");
                                return null;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                    break;
                }
                case Format: {
                    int category;
                    if (argsList.size() != 2) {
                        StiCallFunction.ThrowError(12, "Format", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 1) {
                        StiCallFunction.ThrowError(13, "Format", "1", argsList.get(0).getClass().toString(), "string");
                    }
                    return StiStringUtil.format((String)String.valueOf(argsList.get(0)), argsList.get(1) instanceof StiDateTime ? ((StiDateTime)argsList.get(1)).getTime() : argsList.get(1));
                }
                default: {
                    return StiCallFunction.invokeCustomFunction(name, argsList, report, parser, customFunctionName);
                }
            }
        }
        catch (RuntimeException e) {
            StringBuilder info = new StringBuilder();
            for (Object obj : argsList) {
                info.append(" " + obj);
            }
            if (report != null) {
                report.WriteToReportRenderingMessages("Error: argList=" + info.toString() + ", objName=" + name + ", customFunctionName=" + customFunctionName + " " + (e.getMessage() != null ? e.getMessage() : e.getStackTrace()[0].toString()));
            }
            StiLoggingUtil.showWarning((String)("Error: argList=" + info.toString() + ", objName=" + name + ", customFunctionName=" + customFunctionName), (Exception)e);
            return "";
        }
        return "";
    }

    private static StiParserDataType get_category2(Object par) {
        if (par == null) {
            return StiParserDataType.None;
        }
        boolean category = false;
        if (par instanceof String) {
            return StiParserDataType.String;
        }
        if (par instanceof Character) {
            return StiParserDataType.Char;
        }
        if (par instanceof BigDecimal) {
            return StiParserDataType.Decimal;
        }
        if (par instanceof Double) {
            return StiParserDataType.Double;
        }
        if (par instanceof Float) {
            return StiParserDataType.Double;
        }
        if (par instanceof Long) {
            return StiParserDataType.Int;
        }
        if (par instanceof Integer) {
            return StiParserDataType.Int;
        }
        if (par instanceof Short) {
            return StiParserDataType.Int;
        }
        if (par instanceof Byte) {
            return StiParserDataType.Int;
        }
        if (par instanceof Calendar) {
            return StiParserDataType.DateTime;
        }
        if (par instanceof Boolean) {
            return StiParserDataType.Bool;
        }
        if (par instanceof StiDataSource) {
            return StiParserDataType.StiDataSource;
        }
        return StiParserDataType.None;
    }

    public static int checkParserMethodInfo(StiFunctionType type, ArrayList args) {
        if (!StiParser.getMethodsHash().containsKey((Object)type)) {
            return 0;
        }
        List<StiParserMethodInfo> methods = StiParser.getMethodsHash().get((Object)type);
        int count = args.size();
        StiParserDataType[] types = new StiParserDataType[count];
        for (int index = 0; index < count; ++index) {
            types[index] = StiCallFunction.get_category2(args.get(index));
        }
        boolean flag1 = false;
        for (StiParserMethodInfo methodInfo : methods) {
            if (methodInfo.getArguments().length != count) continue;
            flag1 = true;
            boolean flag2 = true;
            for (int index = 0; index < count; ++index) {
                if ((types[index].getValue() & methodInfo.getArguments()[index].getValue()) != 0) continue;
                flag2 = false;
                break;
            }
            if (!flag2) continue;
            return methodInfo.getNumber();
        }
        if (!flag1) {
            StiCallFunction.ThrowError(12, StiFunctionType.getFunctionsList().get((Object)type).toString(), count);
        }
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < count; ++index) {
            sb.append(types[index].toString());
            if (index >= count - 1) continue;
            sb.append(",");
        }
        StiCallFunction.ThrowError(17, StiFunctionType.getFunctionsList().get(type.name()).toString(), sb.toString());
        return 0;
    }

    private static Object invokeCustomFunction(Object name, ArrayList argsList, StiReport report, StiParser parser, String customFunctionName) {
        if (customFunctionName != null) {
            for (StiCustomFunction function : report.getCustomFunctions()) {
                if (!customFunctionName.equals(function.getFunctionName()) || !StiCallFunction.isParamsEqual(argsList, function.getParametersList())) continue;
                return function.invoke(argsList);
            }
            String params = "";
            for (Object par : argsList) {
                params = params + par.getClass().getName() + " ";
            }
            throw new RuntimeException("Custom function: " + customFunctionName + " with parameters [" + params.trim() + "] not found in report custom functions list");
        }
        return null;
    }

    private static boolean isParamsEqual(ArrayList argsList, List<Class> paramsList) {
        if ((paramsList == null || paramsList.size() == 0) && argsList.size() == 0) {
            return true;
        }
        if (paramsList != null && paramsList.size() != argsList.size() || paramsList == null && argsList.size() > 0) {
            return false;
        }
        for (int i = 0; i < argsList.size(); ++i) {
            if (argsList.get(i) == null || argsList.get(i).getClass().equals(paramsList.get(i))) continue;
            return false;
        }
        return true;
    }

    private static void ThrowError(int code, String message, int size) {
        throw new RuntimeException("code '" + code + "', message '" + message + "', size '" + size);
    }

    private void ThrowError(int code) {
        StiCallFunction.ThrowError(code, "", "", "", "");
    }

    private static void ThrowError(int code, String message1) {
        StiCallFunction.ThrowError(code, message1, "", "", "");
    }

    private static void ThrowError(int code, String message1, String message2) {
        StiCallFunction.ThrowError(code, message1, message2, "", "");
    }

    private void ThrowError(int code, String message1, String message2, String message3) {
        StiCallFunction.ThrowError(code, message1, message2, message3, "");
    }

    private static void ThrowError(int code, String message1, String message2, String message3, String message4) {
        String errorMessage = "Parser error: Unknown error";
        if (code < errorsList.length) {
            errorMessage = "Parser error: " + String.format(errorsList[code], message1, message2, message3, message4);
        }
        throw new RuntimeException(errorMessage);
    }

    public static StiDateTime toDateTime(Object par1) {
        return (StiDateTime)par1;
    }
}

