/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.parser.enums;

import java.util.concurrent.ConcurrentHashMap;

public enum StiParserDataType {
    None(0),
    Object(Integer.MAX_VALUE),
    zFloat(2),
    zDouble(4),
    zDecimal(8),
    Byte(16),
    SByte(32),
    Int16(64),
    UInt16(128),
    Int32(256),
    UInt32(512),
    Int64(1024),
    UInt64(2048),
    Bool(4096),
    Char(8192),
    String(16384),
    DateTime(32768),
    TimeSpan(65536),
    Image(131072),
    StiDataSource(262144),
    Short(StiParserDataType.Byte.intValue | StiParserDataType.SByte.intValue | StiParserDataType.Int16.intValue),
    UShort(StiParserDataType.Byte.intValue | StiParserDataType.UInt16.intValue | StiParserDataType.Char.intValue),
    Int(StiParserDataType.Short.intValue | StiParserDataType.UInt16.intValue | StiParserDataType.Int32.intValue),
    UInt(StiParserDataType.UShort.intValue | StiParserDataType.UInt32.intValue),
    Long(StiParserDataType.Int.intValue | StiParserDataType.UInt32.intValue | StiParserDataType.Int64.intValue),
    ULong(StiParserDataType.UInt.intValue | StiParserDataType.UInt64.intValue),
    Float(StiParserDataType.zFloat.intValue | StiParserDataType.Long.intValue | StiParserDataType.ULong.intValue),
    Double(StiParserDataType.zDouble.intValue | StiParserDataType.Long.intValue | StiParserDataType.ULong.intValue | StiParserDataType.zFloat.intValue),
    Decimal(StiParserDataType.zDecimal.intValue | StiParserDataType.Long.intValue | StiParserDataType.ULong.intValue),
    BasedType(0x10000000),
    FixedType(0x20000000),
    Nullable(0x40000000);

    private final int intValue;
    private static ConcurrentHashMap<Integer, StiParserDataType> mappings;

    private static synchronized ConcurrentHashMap<Integer, StiParserDataType> getMappings() {
        if (mappings == null) {
            mappings = new ConcurrentHashMap();
        }
        return mappings;
    }

    private StiParserDataType(int value) {
        this.intValue = value;
        StiParserDataType.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static StiParserDataType forValue(int value) {
        return StiParserDataType.getMappings().get(value);
    }

    public static StiParserDataType forValue(String name) {
        return StiParserDataType.getMappings().get(name);
    }
}

