/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.parser.enums;

import java.util.concurrent.ConcurrentHashMap;

public enum StiPropertyType {
    Year,
    Month,
    Day,
    Hour,
    Minute,
    Second,
    Length,
    From,
    To,
    FromDate,
    ToDate,
    FromTime,
    ToTime,
    Position,
    SelectedLine;

    private static ConcurrentHashMap<String, StiPropertyType> propertiesList;

    public int getValue() {
        return this.ordinal();
    }

    public static StiPropertyType forValue(int value) {
        return StiPropertyType.values()[value];
    }

    public static StiPropertyType forValue(String name) {
        return Enum.valueOf(StiPropertyType.class, name);
    }

    public static StiPropertyType forValue(Object name) {
        return StiPropertyType.forValue(name.toString());
    }

    public static synchronized ConcurrentHashMap<String, StiPropertyType> getPropertiesList() {
        if (propertiesList == null) {
            propertiesList = new ConcurrentHashMap();
            for (StiPropertyType property : StiPropertyType.values()) {
                propertiesList.put(property.name(), property);
            }
        }
        return propertiesList;
    }

    static {
        propertiesList = null;
    }
}

