/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiEmptyBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiLineInfo;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.StiTextOptions;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.base.utils.StiXmlHelper;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiWatermark;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiTextQuality;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.components.shapeTypes.StiArrowShapeType;
import com.stimulsoft.report.components.shapeTypes.StiDiagonalDownLineShapeType;
import com.stimulsoft.report.components.shapeTypes.StiDiagonalUpLineShapeType;
import com.stimulsoft.report.components.shapeTypes.StiHorizontalLineShapeType;
import com.stimulsoft.report.components.shapeTypes.StiLeftAndRightLineShapeType;
import com.stimulsoft.report.components.shapeTypes.StiOvalShapeType;
import com.stimulsoft.report.components.shapeTypes.StiRectangleShapeType;
import com.stimulsoft.report.components.shapeTypes.StiRoundedRectangleShapeType;
import com.stimulsoft.report.components.shapeTypes.StiShapeDirection;
import com.stimulsoft.report.components.shapeTypes.StiTopAndBottomLineShapeType;
import com.stimulsoft.report.components.shapeTypes.StiTriangleShapeType;
import com.stimulsoft.report.components.shapeTypes.StiVerticalLineShapeType;
import com.stimulsoft.report.components.simplecomponents.StiCheckBox;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.components.simplecomponents.StiRectanglePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiRoundedRectanglePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiShape;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.service.StiImageExportService;
import com.stimulsoft.report.export.service.helper.StiChartSvgHelper;
import com.stimulsoft.report.export.tools.StiBarCodeExportPainter;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiSvgGeomWriter;
import com.stimulsoft.report.export.tools.StiTextRenderer;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StiSvgExportService
extends StiImageExportService {
    @Override
    public StiExportFormat getExportFormat() {
        return StiExportFormat.ImageSvg;
    }

    @Override
    public StiImageFormat getImageFormat() {
        return null;
    }

    public static class StiSvgHelper {
        static final double CORRECT_FONT_SIZE = 1.35;
        static final float PDF_CKT = 0.56f;

        public static String getLineStyleDash(StiPenStyle penStyle, double width) {
            String dotWidth = StiMath.roundS((double)(1.2 * width), (int)1).replaceAll(",", ".");
            String lineWidth = StiMath.roundS((double)(3.0 * width), (int)1).replaceAll(",", ".");
            String dashArray = "";
            switch (penStyle) {
                case Dot: {
                    dashArray = String.format("%s,%s", dotWidth, dotWidth);
                    break;
                }
                case Dash: {
                    dashArray = String.format("%s,%s", lineWidth, dotWidth);
                    break;
                }
                case DashDot: {
                    dashArray = String.format("%s,%s,%s,%s", lineWidth, dotWidth, dotWidth, dotWidth);
                    break;
                }
                case DashDotDot: {
                    dashArray = String.format("%s,%s,%s,%s,%s,%s", lineWidth, dotWidth, dotWidth, dotWidth, dotWidth, dotWidth);
                }
            }
            return dashArray;
        }

        private static String toUnits(double number) {
            int digitsLimit = 2;
            String output = StiMath.roundS((double)number, (int)digitsLimit).replaceAll(",", ".");
            return output;
        }

        private static void writeCoordinates(Element element, StiSvgData svgData) {
            element.setAttribute("x", StiSvgHelper.toUnits(svgData.X));
            element.setAttribute("y", StiSvgHelper.toUnits(svgData.Y));
            element.setAttribute("width", StiSvgHelper.toUnits(svgData.Width));
            element.setAttribute("height", StiSvgHelper.toUnits(svgData.Height));
        }

        private static void writeStrokeInfo(Element element, StiColor color, double width, StiPenStyle style) {
            if (style == StiPenStyle.None) {
                element.setAttribute("stroke", "none");
            } else {
                element.setAttribute("stroke", color.toHTML());
                if (color.getA() != 255) {
                    element.setAttribute("stroke-opacity", StiMath.roundS((double)((float)color.getA() / 255.0f), (int)3).replaceAll(",", "."));
                }
                element.setAttribute("stroke-width", StiSvgHelper.toUnits(width));
                if (style != StiPenStyle.Solid) {
                    element.setAttribute("stroke-dasharray", StiSvgHelper.getLineStyleDash(style, width));
                }
            }
        }

        private static void writeFillInfo(Element element, StiColor color) {
            element.setAttribute("fill", color.toHTML());
            if (color.getA() != 255) {
                element.setAttribute("fill-opacity", StiMath.roundS((double)((float)color.getA() / 255.0f), (int)3).replaceAll(",", "."));
            }
        }

        private static boolean checkShape(StiComponent component) {
            IStiBrush mBrush;
            StiShape shape;
            if (!(component instanceof StiShape)) {
                return false;
            }
            StiShape stiShape = shape = component instanceof StiShape ? (StiShape)component : null;
            if (shape == null) {
                return false;
            }
            IStiBrush iStiBrush = mBrush = component instanceof IStiBrush ? (IStiBrush)((Object)component) : null;
            if (mBrush != null && mBrush.getBrush() != null && !(mBrush.getBrush() instanceof StiSolidBrush) && !(mBrush.getBrush() instanceof StiEmptyBrush)) {
                return false;
            }
            return shape.getShapeType() instanceof StiVerticalLineShapeType || shape.getShapeType() instanceof StiHorizontalLineShapeType || shape.getShapeType() instanceof StiTopAndBottomLineShapeType || shape.getShapeType() instanceof StiLeftAndRightLineShapeType || shape.getShapeType() instanceof StiRectangleShapeType || shape.getShapeType() instanceof StiRoundedRectangleShapeType || shape.getShapeType() instanceof StiDiagonalDownLineShapeType || shape.getShapeType() instanceof StiDiagonalUpLineShapeType || shape.getShapeType() instanceof StiTriangleShapeType || shape.getShapeType() instanceof StiOvalShapeType || shape.getShapeType() instanceof StiArrowShapeType;
        }

        private static Document writeDocument(StiReport report, StiPage page, boolean standalone, int baseClipCounter, StiImageFormat imageFormat, float imageQuality, float imageResolution) throws ParserConfigurationException {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            imageResolution /= 100.0f;
            Element svgEl = doc.createElement("svg");
            doc.appendChild(svgEl);
            svgEl.setAttribute("version", "1.1");
            svgEl.setAttribute("baseProfile", "full");
            if (!standalone) {
                svgEl.setAttribute("style", "margin:5px; border:1px solid DarkGrey;");
            }
            svgEl.setAttribute("xmlns", "http://www.w3.org/2000/svg");
            svgEl.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
            svgEl.setAttribute("xmlns:ev", "http://www.w3.org/2001/xml-events");
            double hiToTwips = 1.0;
            double pageHeight = hiToTwips * report.getUnit().ConvertToHInches(page.getPageHeight() * (double)page.getSegmentPerHeight());
            double pageWidth = hiToTwips * report.getUnit().ConvertToHInches(page.getPageWidth() * (double)page.getSegmentPerWidth());
            double mgLeft = hiToTwips * report.getUnit().ConvertToHInches(page.getMargins().getLeft());
            double mgRight = hiToTwips * report.getUnit().ConvertToHInches(page.getMargins().getRight());
            double mgTop = hiToTwips * report.getUnit().ConvertToHInches(page.getMargins().getTop());
            double mgBottom = hiToTwips * report.getUnit().ConvertToHInches(page.getMargins().getBottom());
            svgEl.setAttribute("height", StiSvgHelper.toUnits(pageHeight));
            svgEl.setAttribute("width", StiSvgHelper.toUnits(pageWidth));
            Element defsEl = doc.createElement("defs");
            svgEl.appendChild(defsEl);
            int clipCounter = baseClipCounter;
            for (StiComponent component : page.getComponents()) {
                if (!component.getEnabled()) continue;
                double x1 = hiToTwips * report.getUnit().ConvertToHInches(component.getLeft());
                double y1 = hiToTwips * report.getUnit().ConvertToHInches(component.getTop());
                double x2 = hiToTwips * report.getUnit().ConvertToHInches(component.getRight());
                double y2 = hiToTwips * report.getUnit().ConvertToHInches(component.getBottom());
                StiSvgData pp = new StiSvgData();
                pp.X = x1 + mgLeft;
                pp.Y = y1 + mgTop;
                pp.Width = x2 - x1;
                pp.Height = y2 - y1;
                pp.Component = component;
                boolean isImage = component.isExportAsImage(StiExportFormat.ImageSvg);
                StiText stiText = component instanceof StiText ? (StiText)component : null;
                if (stiText == null || isImage || stiText.getTextInternal() == null || stiText.getTextInternal().trim().length() <= 0) continue;
                Element clipEl = doc.createElement("clipPath");
                defsEl.appendChild(clipEl);
                clipEl.setAttribute("id", String.format("clipPath%s", clipCounter++));
                Element rectEl = doc.createElement("rect");
                clipEl.appendChild(rectEl);
                StiSvgHelper.writeCoordinates(rectEl, pp);
            }
            clipCounter = baseClipCounter;
            StiRefObject gradientCounter = new StiRefObject((Object)1);
            StiContainer pageCont = new StiContainer();
            pageCont.setBorder((StiBorder)page.getBorder().clone());
            pageCont.setBrush((StiBrush)page.getBrush().clone());
            if (StiBrush.ToColor((StiBrush)pageCont.getBrush()).getA() == 0) {
                pageCont.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.White.color()));
            }
            StiSvgData ppp = new StiSvgData();
            ppp.X = 0.0;
            ppp.Y = 0.0;
            ppp.Width = pageWidth;
            ppp.Height = pageHeight;
            ppp.Component = pageCont;
            StiSvgHelper.writeBorder1(svgEl, ppp, (StiRefObject<Integer>)gradientCounter, doc);
            StiSvgHelper.writeWatermark(svgEl, page, true, pageWidth, pageHeight, imageResolution, doc);
            for (StiComponent component : page.getComponents()) {
                if (!component.getEnabled()) continue;
                double x1 = hiToTwips * report.getUnit().ConvertToHInches(component.getLeft());
                double y1 = hiToTwips * report.getUnit().ConvertToHInches(component.getTop());
                double x2 = hiToTwips * report.getUnit().ConvertToHInches(component.getRight());
                double y2 = hiToTwips * report.getUnit().ConvertToHInches(component.getBottom());
                StiSvgData pp = new StiSvgData();
                pp.X = x1 + mgLeft;
                pp.Y = y1 + mgTop;
                pp.Width = x2 - x1;
                pp.Height = y2 - y1;
                pp.Component = component;
                boolean isShape = StiSvgHelper.checkShape(component);
                boolean isImage = component.isExportAsImage(StiExportFormat.ImageSvg);
                if (!isShape && !isImage) {
                    StiSvgHelper.writeBorder1(svgEl, pp, (StiRefObject<Integer>)gradientCounter, doc);
                }
                if (component instanceof StiText && !isImage) {
                    clipCounter = StiSvgHelper.writeText(svgEl, pp, clipCounter, true, doc);
                }
                if (isShape) {
                    StiSvgHelper.writeShape(svgEl, pp, doc);
                } else if (isImage) {
                    StiSvgHelper.writeImage(svgEl, pp, imageResolution, imageFormat, imageQuality, doc);
                }
                if (!standalone) {
                    pp.X = (double)Math.round(pp.X - 0.5) + 0.5;
                    pp.Y = (double)Math.round(pp.Y - 0.5) + 0.5;
                    pp.Width = (double)Math.round(x2 + mgLeft - 0.5) + 0.5 - pp.X;
                    pp.Height = (double)Math.round(y2 + mgTop - 0.5) + 0.5 - pp.Y;
                }
                if (component instanceof StiRectanglePrimitive) {
                    StiSvgHelper.writeRoundedRectanglePrimitive(svgEl, pp, doc);
                } else {
                    StiSvgHelper.writeBorder2(svgEl, pp, doc);
                }
                if (standalone) continue;
                pp.X = x1 + mgLeft;
                pp.Y = y1 + mgTop;
                pp.Width = x2 - x1;
                pp.Height = y2 - y1;
            }
            ppp.X = mgLeft;
            ppp.Y = mgTop;
            ppp.Width -= mgLeft + mgRight;
            ppp.Height -= mgTop + mgBottom;
            StiSvgHelper.writeBorder2(svgEl, ppp, doc);
            StiSvgHelper.writeWatermark(svgEl, page, false, pageWidth, pageHeight, imageResolution, doc);
            baseClipCounter = clipCounter;
            return doc;
        }

        private static void writeWatermark(Element element, StiPage page, boolean behind, double pageWidth, double pageHeight, float imageResolution, Document document) {
            StiWatermark watermark = page.getWatermark();
            if (watermark != null && watermark.getEnabled()) {
                if (watermark.getImageBytes() == null || watermark.getShowImageBehind() == behind) {
                    // empty if block
                }
                if (watermark.getText() != null && StiValidationUtil.isNotNullOrEmpty((String)watermark.getText()) && watermark.getShowBehind() == behind) {
                    StiSvgData pp = new StiSvgData();
                    pp.X = 0.0;
                    pp.Y = 0.0;
                    pp.Width = pageWidth;
                    pp.Height = pageHeight;
                    StiText stt = new StiText(new StiRectangle(pp.X, pp.Y, pp.Width, pp.Height));
                    stt.setText(watermark.getText());
                    stt.setTextBrush(watermark.getTextBrush());
                    stt.setFont(watermark.getFont());
                    stt.setTextOptions(new StiTextOptions());
                    stt.getTextOptions().setAngle((float)watermark.getAngle());
                    stt.setHorAlignment(StiTextHorAlignment.Center);
                    stt.setVertAlignment(StiVertAlignment.Center);
                    stt.setPage(page);
                    stt.setTextQuality(StiTextQuality.Standard);
                    pp.Component = stt;
                    int tempClipCounter = 0;
                    tempClipCounter = StiSvgHelper.writeText(element, pp, tempClipCounter, false, document);
                }
            }
        }

        private static void writeBorder1(Element element, StiSvgData svgData, StiRefObject<Integer> gradientCounter, Document document) {
            IStiBrush mBrush;
            IStiBrush iStiBrush = mBrush = svgData.Component instanceof IStiBrush ? (IStiBrush)((Object)svgData.Component) : null;
            if (mBrush != null && mBrush.getBrush() != null) {
                if (mBrush.getBrush() instanceof StiGradientBrush) {
                    StiGradientBrush gb = (StiGradientBrush)mBrush.getBrush();
                    double xs = 1.0;
                    double ys = 1.0;
                    double angle = gb.getAngle();
                    if (angle < 0.0) {
                        angle += 360.0;
                    }
                    if (angle >= 270.0 && angle < 360.0) {
                        angle = 360.0 - angle;
                        ys = -1.0;
                    }
                    if (angle >= 180.0 && angle < 270.0) {
                        angle -= 180.0;
                        ys = -1.0;
                        xs = -1.0;
                    }
                    if (angle >= 90.0 && angle < 180.0) {
                        angle = 180.0 - angle;
                        xs = -1.0;
                    }
                    angle = angle * Math.PI / 180.0;
                    double x0 = svgData.X + svgData.Width / 2.0;
                    double y0 = svgData.Y + svgData.Height / 2.0;
                    double r = Math.sqrt(svgData.Width * svgData.Width + svgData.Height * svgData.Height) / 2.0;
                    double a2 = Math.atan2(svgData.Height, svgData.Width);
                    double st = 1.5707963267948966 - angle + a2;
                    double b = r * Math.sin(st);
                    double xr = b * Math.cos(angle) * xs;
                    double yr = b * Math.sin(angle) * -ys;
                    double x1 = x0 - xr;
                    double x2 = x0 + xr;
                    double y1 = y0 + yr;
                    double y2 = y0 - yr;
                    String gradientId = String.format("gradient%s", gradientCounter.argvalue);
                    StiRefObject<Integer> stiRefObject = gradientCounter;
                    Object object = stiRefObject.argvalue;
                    stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                    Integer n = stiRefObject.argvalue;
                    Element linearGrEl = document.createElement("linearGradient");
                    element.appendChild(linearGrEl);
                    linearGrEl.setAttribute("id", gradientId);
                    linearGrEl.setAttribute("gradientUnits", "userSpaceOnUse");
                    linearGrEl.setAttribute("x1", StiSvgHelper.toUnits(x1));
                    linearGrEl.setAttribute("y1", StiSvgHelper.toUnits(y1));
                    linearGrEl.setAttribute("x2", StiSvgHelper.toUnits(x2));
                    linearGrEl.setAttribute("y2", StiSvgHelper.toUnits(y2));
                    Element stopEl = document.createElement("stop");
                    linearGrEl.appendChild(stopEl);
                    stopEl.setAttribute("offset", "0%");
                    stopEl.setAttribute("stop-color", gb.getStartColor().toHTML());
                    if (gb.getStartColor().getA() != 255) {
                        stopEl.setAttribute("stop-opacity", StiMath.roundS((double)((float)gb.getStartColor().getA() / 255.0f), (int)3).replaceAll(",", "."));
                    }
                    Element stopEl2 = document.createElement("stop");
                    linearGrEl.appendChild(stopEl);
                    stopEl2.setAttribute("offset", "100%");
                    stopEl2.setAttribute("stop-color", gb.getEndColor().toHTML());
                    if (gb.getEndColor().getA() != 255) {
                        stopEl2.setAttribute("stop-opacity", StiMath.roundS((double)((float)gb.getEndColor().getA() / 255.0f), (int)3).replaceAll(",", "."));
                    }
                    Element rectEl = document.createElement("rect");
                    element.appendChild(rectEl);
                    StiSvgHelper.writeCoordinates(rectEl, svgData);
                    rectEl.setAttribute("fill", String.format("url(#%s)", gradientId));
                } else {
                    StiColor color = StiBrush.ToColor((StiBrush)mBrush.getBrush());
                    if (!color.equals(StiColorEnum.Transparent.color())) {
                        Element rectEl = document.createElement("rect");
                        element.appendChild(rectEl);
                        StiSvgHelper.writeCoordinates(rectEl, svgData);
                        StiSvgHelper.writeFillInfo(rectEl, color);
                    }
                }
            }
        }

        private static void writeBorder2(Element element, StiSvgData svgData, Document document) {
            IStiBorder mBorder;
            IStiBorder iStiBorder = mBorder = svgData.Component instanceof IStiBorder ? (IStiBorder)((Object)svgData.Component) : null;
            if (mBorder != null && mBorder.getBorder() != null && !mBorder.getBorder().getSide().containsOnly((IStiEnum)StiBorderSides.None) && mBorder.getBorder().getStyle() != StiPenStyle.None) {
                StiBorder border = mBorder.getBorder();
                if (border.getSide().contains((IStiEnum)StiBorderSides.All)) {
                    Element rectEl = document.createElement("rect");
                    element.appendChild(rectEl);
                    StiSvgHelper.writeCoordinates(rectEl, svgData);
                    rectEl.setAttribute("fill", "none");
                    StiSvgHelper.writeStrokeInfo(rectEl, border.getColor(), border.getSize(), border.getStyle());
                } else {
                    Element pathEl = document.createElement("path");
                    element.appendChild(pathEl);
                    String x1 = StiSvgHelper.toUnits(svgData.X);
                    String x2 = StiSvgHelper.toUnits(svgData.X + svgData.Width);
                    String y1 = StiSvgHelper.toUnits(svgData.Y + svgData.Height);
                    String y2 = StiSvgHelper.toUnits(svgData.Y);
                    StringBuilder stPath = new StringBuilder();
                    boolean lastSidePresent = false;
                    if (border.getSide().contains((IStiEnum)StiBorderSides.Left)) {
                        stPath.append(String.format("M %s %s ", x1, y1));
                        stPath.append(String.format("L %s %s ", x1, y2));
                        lastSidePresent = true;
                    } else {
                        lastSidePresent = false;
                    }
                    if (border.getSide().contains((IStiEnum)StiBorderSides.Top)) {
                        if (!lastSidePresent) {
                            stPath.append(String.format("M %s %s ", x1, y2));
                        }
                        stPath.append(String.format("L %s %s ", x2, y2));
                        lastSidePresent = true;
                    } else {
                        lastSidePresent = false;
                    }
                    if (border.getSide().contains((IStiEnum)StiBorderSides.Right)) {
                        if (!lastSidePresent) {
                            stPath.append(String.format("M %s %s ", x2, y2));
                        }
                        stPath.append(String.format("L %s %s ", x2, y1));
                        lastSidePresent = true;
                    } else {
                        lastSidePresent = false;
                    }
                    if (border.getSide().contains((IStiEnum)StiBorderSides.Bottom)) {
                        if (!lastSidePresent) {
                            stPath.append(String.format("M %s %s ", x2, y1));
                        }
                        stPath.append(String.format("L %s %s ", x1, y1));
                    }
                    pathEl.setAttribute("d", stPath.toString());
                    pathEl.setAttribute("fill", "none");
                    StiSvgHelper.writeStrokeInfo(pathEl, border.getColor(), border.getSize(), border.getStyle());
                }
            }
        }

        private static int writeText(Element element, StiSvgData svgData, int clipCounter, boolean useClip, Document document) {
            String textString;
            List<StiLineInfo> arrTextLines;
            StiText stiText = (StiText)svgData.Component;
            StiTextOptions textOptions = new StiTextOptions();
            if (stiText.getTextOptions() != null) {
                textOptions = stiText.getTextOptions();
            }
            if ((arrTextLines = StiTextRenderer.getTextLines(textString = stiText.getTextInternal(), stiText.getFont(), stiText.getPage().getUnit().ConvertToHInches(svgData.Component.ComponentToPage(svgData.Component.getClientRectangle())), textOptions.getWordWrap())).size() > 0 && arrTextLines.get(0).getText().length() > 0) {
                float angle = 0.0f;
                if (stiText.getTextOptions() != null) {
                    angle = stiText.getTextOptions().getAngle();
                }
                boolean needClip = useClip && StiValidationUtil.isNotEmpty((String)stiText.getTextInternal());
                double allTextHeight = 0.0;
                for (StiLineInfo lineInfo : arrTextLines) {
                    allTextHeight += lineInfo.getHeight().doubleValue();
                }
                double bordersize = 0.0;
                if (stiText.getBorder() != null) {
                    bordersize = stiText.getBorder().getSize() / 2.0;
                }
                StringBuilder style = new StringBuilder();
                if (needClip && angle == 0.0f) {
                    style.append(String.format("clip-path: url(#clipPath%s);", clipCounter++));
                }
                double startX = svgData.X;
                double startY = svgData.Y + stiText.getFont().getSize() * 0.9 * 1.35;
                if (stiText.getVertAlignment() == StiVertAlignment.Top) {
                    startY += bordersize;
                }
                if (stiText.getVertAlignment() == StiVertAlignment.Center) {
                    startY += (svgData.Height - allTextHeight) / 2.0;
                }
                if (stiText.getVertAlignment() == StiVertAlignment.Bottom) {
                    startY += svgData.Height - allTextHeight - bordersize;
                }
                if (stiText.getHorAlignment() == StiTextHorAlignment.Left) {
                    startX += 2.5 + bordersize;
                }
                if (stiText.getHorAlignment() == StiTextHorAlignment.Center) {
                    style.append(String.format("text-anchor:%s;", "middle"));
                    startX += svgData.Width / 2.0;
                }
                if (stiText.getHorAlignment() == StiTextHorAlignment.Right) {
                    style.append(String.format("text-anchor:%s;", "end"));
                    startX += svgData.Width - 2.0 - bordersize;
                }
                style.append(String.format("font-size:%spt;", stiText.getFont().getSize()));
                style.append(String.format("font-family:'%s';", stiText.getFont().getName()));
                if (stiText.getFont().bold()) {
                    style.append("font-weight:bold;");
                }
                if (stiText.getFont().italic()) {
                    style.append("font-style:italic;");
                }
                if (stiText.getFont().underline()) {
                    style.append("text-decoration:underline;");
                } else if (stiText.getFont().strikeout()) {
                    style.append("text-decoration:line-through;");
                }
                StiColor textColor = StiBrush.ToColor((StiBrush)stiText.getTextBrush());
                style.append(String.format("fill:%s", textColor.toHTML()));
                if (textColor.getA() != 255) {
                    style.append(String.format("fill-opacity:%s", StiMath.roundS((double)((float)textColor.getA() / 255.0f), (int)3).replaceAll(",", ".")));
                }
                Element curElement = element;
                if (angle != 0.0f) {
                    if (needClip) {
                        Element g1El = document.createElement("g");
                        element.appendChild(g1El);
                        g1El.setAttribute("clip-path", String.format("url(#clipPath%s)", clipCounter++));
                        curElement = g1El;
                    }
                    Element g2El = document.createElement("g");
                    curElement.appendChild(g2El);
                    g2El.setAttribute("transform", String.format("translate(%s,%s)", StiSvgHelper.toUnits(svgData.X + svgData.Width / 2.0), StiSvgHelper.toUnits(svgData.Y + svgData.Height / 2.0)));
                    Element g3El = document.createElement("g");
                    g2El.appendChild(g3El);
                    g3El.setAttribute("transform", String.format("rotate(%s)", StiSvgHelper.toUnits(-angle)));
                    curElement = g3El;
                    startX -= svgData.X + svgData.Width / 2.0;
                    startY -= svgData.Y + svgData.Height / 2.0;
                }
                Element textEl = document.createElement("text");
                curElement.appendChild(textEl);
                textEl.setAttribute("x", StiSvgHelper.toUnits(startX));
                textEl.setAttribute("y", StiSvgHelper.toUnits(startY));
                textEl.setAttribute("style", style.toString());
                for (int indexLine = 0; indexLine < arrTextLines.size(); ++indexLine) {
                    StiLineInfo lineInfo = arrTextLines.get(indexLine);
                    Element currentElement = textEl;
                    if (arrTextLines.size() > 1) {
                        Element tspanEl = document.createElement("tspan");
                        currentElement.appendChild(tspanEl);
                        currentElement = tspanEl;
                        if (indexLine > 0) {
                            tspanEl.setAttribute("x", StiSvgHelper.toUnits(startX));
                            tspanEl.setAttribute("dy", StiSvgHelper.toUnits(lineInfo.getHeight()));
                        }
                    }
                    currentElement.setTextContent(arrTextLines.get(indexLine).getText());
                }
            }
            return clipCounter;
        }

        private static void writeImage(Element element, StiSvgData svgData, float imageResolution, StiImageFormat imageFormat, float imageQuality, Document document) {
            IStiExportImageExtended exportImage;
            IStiExportImageExtended iStiExportImageExtended = exportImage = svgData.Component instanceof IStiExportImageExtended ? (IStiExportImageExtended)((Object)svgData.Component) : null;
            if (exportImage != null && svgData.Component.isExportAsImage(StiExportFormat.ImagePng)) {
                float rsImageResolution = imageResolution;
                BufferedImage image = exportImage.getImage(Double.valueOf(rsImageResolution), StiExportFormat.ImagePng);
                Element imageEl = document.createElement("image");
                element.appendChild(imageEl);
                StiSvgHelper.writeCoordinates(imageEl, svgData);
                imageEl.setAttribute("href", String.format("data:image/%s;base64,\r\n%s", imageFormat.name().toLowerCase(), StiImageHelper.imageToBase64(image, imageFormat)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void writeBarCode(Element element, StiSvgData svgData, Document document) {
            StiBarCode barCode = (StiBarCode)svgData.Component;
            StiSvgGeomWriter svgGeomWriter = new StiSvgGeomWriter(element, document);
            StiBarCodeExportPainter barCodePainter = new StiBarCodeExportPainter(svgGeomWriter);
            StiBarCodeTypeService service = barCode.getBarCodeType();
            service.setExportPainter(barCodePainter);
            try {
                service.draw(null, barCode, new StiRectangle(svgData.X, svgData.Y, svgData.Width, svgData.Height), 1.0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                service.setExportPainter(null);
            }
        }

        private static void writeShape(Element element, StiSvgData svgData, Document document) {
            StiShapeDirection ssd;
            StiShape shape = (StiShape)svgData.Component;
            IStiBrush mBrush = svgData.Component instanceof IStiBrush ? (IStiBrush)((Object)svgData.Component) : null;
            StiColor tempColor = StiColorEnum.Transparent.color();
            if (mBrush != null) {
                tempColor = StiBrush.ToColor((StiBrush)mBrush.getBrush());
            }
            StringBuilder fillPath = new StringBuilder();
            StringBuilder strokePath = new StringBuilder();
            if (shape.getShapeType() instanceof StiVerticalLineShapeType) {
                fillPath.append(String.format("M %s %s V %s H %s V %s Z", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y), StiSvgHelper.toUnits(svgData.Y + svgData.Height), StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y)));
                strokePath.append(String.format("M %s %s V %s", StiSvgHelper.toUnits(svgData.X + svgData.Width / 2.0), StiSvgHelper.toUnits(svgData.Y), StiSvgHelper.toUnits(svgData.Y + svgData.Height)));
            }
            if (shape.getShapeType() instanceof StiHorizontalLineShapeType) {
                fillPath.append(String.format("M %s %s V %s H %s V %s Z", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y), StiSvgHelper.toUnits(svgData.Y + svgData.Height), StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y)));
                strokePath.append(String.format("M %s %s H %s", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y + svgData.Height / 2.0), StiSvgHelper.toUnits(svgData.X + svgData.Width)));
            }
            if (shape.getShapeType() instanceof StiTopAndBottomLineShapeType) {
                fillPath.append(String.format("M %s %s V %s H %s V %s Z", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y), StiSvgHelper.toUnits(svgData.Y + svgData.Height), StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y)));
                strokePath.append(String.format("M %s %s H %s M %s %s H %s", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y), StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y + svgData.Height), StiSvgHelper.toUnits(svgData.X + svgData.Width)));
            }
            if (shape.getShapeType() instanceof StiLeftAndRightLineShapeType) {
                fillPath.append(String.format("M %s %s V %s H %s V %s Z", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y), StiSvgHelper.toUnits(svgData.Y + svgData.Height), StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y)));
                strokePath.append(String.format("M %s %s V %s M %s %s V %s", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y), StiSvgHelper.toUnits(svgData.Y + svgData.Height), StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y), StiSvgHelper.toUnits(svgData.Y + svgData.Height)));
            }
            if (shape.getShapeType() instanceof StiRectangleShapeType) {
                fillPath.append(String.format("M %s %s V %s H %s V %S Z", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y), StiSvgHelper.toUnits(svgData.Y + svgData.Height), StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y)));
                strokePath = fillPath;
            }
            if (shape.getShapeType() instanceof StiDiagonalDownLineShapeType) {
                fillPath.append(String.format("M %s %s V %s H %s V %s Z", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y), StiSvgHelper.toUnits(svgData.Y + svgData.Height), StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y)));
                strokePath.append(String.format("M %s %s L %s %s", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y), StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y + svgData.Height)));
            }
            if (shape.getShapeType() instanceof StiDiagonalUpLineShapeType) {
                fillPath.append(String.format("M %s %s V %s H %s V %s Z", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y), StiSvgHelper.toUnits(svgData.Y + svgData.Height), StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y)));
                strokePath.append(String.format("M %s %s L %s %s", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y + svgData.Height), StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y)));
            }
            if (shape.getShapeType() instanceof StiTriangleShapeType) {
                ssd = ((StiTriangleShapeType)shape.getShapeType()).getDirection();
                if (ssd == StiShapeDirection.Up) {
                    fillPath.append(String.format("M %s %s L %s %s L %s %s Z", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y + svgData.Height), StiSvgHelper.toUnits(svgData.X + svgData.Width / 2.0), StiSvgHelper.toUnits(svgData.Y), StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y + svgData.Height)));
                }
                if (ssd == StiShapeDirection.Down) {
                    fillPath.append(String.format("M %s %s L %s %s L %s %s Z", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y), StiSvgHelper.toUnits(svgData.X + svgData.Width / 2.0), StiSvgHelper.toUnits(svgData.Y + svgData.Height), StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y)));
                }
                if (ssd == StiShapeDirection.Left) {
                    fillPath.append(String.format("M %s %s L %s %s L %s %s Z", StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y + svgData.Height), StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y + svgData.Height / 2.0), StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y)));
                }
                if (ssd == StiShapeDirection.Right) {
                    fillPath.append(String.format("M %s %s L %s %s L %s %s Z", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y + svgData.Height), StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y + svgData.Height / 2.0), StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y)));
                }
                strokePath = fillPath;
            }
            if (shape.getShapeType() instanceof StiOvalShapeType) {
                double tmpX = svgData.Width / 2.0 * (double)0.44f;
                double tmpY = svgData.Height / 2.0 * (double)0.44f;
                double x1 = svgData.X;
                double y1 = svgData.Y;
                double x2 = svgData.X + svgData.Width;
                double y2 = svgData.Y + svgData.Height;
                double xc = svgData.X + svgData.Width / 2.0;
                double yc = svgData.Y + svgData.Height / 2.0;
                fillPath.append(String.format("M %s %s ", StiSvgHelper.toUnits(xc), StiSvgHelper.toUnits(y2)));
                fillPath.append(String.format("C %s %s %s %s %s ", StiSvgHelper.toUnits(x1 + tmpX), StiSvgHelper.toUnits(y2), StiSvgHelper.toUnits(x1), StiSvgHelper.toUnits(y2 - tmpY), StiSvgHelper.toUnits(x1), StiSvgHelper.toUnits(yc)));
                fillPath.append(String.format("C %s %s %s %s %s ", StiSvgHelper.toUnits(x1), StiSvgHelper.toUnits(y1 + tmpY), StiSvgHelper.toUnits(x1 + tmpX), StiSvgHelper.toUnits(y1), StiSvgHelper.toUnits(xc), StiSvgHelper.toUnits(y1)));
                fillPath.append(String.format("C %s %s %s %s %s ", StiSvgHelper.toUnits(x2 - tmpX), StiSvgHelper.toUnits(y1), StiSvgHelper.toUnits(x2), StiSvgHelper.toUnits(y1 + tmpY), StiSvgHelper.toUnits(x2), StiSvgHelper.toUnits(yc)));
                fillPath.append(String.format("C %s %s %s %s %s Z", StiSvgHelper.toUnits(x2), StiSvgHelper.toUnits(y2 - tmpY), StiSvgHelper.toUnits(x2 - tmpX), StiSvgHelper.toUnits(y2), StiSvgHelper.toUnits(xc), StiSvgHelper.toUnits(y2)));
                strokePath = fillPath;
            }
            if (shape.getShapeType() instanceof StiRoundedRectangleShapeType) {
                float rnd = ((StiRoundedRectangleShapeType)shape.getShapeType()).getRound();
                double side = svgData.Width;
                if (side > svgData.Height) {
                    side = svgData.Height;
                }
                double offs = Math.min(side, 100.0 * shape.getPage().getZoom()) * (double)rnd;
                double tmp = offs * (double)0.44f;
                double x1 = svgData.X;
                double y1 = svgData.Y;
                double x2 = svgData.X + svgData.Width;
                double y2 = svgData.Y + svgData.Height;
                fillPath.append(String.format("M %s %Ss ", StiSvgHelper.toUnits(x1 + offs), StiSvgHelper.toUnits(y2)));
                fillPath.append(String.format("C %s %s %s %s %s  ", StiSvgHelper.toUnits(x1 + tmp), StiSvgHelper.toUnits(y2), StiSvgHelper.toUnits(x1), StiSvgHelper.toUnits(y2 - tmp), StiSvgHelper.toUnits(x1), StiSvgHelper.toUnits(y2 - offs)));
                fillPath.append(String.format("V %s ", StiSvgHelper.toUnits(y1 + offs)));
                fillPath.append(String.format("C %s %s %s %s %s ", StiSvgHelper.toUnits(x1), StiSvgHelper.toUnits(y1 + tmp), StiSvgHelper.toUnits(x1 + tmp), StiSvgHelper.toUnits(y1), StiSvgHelper.toUnits(x1 + offs), StiSvgHelper.toUnits(y1)));
                fillPath.append(String.format("H %s ", StiSvgHelper.toUnits(x2 - offs)));
                fillPath.append(String.format("C %s %s %s %s %s ", StiSvgHelper.toUnits(x2 - tmp), StiSvgHelper.toUnits(y1), StiSvgHelper.toUnits(x2), StiSvgHelper.toUnits(y1 + tmp), StiSvgHelper.toUnits(x2), StiSvgHelper.toUnits(y1 + offs)));
                fillPath.append(String.format("V %s ", StiSvgHelper.toUnits(y2 - offs)));
                fillPath.append(String.format("C %s %s %s %s %s Z", StiSvgHelper.toUnits(x2), StiSvgHelper.toUnits(y2 - tmp), StiSvgHelper.toUnits(x2 - tmp), StiSvgHelper.toUnits(y2), StiSvgHelper.toUnits(x2 - offs), StiSvgHelper.toUnits(y2)));
                strokePath = fillPath;
            }
            if (shape.getShapeType() instanceof StiArrowShapeType) {
                ssd = ((StiArrowShapeType)shape.getShapeType()).getDirection();
                float arrowW = ((StiArrowShapeType)shape.getShapeType()).getArrowWidth();
                float arrowH = ((StiArrowShapeType)shape.getShapeType()).getArrowHeight();
                double arw = svgData.Width * (double)arrowW;
                double arh = svgData.Height * (double)arrowH;
                if (ssd == StiShapeDirection.Left || ssd == StiShapeDirection.Right) {
                    arw = svgData.Height * (double)arrowW;
                    arh = svgData.Width * (double)arrowH;
                }
                if (ssd == StiShapeDirection.Up) {
                    fillPath.append(String.format("M %s %s ", StiSvgHelper.toUnits(svgData.X + svgData.Width - arw), StiSvgHelper.toUnits(svgData.Y + svgData.Height)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + svgData.Width - arw), StiSvgHelper.toUnits(svgData.Y + arh)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y + arh)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + svgData.Width / 2.0), StiSvgHelper.toUnits(svgData.Y)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y + arh)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + arw), StiSvgHelper.toUnits(svgData.Y + arh)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + arw), StiSvgHelper.toUnits(svgData.Y + svgData.Height)));
                    fillPath.append(String.format("L %s %s Z", StiSvgHelper.toUnits(svgData.X + svgData.Width - arw), StiSvgHelper.toUnits(svgData.Y + svgData.Height)));
                }
                if (ssd == StiShapeDirection.Down) {
                    fillPath.append(String.format("M %s %s ", StiSvgHelper.toUnits(svgData.X + arw), StiSvgHelper.toUnits(svgData.Y)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + arw), StiSvgHelper.toUnits(svgData.Y + svgData.Height - arh)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y + svgData.Height - arh)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + svgData.Width / 2.0), StiSvgHelper.toUnits(svgData.Y + svgData.Height)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y + svgData.Height - arh)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + svgData.Width - arw), StiSvgHelper.toUnits(svgData.Y + svgData.Height - arh)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + svgData.Width - arw), StiSvgHelper.toUnits(svgData.Y)));
                    fillPath.append(String.format("L %s %s Z", StiSvgHelper.toUnits(svgData.X + arw), StiSvgHelper.toUnits(svgData.Y)));
                }
                if (ssd == StiShapeDirection.Left) {
                    fillPath.append(String.format("M %s %s ", StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y + arw)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + arh), StiSvgHelper.toUnits(svgData.Y + arw)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + arh), StiSvgHelper.toUnits(svgData.Y)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y + svgData.Height / 2.0)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + arh), StiSvgHelper.toUnits(svgData.Y + svgData.Height)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + arh), StiSvgHelper.toUnits(svgData.Y + svgData.Height - arw)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y + svgData.Height - arw)));
                    fillPath.append(String.format("L %s %s Z", StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y + arw)));
                }
                if (ssd == StiShapeDirection.Right) {
                    fillPath.append(String.format("M %s %s ", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y + svgData.Height - arw)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + svgData.Width - arh), StiSvgHelper.toUnits(svgData.Y + svgData.Height - arw)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + svgData.Width - arh), StiSvgHelper.toUnits(svgData.Y + svgData.Height)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + svgData.Width), StiSvgHelper.toUnits(svgData.Y + svgData.Height / 2.0)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + svgData.Width - arh), StiSvgHelper.toUnits(svgData.Y)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X + svgData.Width - arh), StiSvgHelper.toUnits(svgData.Y + arw)));
                    fillPath.append(String.format("L %s %s ", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y + arw)));
                    fillPath.append(String.format("L %s %s Z", StiSvgHelper.toUnits(svgData.X), StiSvgHelper.toUnits(svgData.Y + svgData.Height - arw)));
                }
                strokePath = fillPath;
            }
            if (fillPath.length() > 0 || strokePath.length() > 0) {
                Element pathEl;
                if (fillPath == strokePath) {
                    pathEl = document.createElement("path");
                    element.appendChild(pathEl);
                    if (!StiColorEnum.Transparent.color().equals(tempColor)) {
                        StiSvgHelper.writeFillInfo(pathEl, tempColor);
                    } else {
                        pathEl.setAttribute("fill", "none");
                    }
                    if (!StiColorEnum.Transparent.color().equals(shape.getBorderColor())) {
                        StiSvgHelper.writeStrokeInfo(pathEl, shape.getBorderColor(), shape.getSize(), shape.getStyle());
                    } else {
                        pathEl.setAttribute("stroke", "none");
                    }
                    pathEl.setAttribute("d", fillPath.toString());
                } else {
                    if (fillPath.length() > 0 && !StiColorEnum.Transparent.color().equals(tempColor)) {
                        pathEl = document.createElement("path");
                        element.appendChild(pathEl);
                        StiSvgHelper.writeFillInfo(pathEl, tempColor);
                        pathEl.setAttribute("stroke", "none");
                        pathEl.setAttribute("d", fillPath.toString());
                    }
                    if (strokePath.length() > 0 && !StiColorEnum.Transparent.color().equals(shape.getBorderColor())) {
                        pathEl = document.createElement("path");
                        element.appendChild(pathEl);
                        pathEl.setAttribute("fill", "none");
                        StiSvgHelper.writeStrokeInfo(pathEl, shape.getBorderColor(), shape.getSize(), shape.getStyle());
                        pathEl.setAttribute("d", strokePath.toString());
                    }
                }
            }
        }

        private static void writeRoundedRectanglePrimitive(Element element, StiSvgData svgData, Document document) {
            StiRoundedRectanglePrimitive rrp = (StiRoundedRectanglePrimitive)svgData.Component;
            if (rrp.getColor().equals(StiColorEnum.Transparent.color())) {
                StringBuilder strokePath = new StringBuilder();
                float rnd = rrp.getRound();
                double side = svgData.Width;
                if (side > svgData.Height) {
                    side = svgData.Height;
                }
                double offs = Math.min(side, 100.0 * rrp.getPage().getZoom()) * (double)rnd;
                double tmp = offs * (double)0.44f;
                double x1 = svgData.X;
                double y1 = svgData.Y;
                double x2 = svgData.X + svgData.Width;
                double y2 = svgData.Y + svgData.Height;
                strokePath.append(String.format("M %s %s ", StiSvgHelper.toUnits(x1 + offs), StiSvgHelper.toUnits(y2)));
                strokePath.append(String.format("C %s %s %s %s %s %s ", StiSvgHelper.toUnits(x1 + tmp), StiSvgHelper.toUnits(y2), StiSvgHelper.toUnits(x1), StiSvgHelper.toUnits(y2 - tmp), StiSvgHelper.toUnits(x1), StiSvgHelper.toUnits(y2 - offs)));
                strokePath.append(String.format("V %s ", StiSvgHelper.toUnits(y1 + offs)));
                strokePath.append(String.format("C %s %s %s %s %s %s ", StiSvgHelper.toUnits(x1), StiSvgHelper.toUnits(y1 + tmp), StiSvgHelper.toUnits(x1 + tmp), StiSvgHelper.toUnits(y1), StiSvgHelper.toUnits(x1 + offs), StiSvgHelper.toUnits(y1)));
                strokePath.append(String.format("H %s ", StiSvgHelper.toUnits(x2 - offs)));
                strokePath.append(String.format("C %s %s %s %s %s %s ", StiSvgHelper.toUnits(x2 - tmp), StiSvgHelper.toUnits(y1), StiSvgHelper.toUnits(x2), StiSvgHelper.toUnits(y1 + tmp), StiSvgHelper.toUnits(x2), StiSvgHelper.toUnits(y1 + offs)));
                strokePath.append(String.format("V %s ", StiSvgHelper.toUnits(y2 - offs)));
                strokePath.append(String.format("C %s %s %s %s %s %s Z", StiSvgHelper.toUnits(x2), StiSvgHelper.toUnits(y2 - tmp), StiSvgHelper.toUnits(x2 - tmp), StiSvgHelper.toUnits(y2), StiSvgHelper.toUnits(x2 - offs), StiSvgHelper.toUnits(y2)));
                Element pathEl = document.createElement("path");
                element.appendChild(pathEl);
                pathEl.setAttribute("fill", "none");
                StiSvgHelper.writeStrokeInfo(pathEl, rrp.getColor(), rrp.getSize(), rrp.getStyle());
                pathEl.setAttribute("d", strokePath.toString());
            }
        }

        public static Document saveComponent(StiComponent component) throws ParserConfigurationException {
            return StiSvgHelper.saveComponent(component, StiImageFormat.Jpeg, 0.75f, 100.0f);
        }

        public static Document saveComponent(StiComponent component, StiImageFormat imageFormat, float imageQuality, float imageResolution) throws ParserConfigurationException {
            StiText stiText;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            StiReport report = component.getReport();
            double hiToTwips = 1.0;
            double x1 = hiToTwips * report.getUnit().ConvertToHInches(component.getLeft());
            double y1 = hiToTwips * report.getUnit().ConvertToHInches(component.getTop());
            double x2 = hiToTwips * report.getUnit().ConvertToHInches(component.getRight());
            double y2 = hiToTwips * report.getUnit().ConvertToHInches(component.getBottom());
            StiSvgData pp = new StiSvgData();
            pp.X = 0.0;
            pp.Y = 0.0;
            pp.Width = StiMath.round((double)(x2 - x1), (int)0);
            pp.Height = StiMath.round((double)(y2 - y1), (int)0);
            pp.Component = component;
            boolean isImage = component.isExportAsImage(StiExportFormat.ImageSvg);
            boolean isShape = StiSvgHelper.checkShape(component);
            StiRefObject gradientCounter = new StiRefObject((Object)1);
            int clipCounter = 1;
            StiText stiText2 = stiText = component instanceof StiText ? (StiText)component : null;
            if (stiText != null && !isImage && stiText.getTextInternal() != null && stiText.getTextInternal().trim().length() > 0) {
                Element defsEl = doc.createElement("defs");
                doc.appendChild(defsEl);
                Element clipPathEl = doc.createElement("clipPath");
                defsEl.appendChild(clipPathEl);
                defsEl.setAttribute("id", String.format("clipPath%s", clipCounter));
                Element rectEl = doc.createElement("rect");
                defsEl.appendChild(rectEl);
                StiSvgHelper.writeCoordinates(rectEl, pp);
            }
            if (!isShape && !isImage) {
                StiSvgHelper.writeBorder1(doc.getDocumentElement(), pp, (StiRefObject<Integer>)gradientCounter, doc);
            }
            if (component instanceof StiText && !isImage) {
                clipCounter = StiSvgHelper.writeText(doc.getDocumentElement(), pp, clipCounter, true, doc);
            }
            if (isShape) {
                StiSvgHelper.writeShape(doc.getDocumentElement(), pp, doc);
            } else if (isImage) {
                StiSvgHelper.writeImage(doc.getDocumentElement(), pp, imageResolution, imageFormat, imageQuality, doc);
            }
            return doc;
        }

        public static void saveToStream(StiReport report, StiPage page, OutputStream outputStream, boolean compressed) {
            int tempInt = 0;
            StiSvgHelper.saveToStream(report, page, outputStream, compressed, true, tempInt, StiImageFormat.Png, 0.75f, 100.0f);
        }

        public static void saveToStream(StiReport report, StiPage page, OutputStream outputStream, boolean compressed, boolean standalone, int clipCounter, StiImageFormat imageFormat, float imageQuality, float imageResolution) {
            try {
                Document doc = StiSvgHelper.writeDocument(report, page, standalone, clipCounter, imageFormat, imageQuality, imageResolution);
                String xml = StiXmlHelper.serialize((Document)doc);
                if (compressed) {
                    GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);
                    gzipOutputStream.write(xml.getBytes("UTF-8"));
                    gzipOutputStream.flush();
                    gzipOutputStream.close();
                } else {
                    outputStream.write(xml.getBytes("UTF-8"));
                    outputStream.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public static void writeCheckBox(Element el, StiSvgData svgData, Document doc) {
            StiCheckBox checkBox = (StiCheckBox)svgData.Component;
            if (checkBox == null) {
                return;
            }
            String fill = StiChartSvgHelper.writeFillBrush(el, checkBox.getTextBrush(), new StiRectangle((double)((float)svgData.X), (double)((float)svgData.Y), (double)((float)svgData.Width), (double)((float)svgData.Height)), doc);
            Element g = doc.createElement("g");
            el.appendChild(g);
            int checkBoxSize = 200;
            double scaleCheckBox = 1.0 / ((double)checkBoxSize / Math.min(svgData.Width, svgData.Height));
            double offsetX = 0.0;
            double offsetY = 0.0;
            if (svgData.Width > svgData.Height) {
                offsetX = Math.abs(svgData.Width / 2.0 - (double)checkBoxSize * scaleCheckBox / 2.0);
            } else if (svgData.Width < svgData.Height) {
                offsetY = Math.abs(svgData.Height / 2.0 - (double)checkBoxSize * scaleCheckBox / 2.0);
            }
            g.setAttribute("transform", String.format("translate(%s,%s)", String.valueOf(svgData.X + offsetX).replace(',', '.'), String.valueOf(svgData.Y + offsetY).replace(',', '.')));
            Element path = doc.createElement("path");
            g.appendChild(path);
            path.setAttribute("d", StiSvgHelper.getCheckBoxData(checkBox));
            path.setAttribute("stroke", checkBox.getContourColor().toHTML());
            path.setAttribute("stroke-width", String.valueOf(checkBox.getSize()));
            path.setAttribute("stroke-linecap", "round");
            path.setAttribute("stroke-linejoin", "round");
            path.setAttribute("transform", String.format("scale(%s)", scaleCheckBox).replace(',', '.'));
            path.setAttribute("style", fill);
        }

        private static String getCheckBoxData(StiCheckBox checkbox) {
            boolean checkBoxValue = false;
            Object value = checkbox.getCheckedValue() != null ? checkbox.getCheckedValue() : checkbox.getChecked().getValue();
            String checkedValueStr = value.toString().trim().toLowerCase();
            String[] strs = checkbox.getValues().split("[/|,|;]");
            if (strs != null && strs.length > 0) {
                String firstValue = strs[0].trim().toLowerCase();
                checkBoxValue = checkedValueStr == firstValue;
            }
            String shape = "";
            switch (checkBoxValue ? checkbox.getCheckStyleForTrue() : checkbox.getCheckStyleForFalse()) {
                case Cross: {
                    shape = "m 62.567796,147.97593 c -0.55,-0.14223 -2.162828,-0.5128 -3.584062,-0.82348 -3.647667,-0.79738 -9.670499,-5.83775 -14.242817,-11.91949 l -3.902341,-5.19058 5.080199,-1.13481 c 7.353071,-1.64253 13.640456,-5.71752 21.826811,-14.14646 l 7.208128,-7.42171 -6.410736,-7.513354 c -11.773129,-13.79803 -14.346726,-23.01954 -8.627769,-30.91434 2.894109,-3.9952 11.818482,-12.369333 13.182086,-12.369333 0.411356,0 1.063049,1.6875 1.448207,3.750003 0.980474,5.25038 6.456187,16.76587 10.936694,23 2.075266,2.8875 3.991125,5.25 4.257464,5.25 0.266339,0 3.775242,-3.4875 7.797566,-7.75 16.397034,-17.37615 29.674184,-19.76481 38.280564,-6.88699 4.15523,6.21753 4.18631,8.07093 0.14012,8.3552 -5.84833,0.41088 -17.16241,8.5342 -25.51465,18.319104 l -4.63153,5.42599 4.87803,4.31529 c 6.55108,5.79533 18.8991,11.89272 25.84076,12.76002 3.0455,0.38051 5.53727,1.10582 5.53727,1.6118 0,2.7809 -9.26611,14.41872 -13.03,16.36511 -7.96116,4.11687 -16.36991,0.71207 -32.764584,-13.26677 l -4.985957,-4.25125 -7.086791,8.97188 c -3.897736,4.93454 -8.82141,10.1198 -10.9415,11.52281 -3.906121,2.58495 -8.86588,4.41339 -10.691162,3.94136 z";
                    break;
                }
                case Check: {
                    shape = "M 60.972125,162.49704 C 51.172676,136.72254 43.561975,123.37669 35.370344,117.6027 l -4.45827,-3.14248 2.75159,-2.89559 c 3.875121,-4.07793 10.034743,-7.49924 14.902472,-8.27747 3.859874,-0.61709 4.458306,-0.38024 8.535897,3.37835 2.660692,2.45254 6.265525,7.60856 9.167226,13.11196 2.630218,4.98849 4.910542,9.06999 5.067388,9.06999 0.156846,0 2.31372,-3.0375 4.793052,-6.75 C 96.259164,91.956015 129.68299,58.786374 157.56485,41.281603 l 8.84913,-5.555656 2.2633,2.631238 2.26329,2.631237 -7.76266,6.294183 C 139.859,66.19023 108.01682,105.51363 89.042715,138.83563 c -6.680477,11.73214 -7.172359,12.31296 -15.090788,17.81963 -4.501873,3.13071 -9.044031,6.30443 -10.093684,7.05271 -1.708923,1.21826 -2.010678,1.09165 -2.886118,-1.21093 z";
                    break;
                }
                case CrossRectangle: {
                    shape = "m 24.152542,102.04237 0,-72.499996 74.5,0 74.499998,0 0,72.499996 0,72.5 -74.499998,0 -74.5,0 0,-72.5 z m 133.758188,0.25 -0.25819,-57.249996 -58.999998,0 -59,0 -0.259695,55.999996 c -0.142833,30.8 -0.04446,56.5625 0.218615,57.25 0.375181,0.98048 13.207991,1.25 59.517885,1.25 l 59.039573,0 -0.25819,-57.25 z m -90.574091,43.18692 c -1.823747,-0.3912 -4.926397,-1.85716 -6.894778,-3.25768 -3.319254,-2.36169 -12.289319,-12.40741 -12.289319,-13.76302 0,-0.32888 2.417494,-1.13897 5.372209,-1.80021 7.185193,-1.60797 13.747505,-5.93496 21.803114,-14.3763 l 6.675323,-6.99496 -6.379078,-7.31436 C 64.931387,85.71231 61.643682,76.29465 65.471903,68.89169 67.054097,65.83207 78.56175,54.542374 80.098251,54.542374 c 0.45744,0 1.146839,1.6875 1.531997,3.75 0.980474,5.250386 6.456187,16.765876 10.936694,22.999996 2.075266,2.8875 3.991125,5.25 4.257464,5.25 0.266339,0 3.775244,-3.4875 7.797564,-7.75 16.39704,-17.376139 29.67419,-19.764806 38.28057,-6.88698 4.15523,6.21752 4.18631,8.07092 0.14012,8.35519 -5.82996,0.40959 -18.23707,9.34942 -25.91566,18.67328 -3.90068,4.73647 -3.97203,4.95414 -2.2514,6.86861 3.19054,3.54997 13.7039,10.54321 18.97191,12.61967 2.83427,1.11716 7.43737,2.33421 10.22912,2.70455 2.79175,0.37034 5.07591,0.9956 5.07591,1.38947 0,2.11419 -8.37504,13.20895 -11.6517,15.4355 -8.39423,5.70403 -16.63203,2.77 -34.14289,-12.16054 l -4.985955,-4.25125 -7.086791,8.97188 c -9.722344,12.3085 -16.524852,16.55998 -23.948565,14.96754 z";
                    break;
                }
                case CheckRectangle: {
                    shape = "m 19.915254,103.5 0,-72.5 71.942245,0 71.942241,0 6.55727,-4.11139 6.55726,-4.11139 1.96722,2.36139 c 1.08197,1.298765 1.98219,2.644166 2.00049,2.98978 0.0183,0.345615 -2.44173,2.53784 -5.46673,4.87161 l -5.5,4.243219 0,69.378391 0,69.37839 -74.999991,0 -75.000005,0 0,-72.5 z m 133.999996,3.87756 c 0,-49.33933 -0.12953,-53.514947 -1.62169,-52.276568 -2.78014,2.307312 -15.68408,17.90053 -24.32871,29.399008 -10.4919,13.955575 -23.47926,33.53736 -29.514025,44.5 -4.457326,8.09707 -5.134776,8.80812 -14.291256,15 -5.28667,3.575 -9.903486,6.62471 -10.259592,6.77712 -0.356107,0.15242 -1.912439,-2.99758 -3.458515,-7 -1.546077,-4.00241 -5.258394,-12.41205 -8.249593,-18.68809 -4.285436,-8.99155 -6.676569,-12.64898 -11.27758,-17.25 C 47.70282,104.62757 44.364254,102 43.495254,102 c -2.798369,0 -1.704872,-1.66044 3.983717,-6.049158 5.593548,-4.31539 13.183139,-7.091307 16.801313,-6.145133 3.559412,0.930807 9.408491,8.154973 13.919775,17.192241 l 4.46286,8.94025 4.54378,-6.83321 C 95.518219,96.605618 108.21371,81.688517 125.80695,63.75 L 143.21531,46 l -53.650021,0 -53.650035,0 0,57.5 0,57.5 59.000005,0 58.999991,0 0,-53.62244 z";
                    break;
                }
                case CrossCircle: {
                    shape = "M 83.347458,173.13597 C 61.069754,168.04956 42.193415,152.8724 32.202285,132.01368 23.4014,113.63986 23.679644,89.965903 32.91889,71.042373 41.881579,52.685283 60.867647,37.139882 80.847458,31.799452 c 10.235111,-2.735756 31.264662,-2.427393 40.964762,0.600679 26.18668,8.174684 46.06876,28.926852 51.62012,53.879155 2.43666,10.952327 1.56754,28.058524 -1.98036,38.977594 -6.65679,20.48707 -25.64801,38.95163 -47.32647,46.01402 -6.3909,2.08202 -10.18566,2.59644 -21.27805,2.88446 -9.033911,0.23456 -15.484931,-0.10267 -19.500002,-1.01939 z M 112.4138,158.45825 c 17.13137,-3.13002 33.71724,-15.96081 41.41353,-32.03742 14.8975,-31.119027 -1.10807,-67.659584 -34.40232,-78.540141 -6.71328,-2.193899 -9.93541,-2.643501 -19.07755,-2.661999 -9.354252,-0.01893 -12.16228,0.37753 -18.768532,2.649866 -17.155451,5.900919 -29.669426,17.531424 -36.438658,33.866137 -2.152301,5.193678 -2.694658,8.35455 -3.070923,17.89744 -0.518057,13.139047 0.741843,19.201887 6.111644,29.410237 4.106815,7.80733 15.431893,19.09359 23.36818,23.28808 12.061362,6.37467 27.138828,8.6356 40.864629,6.1278 z M 69.097458,133.41654 c -2.8875,-2.75881 -5.25,-5.35869 -5.25,-5.77751 0,-0.41882 5.658529,-6.30954 12.57451,-13.0905 l 12.57451,-12.329 L 76.198053,89.392633 63.399628,76.565738 68.335951,71.554056 c 2.714978,-2.756426 5.304859,-5.011683 5.75529,-5.011683 0.450432,0 6.574351,5.611554 13.608709,12.470121 l 12.78974,12.470119 4.42889,-4.553471 c 2.43588,-2.50441 8.39186,-8.187924 13.23551,-12.630032 l 8.80663,-8.076559 5.34744,5.281006 5.34743,5.281007 -12.96155,12.557899 -12.96154,12.557897 13.13318,13.16027 13.13319,13.16027 -5.18386,4.66074 c -2.85112,2.5634 -5.70472,4.66073 -6.34134,4.66073 -0.63661,0 -6.5434,-5.4 -13.12621,-12 -6.58281,-6.6 -12.3871,-12 -12.89844,-12 -0.511329,0 -6.593363,5.60029 -13.515627,12.44509 l -12.585935,12.44508 -5.25,-5.016 z";
                    break;
                }
                case DotCircle: {
                    shape = "M 81.652542,170.5936 C 59.374838,165.50719 40.498499,150.33003 30.507369,129.47131 21.706484,111.09749 21.984728,87.42353 31.223974,68.5 40.186663,50.14291 59.172731,34.597509 79.152542,29.257079 89.387653,26.521323 110.4172,26.829686 120.1173,29.857758 c 26.18668,8.174684 46.06876,28.926852 51.62012,53.879152 2.43666,10.95233 1.56754,28.05853 -1.98036,38.9776 -6.65679,20.48707 -25.64801,38.95163 -47.32647,46.01402 -6.3909,2.08202 -10.18566,2.59644 -21.27805,2.88446 -9.033907,0.23456 -15.484927,-0.10267 -19.499998,-1.01939 z m 29.999998,-15.098 c 20.68862,-4.34363 38.01874,-20.45437 44.09844,-40.9956 2.36228,-7.9813 2.36228,-22.0187 0,-30 C 150.08927,65.371023 134.63549,50.297336 114.65254,44.412396 106.5531,42.027127 90.741304,42.026386 82.695253,44.4109 62.460276,50.407701 46.686742,66.039241 41.6053,85.13096 c -1.948821,7.32201 -1.86506,23.11641 0.158766,29.93754 8.730326,29.42481 38.97193,46.91812 69.888474,40.4271 z M 90.004747,122.6703 C 76.550209,117.63801 69.825047,101.82445 75.898143,89.5 c 2.136718,-4.33615 7.147144,-9.356192 11.754399,-11.776953 5.578622,-2.931141 16.413098,-2.927504 22.052908,0.0074 18.03,9.382663 19.07573,32.784373 1.91442,42.841563 -5.57282,3.26589 -15.830952,4.2617 -21.615123,2.09829 z";
                    break;
                }
                case DotRectangle: {
                    shape = "m 23.847458,101.19491 0,-72.499995 74.5,0 74.499992,0 0,72.499995 0,72.5 -74.499992,0 -74.5,0 0,-72.5 z m 133.999992,-0.008 0,-57.507925 -59.249992,0.25793 -59.25,0.25793 -0.25819,57.249995 -0.258189,57.25 59.508189,0 59.508182,0 0,-57.50793 z m -94.320573,33.85402 c -0.37368,-0.37368 -0.679419,-15.67942 -0.679419,-34.01275 l 0,-33.333335 35.513302,0 35.51329,0 -0.2633,33.749995 -0.2633,33.75 -34.570573,0.26275 c -19.013819,0.14452 -34.876319,-0.043 -35.25,-0.41666 z";
                    break;
                }
                case NoneCircle: {
                    shape = "M 83.5,170.5936 C 61.222296,165.50719 42.345957,150.33003 32.354827,129.47131 23.553942,111.09749 23.832186,87.423523 33.071432,68.5 42.034121,50.14291 61.020189,34.597509 81,29.257079 c 10.235111,-2.735756 31.26466,-2.427393 40.96476,0.600679 26.18668,8.174684 46.06876,28.926852 51.62012,53.879155 2.43666,10.95232 1.56754,28.058527 -1.98036,38.977597 -6.65679,20.48707 -25.64801,38.95163 -47.32647,46.01402 -6.3909,2.08202 -10.18566,2.59644 -21.27805,2.88446 -9.033909,0.23456 -15.484929,-0.10267 -19.5,-1.01939 z m 30,-15.098 c 20.68862,-4.34363 38.01874,-20.45437 44.09844,-40.9956 2.36228,-7.9813 2.36228,-22.018707 0,-29.999997 C 151.93673,65.371023 136.48295,50.297336 116.5,44.412396 108.40056,42.027127 92.588762,42.026386 84.542711,44.410896 64.307734,50.407697 48.5342,66.039237 43.452758,85.130959 c -1.948821,7.322 -1.86506,23.116411 0.158766,29.937541 8.730326,29.42481 38.97193,46.91812 69.888476,40.4271 z";
                    break;
                }
                case NoneRectangle: {
                    shape = "m 24.152542,102.04237 0,-72.499997 74.5,0 74.500008,0 0,72.499997 0,72.5 -74.500008,0 -74.5,0 0,-72.5 z m 133.758198,0.25 -0.25819,-57.249997 -59.000008,0 -59,0 -0.259695,55.999997 c -0.142833,30.8 -0.04446,56.5625 0.218615,57.25 0.375181,0.98048 13.207991,1.25 59.517885,1.25 l 59.039583,0 -0.25819,-57.25 z";
                    break;
                }
                case None: {
                    break;
                }
            }
            return shape;
        }

        public static String saveComponentToString(StiComponent component, StiImageFormat imageFormat, float imageQuality, float imageResolution) throws ParserConfigurationException, IOException, TransformerException {
            StiText stiText;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            imageResolution /= 100.0f;
            StiReport report = component.getReport();
            double hiToTwips = 1.0;
            double x1 = hiToTwips * report.getUnit().ConvertToHInches(component.getLeft());
            double y1 = hiToTwips * report.getUnit().ConvertToHInches(component.getTop());
            double x2 = hiToTwips * report.getUnit().ConvertToHInches(component.getRight());
            double y2 = hiToTwips * report.getUnit().ConvertToHInches(component.getBottom());
            StiSvgData pp = new StiSvgData();
            pp.X = 0.0;
            pp.Y = 0.0;
            pp.Width = StiMath.round((double)(x2 - x1), (int)0);
            pp.Height = StiMath.round((double)(y2 - y1), (int)0);
            pp.Component = component;
            boolean isImage = component.isExportAsImage(StiExportFormat.ImageSvg);
            boolean isShape = StiSvgHelper.checkShape(component);
            StiRefObject gradientCounter = new StiRefObject((Object)1);
            int clipCounter = 1;
            Element j = doc.createElement("j");
            doc.appendChild(j);
            StiText stiText2 = stiText = component instanceof StiText ? (StiText)component : null;
            if (stiText != null && !isImage && StiValidationUtil.isNotNullOrEmpty((String)stiText.getTextInternal())) {
                Element defs = doc.createElement("defs");
                doc.getDocumentElement().appendChild(defs);
                Element clipPath = doc.createElement("clipPath");
                defs.appendChild(clipPath);
                Element rect = doc.createElement("rect");
                clipPath.appendChild(rect);
                StiSvgHelper.writeCoordinates(rect, pp);
            }
            if (!isShape && !isImage) {
                StiSvgHelper.writeBorder1(doc.getDocumentElement(), pp, (StiRefObject<Integer>)gradientCounter, doc);
            }
            if (component instanceof StiText && !isImage) {
                StiSvgHelper.writeText(doc.getDocumentElement(), pp, clipCounter, true, doc);
            } else if (component instanceof StiBarCode) {
                StiSvgHelper.writeBarCode(doc.getDocumentElement(), pp, doc);
            } else if (component instanceof StiCheckBox) {
                StiSvgHelper.writeCheckBox(doc.getDocumentElement(), pp, doc);
            } else if (component instanceof StiChart) {
                StiChartSvgHelper.writeChart(doc.getDocumentElement(), pp, false, doc);
            } else if (isShape) {
                StiSvgHelper.writeShape(doc.getDocumentElement(), pp, doc);
            } else if (isImage) {
                StiSvgHelper.writeImage(doc.getDocumentElement(), pp, imageResolution, imageFormat, imageQuality, doc);
            }
            StringBuilder sb = new StringBuilder(StiXmlHelper.serialize((Document)doc, (boolean)false, (boolean)false, null));
            if (sb.indexOf("<j/>") > 0) {
                sb.delete(0, sb.indexOf("<j/>") + 4);
            } else {
                sb.delete(0, sb.indexOf("<j>") + 3);
                sb.delete(sb.indexOf("</j>"), sb.indexOf("</j>") + 4);
            }
            return sb.toString().trim();
        }

        public static class StiSvgData {
            public double X;
            public double Y;
            public double Width;
            public double Height;
            public StiComponent Component;
        }
    }
}

