/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.drawing.StiBorderSide;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.utils.StiCharsetHelper;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.base.utils.StiZipWriter20;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.report.StiImageCache;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiMargins;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.components.enums.StiPageOrientation;
import com.stimulsoft.report.components.interfaces.IStiExportImage;
import com.stimulsoft.report.components.interfaces.IStiFont;
import com.stimulsoft.report.components.interfaces.IStiHorAlignment;
import com.stimulsoft.report.components.interfaces.IStiTextBrush;
import com.stimulsoft.report.components.interfaces.IStiTextHorAlignment;
import com.stimulsoft.report.components.interfaces.IStiTextOptions;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.StiSegmentPagesDivider;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.service.StiRtfExportService;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiWord2007ExportSettings;
import com.stimulsoft.report.export.tools.StiCell;
import com.stimulsoft.report.export.tools.StiExportUtils;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiMapUtil;
import com.stimulsoft.report.export.tools.StiMatrix;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.report.options.ExportOptions;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StiWord2007ExportService
extends StiExportService {
    private static final String NULL_DOC_PREFIX = "DocIsNull";
    private static final String WRONG_URL_SYMBOLS = "\\u0020\\u0022\\u0023\\u0025\\u0027\\u002a\\u002c\\u003b\\u003c\\u003e\\u005b\\u005e\\u0060\\u007b\\u007c\\u007d";
    private StiMatrix matrix = null;
    private boolean removeEmptySpaceAtBottom = ExportOptions.Word2007.getRemoveEmptySpaceAtBottom();
    private Hashtable<String, String> fontList = null;
    private ArrayList<StiWord2007StyleInfo> styleList = null;
    private StiImageCache imageCache = null;
    private Hashtable<String, Integer> bookmarkList = null;
    private Hashtable<String, Integer> hyperlinkList = null;
    private ArrayList<String> embedsList = null;
    private float imageQuality = 0.75f;
    private float imageResolution = 96.0f;
    private String lineSpace = null;
    private boolean usePageHeadersAndFooters = false;
    private ArrayList<Document> headersData = null;
    private ArrayList<Document> headersRels = null;
    private ArrayList<Document> footersData = null;
    private ArrayList<Document> footersRels = null;
    private String docCompanyString = null;
    private String docLastModifiedString = null;
    private StiReport report;

    private String getLineStyle(StiPenStyle penStyle) {
        switch (penStyle) {
            case Solid: {
                return "single";
            }
            case Dot: {
                return "dotted";
            }
            case Dash: {
                return "dashSmallGap";
            }
            case DashDot: {
                return "dotDash";
            }
            case DashDotDot: {
                return "dotDotDash";
            }
            case Double: {
                return "double";
            }
        }
        return "";
    }

    private String getColorString(StiColor color) {
        if (color.getA() < 32) {
            return "FFFFFF";
        }
        return color.toHTML().substring(1);
    }

    private int getStyleNumber(ArrayList<StiWord2007StyleInfo> tmpStyleList, StiWord2007StyleInfo styleInfo) {
        if (tmpStyleList.size() > 0) {
            for (int index = 0; index < tmpStyleList.size(); ++index) {
                StiWord2007StyleInfo tmpStyle = tmpStyleList.get(index);
                if (tmpStyle.Alignment != styleInfo.Alignment || !tmpStyle.Name.equals(styleInfo.Name) || !tmpStyle.FontName.equals(styleInfo.FontName) || tmpStyle.FontSize != styleInfo.FontSize || tmpStyle.Bold != styleInfo.Bold || tmpStyle.Italic != styleInfo.Italic || tmpStyle.Underline != styleInfo.Underline || !tmpStyle.TextColor.equals(styleInfo.TextColor) || tmpStyle.RightToLeft != styleInfo.RightToLeft) continue;
                return index;
            }
        }
        tmpStyleList.add(styleInfo);
        int temp = tmpStyleList.size() - 1;
        return temp;
    }

    private int getStyleFromComponent(StiComponent component) {
        if (component != null && component.getComponentStyle() != null && component.getComponentStyle().length() > 0) {
            IStiFont mFont = component instanceof IStiFont ? (IStiFont)((Object)component) : null;
            IStiTextBrush mTextBrush = component instanceof IStiTextBrush ? (IStiTextBrush)((Object)component) : null;
            IStiTextHorAlignment mTextHorAlign = component instanceof IStiTextHorAlignment ? (IStiTextHorAlignment)((Object)component) : null;
            IStiTextOptions textOpt = component instanceof IStiTextOptions ? (IStiTextOptions)((Object)component) : null;
            StiWord2007StyleInfo style = new StiWord2007StyleInfo();
            style.Name = component.getComponentStyle();
            if (mFont != null) {
                style.FontName = mFont.getFont().getName();
                style.FontSize = (int)StiMath.round((double)(mFont.getFont().getSize() * 2.0), (int)0);
                style.Bold = mFont.getFont().bold();
                style.Italic = mFont.getFont().italic();
                style.Underline = mFont.getFont().underline();
            }
            if (mTextBrush != null) {
                style.TextColor = StiBrush.ToColor((StiBrush)mTextBrush.getTextBrush());
            }
            if (mTextHorAlign != null) {
                style.Alignment = mTextHorAlign.getHorAlignment();
            }
            if (textOpt != null) {
                style.RightToLeft = textOpt.getTextOptions().getRightToLeft();
            }
            return this.getStyleNumber(this.styleList, style);
        }
        return -1;
    }

    private String stringToUrl(String input) throws UnsupportedEncodingException {
        byte[] buf = input.getBytes("UTF8");
        StringBuilder output = new StringBuilder();
        for (byte byt : buf) {
            if (byt < 32 || byt > 127 || WRONG_URL_SYMBOLS.indexOf((char)byt) != -1) {
                output.append(String.format("%%%02x", byt));
                continue;
            }
            output.append((char)byt);
        }
        return output.toString();
    }

    private static double getHiToTwips() {
        return 14.328;
    }

    private int convert(double x) {
        return (int)Math.round(x * StiWord2007ExportService.getHiToTwips());
    }

    private int convertHiToTwips(double x) {
        return (int)Math.round(x * 14.4);
    }

    private int convertTwipsToEmu(double x) {
        return (int)Math.round(x / StiWord2007ExportService.getHiToTwips() / 100.0 * 914400.0);
    }

    private String convertStringToBookmark(String inputString) {
        StringBuilder sbOutput = new StringBuilder();
        for (char ch : inputString.toCharArray()) {
            if (!Character.isLetterOrDigit(ch)) continue;
            sbOutput.append(ch);
        }
        if (sbOutput.length() > 0 && Character.isDigit(sbOutput.charAt(0))) {
            sbOutput.insert(0, 'b');
        }
        return sbOutput.toString();
    }

    private void writeFromMatrix(Element element, int startLine, int endLine, boolean outHeadersAndFooters, Document document) throws IOException, StiException {
        int maxCoordX = this.matrix.getCoordX().size();
        int[] wordCoordX = new int[this.matrix.getCoordX().size()];
        for (int indexColumn = 0; indexColumn < this.matrix.getCoordX().size(); ++indexColumn) {
            double columnX = (Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), indexColumn);
            wordCoordX[indexColumn] = this.convert(columnX);
        }
        int[] wordCoordY = new int[this.matrix.getCoordY().size()];
        for (int indexRow = 0; indexRow < this.matrix.getCoordY().size(); ++indexRow) {
            double columnY = (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), indexRow);
            wordCoordY[indexRow] = this.convert(columnY);
        }
        boolean isTable = false;
        int skipCounter = 0;
        boolean[][] readyCells = new boolean[this.matrix.getCoordY().size()][this.matrix.getCoordX().size()];
        boolean[][] readyCellsVert = new boolean[this.matrix.getCoordY().size()][this.matrix.getCoordX().size()];
        String headerName = "";
        Element tblEl = document.createElement("w:tbl");
        for (int indexRow = 1; indexRow < this.matrix.getCoordY().size(); ++indexRow) {
            Element pEl;
            boolean needOutLine;
            Element rootEl = element;
            this.invokeExporting(indexRow, this.matrix.getCoordY().size());
            boolean bl = needOutLine = indexRow - 1 >= startLine && indexRow - 1 <= endLine;
            if (!(outHeadersAndFooters || this.matrix.getLinePlacement()[indexRow - 1] != StiMatrix.StiTableLineInfo.PageHeader && this.matrix.getLinePlacement()[indexRow - 1] != StiMatrix.StiTableLineInfo.PageFooter && this.matrix.getLinePlacement()[indexRow - 1] != StiMatrix.StiTableLineInfo.Trash)) {
                needOutLine = false;
            }
            if (skipCounter > 0) {
                --skipCounter;
                needOutLine = false;
            }
            double maxTopMargin = 100005.0;
            ArrayList<StiCell> paragraphList = new ArrayList<StiCell>();
            boolean needNewPage = false;
            if (needOutLine) {
                for (int columnIndex = 1; columnIndex < maxCoordX; ++columnIndex) {
                    StiCell cell = this.matrix.getCells()[indexRow - 1][columnIndex - 1];
                    if (readyCells[indexRow][columnIndex] || cell == null || cell.getComponent() == null) continue;
                    if (cell.getComponent().getTagValue() != null) {
                        String cellTag = cell.getComponent().getTagValue().toLowerCase();
                        if (cellTag.indexOf("rtfparagraph") != -1) {
                            paragraphList.add(cell);
                            needOutLine = false;
                        }
                        if (cellTag.indexOf("rtfnewpage") != -1) {
                            needNewPage = true;
                        }
                    }
                    StiMargins margins = null;
                    if (cell.getComponent() instanceof StiText) {
                        margins = ((StiText)cell.getComponent()).getMargins();
                    }
                    if (cell.getComponent() instanceof StiRichText) {
                        margins = ((StiRichText)cell.getComponent()).getMargins();
                    }
                    if (margins == null) continue;
                    if (margins.getTop() < maxTopMargin) {
                        maxTopMargin = margins.getTop();
                    }
                    if (cell.getHeight() <= 0) continue;
                    maxTopMargin = 0.0;
                }
            }
            int maxTopMarginInt = (int)Math.round(maxTopMargin *= StiWord2007ExportService.getHiToTwips());
            if (needNewPage) {
                if (isTable) {
                    isTable = false;
                }
                pEl = document.createElement("w:p");
                element.appendChild(pEl);
                Element rEl = document.createElement("w:r");
                pEl.appendChild(rEl);
                Element brEl = document.createElement("w:br");
                rEl.appendChild(brEl);
                brEl.setAttribute("w:type", "page");
            }
            if (needOutLine) {
                if (this.usePageHeadersAndFooters && this.matrix.getLinePlacement()[indexRow - 1] == StiMatrix.StiTableLineInfo.HeaderAP && this.matrix.getParentBandName()[indexRow - 1] != headerName) {
                    headerName = this.matrix.getParentBandName()[indexRow - 1];
                    pEl = document.createElement("w:p");
                    element.appendChild(pEl);
                    tblEl = document.createElement("w:tbl");
                    element.appendChild(tblEl);
                    rootEl = tblEl;
                    this.writeTableInfo(tblEl, wordCoordX, maxCoordX, document);
                    isTable = true;
                }
                if (!isTable) {
                    tblEl = document.createElement("w:tbl");
                    element.appendChild(tblEl);
                    this.writeTableInfo(tblEl, wordCoordX, maxCoordX, document);
                    isTable = true;
                }
                Element trEl = document.createElement("w:tr");
                tblEl.appendChild(trEl);
                rootEl = trEl;
                int rowHeight = wordCoordY[indexRow] - wordCoordY[indexRow - 1];
                Element trPrEl = document.createElement("w:trPr");
                trEl.appendChild(trPrEl);
                if (!this.usePageHeadersAndFooters || ExportOptions.Word2007.getForceLineHeight()) {
                    Element trHeightEl = document.createElement("w:trHeight");
                    trPrEl.appendChild(trHeightEl);
                    if (!this.usePageHeadersAndFooters && ExportOptions.Word2007.getLineHeightExactly() || this.usePageHeadersAndFooters && ExportOptions.Word2007.getLineHeightExactlyForPHFMode()) {
                        trHeightEl.setAttribute("w:hRule", "exact");
                    }
                    trHeightEl.setAttribute("w:val", String.format("%s", rowHeight));
                }
                if (this.usePageHeadersAndFooters && this.matrix.getLinePlacement()[indexRow - 1] == StiMatrix.StiTableLineInfo.HeaderAP) {
                    Element tblHeaderEl = document.createElement("w:tblHeader");
                    trPrEl.appendChild(tblHeaderEl);
                }
            }
            int curCoordX = 0;
            for (int indexColumn = 1; indexColumn < maxCoordX; ++indexColumn) {
                StiCell cell = this.matrix.getCells()[indexRow - 1][indexColumn - 1];
                if (!readyCells[indexRow][indexColumn] || readyCellsVert[indexRow][indexColumn]) {
                    ++curCoordX;
                    boolean needContent = true;
                    if (readyCellsVert[indexRow][indexColumn]) {
                        int tempIndexRow = indexRow;
                        while (readyCellsVert[tempIndexRow][indexColumn]) {
                            --tempIndexRow;
                        }
                        cell = this.matrix.getCells()[tempIndexRow - 1][indexColumn - 1];
                        needContent = false;
                    }
                    if (cell != null && needContent) {
                        int yy;
                        for (yy = 0; yy <= cell.getHeight(); ++yy) {
                            for (int xx = 0; xx <= cell.getWidth(); ++xx) {
                                readyCells[indexRow + yy][indexColumn + xx] = true;
                            }
                        }
                        if (cell.getHeight() > 0) {
                            for (yy = 1; yy <= cell.getHeight(); ++yy) {
                                readyCellsVert[indexRow + yy][indexColumn] = true;
                            }
                        }
                    }
                    if (needOutLine) {
                        Element tcEl = document.createElement("w:tc");
                        rootEl.appendChild(tcEl);
                        if (cell != null) {
                            boolean isEmbedRtfFlag;
                            Element tcPrEl = document.createElement("w:tcPr");
                            tcEl.appendChild(tcPrEl);
                            int cellWidth = 0;
                            for (int indexMerg = 0; indexMerg < cell.getWidth() + 1; ++indexMerg) {
                                cellWidth += wordCoordX[indexColumn + indexMerg] - wordCoordX[indexColumn - 1 + indexMerg];
                            }
                            Element tcWEl = document.createElement("w:tcW");
                            tcPrEl.appendChild(tcWEl);
                            tcWEl.setAttribute("w:w", String.format("%s", cellWidth));
                            tcWEl.setAttribute("w:type", "dxa");
                            if (cell.getWidth() > 0) {
                                Element gridEl = document.createElement("w:gridSpan");
                                tcPrEl.appendChild(gridEl);
                                gridEl.setAttribute("w:val", String.format("%s", cell.getWidth() + 1));
                            }
                            if (cell.getHeight() > 0) {
                                Element mergeEl;
                                if (!readyCellsVert[indexRow][indexColumn]) {
                                    mergeEl = document.createElement("w:vMerge");
                                    tcPrEl.appendChild(mergeEl);
                                    mergeEl.setAttribute("w:val", "restart");
                                } else {
                                    mergeEl = document.createElement("w:vMerge");
                                    tcPrEl.appendChild(mergeEl);
                                }
                            }
                            if (cell.getCellStyle().getTextOptions() != null) {
                                float textAngle = cell.getCellStyle().getTextOptions().getAngle();
                                String stTextAngle = "";
                                if (textAngle > 45.0f && textAngle < 135.0f) {
                                    stTextAngle = "btLr";
                                }
                                if (textAngle > 225.0f && textAngle < 315.0f) {
                                    stTextAngle = "tbRl";
                                }
                                if (!"".equals(stTextAngle)) {
                                    Element textEl = document.createElement("w:textDirection");
                                    tcPrEl.appendChild(textEl);
                                    textEl.setAttribute("w:val", stTextAngle);
                                }
                            }
                            boolean bl2 = isEmbedRtfFlag = cell.getComponent() instanceof StiText && ((StiText)cell.getComponent()).getAllowHtmlTags() && !ExportOptions.Word2007.getRenderHtmlTagsAsImage();
                            if (needContent && cell.getComponent() instanceof StiText && (!cell.getComponent().isExportAsImage(StiExportFormat.Word2007) || isEmbedRtfFlag)) {
                                StiText stiText = (StiText)cell.getComponent();
                                int mLeft = this.convert(stiText.getMargins().getLeft());
                                int mRight = this.convert(stiText.getMargins().getRight() - (double)ExportOptions.Word2007.getRightMarginCorrection());
                                int mTop = this.convert(stiText.getMargins().getTop());
                                if (mTop > maxTopMarginInt) {
                                    mTop = maxTopMarginInt;
                                }
                                if (mLeft > 0 || mRight > 0 || mTop > 0) {
                                    Element tcMarEl = document.createElement("w:tcMar");
                                    tcPrEl.appendChild(tcMarEl);
                                    if (mTop > 0) {
                                        Element topEl = document.createElement("w:top");
                                        tcMarEl.appendChild(topEl);
                                        topEl.setAttribute("w:w", String.format("%s", mTop));
                                        topEl.setAttribute("w:type", "dxa");
                                    }
                                    if (mLeft > 0) {
                                        Element leftEl = document.createElement("w:left");
                                        tcMarEl.appendChild(leftEl);
                                        leftEl.setAttribute("w:w", String.format("%s", mLeft));
                                        leftEl.setAttribute("w:type", "dxa");
                                    }
                                    if (mRight > 0) {
                                        Element rightEl = document.createElement("w:right");
                                        tcMarEl.appendChild(rightEl);
                                        rightEl.setAttribute("w:w", String.format("%s", mRight));
                                        rightEl.setAttribute("w:type", "dxa");
                                    }
                                }
                            }
                            String stVertAlign = "";
                            switch (cell.getCellStyle().getVertAlignment()) {
                                case Center: {
                                    stVertAlign = "center";
                                    break;
                                }
                                case Bottom: {
                                    stVertAlign = "bottom";
                                }
                            }
                            if (!"".equals(stVertAlign)) {
                                Element vAlignEl = document.createElement("w:vAlign");
                                tcPrEl.appendChild(vAlignEl);
                                vAlignEl.setAttribute("w:val", stVertAlign);
                            }
                            this.writeBorders(tcPrEl, cell.getTop(), cell.getLeft(), cell.getHeight() + 1, cell.getWidth() + 1, document);
                            if (!cell.getComponent().isExportAsImage(StiExportFormat.Word2007)) {
                                Element shdEl = document.createElement("w:shd");
                                tcPrEl.appendChild(shdEl);
                                shdEl.setAttribute("w:val", "clear");
                                shdEl.setAttribute("w:color", "auto");
                                shdEl.setAttribute("w:fill", this.getColorString(cell.getCellStyle().getColor()));
                            }
                            boolean needEmptyParagraph = true;
                            if (needContent) {
                                needEmptyParagraph = this.writeCellContent(tcEl, cell, needEmptyParagraph, indexRow, indexColumn, wordCoordX, wordCoordY, document);
                            }
                            if (needEmptyParagraph) {
                                Element pEl2 = document.createElement("w:p");
                                tcEl.appendChild(pEl2);
                            }
                        } else {
                            ReturnResult result = this.renderBorder2TableGetValues(indexRow, indexColumn);
                            StiEnumSet<StiBorderSides> baseSides = result.borderSides;
                            String baseSt = result.stringResult;
                            int newWidth = 0;
                            if (!baseSides.contains((IStiEnum)StiBorderSides.Right)) {
                                while (indexColumn + newWidth + 1 < maxCoordX && this.matrix.getCells()[indexRow - 1][indexColumn + newWidth + 1 - 1] == null && !readyCells[indexRow][indexColumn + newWidth + 1] && !readyCellsVert[indexRow][indexColumn + newWidth + 1]) {
                                    ReturnResult result2 = this.renderBorder2TableGetValues(indexRow, indexColumn + newWidth + 1);
                                    StiEnumSet<StiBorderSides> newSides = result2.borderSides;
                                    String newSt = result2.stringResult;
                                    if (newSides.contains((IStiEnum)StiBorderSides.Left) || (newSides.contains((IStiEnum)StiBorderSides.Top) | newSides.contains((IStiEnum)StiBorderSides.Bottom)) != (baseSides.contains((IStiEnum)StiBorderSides.Top) | baseSides.contains((IStiEnum)StiBorderSides.Bottom)) || !StiStringUtil.stringsEquals((String)baseSt, (String)newSt)) break;
                                    ++newWidth;
                                    if (!newSides.contains((IStiEnum)StiBorderSides.Right)) continue;
                                    break;
                                }
                                if (newWidth > 0) {
                                    for (int xx = 1; xx <= newWidth; ++xx) {
                                        readyCells[indexRow][indexColumn + xx] = true;
                                    }
                                }
                            }
                            Element tcPrEl = document.createElement("w:tcPr");
                            tcEl.appendChild(tcPrEl);
                            int cellWidth = wordCoordX[indexColumn + newWidth] - wordCoordX[indexColumn - 1];
                            Element tcWEl = document.createElement("w:tcW");
                            tcPrEl.appendChild(tcWEl);
                            tcWEl.setAttribute("w:w", String.format("%s", cellWidth));
                            tcWEl.setAttribute("w:type", "dxa");
                            if (newWidth > 0) {
                                Element gridEl = document.createElement("w:gridSpan");
                                tcPrEl.appendChild(gridEl);
                                gridEl.setAttribute("w:val", String.format("%s", newWidth + 1));
                            }
                            this.writeBorders(tcPrEl, indexRow - 1, indexColumn - 1, 1, newWidth + 1, document);
                            Element pEl3 = document.createElement("w:p");
                            tcEl.appendChild(pEl3);
                        }
                    }
                }
                if (curCoordX >= 64) break;
            }
            for (StiCell paragraphCell : paragraphList) {
                isTable = false;
                skipCounter = paragraphCell.getHeight();
                boolean needEmptyParagraph2 = false;
                needEmptyParagraph2 = this.writeCellContent(element, paragraphCell, needEmptyParagraph2, paragraphCell.getTop() + 1, paragraphCell.getLeft() + 1, wordCoordX, wordCoordY, document);
            }
        }
    }

    private boolean writeCellContent(Element element, StiCell cell, boolean needEmptyParagraph, int indexRow, int indexColumn, int[] wordCoordX, int[] wordCoordY, Document document) throws IOException, StiException {
        float rsImageResolution;
        BufferedImage image;
        IStiExportImage exportImage;
        Element bookmarkEl;
        Element rEl;
        String hyperlink;
        String bkmRefText = null;
        Integer bkmRefId = -1;
        String bkm = this.matrix.getBookmarks()[indexRow - 1][indexColumn - 1];
        if (bkm != null && !this.bookmarkList.containsKey(bkm)) {
            bkmRefId = this.bookmarkList.size();
            bkmRefText = this.convertStringToBookmark(bkm);
            this.bookmarkList.put(bkm, bkmRefId);
        }
        String hypRefText = null;
        int hypRefId = -1;
        if (cell.getComponent() != null && cell.getComponent().getHyperlinkValue() != null && (hyperlink = cell.getComponent().getHyperlinkValue().trim()).length() > 0 && !hyperlink.startsWith("javascript:")) {
            if (hyperlink.startsWith("#")) {
                hypRefText = this.convertStringToBookmark(hyperlink.substring(1));
            } else {
                hypRefText = this.stringToUrl(hyperlink);
                if (this.hyperlinkList.containsKey(hypRefText)) {
                    hypRefId = this.hyperlinkList.get(hypRefText);
                } else {
                    hypRefId = this.hyperlinkList.size();
                    this.hyperlinkList.put(hypRefText, hypRefId);
                }
            }
        }
        if (cell.getComponent() instanceof StiText && !cell.getComponent().isExportAsImage(StiExportFormat.Word2007) && !((StiText)cell.getComponent()).getAllowHtmlTags()) {
            String expr;
            StringBuilder sb = new StringBuilder(cell.getText());
            if (this.usePageHeadersAndFooters && (expr = cell.getComponent().getTagValue()) != null && expr.length() > 0 && expr.toLowerCase().indexOf("rtfnewpage") == -1 && (expr.indexOf("#PageNumber#") != -1 || expr.indexOf("#TotalPageCount#") != -1 || expr.indexOf("#PageRef") != -1)) {
                sb = new StringBuilder(expr);
            }
            ArrayList<String> stringList = new ArrayList<String>();
            String st = "";
            for (char ch : sb.toString().toCharArray()) {
                if (Character.isISOControl(ch) && ch != '\t') {
                    if (ch != '\n') continue;
                    stringList.add(st);
                    st = "";
                    continue;
                }
                st = st + ch;
            }
            if (!"".equals(st)) {
                stringList.add(st);
            }
            if (stringList.size() == 0) {
                stringList.add(st);
            }
            if (stringList.size() > 0) {
                needEmptyParagraph = false;
            }
            int styleIndex = this.getStyleFromComponent(cell.getComponent());
            for (int indexLine = 0; indexLine < stringList.size(); ++indexLine) {
                String textLine = (String)stringList.get(indexLine);
                Element pEl = document.createElement("w:p");
                element.appendChild(pEl);
                Element pPrEl = document.createElement("w:pPr");
                pEl.appendChild(pPrEl);
                if (this.lineSpace != null) {
                    Element spacingEl = document.createElement("w:spacing");
                    pPrEl.appendChild(spacingEl);
                    spacingEl.setAttribute("w:line", this.lineSpace);
                }
                if (styleIndex != -1) {
                    Element pStyleEl = document.createElement("w:pStyle");
                    pPrEl.appendChild(pStyleEl);
                    pStyleEl.setAttribute("w:val", String.format("Style%s", styleIndex));
                }
                StiTextHorAlignment horAlignment = cell.getCellStyle().getHorAlignment();
                boolean rightToLeft = false;
                if (cell.getCellStyle().getTextOptions() != null) {
                    rightToLeft = cell.getCellStyle().getTextOptions().getRightToLeft();
                }
                String stHorAlignment = "";
                if (horAlignment == StiTextHorAlignment.Left && rightToLeft || horAlignment == StiTextHorAlignment.Right && !rightToLeft) {
                    stHorAlignment = "right";
                }
                if (horAlignment == StiTextHorAlignment.Center) {
                    stHorAlignment = "center";
                }
                if (horAlignment == StiTextHorAlignment.Width) {
                    stHorAlignment = "both";
                }
                if (!"".equals(stHorAlignment)) {
                    Element jcEl = document.createElement("w:jc");
                    pPrEl.appendChild(jcEl);
                    jcEl.setAttribute("w:val", stHorAlignment);
                }
                if (styleIndex == -1) {
                    this.writeRunProperties(pPrEl, cell, document);
                }
                Element rootEl = pEl;
                if (hypRefText != null) {
                    Element hyperlinkEl = document.createElement("w:hyperlink");
                    pEl.appendChild(hyperlinkEl);
                    if (hypRefId == -1) {
                        hyperlinkEl.setAttribute("w:anchor", hypRefText);
                    } else {
                        hyperlinkEl.setAttribute("r:id", String.format("hId%s", hypRefId));
                    }
                    rootEl = hyperlinkEl;
                }
                if (bkmRefId != -1) {
                    Element bookEl = document.createElement("w:bookmarkStart");
                    rootEl.appendChild(bookEl);
                    bookEl.setAttribute("w:id", bkmRefId.toString());
                    bookEl.setAttribute("w:name", bkmRefText);
                }
                if (!"".equals(textLine)) {
                    if (this.usePageHeadersAndFooters) {
                        textLine = textLine.replaceAll("#PageNumber#", "\u0001").replaceAll("#TotalPageCount#", "\u0002");
                        ArrayList<String> runList = new ArrayList<String>();
                        StringBuilder sbr = new StringBuilder();
                        for (char ch : textLine.toCharArray()) {
                            if (ch == '\u0001' || ch == '\u0002') {
                                if (sbr.length() > 0) {
                                    runList.add(sbr.toString());
                                }
                                runList.add(Character.toString(ch));
                                sbr = new StringBuilder();
                                continue;
                            }
                            sbr.append(ch);
                        }
                        if (sbr.length() > 0) {
                            runList.add(sbr.toString());
                        }
                        if (runList.size() == 0) {
                            runList.add(textLine);
                        }
                        for (int indexRun = 0; indexRun < runList.size(); ++indexRun) {
                            Element rEl2;
                            String run = (String)runList.get(indexRun);
                            if (run.length() > 0 && (run.charAt(0) == '\u0001' || run.charAt(0) == '\u0002')) {
                                rEl2 = document.createElement("w:r");
                                rootEl.appendChild(rEl2);
                                if (styleIndex == -1) {
                                    this.writeRunProperties(rEl2, cell, document);
                                }
                                Element fldEl = document.createElement("w:fldChar");
                                rEl2.appendChild(fldEl);
                                fldEl.setAttribute("w:fldCharType", "begin");
                                rEl2 = document.createElement("w:r");
                                rootEl.appendChild(rEl2);
                                this.writeRunProperties(rEl2, cell, document);
                                Element instrEl = document.createElement("w:instrText");
                                rEl2.appendChild(instrEl);
                                switch (run.charAt(0)) {
                                    case '\u0001': {
                                        instrEl.setTextContent("PAGE");
                                        break;
                                    }
                                    case '\u0002': {
                                        instrEl.setTextContent("NUMPAGES");
                                    }
                                }
                                rEl2 = document.createElement("w:r");
                                rootEl.appendChild(rEl2);
                                this.writeRunProperties(rEl2, cell, document);
                                Element fldCharEl = document.createElement("w:fldChar");
                                rEl2.appendChild(fldCharEl);
                                fldCharEl.setAttribute("w:fldCharType", "end");
                                continue;
                            }
                            rEl2 = document.createElement("w:r");
                            rootEl.appendChild(rEl2);
                            if (styleIndex == -1) {
                                this.writeRunProperties(rEl2, cell, document);
                            }
                            Element tEl = document.createElement("w:t");
                            rEl2.appendChild(tEl);
                            tEl.setAttribute("xml:space", "preserve");
                            tEl.setTextContent(run);
                        }
                    } else {
                        rEl = document.createElement("w:r");
                        rootEl.appendChild(rEl);
                        if (styleIndex == -1) {
                            this.writeRunProperties(rEl, cell, document);
                        }
                        Element tEl = document.createElement("w:t");
                        rEl.appendChild(tEl);
                        tEl.setAttribute("xml:space", "preserve");
                        tEl.setTextContent(textLine);
                    }
                }
                if (bkmRefId == -1) continue;
                bookmarkEl = document.createElement("w:bookmarkEnd");
                pEl.appendChild(bookmarkEl);
                bookmarkEl.setAttribute("w:id", bkmRefId.toString());
            }
        }
        if (cell.getComponent() instanceof StiRichText && !ExportOptions.Word2007.getRenderRichTextAsImage()) {
            StiRichText rich = (StiRichText)cell.getComponent();
            String rtfText = rich.unpackRTF();
            if (ExportOptions.Word2007.getAllowCorrectFontSize11Problem()) {
                rtfText = rtfText.replaceAll("\\fs22", "\\fs21");
            }
            this.embedsList.add(rtfText);
            if (hypRefText != null) {
                Element hyperEl = document.createElement("w:hyperlink");
                element.appendChild(hyperEl);
                if (hypRefId == -1) {
                    hyperEl.setAttribute("w:anchor", hypRefText);
                } else {
                    hyperEl.setAttribute("r:id", String.format("hId%s", hypRefId));
                }
                Element altEl = document.createElement("w:altChunk");
                hyperEl.appendChild(altEl);
                altEl.setAttribute("r:id", String.format("reId%s", this.embedsList.size()));
            } else {
                Element altEl = document.createElement("w:altChunk");
                element.appendChild(altEl);
                altEl.setAttribute("r:id", String.format("reId%s", this.embedsList.size()));
            }
        } else if (cell.getComponent() instanceof StiText && ((StiText)cell.getComponent()).getAllowHtmlTags() && !ExportOptions.Word2007.getRenderHtmlTagsAsImage()) {
            String st = StiRtfExportService.getRtfFileFromHtmlTags((StiText)cell.getComponent(), cell.getText());
            if (ExportOptions.Word2007.getAllowCorrectFontSize11Problem()) {
                st = st.replaceAll("\\\\fs22", "\\fs21");
            }
            this.embedsList.add(st);
            Element altEl = document.createElement("w:altChunk");
            element.appendChild(altEl);
            altEl.setAttribute("r:id", String.format("reId%s", this.embedsList.size()));
        } else if (cell.getComponent().isExportAsImage(StiExportFormat.Word2007) && (exportImage = (IStiExportImage)((Object)cell.getComponent())) != null && (image = exportImage.getImage(Double.valueOf(rsImageResolution = this.imageResolution))) != null) {
            BufferedImage img = this.matrix.getRealImageData(cell, image);
            needEmptyParagraph = false;
            int imageIndex = 0;
            imageIndex = img != null ? this.imageCache.addImageInt(img) : this.imageCache.addImageInt(image);
            int richWidth = -1;
            int richHeight = -1;
            Element pEl = document.createElement("w:p");
            element.appendChild(pEl);
            Element pPrEl = document.createElement("w:pPr");
            pEl.appendChild(pPrEl);
            StiTextHorAlignment horAlignment = cell.getCellStyle().getHorAlignment();
            boolean rightToLeft = false;
            if (cell.getCellStyle().getTextOptions() != null) {
                rightToLeft = cell.getCellStyle().getTextOptions().getRightToLeft();
            }
            if (!(cell.getComponent() instanceof IStiTextHorAlignment)) {
                IStiHorAlignment horAlignComp;
                IStiHorAlignment iStiHorAlignment = horAlignComp = cell.getComponent() instanceof IStiHorAlignment ? (IStiHorAlignment)((Object)cell.getComponent()) : null;
                if (horAlignComp != null) {
                    horAlignment = horAlignComp.getHorAlignment().toTextHorAlignment();
                }
            }
            String stHorAlignment = "";
            if (horAlignment == StiTextHorAlignment.Left && rightToLeft || horAlignment == StiTextHorAlignment.Right && !rightToLeft) {
                stHorAlignment = "right";
            }
            if (horAlignment == StiTextHorAlignment.Center) {
                stHorAlignment = "center";
            }
            if (horAlignment == StiTextHorAlignment.Width) {
                stHorAlignment = "both";
            }
            if (!"".equals(stHorAlignment)) {
                Element jcEl = document.createElement("w:jc");
                pPrEl.appendChild(jcEl);
                jcEl.setAttribute("w:val", stHorAlignment);
            }
            if (bkmRefId != -1) {
                bookmarkEl = document.createElement("w:bookmarkStart");
                pEl.appendChild(bookmarkEl);
                bookmarkEl.setAttribute("w:id", bkmRefId.toString());
                bookmarkEl.setAttribute("w:name", bkmRefText);
            }
            rEl = document.createElement("w:r");
            pEl.appendChild(rEl);
            Element rPrEl = document.createElement("w:rPr");
            rEl.appendChild(rPrEl);
            Element noProof = document.createElement("w:noProof");
            rPrEl.appendChild(noProof);
            Element drawingEl = document.createElement("w:drawing");
            rEl.appendChild(drawingEl);
            Element inlineEl = document.createElement("wp:inline");
            drawingEl.appendChild(inlineEl);
            inlineEl.setAttribute("distT", "0");
            inlineEl.setAttribute("distB", "0");
            inlineEl.setAttribute("distL", "0");
            inlineEl.setAttribute("distR", "0");
            int imageHeight = wordCoordY[indexRow - 1 + cell.getHeight() + 1] - wordCoordY[indexRow - 1];
            int imageWidth = wordCoordX[indexColumn - 1 + cell.getWidth() + 1] - wordCoordX[indexColumn - 1];
            if (richWidth != -1) {
                imageWidth = richWidth;
                imageHeight = richHeight;
            }
            Element extentEl = document.createElement("wp:extent");
            inlineEl.appendChild(extentEl);
            extentEl.setAttribute("cx", String.format("%s", this.convertTwipsToEmu(imageWidth)));
            extentEl.setAttribute("cy", String.format("%s", this.convertTwipsToEmu(imageHeight)));
            Element effectEl = document.createElement("wp:effectExtent");
            inlineEl.appendChild(effectEl);
            effectEl.setAttribute("l", "0");
            effectEl.setAttribute("t", "0");
            effectEl.setAttribute("r", "0");
            effectEl.setAttribute("b", "0");
            Element docEl = document.createElement("wp:docPr");
            inlineEl.appendChild(docEl);
            docEl.setAttribute("id", String.format("%s", imageIndex + 2));
            docEl.setAttribute("name", String.format("Picture %s", imageIndex + 1));
            docEl.setAttribute("descr", String.format("Image%05d.jpg", imageIndex + 1));
            if (hypRefText != null) {
                if (hypRefId == -1) {
                    hypRefText = "#" + hypRefText;
                    if (this.hyperlinkList.containsKey(hypRefText)) {
                        hypRefId = this.hyperlinkList.get(hypRefText);
                    } else {
                        hypRefId = this.hyperlinkList.size();
                        this.hyperlinkList.put(hypRefText, hypRefId);
                    }
                }
                Element hlinkEl = document.createElement("a:hlinkClick");
                docEl.appendChild(hlinkEl);
                hlinkEl.setAttribute("xmlns:a", "http://schemas.openxmlformats.org/drawingml/2006/main");
                hlinkEl.setAttribute("r:id", String.format("hId%s", hypRefId));
            }
            Element wpEl = document.createElement("wp:cNvGraphicFramePr");
            inlineEl.appendChild(wpEl);
            Element aEl = document.createElement("a:graphicFrameLocks");
            wpEl.appendChild(aEl);
            aEl.setAttribute("xmlns:a", "http://schemas.openxmlformats.org/drawingml/2006/main");
            aEl.setAttribute("noChangeAspect", "1");
            Element graphicEl = document.createElement("a:graphic");
            inlineEl.appendChild(graphicEl);
            graphicEl.setAttribute("xmlns:a", "http://schemas.openxmlformats.org/drawingml/2006/main");
            Element grDataEl = document.createElement("a:graphicData");
            graphicEl.appendChild(grDataEl);
            grDataEl.setAttribute("uri", "http://schemas.openxmlformats.org/drawingml/2006/picture");
            Element picEl = document.createElement("pic:pic");
            grDataEl.appendChild(picEl);
            picEl.setAttribute("xmlns:pic", "http://schemas.openxmlformats.org/drawingml/2006/picture");
            Element ncPicEl = document.createElement("pic:nvPicPr");
            picEl.appendChild(ncPicEl);
            Element cNvEl = document.createElement("pic:cNvPr");
            ncPicEl.appendChild(cNvEl);
            cNvEl.setAttribute("id", "0");
            cNvEl.setAttribute("name", String.format("Image%05d.jpg", imageIndex + 1));
            cNvEl = document.createElement("pic:cNvPicPr");
            ncPicEl.appendChild(cNvEl);
            Element blipEl = document.createElement("pic:blipFill");
            picEl.appendChild(blipEl);
            Element blip2El = document.createElement("a:blip");
            blipEl.appendChild(blip2El);
            blip2El.setAttribute("r:embed", String.format("rId%s", 5 + imageIndex));
            blip2El.setAttribute("cstate", "print");
            Element stretchEl = document.createElement("a:stretch");
            blipEl.appendChild(stretchEl);
            Element fillRectEl = document.createElement("a:fillRect");
            stretchEl.appendChild(fillRectEl);
            Element spPrEl = document.createElement("pic:spPr");
            picEl.appendChild(spPrEl);
            Element xfrmEl = document.createElement("a:xfrm");
            spPrEl.appendChild(xfrmEl);
            Element offEl = document.createElement("a:off");
            xfrmEl.appendChild(offEl);
            offEl.setAttribute("x", "0");
            offEl.setAttribute("y", "0");
            Element extEl = document.createElement("a:ext");
            xfrmEl.appendChild(extEl);
            extEl.setAttribute("cx", String.format("%s", this.convertTwipsToEmu(imageWidth)));
            extEl.setAttribute("cy", String.format("%s", this.convertTwipsToEmu(imageHeight)));
            Element prstEl = document.createElement("a:prstGeom");
            spPrEl.appendChild(prstEl);
            prstEl.setAttribute("prst", "rect");
            Element avLstEl = document.createElement("a:avLst");
            prstEl.appendChild(avLstEl);
            if (bkmRefId != -1) {
                Element bookEl = document.createElement("w:bookmarkEnd");
                pEl.appendChild(bookEl);
                bookEl.setAttribute("w:id", bkmRefId.toString());
            }
        }
        return needEmptyParagraph;
    }

    private void writeTableInfo(Element element, int[] wordCoordX, int maxCoordX, Document document) {
        Element tblPrEl = document.createElement("w:tblPr");
        element.appendChild(tblPrEl);
        Element tblStyleEl = document.createElement("w:tblStyle");
        tblPrEl.appendChild(tblStyleEl);
        tblStyleEl.setAttribute("w:val", "a1");
        Element tblWEl = document.createElement("w:tblW");
        tblPrEl.appendChild(tblWEl);
        tblWEl.setAttribute("w:w", "0");
        tblWEl.setAttribute("w:type", "dxa");
        Element tblLayoutEl = document.createElement("w:tblLayout");
        tblPrEl.appendChild(tblLayoutEl);
        tblLayoutEl.setAttribute("w:type", "fixed");
        Element tblCellMarEl = document.createElement("w:tblCellMar");
        tblPrEl.appendChild(tblCellMarEl);
        Element topEl = document.createElement("w:top");
        tblCellMarEl.appendChild(topEl);
        topEl.setAttribute("w:w", "0");
        topEl.setAttribute("w:type", "dxa");
        Element leftEl = document.createElement("w:left");
        tblCellMarEl.appendChild(leftEl);
        leftEl.setAttribute("w:w", "0");
        leftEl.setAttribute("w:type", "dxa");
        Element bottomEl = document.createElement("w:bottom");
        tblCellMarEl.appendChild(bottomEl);
        bottomEl.setAttribute("w:w", "0");
        bottomEl.setAttribute("w:type", "dxa");
        Element rightEl = document.createElement("w:right");
        tblCellMarEl.appendChild(rightEl);
        rightEl.setAttribute("w:w", "0");
        rightEl.setAttribute("w:type", "dxa");
        Element tblLookEl = document.createElement("w:tblLook");
        tblPrEl.appendChild(tblLookEl);
        tblLookEl.setAttribute("w:val", "04A0");
        Element tblGridEl = document.createElement("w:tblGrid");
        element.appendChild(tblGridEl);
        for (int indexColumn = 1; indexColumn < maxCoordX; ++indexColumn) {
            int columnWidth = wordCoordX[indexColumn] - wordCoordX[indexColumn - 1];
            Element gridColEl = document.createElement("w:gridCol");
            tblGridEl.appendChild(gridColEl);
            gridColEl.setAttribute("w:w", String.format("%s", columnWidth));
        }
    }

    private void writeRunProperties(Element element, StiCell cell, Document document) {
        Element rPrEl = document.createElement("w:rPr");
        element.appendChild(rPrEl);
        Element rFontsEl = document.createElement("w:rFonts");
        rPrEl.appendChild(rFontsEl);
        String fontName = cell.getCellStyle().getFont().getName();
        this.fontList.put(fontName, fontName);
        rFontsEl.setAttribute("w:ascii", fontName);
        rFontsEl.setAttribute("w:hAnsi", fontName);
        rFontsEl.setAttribute("w:eastAsia", fontName);
        rFontsEl.setAttribute("w:cs", fontName);
        if (cell.getCellStyle().getFont().bold()) {
            Element bEl = document.createElement("w:b");
            rPrEl.appendChild(bEl);
        }
        if (cell.getCellStyle().getFont().italic()) {
            Element iEl = document.createElement("w:i");
            rPrEl.appendChild(iEl);
        }
        if (cell.getCellStyle().getFont().underline()) {
            Element uEl = document.createElement("w:u");
            rPrEl.appendChild(uEl);
            uEl.setAttribute("w:val", "single");
        }
        Element colorEl = document.createElement("w:color");
        rPrEl.appendChild(colorEl);
        colorEl.setAttribute("w:val", this.getColorString(cell.getCellStyle().getTextColor()));
        Element szEl = document.createElement("w:sz");
        rPrEl.appendChild(szEl);
        szEl.setAttribute("w:val", String.format("%s", cell.getCellStyle().getFont().getSize() * 2.0));
        if (ExportOptions.Word2007.getSpaceBetweenCharacters() != 0) {
            Element spacingEl = document.createElement("w:spacing");
            rPrEl.appendChild(spacingEl);
            spacingEl.setAttribute("w:val", String.format("%s", ExportOptions.Word2007.getSpaceBetweenCharacters()));
        }
        if (cell.getCellStyle().getTextOptions() != null && cell.getCellStyle().getTextOptions().getRightToLeft()) {
            if (cell.getCellStyle().getFont().bold()) {
                Element bCsEl = document.createElement("w:bCs");
                rPrEl.appendChild(bCsEl);
            }
            if (cell.getCellStyle().getFont().italic()) {
                Element iCsEl = document.createElement("w:iCs");
                rPrEl.appendChild(iCsEl);
            }
            Element szCsEl = document.createElement("w:szCs");
            rPrEl.appendChild(szCsEl);
            szCsEl.setAttribute("w:val", String.format("%s", cell.getCellStyle().getFont().getSize() * 2.0));
            Element rt1El = document.createElement("w:rtl");
            rPrEl.appendChild(rt1El);
        }
    }

    private ReturnResult renderBorder2TableGetValues(int rowIndex, int columnIndex) {
        StiEnumSet sides = StiEnumSet.of((Enum)StiBorderSides.None);
        StringBuilder sb = new StringBuilder();
        if (this.matrix.getBordersY()[rowIndex - 1][columnIndex - 1] != null) {
            sides.add((IStiEnum)StiBorderSides.Left);
        }
        if (this.matrix.getBordersY()[rowIndex - 1][columnIndex - 1 + 1] != null) {
            sides.add((IStiEnum)StiBorderSides.Right);
        }
        if (this.matrix.getBordersX()[rowIndex - 1][columnIndex - 1] != null) {
            sb.append("\\t" + this.getLineStyle2TableGetValues(this.matrix.getBordersX()[rowIndex - 1][columnIndex - 1]));
            sides.add((IStiEnum)StiBorderSides.Top);
        }
        if (this.matrix.getBordersX()[rowIndex - 1 + 1][columnIndex - 1] != null) {
            sb.append("\\b" + this.getLineStyle2TableGetValues(this.matrix.getBordersX()[rowIndex - 1 + 1][columnIndex - 1]));
            sides.add((IStiEnum)StiBorderSides.Bottom);
        }
        return new ReturnResult((StiEnumSet<StiBorderSides>)sides, sb.toString());
    }

    private String getLineStyle2TableGetValues(StiBorderSide border) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLineStyle(border.getStyle()));
        sb.append((int)(border.getSize() * 15.0));
        sb.append(String.format("c%s", this.getColorString(border.getColor())));
        return sb.toString();
    }

    private Document writeDocument(StiPagesCollection pages, StiReport report, boolean outHeadersAndFooters) throws ParserConfigurationException, IOException, StiException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element documentEl = doc.createElement("w:document");
        doc.appendChild(documentEl);
        documentEl.setAttribute("xmlns:ve", "http://schemas.openxmlformats.org/markup-compatibility/2006");
        documentEl.setAttribute("xmlns:o", "urn:schemas-microsoft-com:office:office");
        documentEl.setAttribute("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        documentEl.setAttribute("xmlns:m", "http://schemas.openxmlformats.org/officeDocument/2006/math");
        documentEl.setAttribute("xmlns:v", "urn:schemas-microsoft-com:vml");
        documentEl.setAttribute("xmlns:wp", "http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing");
        documentEl.setAttribute("xmlns:w10", "urn:schemas-microsoft-com:office:word");
        documentEl.setAttribute("xmlns:w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
        documentEl.setAttribute("xmlns:wne", "http://schemas.microsoft.com/office/word/2006/wordml");
        Element bodyEl = doc.createElement("w:body");
        documentEl.appendChild(bodyEl);
        StiPagesCollection allPages = pages;
        pages = null;
        int indexPage = 0;
        int partIndex = 0;
        while (indexPage < allPages.size()) {
            pages = new StiPagesCollection(report);
            pages.setCacheMode(report.getRenderedPages().getCacheMode());
            pages.add((StiPage)allPages.get(indexPage));
            String sheetName = ((StiPage)allPages.get(indexPage)).getExcelSheetValue();
            while (indexPage < allPages.size() - 1 && this.compareExcellSheetNames(((StiPage)allPages.get(indexPage + 1)).getExcelSheetValue(), sheetName) && ((StiPage)allPages.get(indexPage + 1)).getOrientation() == ((StiPage)allPages.get(indexPage)).getOrientation()) {
                pages.add((StiPage)allPages.get(++indexPage));
            }
            StiPage firstPage = (StiPage)pages.get(0);
            if (firstPage != null) {
                pages.GetPage(firstPage);
                if (this.usePageHeadersAndFooters) {
                    StiPagesCollection pages2 = new StiPagesCollection(report);
                    pages2.setCacheMode(report.getRenderedPages().getCacheMode());
                    pages2.add((StiPage)pages.get(0));
                    this.matrix = new StiMatrix(pages2, ExportOptions.Word2007.isDivideBigCells(), this);
                    if (this.isStoped()) {
                        return null;
                    }
                    this.matrix.scanComponentsPlacement(false);
                    int startLine = 0;
                    int endLine = 0;
                    boolean needHeader = false;
                    for (endLine = this.matrix.getCoordY().size() - 1 - 1; endLine > 0 && this.matrix.getLinePlacement()[endLine] != StiMatrix.StiTableLineInfo.PageHeader; --endLine) {
                    }
                    if (endLine >= 0 && this.matrix.getLinePlacement()[endLine] == StiMatrix.StiTableLineInfo.PageHeader) {
                        startLine = 0;
                        while (this.matrix.getLinePlacement()[startLine] != StiMatrix.StiTableLineInfo.PageHeader) {
                            ++startLine;
                        }
                        needHeader = true;
                    }
                    this.headersData.add(this.writeHeader(startLine, endLine, needHeader));
                    if (this.imageCache.getImageStoreSize() > 0) {
                        this.headersRels.add(this.writeHeaderFooterRels());
                    } else {
                        Document docum = docBuilder.newDocument();
                        docum.setUserData(NULL_DOC_PREFIX, NULL_DOC_PREFIX, null);
                        this.headersRels.add(docum);
                    }
                    boolean needFooter = false;
                    for (startLine = 0; this.matrix.getLinePlacement()[startLine] != StiMatrix.StiTableLineInfo.PageFooter && startLine < this.matrix.getCoordY().size() - 1 - 1; ++startLine) {
                    }
                    if (this.matrix.getLinePlacement()[startLine] == StiMatrix.StiTableLineInfo.PageFooter) {
                        endLine = this.matrix.getCoordY().size() - 1 - 1;
                        while (this.matrix.getLinePlacement()[endLine] != StiMatrix.StiTableLineInfo.PageFooter) {
                            --endLine;
                        }
                        needFooter = true;
                    }
                    this.footersData.add(this.writeFooter(startLine, endLine, needFooter));
                    if (this.imageCache.getImageStoreSize() > 0) {
                        this.footersRels.add(this.writeHeaderFooterRels());
                    } else {
                        Document docum = docBuilder.newDocument();
                        docum.setUserData(NULL_DOC_PREFIX, NULL_DOC_PREFIX, null);
                        this.footersRels.add(docum);
                    }
                    this.matrix = new StiMatrix(pages, ExportOptions.Word2007.isDivideBigCells(), this);
                    this.matrix.scanComponentsPlacement(true);
                    endLine = this.matrix.getCoordY().size() - 1 - 1;
                    this.writeFromMatrix(bodyEl, 0, endLine, false, doc);
                } else {
                    this.matrix = new StiMatrix(pages, ExportOptions.Word2007.isDivideBigCells(), this);
                    if (this.isStoped()) {
                        return null;
                    }
                    this.writeFromMatrix(bodyEl, 0, this.matrix.getCoordY().size() - 1 - 1, true, doc);
                }
                if (indexPage < allPages.size() - 1) {
                    Element pEl = doc.createElement("w:p");
                    bodyEl.appendChild(pEl);
                    Element pPrEl = doc.createElement("w:pPr");
                    pEl.appendChild(pPrEl);
                    this.writePageInfo(pPrEl, (StiPage)pages.get(0), partIndex, doc);
                }
            }
            ++indexPage;
            ++partIndex;
        }
        if (pages.size() > 0) {
            this.writePageInfo(bodyEl, (StiPage)pages.get(0), partIndex - 1, doc);
        }
        return doc;
    }

    private boolean compareExcellSheetNames(String name1, String name2) {
        String st2;
        String st1 = name1;
        if (st1 == null || st1.length() == 0) {
            st1 = "";
        }
        if ((st2 = name2) == null || st2.length() == 0) {
            st2 = "";
        }
        return st1.equals(st2);
    }

    private void writePageInfo(Element element, StiPage page, int partIndex, Document document) {
        int pageHeight = this.convertHiToTwips(page.getUnit().ConvertToHInches(page.getPageHeight() * (double)page.getSegmentPerHeight()));
        int pageWidth = this.convertHiToTwips(page.getUnit().ConvertToHInches(page.getPageWidth() * (double)page.getSegmentPerWidth()));
        int mgLeft = this.convertHiToTwips(page.getUnit().ConvertToHInches(page.getMargins().getLeft()));
        int mgRight = this.convertHiToTwips(page.getUnit().ConvertToHInches(page.getMargins().getRight()));
        int mgTop = this.convertHiToTwips(page.getUnit().ConvertToHInches(page.getMargins().getTop()));
        int mgBottom = this.convertHiToTwips(page.getUnit().ConvertToHInches(page.getMargins().getBottom())) - ExportOptions.Word2007.getBottomMarginCorrection();
        if (mgBottom < 0) {
            mgBottom = 0;
        }
        if (pageWidth > 31500) {
            pageWidth = 31500;
        }
        if (pageHeight > 31500) {
            pageHeight = 31500;
        }
        Element sectPrEl = document.createElement("w:sectPr");
        element.appendChild(sectPrEl);
        if (this.usePageHeadersAndFooters) {
            Element headerEl = document.createElement("w:headerReference");
            sectPrEl.appendChild(headerEl);
            headerEl.setAttribute("w:type", "default");
            headerEl.setAttribute("r:id", String.format("rIdh%s", partIndex + 1));
            Element footerEl = document.createElement("w:footerReference");
            sectPrEl.appendChild(footerEl);
            footerEl.setAttribute("w:type", "default");
            footerEl.setAttribute("r:id", String.format("rIdf%s", partIndex + 1));
        } else if (!StiLicenseKeyValidator.isValidOnJavaFramework(null)) {
            Element headerReferenceEl = document.createElement("w:headerReference");
            sectPrEl.appendChild(headerReferenceEl);
            headerReferenceEl.setAttribute("w:type", "default");
            headerReferenceEl.setAttribute("r:id", "rIdh1");
        }
        Element pgSzEl = document.createElement("w:pgSz");
        sectPrEl.appendChild(pgSzEl);
        pgSzEl.setAttribute("w:w", String.format("%s", pageWidth));
        pgSzEl.setAttribute("w:h", String.format("%s", pageHeight));
        if (page.getOrientation() == StiPageOrientation.Landscape) {
            pgSzEl.setAttribute("w:orient", "landscape");
        }
        Element pgMarEl = document.createElement("w:pgMar");
        sectPrEl.appendChild(pgMarEl);
        pgMarEl.setAttribute("w:top", String.format("%s", mgTop));
        pgMarEl.setAttribute("w:right", String.format("%s", mgRight));
        pgMarEl.setAttribute("w:bottom", String.format("%s", mgBottom));
        pgMarEl.setAttribute("w:left", String.format("%s", mgLeft));
        pgMarEl.setAttribute("w:header", String.format("%s", mgTop));
        pgMarEl.setAttribute("w:footer", String.format("%s", mgBottom));
        pgMarEl.setAttribute("w:gutter", "0");
    }

    private void writeBorders(Element element, int indexRow, int indexColumn, int height, int width, Document document) {
        boolean needBorderLeft = true;
        boolean needBorderRight = true;
        for (int index = 0; index < height; ++index) {
            if (this.matrix.getBordersY()[indexRow + index][indexColumn] == null) {
                needBorderLeft = false;
            }
            if (this.matrix.getBordersY()[indexRow + index][indexColumn + width] != null) continue;
            needBorderRight = false;
        }
        boolean needBorderTop = true;
        boolean needBorderBottom = true;
        for (int index = 0; index < width; ++index) {
            if (this.matrix.getBordersX()[indexRow][indexColumn + index] == null) {
                needBorderTop = false;
            }
            if (this.matrix.getBordersX()[indexRow + height][indexColumn + index] != null) continue;
            needBorderBottom = false;
        }
        if (needBorderTop || needBorderLeft || needBorderBottom || needBorderRight) {
            Element tcBordersEl = document.createElement("w:tcBorders");
            element.appendChild(tcBordersEl);
            if (needBorderTop) {
                this.writeBorderData(tcBordersEl, "w:top", this.matrix.getBordersX()[indexRow][indexColumn], document);
            }
            if (needBorderLeft) {
                this.writeBorderData(tcBordersEl, "w:left", this.matrix.getBordersY()[indexRow][indexColumn], document);
            }
            if (needBorderBottom) {
                this.writeBorderData(tcBordersEl, "w:bottom", this.matrix.getBordersX()[indexRow + height][indexColumn], document);
            }
            if (needBorderRight) {
                this.writeBorderData(tcBordersEl, "w:right", this.matrix.getBordersY()[indexRow][indexColumn + width], document);
            }
        }
    }

    private void writeBorderData(Element element, String side, StiBorderSide border, Document document) {
        String style;
        if (border != null && !"".equals(style = this.getLineStyle(border.getStyle()))) {
            Element sideEl = document.createElement(side);
            element.appendChild(sideEl);
            sideEl.setAttribute("w:val", style);
            sideEl.setAttribute("w:sz", String.format("%s", (int)(border.getSize() * 5.0)));
            sideEl.setAttribute("w:space", "0");
            sideEl.setAttribute("w:color", this.getColorString(border.getColor()));
        }
    }

    private Document writeFootNotes() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element footnotesEl = doc.createElement("w:footnotes");
        doc.appendChild(footnotesEl);
        footnotesEl.setAttribute("xmlns:ve", "http://schemas.openxmlformats.org/markup-compatibility/2006");
        footnotesEl.setAttribute("xmlns:o", "urn:schemas-microsoft-com:office:office");
        footnotesEl.setAttribute("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        footnotesEl.setAttribute("xmlns:m", "http://schemas.openxmlformats.org/officeDocument/2006/math");
        footnotesEl.setAttribute("xmlns:v", "urn:schemas-microsoft-com:vml");
        footnotesEl.setAttribute("xmlns:wp", "http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing");
        footnotesEl.setAttribute("xmlns:w10", "urn:schemas-microsoft-com:office:word");
        footnotesEl.setAttribute("xmlns:w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
        footnotesEl.setAttribute("xmlns:wne", "http://schemas.microsoft.com/office/word/2006/wordml");
        Element footnoteEl = doc.createElement("w:footnote");
        footnotesEl.appendChild(footnoteEl);
        footnoteEl.setAttribute("w:type", "separator");
        footnoteEl.setAttribute("w:id", "0");
        Element pEl = doc.createElement("w:p");
        footnoteEl.appendChild(pEl);
        Element rEl = doc.createElement("w:r");
        pEl.appendChild(rEl);
        Element separatorEl = doc.createElement("w:separator");
        rEl.appendChild(separatorEl);
        footnoteEl = doc.createElement("w:footnote");
        footnotesEl.appendChild(footnoteEl);
        footnoteEl.setAttribute("w:type", "continuationSeparator");
        footnoteEl.setAttribute("w:id", "1");
        pEl = doc.createElement("w:p");
        footnoteEl.appendChild(pEl);
        rEl = doc.createElement("w:r");
        pEl.appendChild(rEl);
        separatorEl = doc.createElement("w:continuationSeparator");
        rEl.appendChild(separatorEl);
        return doc;
    }

    private Document writeEndNotes() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element endnotesEl = doc.createElement("w:endnotes");
        doc.appendChild(endnotesEl);
        endnotesEl.setAttribute("xmlns:ve", "http://schemas.openxmlformats.org/markup-compatibility/2006");
        endnotesEl.setAttribute("xmlns:o", "urn:schemas-microsoft-com:office:office");
        endnotesEl.setAttribute("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        endnotesEl.setAttribute("xmlns:m", "http://schemas.openxmlformats.org/officeDocument/2006/math");
        endnotesEl.setAttribute("xmlns:v", "urn:schemas-microsoft-com:vml");
        endnotesEl.setAttribute("xmlns:wp", "http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing");
        endnotesEl.setAttribute("xmlns:w10", "urn:schemas-microsoft-com:office:word");
        endnotesEl.setAttribute("xmlns:w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
        endnotesEl.setAttribute("xmlns:wne", "http://schemas.microsoft.com/office/word/2006/wordml");
        Element endnoteEl = doc.createElement("w:endnote");
        endnotesEl.appendChild(endnoteEl);
        endnoteEl.setAttribute("w:type", "separator");
        endnoteEl.setAttribute("w:id", "0");
        Element pEl = doc.createElement("w:p");
        endnoteEl.appendChild(pEl);
        Element rEl = doc.createElement("w:r");
        pEl.appendChild(rEl);
        Element separatorEl = doc.createElement("w:separator");
        rEl.appendChild(separatorEl);
        endnoteEl = doc.createElement("w:endnote");
        endnotesEl.appendChild(endnoteEl);
        endnoteEl.setAttribute("w:type", "continuationSeparator");
        endnoteEl.setAttribute("w:id", "1");
        pEl = doc.createElement("w:p");
        endnoteEl.appendChild(pEl);
        rEl = doc.createElement("w:r");
        pEl.appendChild(rEl);
        separatorEl = doc.createElement("w:continuationSeparator");
        rEl.appendChild(separatorEl);
        return doc;
    }

    private Document writeHeader(int startLine, int endLine, boolean needHeader) throws ParserConfigurationException, IOException, StiException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element hdrEl = doc.createElement("w:hdr");
        doc.appendChild(hdrEl);
        hdrEl.setAttribute("xmlns:ve", "http://schemas.openxmlformats.org/markup-compatibility/2006");
        hdrEl.setAttribute("xmlns:o", "urn:schemas-microsoft-com:office:office");
        hdrEl.setAttribute("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        hdrEl.setAttribute("xmlns:m", "http://schemas.openxmlformats.org/officeDocument/2006/math");
        hdrEl.setAttribute("xmlns:v", "urn:schemas-microsoft-com:vml");
        hdrEl.setAttribute("xmlns:wp", "http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing");
        hdrEl.setAttribute("xmlns:w10", "urn:schemas-microsoft-com:office:word");
        hdrEl.setAttribute("xmlns:w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
        hdrEl.setAttribute("xmlns:wne", "http://schemas.microsoft.com/office/word/2006/wordml");
        if (needHeader) {
            this.writeFromMatrix(hdrEl, startLine, endLine, true, doc);
        } else {
            Element pEl = doc.createElement("w:p");
            hdrEl.appendChild(pEl);
            Element rEl = doc.createElement("w:r");
            pEl.appendChild(rEl);
            Element crEl = doc.createElement("w:cr");
            rEl.appendChild(crEl);
        }
        return doc;
    }

    private Document writeFooter(int startLine, int endLine, boolean needFooter) throws ParserConfigurationException, IOException, StiException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element ftrEl = doc.createElement("w:ftr");
        doc.appendChild(ftrEl);
        ftrEl.setAttribute("xmlns:ve", "http://schemas.openxmlformats.org/markup-compatibility/2006");
        ftrEl.setAttribute("xmlns:o", "urn:schemas-microsoft-com:office:office");
        ftrEl.setAttribute("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        ftrEl.setAttribute("xmlns:m", "http://schemas.openxmlformats.org/officeDocument/2006/math");
        ftrEl.setAttribute("xmlns:v", "urn:schemas-microsoft-com:vml");
        ftrEl.setAttribute("xmlns:wp", "http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing");
        ftrEl.setAttribute("xmlns:w10", "urn:schemas-microsoft-com:office:word");
        ftrEl.setAttribute("xmlns:w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
        ftrEl.setAttribute("xmlns:wne", "http://schemas.microsoft.com/office/word/2006/wordml");
        if (needFooter) {
            this.writeFromMatrix(ftrEl, startLine, endLine, true, doc);
        } else {
            Element pEl = doc.createElement("w:p");
            ftrEl.appendChild(pEl);
            Element rEl = doc.createElement("w:r");
            pEl.appendChild(rEl);
            Element crEl = doc.createElement("w:cr");
            rEl.appendChild(crEl);
        }
        return doc;
    }

    private Document writeContentTypes() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element typesEl = doc.createElement("Types");
        doc.appendChild(typesEl);
        typesEl.setAttribute("xmlns", "http://schemas.openxmlformats.org/package/2006/content-types");
        Element defaultEl = doc.createElement("Default");
        typesEl.appendChild(defaultEl);
        defaultEl.setAttribute("Extension", "rels");
        defaultEl.setAttribute("ContentType", "application/vnd.openxmlformats-package.relationships+xml");
        defaultEl = doc.createElement("Default");
        typesEl.appendChild(defaultEl);
        defaultEl.setAttribute("Extension", "xml");
        defaultEl.setAttribute("ContentType", "application/xml");
        defaultEl = doc.createElement("Default");
        typesEl.appendChild(defaultEl);
        defaultEl.setAttribute("Extension", "jpeg");
        defaultEl.setAttribute("ContentType", "image/jpeg");
        defaultEl = doc.createElement("Default");
        typesEl.appendChild(defaultEl);
        defaultEl.setAttribute("Extension", "png");
        defaultEl.setAttribute("ContentType", "image/png");
        defaultEl = doc.createElement("Default");
        typesEl.appendChild(defaultEl);
        defaultEl.setAttribute("Extension", "emf");
        defaultEl.setAttribute("ContentType", "image/x-emf");
        defaultEl = doc.createElement("Default");
        typesEl.appendChild(defaultEl);
        defaultEl.setAttribute("Extension", "rtf");
        defaultEl.setAttribute("ContentType", "application/rtf");
        Element overrideEl = doc.createElement("Override");
        typesEl.appendChild(overrideEl);
        overrideEl.setAttribute("PartName", "/docProps/app.xml");
        overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.extended-properties+xml");
        overrideEl = doc.createElement("Override");
        typesEl.appendChild(overrideEl);
        overrideEl.setAttribute("PartName", "/docProps/core.xml");
        overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-package.core-properties+xml");
        overrideEl = doc.createElement("Override");
        typesEl.appendChild(overrideEl);
        overrideEl.setAttribute("PartName", "/word/document.xml");
        overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml");
        overrideEl = doc.createElement("Override");
        typesEl.appendChild(overrideEl);
        overrideEl.setAttribute("PartName", "/word/styles.xml");
        overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml");
        overrideEl = doc.createElement("Override");
        typesEl.appendChild(overrideEl);
        overrideEl.setAttribute("PartName", "/word/settings.xml");
        overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml");
        overrideEl = doc.createElement("Override");
        typesEl.appendChild(overrideEl);
        overrideEl.setAttribute("PartName", "/word/webSettings.xml");
        overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml");
        overrideEl = doc.createElement("Override");
        typesEl.appendChild(overrideEl);
        overrideEl.setAttribute("PartName", "/word/fontTable.xml");
        overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml");
        if (this.usePageHeadersAndFooters) {
            overrideEl = doc.createElement("Override");
            typesEl.appendChild(overrideEl);
            overrideEl.setAttribute("PartName", "/word/footnotes.xml");
            overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml");
            overrideEl = doc.createElement("Override");
            typesEl.appendChild(overrideEl);
            overrideEl.setAttribute("PartName", "/word/endnotes.xml");
            overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml");
            for (int index = 0; index < this.headersData.size(); ++index) {
                overrideEl = doc.createElement("Override");
                typesEl.appendChild(overrideEl);
                overrideEl.setAttribute("PartName", String.format("/word/footer%s.xml", index + 1));
                overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml");
                overrideEl = doc.createElement("Override");
                typesEl.appendChild(overrideEl);
                overrideEl.setAttribute("PartName", String.format("/word/header%s.xml", index + 1));
                overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.wordprocessingml.header+xml");
            }
        } else if (!StiLicenseKeyValidator.isValidOnJavaFramework(null)) {
            overrideEl = doc.createElement("Override");
            typesEl.appendChild(overrideEl);
            overrideEl.setAttribute("PartName", "/word/footnotes.xml");
            overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml");
            overrideEl = doc.createElement("Override");
            typesEl.appendChild(overrideEl);
            overrideEl.setAttribute("PartName", "/word/endnotes.xml");
            overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml");
            overrideEl = doc.createElement("Override");
            typesEl.appendChild(overrideEl);
            overrideEl.setAttribute("PartName", "/word/headerAdditional.xml");
            overrideEl.setAttribute("ContentType", "application/vnd.openxmlformats-officedocument.wordprocessingml.header+xml");
        }
        return doc;
    }

    private Document writeMainRels() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element relationshipsEl = doc.createElement("Relationships");
        doc.appendChild(relationshipsEl);
        relationshipsEl.setAttribute("xmlns", "http://schemas.openxmlformats.org/package/2006/relationships");
        Element relationshipEl = doc.createElement("Relationship");
        relationshipsEl.appendChild(relationshipEl);
        relationshipEl.setAttribute("Id", "rId1");
        relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        relationshipEl.setAttribute("Target", "word/document.xml");
        relationshipEl = doc.createElement("Relationship");
        relationshipsEl.appendChild(relationshipEl);
        relationshipEl.setAttribute("Id", "rId2");
        relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties");
        relationshipEl.setAttribute("Target", "docProps/core.xml");
        relationshipEl = doc.createElement("Relationship");
        relationshipsEl.appendChild(relationshipEl);
        relationshipEl.setAttribute("Id", "rId3");
        relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties");
        relationshipEl.setAttribute("Target", "docProps/app.xml");
        return doc;
    }

    private Document writeDocPropsApp() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element propertiesEl = doc.createElement("Properties");
        doc.appendChild(propertiesEl);
        propertiesEl.setAttribute("xmlns", "http://schemas.openxmlformats.org/officeDocument/2006/extended-properties");
        propertiesEl.setAttribute("xmlns:vt", "http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes");
        Element el = doc.createElement("Application");
        propertiesEl.appendChild(el);
        el.setTextContent("Microsoft Office Word");
        el = doc.createElement("Company");
        propertiesEl.appendChild(el);
        el.setTextContent(this.docCompanyString == null ? "" : this.docCompanyString);
        el = doc.createElement("Template");
        propertiesEl.appendChild(el);
        el.setTextContent("Normal.dotm");
        el = doc.createElement("TotalTime");
        propertiesEl.appendChild(el);
        el.setTextContent("0");
        el = doc.createElement("Pages");
        propertiesEl.appendChild(el);
        el.setTextContent("1");
        el = doc.createElement("Words");
        propertiesEl.appendChild(el);
        el.setTextContent("1");
        el = doc.createElement("Characters");
        propertiesEl.appendChild(el);
        el.setTextContent("1");
        el = doc.createElement("DocSecurity");
        propertiesEl.appendChild(el);
        el.setTextContent("0");
        el = doc.createElement("Lines");
        propertiesEl.appendChild(el);
        el.setTextContent("1");
        el = doc.createElement("Paragraphs");
        propertiesEl.appendChild(el);
        el.setTextContent("1");
        el = doc.createElement("ScaleCrop");
        propertiesEl.appendChild(el);
        el.setTextContent("false");
        el = doc.createElement("LinksUpToDate");
        propertiesEl.appendChild(el);
        el.setTextContent("false");
        el = doc.createElement("CharactersWithSpaces");
        propertiesEl.appendChild(el);
        el.setTextContent("1");
        el = doc.createElement("SharedDoc");
        propertiesEl.appendChild(el);
        el.setTextContent("false");
        el = doc.createElement("HyperlinksChanged");
        propertiesEl.appendChild(el);
        el.setTextContent("false");
        el = doc.createElement("AppVersion");
        propertiesEl.appendChild(el);
        el.setTextContent("12.0000");
        return doc;
    }

    private Document writeDocPropsCore() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element corePropertiesEl = doc.createElement("cp:coreProperties");
        doc.appendChild(corePropertiesEl);
        corePropertiesEl.setAttribute("xmlns:cp", "http://schemas.openxmlformats.org/package/2006/metadata/core-properties");
        corePropertiesEl.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        corePropertiesEl.setAttribute("xmlns:dcterms", "http://purl.org/dc/terms/");
        corePropertiesEl.setAttribute("xmlns:dcmitype", "http://purl.org/dc/dcmitype/");
        corePropertiesEl.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        String dateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH).format(new Date());
        Element el = doc.createElement("dc:title");
        corePropertiesEl.appendChild(el);
        el.setTextContent(this.report.getReportName() == null ? "" : this.report.getReportName());
        el = doc.createElement("dc:subject");
        corePropertiesEl.appendChild(el);
        el.setTextContent(this.report.getReportAlias() == null ? "" : this.report.getReportAlias());
        el = doc.createElement("dc:creator");
        corePropertiesEl.appendChild(el);
        el.setTextContent(this.report.getReportAuthor() == null ? "" : this.report.getReportAuthor());
        el = doc.createElement("cp:keywords");
        corePropertiesEl.appendChild(el);
        el.setTextContent("");
        el = doc.createElement("dc:description");
        corePropertiesEl.appendChild(el);
        el.setTextContent(this.report.getReportDescription() == null ? "" : this.report.getReportDescription());
        el = doc.createElement("cp:lastModifiedBy");
        corePropertiesEl.appendChild(el);
        el.setTextContent(this.docLastModifiedString == null ? "" : this.docLastModifiedString);
        el = doc.createElement("cp:revision");
        corePropertiesEl.appendChild(el);
        el.setTextContent("1");
        Element createedEl = doc.createElement("dcterms:created");
        corePropertiesEl.appendChild(createedEl);
        createedEl.setAttribute("xsi:type", "dcterms:W3CDTF");
        createedEl.setTextContent(dateTime);
        Element modifiedEl = doc.createElement("dcterms:modified");
        corePropertiesEl.appendChild(modifiedEl);
        modifiedEl.setAttribute("xsi:type", "dcterms:W3CDTF");
        modifiedEl.setTextContent(dateTime);
        return doc;
    }

    private Document writeSettings() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element settingsEl = doc.createElement("w:settings");
        doc.appendChild(settingsEl);
        settingsEl.setAttribute("xmlns:o", "urn:schemas-microsoft-com:office:office");
        settingsEl.setAttribute("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        settingsEl.setAttribute("xmlns:m", "http://schemas.openxmlformats.org/officeDocument/2006/math");
        settingsEl.setAttribute("xmlns:v", "urn:schemas-microsoft-com:vml");
        settingsEl.setAttribute("xmlns:w10", "urn:schemas-microsoft-com:office:word");
        settingsEl.setAttribute("xmlns:w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
        settingsEl.setAttribute("xmlns:sl", "http://schemas.openxmlformats.org/schemaLibrary/2006/main");
        Element zoomEl = doc.createElement("w:zoom");
        settingsEl.appendChild(zoomEl);
        zoomEl.setAttribute("w:percent", "100");
        Element proofStateEl = doc.createElement("w:proofState");
        settingsEl.appendChild(proofStateEl);
        proofStateEl.setAttribute("w:spelling", "clean");
        proofStateEl.setAttribute("w:grammar", "clean");
        Element defaultTabStopEl = doc.createElement("w:defaultTabStop");
        settingsEl.appendChild(defaultTabStopEl);
        defaultTabStopEl.setAttribute("w:val", "708");
        Element chracterEl = doc.createElement("w:characterSpacingControl");
        settingsEl.appendChild(chracterEl);
        chracterEl.setAttribute("w:val", "doNotCompress");
        if (this.usePageHeadersAndFooters) {
            Element footnotePrEl = doc.createElement("w:footnotePr");
            settingsEl.appendChild(footnotePrEl);
            Element footnoteEl = doc.createElement("w:footnote");
            footnotePrEl.appendChild(footnoteEl);
            footnoteEl.setAttribute("w:id", "0");
            footnoteEl = doc.createElement("w:footnote");
            footnotePrEl.appendChild(footnoteEl);
            footnoteEl.setAttribute("w:id", "1");
            Element endnotePrEl = doc.createElement("w:endnotePr");
            settingsEl.appendChild(endnotePrEl);
            Element endnoteEl = doc.createElement("w:endnote");
            endnotePrEl.appendChild(endnoteEl);
            endnoteEl.setAttribute("w:id", "0");
            endnoteEl = doc.createElement("w:endnote");
            endnotePrEl.appendChild(endnoteEl);
            endnoteEl.setAttribute("w:id", "1");
        }
        Element compatEl = doc.createElement("w:compat");
        settingsEl.appendChild(compatEl);
        Element mathPrEl = doc.createElement("m:mathPr");
        settingsEl.appendChild(mathPrEl);
        Element mathFontEl = doc.createElement("m:mathFont");
        mathPrEl.appendChild(mathFontEl);
        mathFontEl.setAttribute("m:val", "Cambria Math");
        Element brkBinEl = doc.createElement("m:brkBin");
        mathPrEl.appendChild(brkBinEl);
        brkBinEl.setAttribute("m:val", "before");
        Element brkBinSubEl = doc.createElement("m:brkBinSub");
        mathPrEl.appendChild(brkBinSubEl);
        brkBinSubEl.setAttribute("m:val", "--");
        Element smallFracEl = doc.createElement("m:smallFrac");
        mathPrEl.appendChild(smallFracEl);
        smallFracEl.setAttribute("m:val", "off");
        Element dispDefEl = doc.createElement("m:dispDef");
        mathPrEl.appendChild(dispDefEl);
        Element lMarginEl = doc.createElement("m:lMargin");
        mathPrEl.appendChild(lMarginEl);
        lMarginEl.setAttribute("m:val", "0");
        Element rMarginEl = doc.createElement("m:rMargin");
        mathPrEl.appendChild(rMarginEl);
        rMarginEl.setAttribute("m:val", "0");
        Element defJcEl = doc.createElement("m:defJc");
        mathPrEl.appendChild(defJcEl);
        defJcEl.setAttribute("m:val", "centerGroup");
        Element wrapIndentEl = doc.createElement("m:wrapIndent");
        mathPrEl.appendChild(wrapIndentEl);
        wrapIndentEl.setAttribute("m:val", "1440");
        Element intLimEl = doc.createElement("m:intLim");
        mathPrEl.appendChild(intLimEl);
        intLimEl.setAttribute("m:val", "subSup");
        Element naryLimEl = doc.createElement("m:naryLim");
        mathPrEl.appendChild(naryLimEl);
        naryLimEl.setAttribute("m:val", "undOvr");
        Element themeEl = doc.createElement("w:themeFontLang");
        settingsEl.appendChild(themeEl);
        themeEl.setAttribute("w:val", "en-EN");
        Element clrSchemeEl = doc.createElement("w:clrSchemeMapping");
        settingsEl.appendChild(clrSchemeEl);
        clrSchemeEl.setAttribute("w:bg1", "light1");
        clrSchemeEl.setAttribute("w:t1", "dark1");
        clrSchemeEl.setAttribute("w:bg2", "light2");
        clrSchemeEl.setAttribute("w:t2", "dark2");
        clrSchemeEl.setAttribute("w:accent1", "accent1");
        clrSchemeEl.setAttribute("w:accent2", "accent2");
        clrSchemeEl.setAttribute("w:accent3", "accent3");
        clrSchemeEl.setAttribute("w:accent4", "accent4");
        clrSchemeEl.setAttribute("w:accent5", "accent5");
        clrSchemeEl.setAttribute("w:accent6", "accent6");
        clrSchemeEl.setAttribute("w:hyperlink", "hyperlink");
        clrSchemeEl.setAttribute("w:followedHyperlink", "followedHyperlink");
        Element shapeDefaultsEl = doc.createElement("w:shapeDefaults");
        settingsEl.appendChild(shapeDefaultsEl);
        Element shapedefaultsEl = doc.createElement("o:shapedefaults");
        shapeDefaultsEl.appendChild(shapedefaultsEl);
        shapedefaultsEl.setAttribute("v:ext", "edit");
        shapedefaultsEl.setAttribute("spidmax", "2050");
        Element shapeLayoutEl = doc.createElement("o:shapelayout");
        shapeDefaultsEl.appendChild(shapeLayoutEl);
        shapeLayoutEl.setAttribute("v:ext", "edit");
        Element idmapEl = doc.createElement("o:idmap");
        shapeLayoutEl.appendChild(idmapEl);
        idmapEl.setAttribute("v:ext", "edit");
        idmapEl.setAttribute("data", "1");
        Element decimalEl = doc.createElement("w:decimalSymbol");
        settingsEl.appendChild(decimalEl);
        decimalEl.setAttribute("w:val", ",");
        Element listEl = doc.createElement("w:listSeparator");
        settingsEl.appendChild(listEl);
        listEl.setAttribute("w:val", ";");
        return doc;
    }

    private Document writeWebSettings() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element webSettingsEl = doc.createElement("w:webSettings");
        doc.appendChild(webSettingsEl);
        webSettingsEl.setAttribute("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        webSettingsEl.setAttribute("xmlns:w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
        Element optimizeEl = doc.createElement("w:optimizeForBrowser");
        webSettingsEl.appendChild(optimizeEl);
        return doc;
    }

    private Document writeFontTable() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element fontsEl = doc.createElement("w:fonts");
        doc.appendChild(fontsEl);
        fontsEl.setAttribute("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        fontsEl.setAttribute("xmlns:w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
        this.fontList.put("Calibri", "Calibri");
        this.fontList.put("Cambria", "Cambria");
        for (String fontName : this.fontList.values()) {
            Element fontEl = doc.createElement("w:font");
            fontsEl.appendChild(fontEl);
            fontEl.setAttribute("w:name", fontName);
        }
        return doc;
    }

    private Document writeDocumentRels() throws ParserConfigurationException {
        int index;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element relationshipsEl = doc.createElement("Relationships");
        doc.appendChild(relationshipsEl);
        relationshipsEl.setAttribute("xmlns", "http://schemas.openxmlformats.org/package/2006/relationships");
        Element relationshipEl = doc.createElement("Relationship");
        relationshipsEl.appendChild(relationshipEl);
        relationshipEl.setAttribute("Id", "rId1");
        relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles");
        relationshipEl.setAttribute("Target", "styles.xml");
        relationshipEl = doc.createElement("Relationship");
        relationshipsEl.appendChild(relationshipEl);
        relationshipEl.setAttribute("Id", "rId2");
        relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/settings");
        relationshipEl.setAttribute("Target", "settings.xml");
        relationshipEl = doc.createElement("Relationship");
        relationshipsEl.appendChild(relationshipEl);
        relationshipEl.setAttribute("Id", "rId3");
        relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/webSettings");
        relationshipEl.setAttribute("Target", "webSettings.xml");
        relationshipEl = doc.createElement("Relationship");
        relationshipsEl.appendChild(relationshipEl);
        relationshipEl.setAttribute("Id", "rId4");
        relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/fontTable");
        relationshipEl.setAttribute("Target", "fontTable.xml");
        for (index = 0; index < this.imageCache.getImageStoreSize(); ++index) {
            relationshipEl = doc.createElement("Relationship");
            relationshipsEl.appendChild(relationshipEl);
            relationshipEl.setAttribute("Id", String.format("rId%s", 5 + index));
            relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image");
            relationshipEl.setAttribute("Target", String.format("media/image%05d.jpeg", index + 1));
        }
        if (this.usePageHeadersAndFooters) {
            relationshipEl = doc.createElement("Relationship");
            relationshipsEl.appendChild(relationshipEl);
            relationshipEl.setAttribute("Id", String.format("rId%s", 5 + this.imageCache.getImageStoreSize() + 0));
            relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/footnotes");
            relationshipEl.setAttribute("Target", "footnotes.xml");
            relationshipEl = doc.createElement("Relationship");
            relationshipsEl.appendChild(relationshipEl);
            relationshipEl.setAttribute("Id", String.format("rId%s", 5 + this.imageCache.getImageStoreSize() + 1));
            relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/endnotes");
            relationshipEl.setAttribute("Target", "endnotes.xml");
            for (index = 0; index < this.headersData.size(); ++index) {
                relationshipEl = doc.createElement("Relationship");
                relationshipsEl.appendChild(relationshipEl);
                relationshipEl.setAttribute("Id", String.format("rIdh%s", index + 1));
                relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/header");
                relationshipEl.setAttribute("Target", String.format("header%s.xml", index + 1));
                relationshipEl = doc.createElement("Relationship");
                relationshipsEl.appendChild(relationshipEl);
                relationshipEl.setAttribute("Id", String.format("rIdf%s", index + 1));
                relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer");
                relationshipEl.setAttribute("Target", String.format("footer%s.xml", index + 1));
            }
        } else if (!StiLicenseKeyValidator.isValidOnJavaFramework(null)) {
            relationshipEl = doc.createElement("Relationship");
            relationshipsEl.appendChild(relationshipEl);
            relationshipEl.setAttribute("Id", String.format("rId%s", 5 + this.imageCache.getImageStoreSize() + 0));
            relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/footnotes");
            relationshipEl.setAttribute("Target", "footnotes.xml");
            relationshipEl = doc.createElement("Relationship");
            relationshipsEl.appendChild(relationshipEl);
            relationshipEl.setAttribute("Id", String.format("rId%s", 5 + this.imageCache.getImageStoreSize() + 1));
            relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/endnotes");
            relationshipEl.setAttribute("Target", "endnotes.xml");
            relationshipEl = doc.createElement("Relationship");
            relationshipsEl.appendChild(relationshipEl);
            relationshipEl.setAttribute("Id", "rIdh1");
            relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/header");
            relationshipEl.setAttribute("Target", "headerAdditional.xml");
        }
        if (this.hyperlinkList.size() > 0) {
            for (String key : this.hyperlinkList.keySet()) {
                relationshipEl = doc.createElement("Relationship");
                relationshipsEl.appendChild(relationshipEl);
                relationshipEl.setAttribute("Id", String.format("hId%s", (int)this.hyperlinkList.get(key)));
                relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink");
                relationshipEl.setAttribute("Target", key);
                relationshipEl.setAttribute("TargetMode", "External");
            }
        }
        if (this.embedsList.size() > 0) {
            for (int index2 = 0; index2 < this.embedsList.size(); ++index2) {
                relationshipEl = doc.createElement("Relationship");
                relationshipsEl.appendChild(relationshipEl);
                relationshipEl.setAttribute("Id", String.format("reId%s", 1 + index2));
                relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/aFChunk");
                relationshipEl.setAttribute("Target", String.format("embeddings/richtext%05d.rtf", index2 + 1));
                relationshipEl.setAttribute("TargetMode", "Internal");
            }
        }
        return doc;
    }

    private Document writeHeaderFooterRels() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element relationshipsEl = doc.createElement("Relationships");
        doc.appendChild(relationshipsEl);
        relationshipsEl.setAttribute("xmlns", "http://schemas.openxmlformats.org/package/2006/relationships");
        for (int index = 0; index < this.imageCache.getImageStoreSize(); ++index) {
            Element relationhipEl = doc.createElement("Relationship");
            relationshipsEl.appendChild(relationhipEl);
            relationhipEl.setAttribute("Id", String.format("rId%s", 5 + index));
            relationhipEl.setAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image");
            relationhipEl.setAttribute("Target", String.format("media/image%05d.jpeg", index + 1));
        }
        return doc;
    }

    private Document writeStyles() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element stylesEl = doc.createElement("w:styles");
        doc.appendChild(stylesEl);
        stylesEl.setAttribute("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        stylesEl.setAttribute("xmlns:w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
        Element styleEl = doc.createElement("w:style");
        stylesEl.appendChild(styleEl);
        styleEl.setAttribute("w:type", "paragraph");
        styleEl.setAttribute("w:default", "1");
        styleEl.setAttribute("w:styleId", "a");
        Element nameEl = doc.createElement("w:name");
        styleEl.appendChild(nameEl);
        nameEl.setAttribute("w:val", "Normal");
        Element formatEl = doc.createElement("w:qFormat");
        styleEl.appendChild(formatEl);
        Element pPrEl = doc.createElement("w:pPr");
        styleEl.appendChild(pPrEl);
        Element spacingEl = doc.createElement("w:spacing");
        pPrEl.appendChild(spacingEl);
        spacingEl.setAttribute("w:after", "0");
        spacingEl.setAttribute("w:line", "240");
        spacingEl.setAttribute("w:lineRule", "auto");
        Element rPrEl = doc.createElement("w:rPr");
        styleEl.appendChild(rPrEl);
        Element szEl = doc.createElement("w:sz");
        rPrEl.appendChild(szEl);
        szEl.setAttribute("w:val", String.format("%s", Math.round(ExportOptions.Word2007.getNormalStyleDefaultFontSize() * 2.0f)));
        styleEl = doc.createElement("w:style");
        stylesEl.appendChild(styleEl);
        styleEl.setAttribute("w:type", "character");
        styleEl.setAttribute("w:default", "1");
        styleEl.setAttribute("w:styleId", "a0");
        nameEl = doc.createElement("w:name");
        styleEl.appendChild(nameEl);
        nameEl.setAttribute("w:val", "Default Paragraph Font");
        Element uiPriorityEl = doc.createElement("w:uiPriority");
        styleEl.appendChild(uiPriorityEl);
        uiPriorityEl.setAttribute("w:val", "1");
        Element semiHiddenEl = doc.createElement("w:semiHidden");
        styleEl.appendChild(semiHiddenEl);
        Element unhideEl = doc.createElement("w:unhideWhenUsed");
        styleEl.appendChild(unhideEl);
        styleEl = doc.createElement("w:style");
        stylesEl.appendChild(styleEl);
        styleEl.setAttribute("w:type", "table");
        styleEl.setAttribute("w:default", "1");
        styleEl.setAttribute("w:styleId", "a1");
        nameEl = doc.createElement("w:name");
        styleEl.appendChild(nameEl);
        nameEl.setAttribute("w:val", "Normal Table");
        uiPriorityEl = doc.createElement("w:uiPriority");
        styleEl.appendChild(uiPriorityEl);
        uiPriorityEl.setAttribute("w:val", "99");
        semiHiddenEl = doc.createElement("w:semiHidden");
        styleEl.appendChild(semiHiddenEl);
        unhideEl = doc.createElement("w:unhideWhenUsed");
        styleEl.appendChild(unhideEl);
        Element qFormatEl = doc.createElement("w:qFormat");
        styleEl.appendChild(qFormatEl);
        Element tblPrEl = doc.createElement("w:tblPr");
        styleEl.appendChild(tblPrEl);
        Element tblIndEl = doc.createElement("w:tblInd");
        tblPrEl.appendChild(tblIndEl);
        tblIndEl.setAttribute("w:w", "0");
        tblIndEl.setAttribute("w:type", "dxa");
        Element tblCellMarEl = doc.createElement("w:tblCellMar");
        tblPrEl.appendChild(tblCellMarEl);
        Element topEl = doc.createElement("w:top");
        tblCellMarEl.appendChild(topEl);
        topEl.setAttribute("w:w", "0");
        topEl.setAttribute("w:type", "dxa");
        Element leftEl = doc.createElement("w:left");
        tblCellMarEl.appendChild(leftEl);
        leftEl.setAttribute("w:w", "0");
        leftEl.setAttribute("w:type", "dxa");
        Element bottomEl = doc.createElement("w:bottom");
        tblCellMarEl.appendChild(bottomEl);
        bottomEl.setAttribute("w:w", "0");
        bottomEl.setAttribute("w:type", "dxa");
        Element rightEl = doc.createElement("w:right");
        tblCellMarEl.appendChild(rightEl);
        rightEl.setAttribute("w:w", "0");
        rightEl.setAttribute("w:type", "dxa");
        styleEl = doc.createElement("w:style");
        stylesEl.appendChild(styleEl);
        styleEl.setAttribute("w:type", "numbering");
        styleEl.setAttribute("w:default", "1");
        styleEl.setAttribute("w:styleId", "a2");
        nameEl = doc.createElement("w:name");
        styleEl.appendChild(nameEl);
        nameEl.setAttribute("w:val", "No List");
        uiPriorityEl = doc.createElement("w:uiPriority");
        styleEl.appendChild(uiPriorityEl);
        uiPriorityEl.setAttribute("w:val", "99");
        semiHiddenEl = doc.createElement("w:semiHidden");
        styleEl.appendChild(semiHiddenEl);
        unhideEl = doc.createElement("w:unhideWhenUsed");
        styleEl.appendChild(unhideEl);
        for (int index = 0; index < this.styleList.size(); ++index) {
            StiWord2007StyleInfo style = this.styleList.get(index);
            styleEl = doc.createElement("w:style");
            stylesEl.appendChild(styleEl);
            styleEl.setAttribute("w:type", "paragraph");
            styleEl.setAttribute("w:customStyle", "1");
            styleEl.setAttribute("w:styleId", String.format("Style%s", index));
            nameEl = doc.createElement("w:name");
            styleEl.appendChild(nameEl);
            nameEl.setAttribute("w:val", style.Name);
            Element baseOnEl = doc.createElement("w:basedOn");
            styleEl.appendChild(baseOnEl);
            baseOnEl.setAttribute("w:val", "a");
            rPrEl = doc.createElement("w:rPr");
            styleEl.appendChild(rPrEl);
            Element rFontsEl = doc.createElement("w:rFonts");
            rPrEl.appendChild(rFontsEl);
            rFontsEl.setAttribute("w:ascii", style.FontName);
            rFontsEl.setAttribute("w:hAnsi", style.FontName);
            rFontsEl.setAttribute("w:cs", style.FontName);
            if (style.Bold) {
                Element bEl = doc.createElement("w:b");
                rPrEl.appendChild(bEl);
            }
            if (style.Italic) {
                Element iEl = doc.createElement("w:i");
                rPrEl.appendChild(iEl);
            }
            if (style.Underline) {
                Element uEl = doc.createElement("w:u");
                rPrEl.appendChild(uEl);
                uEl.setAttribute("w:val", "single");
            }
            Element colorEl = doc.createElement("w:color");
            rPrEl.appendChild(colorEl);
            colorEl.setAttribute("w:val", this.getColorString(style.TextColor));
            szEl = doc.createElement("w:sz");
            rPrEl.appendChild(szEl);
            szEl.setAttribute("w:val", String.format("%s", style.FontSize));
            if (ExportOptions.Word2007.getSpaceBetweenCharacters() != 0) {
                spacingEl = doc.createElement("w:spacing");
                rPrEl.appendChild(spacingEl);
                spacingEl.setAttribute("w:val", String.format("%s", ExportOptions.Word2007.getSpaceBetweenCharacters()));
            }
            if (!style.RightToLeft) continue;
            if (style.Bold) {
                Element bCsEl = doc.createElement("w:bCs");
                rPrEl.appendChild(bCsEl);
            }
            if (style.Italic) {
                Element iCsEl = doc.createElement("w:iCs");
                rPrEl.appendChild(iCsEl);
            }
            Element szCsEl = doc.createElement("w:szCs");
            rPrEl.appendChild(szCsEl);
            szCsEl.setAttribute("w:val", String.format("%s", style.FontSize));
            Element rtlEl = doc.createElement("w:rtl");
            rPrEl.appendChild(rtlEl);
        }
        return doc;
    }

    private byte[] writeImage(int index) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StiImageHelper.saveWithDPI(this.imageCache.getImageByIndex(index), out, StiImageFormat.Jpeg, (Integer)72, this.imageQuality);
        byte[] bytes = out.toByteArray();
        out.close();
        return bytes;
    }

    private byte[] writeEmbed(int number) throws UnsupportedEncodingException {
        String st = this.embedsList.get(number);
        StringBuilder sb = new StringBuilder();
        if (st != null && st.length() > 0) {
            Charset enc = StiCharsetHelper.UTF8;
            try {
                int posCpg = st.indexOf("\\ansicpg");
                if (posCpg > 0) {
                    int posEnd;
                    for (posEnd = posCpg += 8; posEnd < st.length() && Character.isDigit(st.charAt(posEnd)); ++posEnd) {
                    }
                    String codeSt = st.substring(posCpg, posEnd);
                    int codePage = 0;
                    codePage = Integer.parseInt(codeSt);
                    if (codePage != 0) {
                        enc = StiCharsetHelper.findCharset((String)String.valueOf(codePage));
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            byte[] buf = st.getBytes(enc.name());
            return buf;
        }
        return new byte[0];
    }

    private byte[] writeAdditionalData(String st, boolean base64) throws UnsupportedEncodingException {
        if (base64) {
            return StiBase64DecoderUtil.decode((String)st);
        }
        return st.getBytes("US-ASCII");
    }

    @Override
    public void export(StiReport report, OutputStream outputStream, StiExportSettings exportSettings) throws StiException {
        this.exportWord(report, outputStream, (StiWord2007ExportSettings)exportSettings);
    }

    public void exportWord(StiReport report, OutputStream outputStream, StiWord2007ExportSettings settings) throws StiException {
        try {
            this.exportWordException(report, outputStream, settings);
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportWordException(StiReport report, OutputStream outputStream, StiWord2007ExportSettings settings) throws IOException, ParserConfigurationException, StiException, TransformerException {
        if (settings == null) {
            throw new IllegalArgumentException("The 'settings' argument cannot be equal in null.");
        }
        StiPagesRange pageRange = settings.getPageRange();
        this.usePageHeadersAndFooters = settings.isUsePageHeadersAndFooters();
        this.removeEmptySpaceAtBottom = settings.isRemoveEmptySpaceAtBottom();
        this.imageResolution = settings.getImageResolution();
        this.imageQuality = settings.getImageQuality();
        this.docCompanyString = settings.getCompanyString();
        this.docLastModifiedString = settings.getLastModifiedString();
        if (this.imageQuality < 0.0f) {
            this.imageQuality = 0.0f;
        }
        if (this.imageQuality > 1.0f) {
            this.imageQuality = 1.0f;
        }
        if (this.imageResolution < 10.0f) {
            this.imageResolution = 10.0f;
        }
        this.imageResolution /= 100.0f;
        if (ExportOptions.Word2007.getLineSpacing() != 1.0) {
            this.lineSpace = String.valueOf((int)Math.round(ExportOptions.Word2007.getLineSpacing() * 240.0));
        }
        this.report = report;
        try {
            int index;
            this.styleList = new ArrayList();
            this.fontList = new Hashtable();
            this.imageCache = new StiImageCache(ExportOptions.Word2007.getAllowImageComparer(), StiImageFormat.Jpeg, this.imageQuality);
            this.bookmarkList = new Hashtable();
            this.hyperlinkList = new Hashtable();
            this.embedsList = new ArrayList();
            StiPagesCollection pages = pageRange.getSelectedPages(report.getRenderedPages());
            if (ExportOptions.Word2007.getDivideSegmentPages()) {
                pages = StiSegmentPagesDivider.divide(pages, this);
            }
            if (this.isStoped()) {
                return;
            }
            this.setStatusString(StiLocalization.getValue((String)"Export", (String)"ExportingCreatingDocument"));
            StiZipWriter20 zip = new StiZipWriter20(outputStream);
            if (this.usePageHeadersAndFooters) {
                this.headersData = new ArrayList();
                this.headersRels = new ArrayList();
                this.footersData = new ArrayList();
                this.footersRels = new ArrayList();
            }
            zip.addFile("word/", "document.xml", this.writeDocument(pages, report, this.usePageHeadersAndFooters));
            if (this.isStoped()) {
                return;
            }
            if (this.usePageHeadersAndFooters) {
                for (index = 0; index < this.headersData.size(); ++index) {
                    zip.addFile("word/", String.format("header%s.xml", index + 1), this.headersData.get(index));
                    if (this.headersRels.size() > index && this.headersRels.get(index).getUserData(NULL_DOC_PREFIX) == null) {
                        zip.addFile("word/_rels/", String.format("header%s.xml.rels", index + 1), this.headersRels.get(index));
                    }
                    zip.addFile("word/", String.format("footer%s.xml", index + 1), this.footersData.get(index));
                    if (this.footersRels.size() <= index || this.footersRels.get(index).getUserData(NULL_DOC_PREFIX) != null) continue;
                    zip.addFile("word/_rels/", String.format("footer%s.xml.rels", index + 1), this.footersRels.get(index));
                }
            }
            if (this.usePageHeadersAndFooters) {
                zip.addFile("word/", "footnotes.xml", this.writeFootNotes());
                zip.addFile("word/", "endnotes.xml", this.writeEndNotes());
            }
            zip.addFile("", "[Content_Types].xml", this.writeContentTypes());
            zip.addFile("_rels/", ".rels", this.writeMainRels());
            zip.addFile("docProps/", "app.xml", this.writeDocPropsApp());
            zip.addFile("docProps/", "core.xml", this.writeDocPropsCore());
            zip.addFile("word/", "settings.xml", this.writeSettings());
            zip.addFile("word/", "webSettings.xml", this.writeWebSettings());
            zip.addFile("word/", "fontTable.xml", this.writeFontTable());
            zip.addFile("word/_rels/", "document.xml.rels", this.writeDocumentRels());
            zip.addFile("word/", "styles.xml", this.writeStyles());
            if (this.imageCache.getImageStoreSize() > 0) {
                for (index = 0; index < this.imageCache.getImageStoreSize(); ++index) {
                    zip.addFile("word/media/", String.format("image%05d.jpeg", index + 1), this.writeImage(index));
                }
            }
            if (this.embedsList.size() > 0) {
                for (index = 0; index < this.embedsList.size(); ++index) {
                    zip.addFile("word/embeddings/", String.format("richtext%05d.rtf", index + 1), this.writeEmbed(index));
                }
            }
            if (!this.usePageHeadersAndFooters && !StiLicenseKeyValidator.isValidOnJavaFramework(null)) {
                zip.addFile("word/", "footnotes.xml", this.writeFootNotes());
                zip.addFile("word/", "endnotes.xml", this.writeEndNotes());
                zip.addFile("word/media/", "imageAdditional.png", this.writeAdditionalData(StiExportUtils.AdditionalData, true));
                zip.addFile("word/", "headerAdditional.xml", this.writeAdditionalData("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\r\n<w:hdr xmlns:ve=\"http://schemas.openxmlformats.org/markup-compatibility/2006\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:m=\"http://schemas.openxmlformats.org/officeDocument/2006/math\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" xmlns:w10=\"urn:schemas-microsoft-com:office:word\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:wne=\"http://schemas.microsoft.com/office/word/2006/wordml\"><w:p><w:pPr><w:pStyle w:val=\"a3\"/></w:pPr><w:r><w:rPr><w:noProof/><w:lang w:eastAsia=\"ru-RU\"/></w:rPr><w:pict><v:shapetype id=\"_x0000_t75\" coordsize=\"21600,21600\" o:spt=\"75\" o:preferrelative=\"t\" path=\"m@4@5l@4@11@9@11@9@5xe\" filled=\"f\" stroked=\"f\"> <v:stroke joinstyle=\"miter\"/> <v:formulas><v:f eqn=\"if lineDrawn pixelLineWidth 0\"/><v:f eqn=\"sum @0 1 0\"/><v:f eqn=\"sum 0 0 @1\"/><v:f eqn=\"prod @2 1 2\"/><v:f eqn=\"prod @3 21600 pixelWidth\"/><v:f eqn=\"prod @3 21600 pixelHeight\"/><v:f eqn=\"sum @0 0 1\"/><v:f eqn=\"prod @6 1 2\"/><v:f eqn=\"prod @7 21600 pixelWidth\"/><v:f eqn=\"sum @8 21600 0\"/><v:f eqn=\"prod @7 21600 pixelHeight\"/><v:f eqn=\"sum @10 21600 0\"/></v:formulas><v:path o:extrusionok=\"f\" gradientshapeok=\"t\" o:connecttype=\"rect\"/><o:lock v:ext=\"edit\" aspectratio=\"t\"/></v:shapetype><v:shape id=\"WordPictureWatermark11777093\" o:spid=\"_x0000_s2050\" type=\"#_x0000_t75\" style=\"position:absolute;margin-left:0;margin-top:0;width:467.45pt;height:381pt;z-index:-251657216;mso-position-horizontal:center;mso-position-horizontal-relative:margin;mso-position-vertical:center;mso-position-vertical-relative:margin\" o:allowincell=\"f\"><v:imagedata r:id=\"rId1\" o:title=\"additional\"/></v:shape></w:pict></w:r></w:p></w:hdr>", false));
                zip.addFile("word/_rels/", "headerAdditional.xml.rels", this.writeAdditionalData("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\r\n<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\"><Relationship Id=\"rId1\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/image\" Target=\"media/imageAdditional.png\" /></Relationships>", false));
            }
            zip.finish();
        }
        finally {
            if (this.matrix != null) {
                this.matrix.clear();
                this.matrix = null;
            }
            this.fontList.clear();
            this.fontList = null;
            this.imageCache.clear();
            this.imageCache = null;
            this.styleList.clear();
            this.styleList = null;
            this.bookmarkList.clear();
            this.bookmarkList = null;
            this.hyperlinkList.clear();
            this.hyperlinkList = null;
            this.embedsList.clear();
            this.embedsList = null;
            if (this.usePageHeadersAndFooters) {
                this.headersData.clear();
                this.headersData = null;
                this.headersRels.clear();
                this.headersRels = null;
                this.footersData.clear();
                this.footersData = null;
                this.footersRels.clear();
                this.footersRels = null;
            }
        }
        this.closeProgress();
    }

    public boolean isRemoveEmptySpaceAtBottom() {
        return this.removeEmptySpaceAtBottom;
    }

    @Override
    public StiExportFormat getExportFormat() {
        return StiExportFormat.Word2007;
    }

    @Override
    public boolean getMultipleFiles() {
        return false;
    }

    private class ReturnResult {
        public StiEnumSet<StiBorderSides> borderSides;
        public String stringResult;

        public ReturnResult(StiEnumSet<StiBorderSides> borderSides, String stringResult) {
            this.borderSides = borderSides;
            this.stringResult = stringResult;
        }
    }

    private class StiWord2007StyleInfo {
        public String Name;
        public StiTextHorAlignment Alignment;
        public boolean RightToLeft;
        public String FontName;
        public int FontSize;
        public boolean Bold;
        public boolean Italic;
        public boolean Underline;
        public StiColor TextColor;

        private StiWord2007StyleInfo() {
        }
    }
}

