/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.tools;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.drawing.StiAdvancedBorder;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBorderSide;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.StiTextOptions;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiFontStyle;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiRtfHelper;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiBandInteraction;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiTextQuality;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiFont;
import com.stimulsoft.report.components.interfaces.IStiText;
import com.stimulsoft.report.components.interfaces.IStiTextBrush;
import com.stimulsoft.report.components.interfaces.IStiTextHorAlignment;
import com.stimulsoft.report.components.interfaces.IStiTextOptions;
import com.stimulsoft.report.components.interfaces.IStiVertAlignment;
import com.stimulsoft.report.components.simplecomponents.StiCheckBox;
import com.stimulsoft.report.components.simplecomponents.StiHorizontalLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiPointPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiRectanglePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.components.simplecomponents.StiShape;
import com.stimulsoft.report.components.simplecomponents.StiSimpleText;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.components.simplecomponents.StiVerticalLinePrimitive;
import com.stimulsoft.report.crossTab.StiCrossColumnTotal;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.service.StiExcel2007ExportService;
import com.stimulsoft.report.export.service.StiExcelExportService;
import com.stimulsoft.report.export.service.StiExcelXmlExportService;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.service.StiHtmlExportService;
import com.stimulsoft.report.export.service.StiRtfExportService;
import com.stimulsoft.report.export.service.StiWord2007ExportService;
import com.stimulsoft.report.export.tools.StiCell;
import com.stimulsoft.report.export.tools.StiCellStyle;
import com.stimulsoft.report.export.tools.StiDataExportMode;
import com.stimulsoft.report.export.tools.StiExportDataType;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiMapUtil;
import com.stimulsoft.report.export.tools.StiTextRenderer;
import com.stimulsoft.report.options.ExportOptions;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class StiMatrix {
    private StiCell[][] cells;
    private StiCell[][] cellsMap;
    private double totalHeight = 0.0;
    private double totalWidth = 0.0;
    private ArrayList<StiCellStyle> styles = new ArrayList();
    private SortedMap<Double, Double> coordX = new TreeMap<Double, Double>();
    private SortedMap<Double, Double> coordY = new TreeMap<Double, Double>();
    private StiTableLineInfo[] linePlacement;
    private String[] parentBandName;
    private StiBorderSide[][] bordersX;
    private StiBorderSide[][] bordersY;
    private ArrayList<Integer> horizontalPageBreaks = new ArrayList();
    private StiCellStyle[][] cellStyles;
    private String[][] bookmarks;
    private final float maxRowHeight = 200.0f;
    private double defaultLinePrimitiveWidth = 0.0;
    private final int _defaultLinePrimitiveWidth = 1;
    private boolean[] coordXCheck;
    private boolean[] coordYCheck;
    private int[] coordXNew;
    private int[] coordYNew;
    private int[] coordXPrim;
    private int[] coordYPrim;
    private Hashtable<StiComponent, StiRectangle> imagesBaseRect = new Hashtable();
    private StiExportFormat exportFormat = StiExportFormat.Excel;
    private boolean isHtmlService = false;
    private boolean isHtmlPngMode = false;
    private Hashtable<Double, Integer> leftCached = new Hashtable();
    private Hashtable<Double, Integer> topCached = new Hashtable();
    private ArrayList<StiCell> createdCells = new ArrayList();
    private DataField[] fields = null;
    public int DataArrayLength = 0;
    private ArrayList<DataField> fieldsList = new ArrayList();
    private int sizeX = 0;
    private int sizeY = 0;
    private Hashtable<String, Integer> htName = new Hashtable();
    private List<StiBorderSide> borderSides = new ArrayList<StiBorderSide>();
    private StiReport report = null;
    private boolean addComponentWithInteractions = false;
    public int[][][] interactions;
    private double maxCoordY = 0.0;
    private final double htmlScaleX = 0.96;
    private final double htmlScaleY = 0.956;
    private boolean isHtmlOrExcelXmlService = false;

    public StiMatrix(StiPagesCollection pages, StiExportService service) {
        this(pages, false, service, null);
    }

    public StiMatrix(StiPagesCollection pages, boolean checkForExcel, StiExportService service) {
        this(pages, checkForExcel, service, null);
    }

    public StiMatrix(StiPagesCollection pages, StiExportService service, ArrayList<StiCellStyle> styles) {
        this(pages, false, service, styles);
    }

    public StiMatrix(StiPagesCollection pages, boolean checkForExcel, StiExportService service, ArrayList<StiCellStyle> styles) {
        StiRectangle rect;
        StiContainer borderComponent;
        this.report = pages.getReport();
        this.exportFormat = service.getExportFormat();
        boolean exportData = this.exportFormat == StiExportFormat.Dbf || this.exportFormat == StiExportFormat.Csv || this.exportFormat == StiExportFormat.Xml;
        this.isHtmlService = service instanceof StiHtmlExportService;
        this.isHtmlOrExcelXmlService = this.isHtmlService || service instanceof StiExcelXmlExportService;
        boolean bl = this.isHtmlPngMode = service instanceof StiHtmlExportService && ((StiHtmlExportService)service).getImageFormat() == StiImageFormat.Png;
        if (service instanceof StiHtmlExportService) {
            this.addComponentWithInteractions = ((StiHtmlExportService)service).isInsertInteractionParameters();
        }
        int tempStylesCount = -1;
        if (styles != null) {
            this.styles = styles;
            tempStylesCount = styles.size();
        }
        Double[] totalHeightPage = new Double[pages.size() + 1];
        Double[] totalHeightPage2 = new Double[pages.size() + 1];
        int totalHeightPageCounter = 0;
        double totalHeight2 = 0.0;
        this.defaultLinePrimitiveWidth = 1.0 / (this.isHtmlService && ExportOptions.Html.isPrintLayoutOptimization() ? 0.956 : 1.0);
        service.setStatusString(StiLocalization.getValue((String)"Export", (String)"ExportingCalculatingCoordinates"));
        boolean removeEmptySpaceAtBottom = true;
        if (service instanceof StiRtfExportService) {
            removeEmptySpaceAtBottom = ((StiRtfExportService)service).getRemoveEmptySpaceAtBottom();
        }
        if (service instanceof StiWord2007ExportService) {
            removeEmptySpaceAtBottom = ((StiWord2007ExportService)service).isRemoveEmptySpaceAtBottom();
        }
        if (service instanceof StiExcel2007ExportService) {
            removeEmptySpaceAtBottom = ExportOptions.Excel2007.getRemoveEmptySpaceAtBottom();
        }
        if (service instanceof StiExcelExportService) {
            removeEmptySpaceAtBottom = ExportOptions.Excel.getRemoveEmptySpaceAtBottom();
        }
        if (service instanceof StiHtmlExportService) {
            removeEmptySpaceAtBottom = ((StiHtmlExportService)service).isRemoveEmptySpaceAtBottom();
        }
        int pageIndex = 0;
        int maxLinesCount = 0;
        for (StiPage page : pages) {
            service.invokeExporting(page, pages);
            if (service.isStoped()) {
                return;
            }
            int lastLinesCount = this.coordY.size();
            totalHeightPage[totalHeightPageCounter] = this.totalHeight;
            totalHeightPage2[totalHeightPageCounter] = totalHeight2;
            ++totalHeightPageCounter;
            StiRectangle pageRect = page.getUnit().ConvertToHInches(page.getClientRectangle());
            if (page.getBorder() != null && !page.getBorder().getSide().containsOnly((IStiEnum)StiBorderSides.None)) {
                borderComponent = new StiContainer();
                borderComponent.setDisplayRectangle(page.getClientRectangle());
                this.addCoord(page.getUnit().ConvertToHInches(borderComponent.getDisplayRectangle()));
            }
            if (removeEmptySpaceAtBottom || pageIndex == pages.size() - 1 && !(service instanceof StiHtmlExportService)) {
                pageRect.setHeight(0.0);
            }
            this.addCoord(pageRect);
            pageRect = page.getUnit().ConvertToHInches(page.getClientRectangle());
            for (StiComponent component : page.getComponents()) {
                if (!component.getEnabled()) continue;
                rect = page.getUnit().ConvertToHInches(component.getDisplayRectangle());
                if (rect.getHeight() < 0.0) {
                    rect.setY(rect.getY() + rect.getHeight());
                    rect.setHeight(Math.abs(rect.getHeight()));
                }
                boolean needAdd = true;
                if (component instanceof StiPointPrimitive) {
                    needAdd = false;
                }
                if (rect.getRight() < pageRect.getLeft() || rect.getLeft() > pageRect.getRight() || rect.getBottom() < pageRect.getTop() || rect.getTop() > pageRect.getBottom()) {
                    needAdd = false;
                }
                if (!needAdd) continue;
                if (component instanceof StiLinePrimitive) {
                    if (component instanceof StiRectanglePrimitive) {
                        this.addCoord(rect);
                        rect.setY(rect.getY() - this.defaultLinePrimitiveWidth);
                        rect.setX(rect.getX() - this.defaultLinePrimitiveWidth);
                    } else {
                        if (rect.getHeight() < 1.5) {
                            rect.setY(rect.getY() - rect.getHeight());
                        }
                        if (rect.getWidth() < 1.5) {
                            rect.setX(rect.getX() - rect.getWidth());
                        }
                    }
                }
                this.addCoord(rect);
            }
            this.totalHeight = this.maxCoordY;
            totalHeight2 = ((Double)StiMapUtil.getByIndex(this.coordY, this.coordY.size() - 1)).intValue();
            this.totalWidth = Math.max(this.totalWidth, page.getUnit().ConvertToHInches(page.getWidth()) * (this.isHtmlService && ExportOptions.Html.isPrintLayoutOptimization() ? 0.96 : 1.0));
            ++pageIndex;
            if (this.coordY.size() - lastLinesCount <= maxLinesCount) continue;
            maxLinesCount = this.coordY.size() - lastLinesCount;
        }
        totalHeightPage[totalHeightPageCounter] = this.totalHeight;
        boolean putAdditionalInformation = false;
        StiText additionalInfo = null;
        if (!StiLicenseKeyValidator.isValidOnJavaFramework(null)) {
            StiPage tempPage = pages.size() > 0 ? (StiPage)pages.get(0) : new StiPage(this.report);
            StiRectangle tempRect = new StiRectangle(0.0, tempPage.getUnit().ConvertFromHInches(-20.0), tempPage.getWidth(), tempPage.getUnit().ConvertFromHInches(20.0));
            additionalInfo = new StiText(tempRect, "Stimulsoft Reports - Trial");
            additionalInfo.setHorAlignment(StiTextHorAlignment.Center);
            additionalInfo.setVertAlignment(StiVertAlignment.Center);
            additionalInfo.setFont(new StiFont("Arial", 12.0, StiFontStyle.Bold));
            additionalInfo.setTextBrush((StiBrush)new StiSolidBrush(StiColorEnum.Red.color()));
            additionalInfo.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.White.color()));
            additionalInfo.setBorder(new StiBorder(StiBorderSides.All, StiColorEnum.Black.color(), 1.0, StiPenStyle.Solid));
            additionalInfo.setPage(tempPage);
            boolean bl2 = putAdditionalInformation = pages.size() > 0 && (this.exportFormat == StiExportFormat.Excel || this.exportFormat == StiExportFormat.ExcelXml || this.exportFormat == StiExportFormat.Odt || this.exportFormat == StiExportFormat.Ods || this.exportFormat == StiExportFormat.Rtf || this.exportFormat == StiExportFormat.RtfTable);
            if (putAdditionalInformation) {
                StiRectangle tempRect2 = tempPage.getUnit().ConvertToHInches(additionalInfo.getDisplayRectangle());
                this.addCoord(tempRect2.getLeft(), tempRect2.getTop(), true);
                this.addCoord(tempRect2.getRight(), tempRect2.getBottom(), true);
            }
        }
        if (checkForExcel) {
            this.prepareTable();
        }
        if (this.isHtmlOrExcelXmlService) {
            this.addCoord(0.0, this.totalHeight + 1.0, false);
        }
        for (int indexY = 0; indexY < this.coordY.size(); ++indexY) {
            this.topCached.put((Double)StiMapUtil.getByIndex(this.coordY, indexY), indexY);
        }
        for (int indexX = 0; indexX < this.coordX.size(); ++indexX) {
            this.leftCached.put((Double)StiMapUtil.getByIndex(this.coordX, indexX), indexX);
        }
        this.cells = new StiCell[this.coordY.size()][this.coordX.size()];
        this.cellsMap = new StiCell[this.coordY.size()][this.coordX.size()];
        totalHeightPageCounter = 0;
        if (this.addComponentWithInteractions) {
            this.interactions = new int[this.coordY.size()][this.coordX.size()][2];
        }
        this.bordersX = new StiBorderSide[this.coordY.size()][this.coordX.size()];
        this.bordersY = new StiBorderSide[this.coordY.size()][this.coordX.size()];
        this.coordXCheck = new boolean[this.coordX.size()];
        this.coordYCheck = new boolean[this.coordY.size()];
        this.coordXNew = new int[this.coordX.size()];
        this.coordYNew = new int[this.coordY.size()];
        this.coordXPrim = new int[this.coordX.size()];
        this.coordYPrim = new int[this.coordY.size()];
        this.bookmarks = new String[this.coordY.size()][this.coordX.size()];
        this.imagesBaseRect = new Hashtable();
        service.setStatusString(StiLocalization.getValue((String)"Export", (String)"ExportingFormatingObjects"));
        for (StiPage page : pages) {
            String bookmark;
            pages.GetPage(page);
            service.invokeExporting(page, pages);
            if (service.isStoped()) {
                return;
            }
            this.totalHeight = totalHeightPage[totalHeightPageCounter++];
            if (page.getBorder() != null && !page.getBorder().getSide().containsOnly((IStiEnum)StiBorderSides.None)) {
                borderComponent = new StiContainer();
                borderComponent.setDisplayRectangle(page.getClientRectangle());
                borderComponent.setBorder(page.getBorder());
                borderComponent.setBrush(page.getBrush());
                borderComponent.setPage(page);
                this.renderComponent(borderComponent, exportData, true);
            }
            StiRectangle pageRect = page.getUnit().ConvertToHInches(page.getClientRectangle());
            for (StiComponent component : page.getComponents()) {
                if (!component.getEnabled()) continue;
                StiRectangle rect2 = page.getUnit().ConvertToHInches(component.getDisplayRectangle());
                if (rect2.getHeight() < 0.0) {
                    rect2.setY(rect2.getY() + rect2.getHeight());
                    rect2.setHeight(Math.abs(rect2.getHeight()));
                }
                boolean needAdd = true;
                if (component instanceof StiPointPrimitive) {
                    needAdd = false;
                }
                if (rect2.getRight() < pageRect.getLeft() || rect2.getLeft() > pageRect.getRight() || rect2.getBottom() < pageRect.getTop() || rect2.getTop() > pageRect.getBottom()) {
                    needAdd = false;
                }
                if (!needAdd) continue;
                this.renderComponent(component, exportData, false);
            }
            if (page.getBookmarkValue() != null && (bookmark = page.getBookmarkValue()) != null && bookmark.length() > 0 && (rect = this.getRange(page.getUnit().ConvertToHInches(page.getClientRectangle()))).getLeft() != -1.0) {
                if (rect.getBottom() == -1.0) {
                    rect.height = (double)(this.coordY.size() - 1) - rect.getTop();
                }
                block6: for (int indexY = rect.getYi(); indexY < rect.getBi(); ++indexY) {
                    int indexX;
                    boolean written = false;
                    for (indexX = rect.getXi(); indexX < rect.getRi(); ++indexX) {
                        if (this.cellsMap[indexY][indexX] == null || this.bookmarks[indexY][indexX] != null) continue;
                        this.bookmarks[indexY][indexX] = bookmark;
                        written = true;
                        break;
                    }
                    if (written) continue;
                    for (indexX = rect.getXi(); indexX < rect.getRi(); ++indexX) {
                        if (this.cellsMap[indexY][indexX] == null) continue;
                        this.bookmarks[indexY][indexX] = bookmark;
                        continue block6;
                    }
                }
            }
            if (StiLicenseKeyValidator.isValidOnJavaFramework(null) || !putAdditionalInformation || pageIndex != 0 || additionalInfo == null) continue;
            this.renderComponent(additionalInfo, exportData, false);
        }
        ArrayList<Double> listX = new ArrayList<Double>(this.coordX.values());
        ArrayList<Double> listY = new ArrayList<Double>(this.coordY.values());
        for (StiCell cell : this.createdCells) {
            if (cell.getWidth() == 0 && cell.getHeight() == 0) continue;
            int startX = 0;
            int startY = 0;
            StiRectangle cellRect = this.getCellRectangle(startX, startY, cell);
            if (cellRect.getWidth() == (double)(cell.getWidth() + 1) && cellRect.getHeight() == (double)(cell.getHeight() + 1)) {
                this.cutRectangleFromCellsMap(cellRect, cell);
                continue;
            }
            ArrayList<StiCell> newCells = new ArrayList<StiCell>();
            for (int y = 0; y <= cell.getHeight(); ++y) {
                for (int x = 0; x <= cell.getWidth(); ++x) {
                    cellRect = this.getCellRectangle(x, y, cell);
                    if (cellRect.getWidth() == 0.0) {
                        x = cell.getWidth() + 1;
                        continue;
                    }
                    this.cutRectangleFromCellsMap(cellRect, cell);
                    StiCell newCell = cell.clone();
                    newCell.setLeft(cell.getLeft() + cellRect.getXi());
                    newCell.setTop(cell.getTop() + cellRect.getYi());
                    newCell.setWidth(cellRect.getWi() - 1);
                    newCell.setHeight(cellRect.getHi() - 1);
                    this.cells[newCell.getTop()][newCell.getLeft()] = newCell;
                    newCells.add(newCell);
                    x = (int)((double)x + cellRect.getWidth());
                }
            }
            if (newCells.size() <= 0) continue;
            double maxArea = 0.0;
            StiCell selectedCell = null;
            for (StiCell cell2 : newCells) {
                double cellHeight;
                double cellWidth = listX.get(cell2.getLeft() + cell2.getWidth() + 1) - listX.get(cell2.getLeft());
                if (!(maxArea < cellWidth * (cellHeight = listY.get(cell2.getTop() + cell2.getHeight() + 1) - listY.get(cell2.getTop())))) continue;
                maxArea = cellWidth * cellHeight;
                selectedCell = cell2;
            }
            for (StiCell cell3 : newCells) {
                if (cell3 == selectedCell) continue;
                cell3.setText("");
                cell3.setExportImage(null);
            }
        }
        int maxCurrentCounterX = 0;
        for (int index = 0; index < this.coordX.size(); ++index) {
            this.coordXNew[index] = maxCurrentCounterX++;
            if (index >= this.coordX.size() - 1 || !((Double)StiMapUtil.getByIndex(this.coordX, index + 1) - (Double)StiMapUtil.getByIndex(this.coordX, index) < 1.1) || this.coordXPrim[index] != 1) continue;
            this.coordXCheck[index] = true;
        }
        int maxCurrentCounterY = 0;
        for (int index = 0; index < this.coordY.size(); ++index) {
            this.coordYNew[index] = maxCurrentCounterY++;
            if (index >= this.coordY.size() - 1 || !((Double)StiMapUtil.getByIndex(this.coordY, index + 1) - (Double)StiMapUtil.getByIndex(this.coordY, index) < 1.1) || this.coordYPrim[index] != 1) continue;
            this.coordYCheck[index] = true;
        }
        boolean check = true;
        if (check && (maxCurrentCounterY > 0 || maxCurrentCounterX > 0)) {
            int index;
            boolean[][] readyCells = new boolean[this.coordY.size()][this.coordX.size()];
            for (int indexY = 0; indexY < this.coordY.size() - 1; ++indexY) {
                for (int indexX = 0; indexX < this.coordX.size() - 1; ++indexX) {
                    int correctValueX = this.coordXNew[indexX];
                    int correctValueY = this.coordYNew[indexY];
                    StiCell currentCell = this.cells[indexY][indexX];
                    this.bordersX[indexY - correctValueY][indexX - correctValueX] = this.bordersX[indexY][indexX];
                    this.bordersY[indexY - correctValueY][indexX - correctValueX] = this.bordersY[indexY][indexX];
                    this.bookmarks[indexY - correctValueY][indexX - correctValueX] = this.bookmarks[indexY][indexX];
                    if (this.addComponentWithInteractions) {
                        this.interactions[indexY - correctValueY][indexX - correctValueX][0] = this.interactions[indexY][indexX][0];
                        this.interactions[indexY - correctValueY][indexX - correctValueX][1] = this.interactions[indexY][indexX][1];
                    }
                    if (currentCell == null || readyCells[indexY][indexX]) continue;
                    for (int yy = 0; yy <= currentCell.getHeight(); ++yy) {
                        for (int xx = 0; xx <= currentCell.getWidth(); ++xx) {
                            readyCells[indexY + yy][indexX + xx] = true;
                            if (yy == 0 && xx == 0) continue;
                            this.cells[indexY + yy][indexX + xx] = null;
                        }
                    }
                    if (this.coordXCheck[indexX] || this.coordYCheck[indexY]) {
                        this.cells[indexY][indexX] = null;
                        currentCell = null;
                    } else {
                        currentCell.setWidth(currentCell.getWidth() - (this.coordXNew[indexX + currentCell.getWidth() + 1] - correctValueX));
                        currentCell.setHeight(currentCell.getHeight() - (this.coordYNew[indexY + currentCell.getHeight() + 1] - correctValueY));
                        currentCell.setLeft(currentCell.getLeft() - correctValueX);
                        currentCell.setTop(currentCell.getTop() - correctValueY);
                    }
                    if (correctValueX <= 0 && correctValueY <= 0) continue;
                    this.cells[indexY - correctValueY][indexX - correctValueX] = currentCell;
                    this.cells[indexY][indexX] = null;
                    currentCell = null;
                }
            }
            for (index = 0; index < this.coordX.size() - 1; ++index) {
                int correctValueX = this.coordXNew[index];
                this.bordersX[this.coordY.size() - 1 - maxCurrentCounterY][index - correctValueX] = this.bordersX[this.coordY.size() - 1][index];
            }
            for (index = 0; index < this.coordY.size() - 1; ++index) {
                int correctValueY = this.coordYNew[index];
                this.bordersY[index - correctValueY][this.coordX.size() - 1 - maxCurrentCounterX] = this.bordersY[index][this.coordX.size() - 1];
            }
            for (index = this.coordX.size() - 1 - 1; index >= 0; --index) {
                if (!this.coordXCheck[index]) continue;
                this.coordX.remove(StiMapUtil.getByIndex(this.coordX, index));
            }
            for (index = this.coordY.size() - 1 - 1; index >= 0; --index) {
                if (!this.coordYCheck[index]) continue;
                this.coordY.remove(StiMapUtil.getByIndex(this.coordY, index));
            }
        }
        if (this.isHtmlOrExcelXmlService) {
            this.cellStyles = new StiCellStyle[this.coordY.size()][this.coordX.size()];
            boolean[][] readyCells = new boolean[this.coordY.size()][this.coordX.size()];
            StiFont defaultFont = new StiFont("Arial", 8.0);
            if (tempStylesCount == -1) {
                this.styles.clear();
            } else {
                for (int i = tempStylesCount; i < this.styles.size(); ++i) {
                    this.styles.remove(tempStylesCount);
                }
            }
            for (int rowIndex = 1; rowIndex < this.coordY.size() - 1; ++rowIndex) {
                for (int columnIndex = 1; columnIndex < this.coordX.size(); ++columnIndex) {
                    StiCellStyle newStyle;
                    boolean needBorderBottom;
                    boolean needBorderTop;
                    boolean needBorderLeft;
                    if (readyCells[rowIndex - 1][columnIndex - 1]) continue;
                    StiCell cell = this.cells[rowIndex - 1][columnIndex - 1];
                    if (cell != null) {
                        StiCellStyle newStyle2;
                        for (int yy = 0; yy <= cell.getHeight(); ++yy) {
                            for (int xx = 0; xx <= cell.getWidth(); ++xx) {
                                readyCells[rowIndex - 1 + yy][columnIndex - 1 + xx] = true;
                            }
                        }
                        needBorderLeft = true;
                        boolean needBorderRight = true;
                        for (int index = 0; index < cell.getHeight() + 1; ++index) {
                            if (this.bordersY[cell.getTop() + index][cell.getLeft()] == null) {
                                needBorderLeft = false;
                            }
                            if (this.bordersY[cell.getTop() + index][cell.getLeft() + cell.getWidth() + 1] != null) continue;
                            needBorderRight = false;
                        }
                        needBorderTop = true;
                        needBorderBottom = true;
                        for (int index = 0; index < cell.getWidth() + 1; ++index) {
                            if (this.bordersX[cell.getTop()][cell.getLeft() + index] == null) {
                                needBorderTop = false;
                            }
                            if (this.bordersX[cell.getTop() + cell.getHeight() + 1][cell.getLeft() + index] != null) continue;
                            needBorderBottom = false;
                        }
                        StiCellStyle style = cell.getCellStyle();
                        this.cellStyles[rowIndex - 1][columnIndex - 1] = newStyle2 = this.getStyle(new StiCellStyle(style.getColor(), style.getTextColor(), style.getFont(), style.getHorAlignment(), style.getVertAlignment(), needBorderTop ? this.bordersX[cell.getTop()][cell.getLeft()] : null, needBorderLeft ? this.bordersY[cell.getTop()][cell.getLeft()] : null, needBorderRight ? this.bordersY[cell.getTop()][cell.getLeft() + cell.getWidth() + 1] : null, needBorderBottom ? this.bordersX[cell.getTop() + cell.getHeight() + 1][cell.getLeft()] : null, style.getTextOptions(), style.isWordWrap(), style.getFormat(), style.getInternalStyleName()));
                        continue;
                    }
                    needBorderLeft = true;
                    boolean needBorderRight = true;
                    if (this.bordersY[rowIndex - 1][columnIndex - 1] == null) {
                        needBorderLeft = false;
                    }
                    if (this.bordersY[rowIndex - 1][columnIndex - 0] == null) {
                        needBorderRight = false;
                    }
                    needBorderTop = true;
                    needBorderBottom = true;
                    if (this.bordersX[rowIndex - 1][columnIndex - 1] == null) {
                        needBorderTop = false;
                    }
                    if (this.bordersX[rowIndex - 0][columnIndex - 1] == null) {
                        needBorderBottom = false;
                    }
                    if (!needBorderLeft && !needBorderRight && !needBorderTop && !needBorderBottom) continue;
                    this.cellStyles[rowIndex - 1][columnIndex - 1] = newStyle = this.getStyle(new StiCellStyle(StiColorEnum.Transparent.color(), StiColorEnum.Black.color(), defaultFont, StiTextHorAlignment.Center, StiVertAlignment.Center, needBorderTop ? this.bordersX[rowIndex - 1][columnIndex - 1] : null, needBorderLeft ? this.bordersY[rowIndex - 1][columnIndex - 1] : null, needBorderRight ? this.bordersY[rowIndex - 1][columnIndex - 0] : null, needBorderBottom ? this.bordersX[rowIndex - 0][columnIndex - 1] : null, null, false, null));
                }
            }
            this.checkStylesNames();
        }
        if (pages.size() > 1) {
            int startPageCounter = 1;
            block31: for (int indexY = 0; indexY < this.coordY.size(); ++indexY) {
                double currentY = (Double)StiMapUtil.getByIndex(this.coordY, indexY);
                for (int indexPage = startPageCounter; indexPage < pages.size(); ++indexPage) {
                    if (totalHeightPage2[indexPage] != currentY) continue;
                    this.horizontalPageBreaks.add(indexY);
                    startPageCounter = indexPage + 1;
                    continue block31;
                }
            }
        }
    }

    private double round(double value) {
        return (long)Math.rint(value);
    }

    private void addCoord(StiRectangle rect) {
        this.addCoord(rect.getLeft(), rect.getTop() + this.totalHeight, true);
        this.addCoord(rect.getRight(), rect.getBottom() + this.totalHeight, true);
    }

    private void addCoord(double x, double y, boolean convert) {
        if (y > this.maxCoordY) {
            this.maxCoordY = y;
        }
        if (convert && this.isHtmlService && ExportOptions.Html.isPrintLayoutOptimization()) {
            x = this.round(x * 0.96);
            y = this.round(y * 0.956);
        } else {
            x = this.round(x);
            y = this.round(y);
        }
        x = this.round(x);
        y = this.round(y);
        this.coordX.put(x, x);
        this.coordY.put(y, y);
    }

    public void prepareTable() {
        for (int rowIndex = 1; rowIndex < this.coordY.size(); ++rowIndex) {
            double maxLineHeight;
            double rowHeight = (Double)StiMapUtil.getByIndex(this.coordY, rowIndex) - (Double)StiMapUtil.getByIndex(this.coordY, rowIndex - 1);
            if (!((rowHeight = this.round(rowHeight)) > (maxLineHeight = 200.0))) continue;
            if (rowHeight < maxLineHeight * 2.0) {
                maxLineHeight = this.round(rowHeight / 2.0);
            }
            double endHeight = (Double)StiMapUtil.getByIndex(this.coordY, rowIndex - 1) + maxLineHeight;
            this.addCoord(0.0, endHeight, false);
        }
    }

    private Double getKey(Map<Double, Double> map, Double value) {
        for (Double key : map.keySet()) {
            if (map.get(key) != value) continue;
            return key;
        }
        return value;
    }

    public StiRectangle getRange(StiRectangle rect) {
        double scaleX = this.isHtmlService && ExportOptions.Html.isPrintLayoutOptimization() ? 0.96 : 1.0;
        double scaleY = this.isHtmlService && ExportOptions.Html.isPrintLayoutOptimization() ? 0.956 : 1.0;
        double ll = this.round(rect.getLeft() * scaleX);
        double tt = this.round((rect.getTop() + this.totalHeight) * scaleY);
        double rr = this.round(rect.getRight() * scaleX);
        double bb = this.round((rect.getBottom() + this.totalHeight) * scaleY);
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        if (this.leftCached.get(ll) == null) {
            left = this.getKey(this.coordX, ll).intValue();
            this.leftCached.put(ll, left);
        } else {
            left = this.leftCached.get(ll);
        }
        if (this.topCached.get(tt) == null) {
            top = this.getKey(this.coordY, tt).intValue();
            this.topCached.put(tt, top);
        } else {
            top = this.topCached.get(tt);
        }
        if (this.leftCached.get(rr) == null) {
            right = this.getKey(this.coordX, rr).intValue();
            this.leftCached.put(rr, right);
        } else {
            right = this.leftCached.get(rr);
        }
        if (this.topCached.get(bb) == null) {
            bottom = this.getKey(this.coordY, bb).intValue();
            this.topCached.put(bb, bottom);
        } else {
            bottom = this.topCached.get(bb);
        }
        return new StiRectangle((long)left, (long)top, (long)(right - left), (long)(bottom - top));
    }

    public StiCellStyle getStyleFromComponent(StiComponent component, int x, int y) {
        IStiBrush brushComp;
        StiColor color = StiColorEnum.White.color();
        IStiBrush iStiBrush = brushComp = component instanceof IStiBrush ? (IStiBrush)((Object)component) : null;
        if (brushComp != null && !(component instanceof StiShape)) {
            color = StiBrush.ToColor((StiBrush)brushComp.getBrush());
        }
        if (component instanceof StiShape && this.isHtmlPngMode) {
            color = StiColorEnum.Transparent.color();
        }
        StiRichText richText = null;
        if (component instanceof StiRichText) {
            richText = (StiRichText)component;
            color = richText.getBackColor();
        }
        if (component instanceof StiPrimitive) {
            color = StiColorEnum.Transparent.color();
        }
        if (x != -1 && y != -1 && color.getA() == 0 && this.cellsMap[y][x] != null) {
            StiCell cell = this.cellsMap[y][x];
            color = cell.getCellStyle().getColor();
        }
        StiColor textColor = StiColorEnum.Black.color();
        IStiTextBrush textBrushComp = null;
        if (component instanceof IStiTextBrush) {
            textBrushComp = (IStiTextBrush)((Object)component);
            textColor = StiBrush.ToColor((StiBrush)textBrushComp.getTextBrush());
        }
        StiFont font = null;
        IStiFont textFontComp = null;
        if (component instanceof IStiFont) {
            textFontComp = (IStiFont)((Object)component);
            font = textFontComp.getFont();
        } else {
            font = new StiFont("Arial", 8.0);
        }
        StiTextHorAlignment horAlign = StiTextHorAlignment.Left;
        IStiTextHorAlignment horAlignComp = null;
        if (component instanceof IStiTextHorAlignment) {
            horAlignComp = (IStiTextHorAlignment)((Object)component);
            horAlign = horAlignComp.getHorAlignment();
        }
        StiVertAlignment vertAlign = StiVertAlignment.Top;
        IStiVertAlignment vertAlignComp = null;
        if (component instanceof IStiVertAlignment) {
            vertAlignComp = (IStiVertAlignment)((Object)component);
            vertAlign = vertAlignComp.getVertAlignment();
        }
        StiBorderSide borderL = null;
        StiBorderSide borderR = null;
        StiBorderSide borderT = null;
        StiBorderSide borderB = null;
        IStiBorder borderComp = null;
        if (component instanceof IStiBorder) {
            borderComp = (IStiBorder)((Object)component);
            StiAdvancedBorder advBorder = null;
            if (borderComp.getBorder() instanceof StiAdvancedBorder) {
                advBorder = (StiAdvancedBorder)borderComp.getBorder();
                borderL = advBorder.getLeftSide();
                borderR = advBorder.getRightSide();
                borderT = advBorder.getTopSide();
                borderB = advBorder.getBottomSide();
            } else {
                borderL = new StiBorderSide(borderComp.getBorder().getColor(), borderComp.getBorder().getSize(), borderComp.getBorder().getStyle());
                if (borderComp.getBorder().isRightBorderSidePresent()) {
                    borderR = borderL;
                }
                if (borderComp.getBorder().isTopBorderSidePresent()) {
                    borderT = borderL;
                }
                if (borderComp.getBorder().isBottomBorderSidePresent()) {
                    borderB = borderL;
                }
                if (!borderComp.getBorder().isLeftBorderSidePresent()) {
                    borderL = null;
                }
            }
        }
        StiTextOptions textOptions = null;
        IStiTextOptions textOptionsComp = null;
        if (component instanceof IStiTextOptions) {
            textOptionsComp = (IStiTextOptions)((Object)component);
            textOptions = textOptionsComp.getTextOptions();
        }
        boolean wordWrap = false;
        IStiText text = null;
        if (component instanceof IStiText && (text = (IStiText)((Object)component)).getTextInternal() != null) {
            boolean bl = wordWrap = text.getTextInternal().indexOf("\n") != -1;
        }
        if (this.isHtmlOrExcelXmlService && textOptions != null) {
            wordWrap = textOptions.getWordWrap();
        }
        String format = null;
        StiText textComp = null;
        if (this.exportFormat == StiExportFormat.ExcelXml && component instanceof StiText) {
            textComp = (StiText)component;
            String inputFormat = textComp.getFormat();
            boolean isFormatCurrency = false;
            boolean isFormatNumeric = false;
            boolean isFormatPercent = false;
            String outputFormat = "";
            int decimalDigits = 2;
            int groupDigits = 0;
            char currencySymbol = '$';
            boolean currencyPositionBefore = false;
            boolean negativeBraces = false;
            if (inputFormat != null && inputFormat.length() > 0) {
                if (inputFormat.charAt(0) == 'C') {
                    isFormatCurrency = true;
                }
                if (inputFormat.charAt(0) == 'N') {
                    isFormatNumeric = true;
                }
                if (inputFormat.charAt(0) == 'P') {
                    isFormatPercent = true;
                }
                if ((isFormatCurrency || isFormatNumeric || isFormatPercent) && inputFormat.length() > 1) {
                    int indexPos = 1;
                    if (Character.isDigit(inputFormat.charAt(indexPos))) {
                        StringBuilder decimalSB = new StringBuilder();
                        while (indexPos < inputFormat.length() && Character.isDigit(inputFormat.charAt(indexPos))) {
                            decimalSB.append(inputFormat.charAt(indexPos));
                            ++indexPos;
                        }
                        decimalDigits = Integer.parseInt(decimalSB.toString());
                    }
                    if (indexPos < inputFormat.length() && inputFormat.charAt(indexPos) == 'G') {
                        ++indexPos;
                        groupDigits = 3;
                    }
                    if (indexPos < inputFormat.length() && inputFormat.charAt(indexPos) == '(') {
                        ++indexPos;
                        negativeBraces = true;
                    }
                    if (indexPos < inputFormat.length() && (inputFormat.charAt(indexPos) == '+' || inputFormat.charAt(indexPos) == '-')) {
                        if (inputFormat.charAt(indexPos) == '+') {
                            currencyPositionBefore = true;
                        }
                        if (++indexPos < inputFormat.length()) {
                            currencySymbol = inputFormat.charAt(indexPos);
                        }
                    }
                }
            }
            if (isFormatCurrency || isFormatNumeric || isFormatPercent) {
                StringBuilder outputSB = new StringBuilder();
                if (isFormatCurrency && currencyPositionBefore) {
                    outputSB.append("\"");
                    outputSB.append(currencySymbol);
                    outputSB.append("\"");
                }
                if (groupDigits > 1) {
                    outputSB.append("#,");
                    outputSB.append(StiStringUtil.repeatString((String)"#", (int)(groupDigits - 1)));
                }
                outputSB.append('0');
                if (decimalDigits > 0) {
                    outputSB.append(".");
                    outputSB.append(StiStringUtil.repeatString((String)"0", (int)decimalDigits));
                }
                if (isFormatCurrency && !currencyPositionBefore) {
                    outputSB.append("\"");
                    outputSB.append(currencySymbol);
                    outputSB.append("\"");
                }
                if (isFormatPercent) {
                    outputSB.append("%");
                }
                outputFormat = outputSB.toString();
                String negativePattern = (negativeBraces ? "(" : "-") + outputFormat + (negativeBraces ? ")" : "");
                if (textComp != null && textComp.getHideZeros()) {
                    outputFormat = outputFormat + ";" + negativePattern + ";";
                } else if (negativeBraces) {
                    outputFormat = outputFormat + ";" + negativePattern;
                }
            }
            format = outputFormat;
        }
        String styleName = null;
        if (component.getComponentStyle() != null && component.getComponentStyle().length() > 0) {
            styleName = component.getComponentStyle();
        }
        if (this.isHtmlOrExcelXmlService && !ExportOptions.Html.isUseComponentStyleName()) {
            styleName = null;
        }
        return this.getStyle(new StiCellStyle(color, textColor, font, horAlign, vertAlign, borderT, borderL, borderR, borderB, textOptions, wordWrap, format, styleName));
    }

    private StiCellStyle getStyle(StiCellStyle style) {
        for (StiCellStyle stl : this.styles) {
            if (!stl.equals(style)) continue;
            return stl;
        }
        this.styles.add(style);
        return style;
    }

    private void renderComponent(StiComponent component, boolean exportData, boolean isPage) {
        StiRectangle rect;
        StiRectangle rectD = component.getPage().getUnit().ConvertToHInches(component.getDisplayRectangle());
        if (rectD.getHeight() < 0.0) {
            rectD.setY(rectD.getY() + rectD.getHeight());
            rectD.setHeight(Math.abs(rectD.getHeight()));
        }
        if (!(component instanceof StiLinePrimitive || rectD.getWidth() != 0.0 && rectD.getHeight() != 0.0)) {
            return;
        }
        if (component instanceof StiLinePrimitive) {
            if (component instanceof StiRectanglePrimitive) {
                rectD.setY(rectD.getY() - this.defaultLinePrimitiveWidth);
                rectD.setX(rectD.getX() - this.defaultLinePrimitiveWidth);
            } else {
                if (rectD.getHeight() < 1.5) {
                    rectD.setY(rectD.getY() - rectD.getHeight());
                }
                if (rectD.getWidth() < 1.5) {
                    rectD.setX(rectD.getX() - rectD.getWidth());
                }
            }
        }
        if ((rect = this.getRange(rectD)).getLeft() != -1.0) {
            boolean needAdd = true;
            IStiBorder borderComp = component instanceof IStiBorder ? (IStiBorder)((Object)component) : null;
            String bookmark = component.getBookmarkValue();
            boolean haveBookmark = bookmark != null && bookmark.length() > 0;
            boolean haveBorder = borderComp != null && borderComp.getBorder() != null && !borderComp.getBorder().getSide().containsOnly((IStiEnum)StiBorderSides.None);
            boolean haveText = false;
            boolean haveBrush = false;
            boolean haveExcel = false;
            boolean haveIndicator = false;
            StiText sText = null;
            if (component instanceof StiText) {
                sText = (StiText)component;
                haveText = sText.getText() != null && sText.getTextInternal() != null && (sText.getTextInternal().length() > 0 || exportData);
                haveBrush = sText.getBrush() != null && StiBrush.ToColor((StiBrush)sText.getBrush()).getA() != 0;
                haveExcel = sText.getExcelDataValue() != null;
                haveIndicator = sText.getIndicator() != null;
                needAdd = haveText || haveBrush || haveExcel || haveBorder || haveIndicator;
            }
            StiContainer cont = null;
            if (component instanceof StiContainer) {
                cont = (StiContainer)component;
                haveBrush = cont.getBrush() != null && StiBrush.ToColor((StiBrush)cont.getBrush()).getA() != 0;
                boolean bl = needAdd = haveBrush || haveBorder && !isPage;
            }
            if (haveBookmark) {
                needAdd = true;
            }
            if (component instanceof StiRectanglePrimitive) {
                needAdd = false;
                if (this.coordXPrim[rect.getLi()] == 0) {
                    this.coordXPrim[rect.getLi()] = 1;
                }
                if (this.coordXPrim[rect.getRi()] == 0) {
                    this.coordXPrim[rect.getRi()] = 1;
                }
                if (this.coordYPrim[rect.getTi()] == 0) {
                    this.coordYPrim[rect.getTi()] = 1;
                }
                if (this.coordYPrim[rect.getBi()] == 0) {
                    this.coordYPrim[rect.getBi()] = 1;
                }
            }
            boolean haveInteraction = this.isComponentHasInteraction(component);
            int interactionPageId = 0;
            int interactionComponentId = 0;
            if (haveInteraction) {
                needAdd = true;
                interactionPageId = component.getReport().getRenderedPages().indexOf(component.getPage()) + 1;
                interactionComponentId = component.getPage().getComponents().indexOf(component) + 1;
            }
            if (needAdd) {
                StiCell cell = new StiCell(this.exportFormat);
                this.createdCells.add(cell);
                if (this.exportFormat != StiExportFormat.Csv && this.exportFormat != StiExportFormat.Dbf && this.exportFormat != StiExportFormat.Xml) {
                    cell.setCellStyle(this.getStyleFromComponent(component, rect.getLi(), rect.getTi()));
                }
                boolean assignComponent = true;
                if (this.exportFormat == StiExportFormat.ExcelXml) {
                    assignComponent = false;
                    if (component instanceof StiRichText) {
                        assignComponent = true;
                    }
                    if (component instanceof StiCheckBox) {
                        assignComponent = true;
                    }
                    if (sText != null && sText.getExcelDataValue() != null) {
                        assignComponent = true;
                    }
                    if (ExportOptions.ExcelXml.getAllowFreezePanes() && (component.getLocked() || component.getTagValue() != null && component.getTagValue().contains("excelfreezepanes"))) {
                        assignComponent = true;
                    }
                }
                if (assignComponent) {
                    cell.setComponent(component);
                }
                if (cell.getExportImage() != null) {
                    this.imagesBaseRect.put(component, new StiRectangle(rectD.getX(), rectD.getY() + this.totalHeight, rectD.getWidth(), rectD.getHeight()));
                }
                this.cells[rect.getTi()][rect.getLi()] = cell;
                cell.setLeft(rect.getLi());
                cell.setTop(rect.getTi());
                IStiText text = null;
                if (component instanceof IStiText) {
                    text = (IStiText)((Object)component);
                    cell.setText(text.getText().getValue());
                    if (component instanceof StiText && ((StiText)component).getTextQuality() == StiTextQuality.Wysiwyg && StiValidationUtil.isNotNullOrEmpty((String)cell.getText()) && cell.getText().endsWith(StiTextRenderer.StiForceWidthAlignTag)) {
                        cell.setText(cell.getText().substring(0, cell.getText().length() - StiTextRenderer.StiForceWidthAlignTag.length()));
                    }
                } else {
                    cell.setText("");
                }
                cell.setWidth(rect.getWi() - 1);
                cell.setHeight(rect.getHi() - 1);
                for (int indexX = rect.getXi(); indexX < rect.getRi(); ++indexX) {
                    for (int indexY = rect.getYi(); indexY < rect.getBi(); ++indexY) {
                        this.cellsMap[indexY][indexX] = cell;
                        if (haveBookmark) {
                            this.bookmarks[indexY][indexX] = bookmark;
                        }
                        if (!haveInteraction) continue;
                        this.interactions[indexY][indexX][0] = interactionPageId;
                        this.interactions[indexY][indexX][1] = interactionComponentId;
                    }
                }
                if (component instanceof StiVerticalLinePrimitive) {
                    if (this.coordXPrim[cell.getLeft()] == 0) {
                        this.coordXPrim[cell.getLeft()] = 1;
                    }
                } else {
                    this.coordXPrim[cell.getLeft()] = -1;
                }
                if (component instanceof StiHorizontalLinePrimitive) {
                    if (this.coordYPrim[cell.getTop()] == 0) {
                        this.coordYPrim[cell.getTop()] = 1;
                    }
                } else {
                    this.coordYPrim[cell.getTop()] = -1;
                }
            }
            if (haveBorder) {
                int index;
                StiBorderSide border = new StiBorderSide(borderComp.getBorder().getColor(), borderComp.getBorder().getSize(), borderComp.getBorder().getStyle());
                StiAdvancedBorder advBorder = borderComp.getBorder() instanceof StiAdvancedBorder ? (StiAdvancedBorder)borderComp.getBorder() : null;
                StiRectanglePrimitive primitive = new StiRectanglePrimitive();
                if (component instanceof StiVerticalLinePrimitive) {
                    rect.setX(rect.getX() + 1.0);
                }
                if (component instanceof StiHorizontalLinePrimitive) {
                    rect.setY(rect.getY() + 1.0);
                }
                if (component instanceof StiRectanglePrimitive) {
                    rect.setX(rect.getX() + 1.0);
                    rect.setY(rect.getY() + 1.0);
                    primitive = (StiRectanglePrimitive)component;
                }
                if (advBorder != null) {
                    border = advBorder.getTopSide();
                }
                if (borderComp.getBorder().isTopBorderSidePresent() && border.getStyle() != StiPenStyle.None && primitive.getTopSide()) {
                    for (index = rect.getLi(); index < rect.getRi(); ++index) {
                        if (this.bordersX[rect.getTi()][index] != null) {
                            if (!(this.bordersX[rect.getTi()][index].getSize() <= border.getSize())) continue;
                            this.bordersX[rect.getTi()][index] = border;
                            continue;
                        }
                        this.bordersX[rect.getTi()][index] = border;
                    }
                }
                if (advBorder != null) {
                    border = advBorder.getBottomSide();
                }
                if (borderComp.getBorder().isBottomBorderSidePresent() && border.getStyle() != StiPenStyle.None && primitive.getBottomSide()) {
                    for (index = rect.getLi(); index < rect.getRi(); ++index) {
                        if (this.bordersX[rect.getBi()][index] != null) {
                            if (!(this.bordersX[rect.getBi()][index].getSize() <= border.getSize())) continue;
                            this.bordersX[rect.getBi()][index] = border;
                            continue;
                        }
                        this.bordersX[rect.getBi()][index] = border;
                    }
                }
                if (advBorder != null) {
                    border = advBorder.getLeftSide();
                }
                if (borderComp.getBorder().isLeftBorderSidePresent() && border.getStyle() != StiPenStyle.None && primitive.getLeftSide()) {
                    for (index = rect.getTi(); index < rect.getBi(); ++index) {
                        if (this.bordersY[index][rect.getLi()] != null) {
                            if (!(this.bordersY[index][rect.getLi()].getSize() <= border.getSize())) continue;
                            this.bordersY[index][rect.getLi()] = border;
                            continue;
                        }
                        this.bordersY[index][rect.getLi()] = border;
                    }
                }
                if (advBorder != null) {
                    border = advBorder.getRightSide();
                }
                if (borderComp.getBorder().isRightBorderSidePresent() && border.getStyle() != StiPenStyle.None && primitive.getRightSide()) {
                    for (index = rect.getTi(); index < rect.getBi(); ++index) {
                        if (this.bordersY[index][rect.getRi()] != null) {
                            if (!(this.bordersY[index][rect.getRi()].getSize() <= border.getSize())) continue;
                            this.bordersY[index][rect.getRi()] = border;
                            continue;
                        }
                        this.bordersY[index][rect.getRi()] = border;
                    }
                }
            }
        }
    }

    private StiRectangle getCellRectangle(int startX, int startY, StiCell cell) {
        int rectLeft;
        int rectTop = startY;
        int rectRight = startX;
        int rectBottom = startY;
        for (rectLeft = startX; rectLeft <= cell.getWidth() && this.cellsMap[rectTop + cell.getTop()][rectLeft + cell.getLeft()] != cell; ++rectLeft) {
        }
        if (rectLeft > cell.getWidth()) {
            return new StiRectangle(0L, 0L, 0L, 0L);
        }
        for (rectRight = rectLeft; rectRight <= cell.getWidth() && this.cellsMap[rectTop + cell.getTop()][rectRight + cell.getLeft()] == cell; ++rectRight) {
        }
        if (rectLeft == rectRight) {
            return new StiRectangle(0L, 0L, 0L, 0L);
        }
        boolean fail = false;
        rectBottom = rectTop + 1;
        while (rectBottom <= cell.getHeight() && !fail) {
            if (rectLeft > 0 && this.cellsMap[cell.getTop() + rectBottom][cell.getLeft() + rectLeft - 1] == cell) {
                fail = true;
                break;
            }
            if (rectRight <= cell.getWidth() && this.cellsMap[rectBottom + cell.getTop()][cell.getLeft() + rectRight] == cell) {
                fail = true;
                break;
            }
            for (int index = rectLeft; index < rectRight; ++index) {
                if (this.cellsMap[rectBottom + cell.getTop()][index + cell.getLeft()] == cell) continue;
                fail = true;
                break;
            }
            if (fail) continue;
            ++rectBottom;
        }
        return new StiRectangle((long)rectLeft, (long)rectTop, (long)(rectRight - rectLeft), (long)(rectBottom - rectTop));
    }

    private void cutRectangleFromCellsMap(StiRectangle cellRect, StiCell cell) {
        for (int mapX = cellRect.getLi(); mapX < cellRect.getRi(); ++mapX) {
            for (int mapY = cellRect.getTi(); mapY < cellRect.getBi(); ++mapY) {
                this.cellsMap[cell.getTop() + mapY][cell.getLeft() + mapX] = null;
            }
        }
    }

    public boolean isComponentHasInteraction(StiComponent component) {
        if (this.addComponentWithInteractions && component.getInteraction() != null) {
            if (component.getInteraction().getSortingEnabled()) {
                return true;
            }
            if (component.getInteraction().getDrillDownEnabled() && component.getInteraction().getDrillDownPage() != null) {
                return true;
            }
            if (component.getInteraction() instanceof StiBandInteraction && ((StiBandInteraction)component.getInteraction()).getCollapsingEnabled()) {
                return true;
            }
        }
        return false;
    }

    public void scanComponentsPlacement(boolean optimize) {
        this.scanComponentsPlacement(optimize, false);
    }

    public void scanComponentsPlacement(boolean optimize, boolean exportObjectFormatting) {
        this.linePlacement = new StiTableLineInfo[this.coordY.size()];
        Arrays.fill((Object[])this.linePlacement, (Object)StiTableLineInfo.Empty);
        this.parentBandName = new String[this.coordY.size()];
        for (int rowIndex = 0; rowIndex < this.coordY.size() - 1; ++rowIndex) {
            StiTableLineInfo lineInfo = this.linePlacement[rowIndex];
            StringBuilder parentName = new StringBuilder();
            boolean flag = false;
            int skipCount = 0;
            for (int columnIndex = 1; columnIndex < this.coordX.size(); ++columnIndex) {
                int stPos;
                StiCell cell = this.cells[rowIndex][columnIndex - 1];
                if (cell == null || cell.getComponent() instanceof StiCrossColumnTotal) continue;
                String cp = cell.getComponent().getComponentPlacement();
                if (cp == null) {
                    cp = "";
                }
                if ((stPos = cp.indexOf("Hd_HPnl")) != -1) {
                    cp = cp.substring(0, stPos + 7);
                }
                if (!flag) {
                    if (cp.startsWith("ph")) {
                        lineInfo = StiTableLineInfo.PageHeader;
                        flag = true;
                    } else if (cp.startsWith("pf")) {
                        lineInfo = StiTableLineInfo.PageFooter;
                        flag = true;
                    } else if (cp.startsWith("h.ap")) {
                        lineInfo = StiTableLineInfo.HeaderAP;
                    } else if (cp.startsWith("f.ap")) {
                        lineInfo = StiTableLineInfo.FooterAP;
                    } else if (cp.startsWith("h")) {
                        lineInfo = StiTableLineInfo.HeaderD;
                    } else if (cp.startsWith("f")) {
                        lineInfo = StiTableLineInfo.FooterD;
                    } else if (cp.startsWith("d")) {
                        lineInfo = StiTableLineInfo.Data;
                    } else if (cp.startsWith("gh")) {
                        lineInfo = StiTableLineInfo.HeaderD;
                    } else if (cp.startsWith("gf")) {
                        lineInfo = StiTableLineInfo.FooterD;
                    }
                }
                if (!"".equals(cp) && lineInfo == StiTableLineInfo.Empty) {
                    lineInfo = StiTableLineInfo.Unknown;
                }
                if (parentName.length() == 0) {
                    parentName.append(cp + '\u001f');
                }
                if (parentName.length() == 1 && parentName.charAt(0) == '\u001f' && !"".equals(cp)) {
                    parentName.insert(0, cp);
                }
                if ((lineInfo == StiTableLineInfo.HeaderD || lineInfo == StiTableLineInfo.HeaderAP) && cell.getText() != null) {
                    parentName.append(cell.getText());
                }
                int cellHeight = cell.getHeight();
                if (!exportObjectFormatting) {
                    cellHeight = 0;
                }
                for (int indexHeight = 0; indexHeight <= cellHeight; ++indexHeight) {
                    this.linePlacement[rowIndex + indexHeight] = lineInfo;
                    this.parentBandName[rowIndex + indexHeight] = parentName.toString();
                }
                if (cellHeight <= skipCount) continue;
                skipCount = cellHeight;
            }
            this.linePlacement[rowIndex] = lineInfo;
        }
        if (optimize) {
            Hashtable<String, String> headerNames = new Hashtable<String, String>();
            String lastParentBandName = null;
            for (int tempOffset = 0; tempOffset < this.coordY.size() - 1; ++tempOffset) {
                String currentParentBandName;
                if (this.linePlacement[tempOffset] != StiTableLineInfo.HeaderAP) continue;
                String headerName = this.parentBandName[tempOffset];
                int symPos = headerName.indexOf("\\x1f");
                if (symPos != -1 && (currentParentBandName = headerName.substring(0, symPos)) != lastParentBandName) {
                    lastParentBandName = currentParentBandName;
                    headerNames.clear();
                }
                if (headerNames.containsKey(headerName)) {
                    this.linePlacement[tempOffset] = StiTableLineInfo.Trash;
                    continue;
                }
                headerNames.put(headerName, headerName);
            }
            Hashtable<String, String> footerNames = new Hashtable<String, String>();
            lastParentBandName = null;
            for (int tempOffset = this.coordY.size() - 1 - 1; tempOffset >= 0; --tempOffset) {
                String currentParentBandName;
                if (this.linePlacement[tempOffset] != StiTableLineInfo.FooterAP) continue;
                String footerName = this.parentBandName[tempOffset];
                int symPos = footerName.indexOf("\\x1f");
                if (symPos != -1 && (currentParentBandName = footerName.substring(0, symPos)) != lastParentBandName) {
                    lastParentBandName = currentParentBandName;
                    footerNames.clear();
                }
                if (footerNames.containsKey(footerName)) {
                    this.linePlacement[tempOffset] = StiTableLineInfo.Trash;
                    continue;
                }
                footerNames.put(footerName, footerName);
            }
            for (int rowIndex = 0; rowIndex < this.coordY.size() - 1; ++rowIndex) {
                if (this.linePlacement[rowIndex] != StiTableLineInfo.PageHeader && this.linePlacement[rowIndex] != StiTableLineInfo.PageFooter && this.linePlacement[rowIndex] != StiTableLineInfo.Trash) continue;
                int offset = 0;
                while (rowIndex + offset > 0 && this.linePlacement[rowIndex + offset - 1] == StiTableLineInfo.Empty) {
                    this.linePlacement[rowIndex + --offset] = this.linePlacement[rowIndex];
                }
                offset = 0;
                while (rowIndex + offset < this.coordY.size() - 1 && this.linePlacement[rowIndex + offset + 1] == StiTableLineInfo.Empty) {
                    this.linePlacement[rowIndex + ++offset] = this.linePlacement[rowIndex];
                }
            }
        }
    }

    public static String[] splitTag(String inputString) {
        String inString = inputString;
        if (!inString.endsWith(";")) {
            inString = inString + ";";
        }
        ArrayList<String> outString = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int stPos = 0;
        boolean posInString = false;
        while (stPos < inString.length()) {
            char sym = inString.charAt(stPos);
            ++stPos;
            if (sym == '\"') {
                if (posInString) {
                    if (inString.charAt(stPos) == '\"') {
                        sb.append(sym);
                        ++stPos;
                    } else {
                        posInString = !posInString;
                    }
                } else {
                    boolean bl = posInString = !posInString;
                }
            }
            if (sym == ';' && !posInString || stPos >= inString.length()) {
                String stTemp = sb.toString().trim();
                if (stTemp.length() > 0) {
                    outString.add(stTemp);
                }
                sb = new StringBuilder();
                continue;
            }
            sb.append(sym);
        }
        return outString.toArray(new String[0]);
    }

    public static String[] getStringsFromTag(String tag, int startPosition) {
        int pos;
        ArrayList<String> outString = new ArrayList<String>();
        for (pos = startPosition; pos < tag.length() && tag.charAt(pos) != '\"'; ++pos) {
        }
        StringBuilder sb = new StringBuilder();
        boolean posInString = false;
        while (pos < tag.length()) {
            char sym = tag.charAt(pos);
            ++pos;
            if (sym == '\"') {
                if (!posInString) {
                    posInString = true;
                    continue;
                }
                if (pos < tag.length() && tag.charAt(pos) == '\"') {
                    sb.append(sym);
                    ++pos;
                    continue;
                }
                outString.add(sb.toString());
                sb = new StringBuilder();
                posInString = false;
                continue;
            }
            if (!posInString) continue;
            sb.append(sym);
        }
        if (sb.length() > 0) {
            outString.add(sb.toString());
        }
        return outString.toArray(new String[0]);
    }

    private void copyFieldsListToFields() {
        this.fields = new DataField[this.fieldsList.size()];
        for (int index = 0; index < this.fieldsList.size(); ++index) {
            this.fields[index] = this.fieldsList.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareDocument(StiExportService service, StiDataExportMode mode) {
        int index;
        this.sizeX = this.coordX.size() - 1;
        this.sizeY = this.coordY.size() - 1;
        int dataArraySizeY = 0;
        for (index = 0; index < this.sizeY; ++index) {
            if (((mode.value & StiDataExportMode.Data.value) <= 0 || this.linePlacement[index] != StiTableLineInfo.Data) && ((mode.value & StiDataExportMode.HeadersFooters.value) <= 0 || this.linePlacement[index] != StiTableLineInfo.HeaderD && this.linePlacement[index] != StiTableLineInfo.FooterD) && mode != StiDataExportMode.AllBands) continue;
            ++dataArraySizeY;
        }
        this.fieldsList = new ArrayList();
        for (index = 0; index < this.sizeX; ++index) {
            this.fieldsList.add(new DataField(dataArraySizeY));
        }
        this.copyFieldsListToFields();
        Integer columnIndex = 0;
        while (columnIndex < this.sizeX) {
            this.fields[columnIndex.intValue()].Name = "FIELD" + String.format("%04d", columnIndex);
            Integer n = columnIndex;
            Integer n2 = columnIndex = Integer.valueOf(columnIndex + 1);
        }
        String exportName = "";
        boolean useAliases = false;
        switch (service.getExportFormat()) {
            case Csv: {
                exportName = "csv";
                useAliases = ExportOptions.Csv.getUseAliases();
                break;
            }
            case Dbf: {
                exportName = "dbf";
                useAliases = ExportOptions.Dbf.getUseAliases();
                break;
            }
            case Xml: {
                exportName = "xml";
                useAliases = ExportOptions.Xml.getUseAliases();
            }
        }
        int dataArrayCounter = 0;
        this.htName = new Hashtable();
        for (int rowIndex = 0; rowIndex < this.sizeY; ++rowIndex) {
            boolean needWriteData;
            boolean bl = needWriteData = (mode.value & StiDataExportMode.Data.value) > 0 && this.linePlacement[rowIndex] == StiTableLineInfo.Data || (mode.value & StiDataExportMode.HeadersFooters.value) > 0 && (this.linePlacement[rowIndex] == StiTableLineInfo.HeaderD || this.linePlacement[rowIndex] == StiTableLineInfo.FooterD) || mode == StiDataExportMode.AllBands;
            if (!needWriteData) continue;
            for (int columnIndex2 = 0; columnIndex2 < this.sizeX; ++columnIndex2) {
                StiCell cell = this.cells[rowIndex][columnIndex2];
                if (cell != null) {
                    String sTag = cell.getComponent().getTagValue();
                    String[] sTagArray = null;
                    if (sTag != null && sTag.length() > 0) {
                        sTagArray = StiMatrix.splitTag(sTag);
                    }
                    if (sTagArray != null) {
                        for (int index2 = 0; index2 < sTagArray.length; ++index2) {
                            String[] stArr;
                            if (!sTagArray[index2].toLowerCase(Locale.getDefault()).startsWith("column") || (stArr = StiMatrix.getStringsFromTag(sTagArray[index2], 6)).length <= 1) continue;
                            if (!this.htName.containsKey(stArr[0])) {
                                int newColumn = this.fields.length;
                                this.fieldsList.add(new DataField(dataArraySizeY));
                                this.copyFieldsListToFields();
                                this.fields[newColumn].Name = stArr[0];
                                this.fields[newColumn].readyName = true;
                                this.fields[newColumn].readyType = true;
                                this.htName.put(stArr[0], newColumn);
                            }
                            int column = this.htName.get(stArr[0]);
                            this.fields[column].DataArray[dataArrayCounter] = stArr[1];
                        }
                    }
                    if (cell.getComponent() != null && cell.getComponent() instanceof StiSimpleText) {
                        if (!this.fields[columnIndex2].readyName) {
                            String st = cell.getComponent().getName();
                            if (useAliases && cell.getComponent().getAlias() != null && cell.getComponent().getAlias().length() > 0) {
                                st = cell.getComponent().getAlias();
                            }
                            if (sTagArray != null) {
                                for (int tagIndex = 0; tagIndex < sTagArray.length; ++tagIndex) {
                                    String text = sTagArray[tagIndex].trim();
                                    if (!text.toLowerCase(Locale.getDefault()).startsWith(exportName) && !text.toLowerCase(Locale.getDefault()).startsWith("default")) continue;
                                    int firstIndex = text.indexOf("\"");
                                    if (firstIndex != -1) {
                                        int stringLength;
                                        if ((stringLength = text.indexOf("\"", ++firstIndex) - firstIndex) > 0) {
                                            st = text.substring(firstIndex, firstIndex + stringLength);
                                            if (text.toLowerCase(Locale.getDefault()).startsWith("default")) continue;
                                            break;
                                        }
                                        throw new IllegalArgumentException("Name of DataColumn not found in property: " + st);
                                    }
                                    throw new IllegalArgumentException("Name of DataColumn not found in property: " + st);
                                }
                            }
                            if (service.getExportFormat() == StiExportFormat.Dbf && st.length() > 10) {
                                st = st.substring(0, 10);
                            }
                            this.fields[columnIndex2].Name = st;
                            this.fields[columnIndex2].readyName = true;
                        }
                        if (!(this.fields[columnIndex2].readyType || sTagArray == null || service.getExportFormat() != StiExportFormat.Xml && service.getExportFormat() != StiExportFormat.Dbf)) {
                            String[] args = sTagArray[0].split(":", 3);
                            args[0] = args[0].trim().toLowerCase(Locale.getDefault());
                            if (args[0].startsWith("int")) {
                                this.fields[columnIndex2].Info[0] = StiExportDataType.Int.ordinal();
                                this.fields[columnIndex2].Info[1] = 15;
                            }
                            if (args[0].startsWith("long")) {
                                this.fields[columnIndex2].Info[0] = StiExportDataType.Long.ordinal();
                                this.fields[columnIndex2].Info[1] = 25;
                            }
                            if (args[0].startsWith("float")) {
                                this.fields[columnIndex2].Info[0] = StiExportDataType.Float.ordinal();
                                this.fields[columnIndex2].Info[1] = 15;
                                this.fields[columnIndex2].Info[2] = 5;
                            }
                            if (args[0].startsWith("double")) {
                                this.fields[columnIndex2].Info[0] = StiExportDataType.Double.ordinal();
                                this.fields[columnIndex2].Info[1] = 20;
                                this.fields[columnIndex2].Info[2] = 10;
                            }
                            if (args[0].startsWith("date")) {
                                this.fields[columnIndex2].Info[0] = StiExportDataType.Date.ordinal();
                                this.fields[columnIndex2].Info[1] = 8;
                                this.fields[columnIndex2].Info[2] = 0;
                            }
                            if (args.length > 1) {
                                args[1] = args[1].trim();
                                int param1 = 0;
                                try {
                                    param1 = Integer.parseInt(args[1]);
                                }
                                catch (Exception e) {
                                    param1 = 0;
                                }
                                finally {
                                    if (param1 > 0) {
                                        this.fields[columnIndex2].Info[1] = param1;
                                    }
                                }
                                if (args.length > 2) {
                                    args[2] = args[2].trim();
                                    int param2 = 0;
                                    try {
                                        param2 = Integer.parseInt(args[2]);
                                    }
                                    catch (Exception e) {
                                        param2 = 0;
                                    }
                                    finally {
                                        if (param2 > 0 && param2 < param1) {
                                            this.fields[columnIndex2].Info[2] = param2;
                                        }
                                    }
                                }
                            }
                            this.fields[columnIndex2].readyType = true;
                        }
                    }
                    StiRichText rtf = cell.getComponent() instanceof StiRichText ? (StiRichText)cell.getComponent() : null;
                    String str = cell.getText();
                    if (rtf != null && StiValidationUtil.isNotNullOrEmpty((String)rtf.unpackRTF())) {
                        str = StiRtfHelper.rtfToPlain((String)rtf.unpackRTF());
                    }
                    if (str == null) {
                        str = "";
                    }
                    if (str != null && str.length() > 0) {
                        if (service.getExportFormat() == StiExportFormat.Csv && ExportOptions.Csv.getUseMultilineText() || service.getExportFormat() == StiExportFormat.Xml) {
                            str = str.replaceAll("\r", "");
                        } else {
                            str = str.replaceAll("\n", " ");
                            str = str.replaceAll("\r", "");
                        }
                        if (service.getExportFormat() == StiExportFormat.Dbf && str.length() > 254) {
                            str = str.substring(0, 254);
                        }
                    }
                    this.fields[columnIndex2].DataArray[dataArrayCounter] = str;
                    continue;
                }
                this.fields[columnIndex2].DataArray[dataArrayCounter] = "";
            }
            ++dataArrayCounter;
        }
        for (int columnIndex3 = this.fieldsList.size() - 1; columnIndex3 >= 0; --columnIndex3) {
            if (this.fields[columnIndex3].readyName) continue;
            this.fieldsList.remove(columnIndex3);
        }
        this.copyFieldsListToFields();
        this.DataArrayLength = dataArraySizeY;
    }

    public void checkStylesNames() {
        Hashtable<String, String> hs = new Hashtable<String, String>();
        for (int indexStyle = 0; indexStyle < this.styles.size(); ++indexStyle) {
            StiCellStyle style = this.styles.get(indexStyle);
            String st = style.getStyleName();
            String stNum = "";
            Integer num = 0;
            while (hs.contains(st + stNum)) {
                Integer n = num;
                Integer n2 = num = Integer.valueOf(num + 1);
                stNum = num.toString();
            }
            if (!"".equals(stNum)) {
                st = st + stNum;
                style.setStyleName(st);
            }
            hs.put(st, st);
        }
    }

    public BufferedImage getRealImageData(StiCell cell, BufferedImage baseImage) {
        if (cell == null || cell.getComponent() == null || baseImage == null) {
            return null;
        }
        StiRectangle obj = this.imagesBaseRect.get(cell.getComponent());
        if (obj == null || !(obj instanceof StiRectangle)) {
            return null;
        }
        StiRectangle rectD = obj;
        double scaleX = this.isHtmlService && ExportOptions.Html.isPrintLayoutOptimization() ? 0.96 : 1.0;
        double scaleY = this.isHtmlService && ExportOptions.Html.isPrintLayoutOptimization() ? 0.956 : 1.0;
        double ll = this.round(rectD.getLeft() * scaleX);
        double tt = this.round(rectD.getTop() * scaleY);
        double rr = this.round(rectD.getRight() * scaleX);
        double bb = this.round(rectD.getBottom() * scaleY);
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        if (this.leftCached.get(ll) == null) {
            left = StiMapUtil.getIndexOf(this.coordX, ll);
            this.leftCached.put(ll, left);
        } else {
            left = this.leftCached.get(ll);
        }
        if (this.topCached.get(tt) == null) {
            top = StiMapUtil.getIndexOf(this.coordY, tt);
            this.topCached.put(tt, top);
        } else {
            top = this.topCached.get(tt);
        }
        if (this.leftCached.get(rr) == null) {
            right = StiMapUtil.getIndexOf(this.coordX, rr);
            this.leftCached.put(rr, right);
        } else {
            right = this.leftCached.get(rr);
        }
        if (this.topCached.get(bb) == null) {
            bottom = StiMapUtil.getIndexOf(this.coordY, bb);
            this.topCached.put(bb, bottom);
        } else {
            bottom = this.topCached.get(bb);
        }
        if (left == -1 || right == -1 || top == -1 || bottom == -1) {
            return null;
        }
        if (left == cell.getLeft() && right == cell.getLeft() + cell.getWidth() + 1 && top == cell.getTop() && bottom == cell.getTop() + cell.getHeight() + 1) {
            return null;
        }
        int ll2 = ((Double)StiMapUtil.getByIndex(this.coordX, cell.getLeft())).intValue();
        int tt2 = ((Double)StiMapUtil.getByIndex(this.coordY, cell.getTop())).intValue();
        int rr2 = ((Double)StiMapUtil.getByIndex(this.coordX, cell.getLeft() + cell.getWidth() + 1)).intValue();
        int bbc = cell.getTop() + cell.getHeight() + 1;
        if (bbc > this.coordY.size() - 1) {
            bbc = this.coordY.size() - 1;
        }
        int bb2 = ((Double)StiMapUtil.getByIndex(this.coordY, bbc)).intValue();
        double ppl = ((double)ll2 - ll) / (rr - ll);
        double ppr = ((double)rr2 - ll) / (rr - ll);
        double ppt = ((double)tt2 - tt) / (bb - tt);
        double ppb = ((double)bb2 - tt) / (bb - tt);
        int nl = (int)((double)baseImage.getWidth() * ppl);
        int nr = (int)Math.round((double)baseImage.getWidth() * ppr + 0.5);
        int nt = (int)((double)baseImage.getHeight() * ppt);
        int nb = (int)Math.round((double)baseImage.getHeight() * ppb + 0.5);
        BufferedImage bmp = new BufferedImage(nr - nl, nb - nt, 1);
        Graphics2D bmpGraphics = bmp.createGraphics();
        bmpGraphics.setColor(Color.WHITE);
        bmpGraphics.fillRect(0, 0, nr - nl, nb - nt);
        Graphics2D g = bmp.createGraphics();
        g.drawImage(baseImage, 0, 0, nr - nl, nb - nt, nl, nt, nr, nb, null);
        g.dispose();
        return bmp;
    }

    public void clear() {
        this.cells = null;
        this.cellsMap = null;
        this.styles = null;
        this.coordX = null;
        this.coordY = null;
        this.linePlacement = null;
        this.parentBandName = null;
        this.bordersX = null;
        this.bordersY = null;
        this.bookmarks = null;
        this.horizontalPageBreaks = null;
        this.cellStyles = null;
        this.coordXCheck = null;
        this.coordYCheck = null;
        this.coordXNew = null;
        this.coordYNew = null;
        this.coordXPrim = null;
        this.coordYPrim = null;
        this.leftCached = null;
        this.topCached = null;
        this.fields = null;
        this.fieldsList = null;
        this.htName = null;
    }

    public Hashtable<StiComponent, StiRectangle> getImagesBaseRect() {
        return this.imagesBaseRect;
    }

    public ArrayList<StiCellStyle> getStyles() {
        return this.styles;
    }

    public void setStyles(ArrayList<StiCellStyle> styles) {
        this.styles = styles;
    }

    public double getTotalHeight() {
        return this.totalHeight;
    }

    public void setTotalHeight(double totalHeight) {
        this.totalHeight = totalHeight;
    }

    public double getTotalWidth() {
        return this.totalWidth;
    }

    public void setTotalWidth(double totalWidth) {
        this.totalWidth = totalWidth;
    }

    public SortedMap<Double, Double> getCoordX() {
        return this.coordX;
    }

    public void setCoordX(SortedMap<Double, Double> coordX) {
        this.coordX = coordX;
    }

    public SortedMap<Double, Double> getCoordY() {
        return this.coordY;
    }

    public void setCoordY(SortedMap<Double, Double> coordY) {
        this.coordY = coordY;
    }

    public StiCell[][] getCells() {
        return this.cells;
    }

    public StiCellStyle[][] getCellStyles() {
        return this.cellStyles;
    }

    public String[][] getBookmarks() {
        return this.bookmarks;
    }

    public StiBorderSide[][] getBordersX() {
        return this.bordersX;
    }

    public StiBorderSide[][] getBordersY() {
        return this.bordersY;
    }

    public ArrayList<Integer> getHorizontalPageBreaks() {
        return this.horizontalPageBreaks;
    }

    public StiTableLineInfo[] getLinePlacement() {
        return this.linePlacement;
    }

    public String[] getParentBandName() {
        return this.parentBandName;
    }

    public DataField[] getFields() {
        return this.fields;
    }

    public List<StiBorderSide> getBorderSides() {
        return this.borderSides;
    }

    public class DataField {
        public String Name = "";
        public int[] Info = new int[3];
        public String FormatString = "";
        public String[] DataArray;
        public boolean readyName;
        public boolean readyType;

        public DataField(int size) {
            this.DataArray = new String[size];
            this.readyName = false;
            this.readyType = false;
        }
    }

    public static enum StiTableLineInfo {
        Empty,
        Unknown,
        PageHeader,
        PageFooter,
        HeaderAP,
        FooterAP,
        HeaderD,
        FooterD,
        Data,
        Trash;

    }
}

