/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.tools;

import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.enums.StiRangeType;

public class StiPagesRange {
    public static final StiPagesRange All = new StiPagesRange();
    private StiRangeType rangeType = StiRangeType.All;
    private String pageRanges = "";
    private Integer currentPage;

    public StiPagesRange() {
        this(StiRangeType.All, "", 0);
    }

    public StiPagesRange(int currentPage) {
        this(StiRangeType.CurrentPage, "", currentPage);
    }

    public StiPagesRange(String pageRanges) {
        this(StiRangeType.Pages, pageRanges, 0);
    }

    public StiPagesRange(StiRangeType rangeType, String pageRanges, int currentPage) {
        this.rangeType = rangeType;
        this.pageRanges = pageRanges;
        this.currentPage = currentPage;
    }

    public StiPagesCollection getSelectedPages(StiPagesCollection originalPages) {
        StiPagesCollection pages = new StiPagesCollection(originalPages.getReport());
        pages.setCacheMode(originalPages.getCacheMode());
        if (this.rangeType == StiRangeType.Pages) {
            if (this.pageRanges != null && this.pageRanges.length() > 0) {
                String[] pageNumbers;
                for (String number : pageNumbers = this.pageRanges.split(",")) {
                    if (number.indexOf("-") == -1) {
                        try {
                            int pageIndex = Integer.parseInt(number.trim());
                            if (pageIndex < 1 || pageIndex > originalPages.size()) continue;
                            pages.add((StiPage)originalPages.get(pageIndex - 1));
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    String[] numbers = number.split("-");
                    try {
                        int index;
                        int startIndex = Integer.parseInt(numbers[0].trim());
                        int endIndex = Integer.parseInt(numbers[1].trim());
                        endIndex = Math.min(endIndex, originalPages.size());
                        if (startIndex < 1 || startIndex > originalPages.size() || endIndex < 1 || endIndex > originalPages.size()) continue;
                        if (startIndex <= endIndex) {
                            for (index = startIndex; index <= endIndex; ++index) {
                                pages.add((StiPage)originalPages.get(index - 1));
                            }
                            continue;
                        }
                        for (index = startIndex; index >= endIndex; --index) {
                            pages.add((StiPage)originalPages.get(index - 1));
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (pages.size() != 0) {
                return pages;
            }
        } else if (this.rangeType == StiRangeType.CurrentPage) {
            if (this.currentPage >= 0 && this.currentPage < originalPages.size()) {
                pages.add((StiPage)originalPages.get(this.currentPage));
            }
            if (pages.size() != 0) {
                return pages;
            }
        }
        for (StiPage page : originalPages) {
            pages.add(page);
        }
        return pages;
    }

    public StiRangeType getRangeType() {
        return this.rangeType;
    }

    public void setRangeType(StiRangeType rangeType) {
        this.rangeType = rangeType;
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public String getPageRanges() {
        return this.pageRanges;
    }
}

