/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.globalization;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.StiSerializedObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToAttributes;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.globalization.IStiGlobalizationProvider;
import com.stimulsoft.report.globalization.StiGlobalizationItem;
import com.stimulsoft.report.globalization.StiGlobalizationItemCollection;
import java.util.Hashtable;
import java.util.Iterator;

public class StiGlobalizationContainer
extends StiSerializedObject
implements IStiSerializable,
IStiSerializableToAttributes,
IStiJsonReportObject {
    private String cultureName = "";
    private StiGlobalizationItemCollection items = new StiGlobalizationItemCollection();

    public StiGlobalizationContainer() {
        this("en");
    }

    public StiGlobalizationContainer(String cultureName) {
        this.cultureName = cultureName;
    }

    public Hashtable<String, String> getAllStringsForReport(StiReport report) {
        Hashtable<String, String> compsList = new Hashtable<String, String>();
        StiComponentsCollection comps = report.GetComponents();
        for (StiComponent comp : comps) {
            String[] strs;
            IStiGlobalizationProvider provider = comp instanceof IStiGlobalizationProvider ? (IStiGlobalizationProvider)((Object)comp) : null;
            if (provider == null) continue;
            for (String str : strs = provider.getAllStrings()) {
                String data = String.format("%s.%s", comp.getName(), str);
                String value = provider.getString(str);
                if (value == null) continue;
                compsList.put(data, value);
            }
        }
        Iterator i$ = report.getDictionary().getVariables().iterator();
        while (i$.hasNext()) {
            StiVariable variable = (StiVariable)i$.next();
            compsList.put("Variable." + variable.getName(), variable.getValueObject().toString());
        }
        compsList.put("ReportAuthor", report.getReportAuthor());
        compsList.put("ReportDescription", report.getReportDescription());
        compsList.put("ReportAlias", report.getReportAlias());
        return compsList;
    }

    public void localizeReport(StiReport report) {
        Hashtable<String, StiVariable> variables = new Hashtable<String, StiVariable>();
        Iterator i$ = report.getDictionary().getVariables().iterator();
        while (i$.hasNext()) {
            StiVariable variable = (StiVariable)i$.next();
            variables.put("Variable." + variable.getName(), variable);
        }
        for (StiGlobalizationItem item : this.getItems()) {
            String str = item.getPropertyName();
            if ("ReportAuthor".equals(str)) {
                report.setReportAuthor(item.getText());
                continue;
            }
            if ("ReportDescription".equals(str)) {
                report.setReportDescription(item.getText());
                continue;
            }
            if ("ReportAlias".equals(str)) {
                report.setReportAlias(item.getText());
                continue;
            }
            if (variables.get(str) instanceof StiVariable) {
                StiVariable variable = (StiVariable)variables.get(str);
                variable.setValue(item.getText());
                continue;
            }
            int index = str.indexOf(".");
            if (index == -1) continue;
            String compName = str.substring(0, index);
            String propertyName = str.substring(index + 1);
            IStiGlobalizationProvider provider = report.GetComponents().get(compName) instanceof IStiGlobalizationProvider ? (IStiGlobalizationProvider)((Object)report.GetComponents().get(compName)) : null;
            if (provider == null) continue;
            provider.setString(propertyName, item.getText());
        }
    }

    public void fillItemsFromReport(StiReport report) {
        Hashtable<String, String> list = this.getAllStringsForReport(report);
        Hashtable<String, StiGlobalizationItem> hash = new Hashtable<String, StiGlobalizationItem>();
        for (StiGlobalizationItem item : this.getItems()) {
            hash.put(item.getPropertyName(), item);
        }
        for (String str : list.keySet()) {
            if (hash.containsKey(str)) continue;
            this.getItems().add(new StiGlobalizationItem(str, list.get(str)));
        }
    }

    public void removeUnlocalizedItemsFromReport(StiReport report) {
        Hashtable<String, String> list = this.getAllStringsForReport(report);
        Hashtable<String, StiGlobalizationItem> hash = new Hashtable<String, StiGlobalizationItem>();
        for (StiGlobalizationItem item : this.getItems()) {
            hash.put(item.getPropertyName(), item);
        }
        for (String str : list.keySet()) {
            String value = list.get(str);
            StiGlobalizationItem item = (StiGlobalizationItem)hash.get(str);
            if (value == null || !value.equals(item.getText())) continue;
            this.getItems().remove(item);
        }
    }

    @StiSerializable
    public String getCultureName() {
        return this.cultureName;
    }

    public void setCultureName(String cultureName) {
        this.cultureName = cultureName;
    }

    @StiSerializable
    public StiGlobalizationItemCollection getItems() {
        return this.items;
    }

    public void setItems(StiGlobalizationItemCollection items) {
        this.items = items;
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyStringNullOfEmpty("CultureName", this.getCultureName());
        if (this.getItems().size() > 0) {
            JSONObject jObjectArray = new JSONObject();
            Integer index = 0;
            for (StiGlobalizationItem item : this.getItems()) {
                jObjectArray.AddPropertyJObject(index.toString(), item.SaveToJsonObject(mode));
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
            jObject.AddPropertyJObject("Items", jObjectArray);
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("CultureName")) {
                this.cultureName = (String)property.Value;
                continue;
            }
            if (!property.Name.equals("Items")) continue;
            for (JProperty prop1 : ((JSONObject)property.Value).Properties()) {
                StiGlobalizationItem item = new StiGlobalizationItem();
                item.LoadFromJsonObject((JSONObject)prop1.Value);
                this.items.add(item);
            }
        }
    }
}

