/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.helpers;

import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.export.tools.StiImageFormat;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.ImageIO;

public class StiHyperlinkProcessor {
    public static final String ServerIdent = "stimulsoft-server://";
    public static final String ResourceIdent = "resource://";
    public static final String VariableIdent = "variable://";
    public static final String FileIdent = "file://";

    public static boolean isResourceHyperlink(String hyperlink) {
        return !StiValidationUtil.isNullOrWhiteSpace((String)hyperlink) && hyperlink.toLowerCase().startsWith(ResourceIdent);
    }

    public static boolean isVariableHyperlink(String hyperlink) {
        return !StiValidationUtil.isNullOrWhiteSpace((String)hyperlink) && hyperlink.toLowerCase().startsWith(VariableIdent);
    }

    public static String getVariableNameFromHyperlink(String hyperlink) {
        if (!StiHyperlinkProcessor.isVariableHyperlink(hyperlink)) {
            return null;
        }
        return hyperlink.substring(VariableIdent.length());
    }

    public static StiImage getImage(StiReport report, String hyperlink) throws FileNotFoundException, IOException {
        StiVariable variable = StiHyperlinkProcessor.getVariable(report, StiHyperlinkProcessor.getVariableNameFromHyperlink(hyperlink));
        if (variable != null) {
            return (StiImage)variable.getValueObject();
        }
        String file = StiHyperlinkProcessor.getFileNameFromHyperlink(hyperlink);
        if (file != null) {
            return new File(file).exists() ? StiImageHelper.FromFile(file) : null;
        }
        BufferedImage bi = ImageIO.read(new URL(hyperlink));
        StiImage img = new StiImage();
        img.setImageBytesToDraw(StiImageHelper.imageToBase64(bi, StiImageFormat.Png));
        return img;
    }

    private static StiVariable getVariable(StiReport report, String variableName) {
        if (report == null || StiValidationUtil.isNullOrWhiteSpace((String)variableName)) {
            return null;
        }
        variableName = variableName.toLowerCase().trim();
        Iterator i$ = report.getDictionary().getVariables().iterator();
        while (i$.hasNext()) {
            StiVariable variable = (StiVariable)i$.next();
            if (variable.getName() == null || !variable.getName().toLowerCase().trim().equals(variableName)) continue;
            return variable;
        }
        return null;
    }

    public static String getFileNameFromHyperlink(String hyperlink) {
        if (!StiHyperlinkProcessor.isFileHyperlink(hyperlink)) {
            return null;
        }
        return hyperlink.substring(FileIdent.length());
    }

    public static boolean isFileHyperlink(String hyperlink) {
        return !StiValidationUtil.isNullOrWhiteSpace((String)hyperlink) && hyperlink.toLowerCase().startsWith(FileIdent);
    }

    public static String createResourceName(String name) {
        return String.format("%s%s", ResourceIdent, name);
    }
}

