/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiCap;
import com.stimulsoft.base.drawing.StiCapStyle;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.path.StiPathLineTo;
import com.stimulsoft.base.drawing.path.StiPathMoveTo;
import com.stimulsoft.base.enums.StiHighlightState;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiRestrictionsHelper;
import com.stimulsoft.report.components.simplecomponents.StiVerticalLinePrimitive;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.components.StiLinePrimitivePainter;
import java.util.ArrayList;

public class StiVerticalLinePrimitivePainter
extends StiLinePrimitivePainter {
    @Override
    public void paint(StiComponent component, StiPaintArgs args) {
        StiVerticalLinePrimitive primitive = (StiVerticalLinePrimitive)component;
        Double zoom = primitive.getReport().getInfo().getZoom();
        Double pageZoom = primitive.getReport().getInfo().getPageZoom();
        if (primitive.getEnabled() || primitive.getIsDesigning()) {
            StiGraphics g = args.getG();
            StiRectangle rect = primitive.getPaintRectangle();
            if (rect.getWidth() > 0.0 && rect.getHeight() > 0.0 && args.intersectsWith(rect).booleanValue()) {
                Double x = rect.getX();
                if (primitive.getPage().getOffsetRectangle().getWidth() < 0.0) {
                    x = rect.getRight();
                }
                if ((primitive.getHighlightState() == StiHighlightState.Show || primitive.getHighlightState() == StiHighlightState.Active) && !primitive.getReport().getInfo().getIsComponentsMoving() && StiRestrictionsHelper.isAllowSelect(primitive)) {
                    StiPen pen2 = new StiPen(primitive.getSize(), StiColor.fromAColor((int)150, (StiColor)StiColorEnum.Gold.color()));
                    ArrayList<Object> path = new ArrayList<Object>();
                    path.add(new StiPathMoveTo(x, Double.valueOf(rect.getY())));
                    path.add(new StiPathLineTo(x, Double.valueOf(rect.getBottom())));
                    g.drawPath(path, pen2, null, zoom.doubleValue(), pageZoom.doubleValue());
                }
                StiPen pen = new StiPen(primitive.getSize(), primitive.getColor(), primitive.getStyle());
                if (primitive.getStyle().equals((Object)StiPenStyle.Double)) {
                    g.drawLineXY(Double.valueOf(x - zoom), Double.valueOf(rect.getY()), Double.valueOf(x - zoom), Double.valueOf(rect.getBottom()), pen, zoom);
                    g.drawLineXY(Double.valueOf(x + zoom), Double.valueOf(rect.getY()), Double.valueOf(x + zoom), Double.valueOf(rect.getBottom()), pen, zoom);
                } else {
                    g.drawLineXY(x, Double.valueOf(rect.getY()), x, Double.valueOf(rect.getBottom()), pen, zoom);
                }
                this.drawCap(g, primitive, rect);
                this.paintEvents(primitive, args.getG(), rect);
                this.paintConditions(primitive, args.getG(), rect);
            }
        }
    }

    @Override
    public void paintSelection(StiComponent component, StiPaintArgs args) {
        StiGraphics g = args.getG();
        Double zoom = component.getReport().getInfo().getZoom();
        Double pageZoom = component.getReport().getInfo().getPageZoom();
        if (component.getIsDesigning() && component.getIsSelected() && !component.getReport().getInfo().getIsComponentsMoving()) {
            StiRectangle rect = component.getPaintRectangle();
            Double size = 3.5;
            if (component.getLinked()) {
                size = 4.5;
            }
            if (component.getLocked()) {
                this.drawDot(g, StiPen.RED, rect.getX(), rect.getY(), size, zoom, pageZoom);
                this.drawDot(g, StiPen.RED, rect.getX(), rect.getBottom(), size, zoom, pageZoom);
            } else {
                this.drawDot(g, StiPen.DIM_GRAY, rect.getX(), rect.getY(), size, zoom, pageZoom);
                this.drawDot(g, StiPen.DIM_GRAY, rect.getX(), rect.getBottom(), size, zoom, pageZoom);
            }
        }
    }

    private void drawCap(StiGraphics g, StiVerticalLinePrimitive primitive, StiRectangle paintRect) {
        StiRectangle clRect;
        Double zoom = primitive.getReport().getInfo().getZoom();
        Double pageZoom = primitive.getReport().getInfo().getPageZoom();
        ArrayList<Object> path = new ArrayList<Object>();
        StiCap startCap = primitive.getStartCap();
        if (!startCap.getStyle().equals((Object)StiCapStyle.None)) {
            clRect = new StiRectangle(paintRect.getX() - (double)startCap.getWidth() * zoom / 2.0, paintRect.getY(), (double)startCap.getWidth() * zoom, (double)startCap.getHeight() * zoom);
            StiPen startCapPen = new StiPen(primitive.getSize(), startCap.getColor());
            StiSolidBrush startCapBrush = startCap.getFill() ? new StiSolidBrush(startCap.getColor()) : null;
            switch (startCap.getStyle()) {
                case Arrow: {
                    path.add(new StiPathMoveTo(Double.valueOf(clRect.getX()), Double.valueOf(clRect.getBottom())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX() + clRect.getWidth() / 2.0), Double.valueOf(clRect.getY())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getRight()), Double.valueOf(clRect.getBottom())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX()), Double.valueOf(clRect.getBottom())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX() + clRect.getWidth() / 2.0), Double.valueOf(clRect.getY())));
                    g.drawPath(path, startCapPen, (StiBrush)startCapBrush, zoom.doubleValue(), pageZoom.doubleValue());
                    break;
                }
                case Diamond: {
                    clRect.move(Double.valueOf(0.0), Double.valueOf(-clRect.getHeight() / 2.0));
                    path.add(new StiPathMoveTo(Double.valueOf(clRect.getX()), Double.valueOf(clRect.getY() + clRect.getHeight() / 2.0)));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX() + clRect.getWidth() / 2.0), Double.valueOf(clRect.getY())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getRight()), Double.valueOf(clRect.getY() + clRect.getHeight() / 2.0)));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX() + clRect.getWidth() / 2.0), Double.valueOf(clRect.getBottom())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX()), Double.valueOf(clRect.getY() + clRect.getHeight() / 2.0)));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX() + clRect.getWidth() / 2.0), Double.valueOf(clRect.getY())));
                    g.drawPath(path, startCapPen, (StiBrush)startCapBrush, zoom.doubleValue(), pageZoom.doubleValue());
                    break;
                }
                case Open: {
                    path.add(new StiPathMoveTo(Double.valueOf(clRect.getX()), Double.valueOf(clRect.getBottom())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX() + clRect.getWidth() / 2.0), Double.valueOf(clRect.getY())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getRight()), Double.valueOf(clRect.getBottom())));
                    g.drawPath(path, startCapPen, null, zoom.doubleValue(), pageZoom.doubleValue());
                    break;
                }
                case Oval: {
                    g.drawEllise(clRect.move(Double.valueOf(0.0), Double.valueOf(-clRect.getHeight() / 2.0)), startCapPen, (StiBrush)startCapBrush, zoom, pageZoom);
                    break;
                }
                case Square: {
                    g.drawRectangle(clRect.move(Double.valueOf(0.0), Double.valueOf(-clRect.getHeight() / 2.0)), startCapPen, (StiBrush)startCapBrush, zoom, pageZoom);
                    break;
                }
                case Stealth: {
                    path.add(new StiPathMoveTo(Double.valueOf(clRect.getX()), Double.valueOf(clRect.getBottom())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX() + clRect.getWidth() / 2.0), Double.valueOf(clRect.getY())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getRight()), Double.valueOf(clRect.getBottom())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX() + clRect.getWidth() / 2.0), Double.valueOf(clRect.getBottom() - clRect.getWidth() / 3.0)));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX()), Double.valueOf(clRect.getBottom())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX() + clRect.getWidth() / 2.0), Double.valueOf(clRect.getY())));
                    g.drawPath(path, startCapPen, (StiBrush)startCapBrush, zoom.doubleValue(), pageZoom.doubleValue());
                }
            }
        }
        path.clear();
        StiCap endCap = primitive.getEndCap();
        if (!endCap.getStyle().equals((Object)StiCapStyle.None)) {
            StiPen endCapPen = new StiPen(primitive.getSize(), endCap.getColor());
            StiSolidBrush endCapBrush = endCap.getFill() ? new StiSolidBrush(endCap.getColor()) : null;
            clRect = new StiRectangle(paintRect.getX() - (double)endCap.getWidth() * zoom / 2.0, paintRect.getBottom() - (double)endCap.getHeight() * zoom, (double)endCap.getWidth() * zoom, (double)endCap.getHeight() * zoom);
            switch (endCap.getStyle()) {
                case Arrow: {
                    path.add(new StiPathMoveTo(Double.valueOf(clRect.getX()), Double.valueOf(clRect.getY())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX() + clRect.getWidth() / 2.0), Double.valueOf(clRect.getBottom())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getRight()), Double.valueOf(clRect.getY())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX()), Double.valueOf(clRect.getY())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX() + clRect.getWidth() / 2.0), Double.valueOf(clRect.getBottom())));
                    g.drawPath(path, endCapPen, (StiBrush)endCapBrush, zoom.doubleValue(), pageZoom.doubleValue());
                    break;
                }
                case Diamond: {
                    clRect.move(Double.valueOf(0.0), Double.valueOf(clRect.getHeight() / 2.0));
                    path.add(new StiPathMoveTo(Double.valueOf(clRect.getX()), Double.valueOf(clRect.getY() + clRect.getHeight() / 2.0)));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX() + clRect.getWidth() / 2.0), Double.valueOf(clRect.getY())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getRight()), Double.valueOf(clRect.getY() + clRect.getHeight() / 2.0)));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX() + clRect.getWidth() / 2.0), Double.valueOf(clRect.getBottom())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX()), Double.valueOf(clRect.getY() + clRect.getHeight() / 2.0)));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX() + clRect.getWidth() / 2.0), Double.valueOf(clRect.getY())));
                    g.drawPath(path, endCapPen, (StiBrush)endCapBrush, zoom.doubleValue(), pageZoom.doubleValue());
                    break;
                }
                case Open: {
                    path.add(new StiPathMoveTo(Double.valueOf(clRect.getX()), Double.valueOf(clRect.getY())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX() + clRect.getWidth() / 2.0), Double.valueOf(clRect.getBottom())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getRight()), Double.valueOf(clRect.getY())));
                    g.drawPath(path, endCapPen, null, zoom.doubleValue(), pageZoom.doubleValue());
                    break;
                }
                case Oval: {
                    g.drawEllise(clRect.move(Double.valueOf(0.0), Double.valueOf(clRect.getHeight() / 2.0)), endCapPen, (StiBrush)endCapBrush, zoom, pageZoom);
                    break;
                }
                case Square: {
                    g.drawRectangle(clRect.move(Double.valueOf(0.0), Double.valueOf(clRect.getHeight() / 2.0)), endCapPen, (StiBrush)endCapBrush, zoom, pageZoom);
                    break;
                }
                case Stealth: {
                    path.add(new StiPathMoveTo(Double.valueOf(clRect.getRight()), Double.valueOf(clRect.getY())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX() + clRect.getWidth() / 2.0), Double.valueOf(clRect.getBottom())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX()), Double.valueOf(clRect.getY())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX() + clRect.getWidth() / 2.0), Double.valueOf(clRect.getY() + clRect.getHeight() / 3.0)));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getRight()), Double.valueOf(clRect.getY())));
                    path.add(new StiPathLineTo(Double.valueOf(clRect.getX() + clRect.getWidth() / 2.0), Double.valueOf(clRect.getBottom())));
                    g.drawPath(path, endCapPen, (StiBrush)endCapBrush, zoom.doubleValue(), pageZoom.doubleValue());
                }
            }
        }
    }
}

