/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.indicator;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.enums.StiIcon;
import com.stimulsoft.report.components.indicators.StiIconSetHelper;
import com.stimulsoft.report.components.indicators.StiIconSetIndicator;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.painters.indicator.StiIndicatorTypePainter;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class StiIconSetIndicatorTypePainter
extends StiIndicatorTypePainter {
    @Override
    public StiRectangle paint(StiGraphics g, StiComponent component, StiRectangle rect) throws IOException {
        StiText textComp = (StiText)component;
        Double zoom = component.getReport().getInfo().getZoom();
        StiRectangle rectComp = rect.clone();
        if (zoom > 1.0) {
            rectComp.inflate(Double.valueOf(-1.0 * zoom), Double.valueOf(-1.0 * zoom));
        } else {
            rectComp.inflate(Double.valueOf(-1.0), Double.valueOf(-1.0));
        }
        StiIconSetIndicator indicator = (StiIconSetIndicator)textComp.getIndicator();
        if (indicator != null && !indicator.getIcon().equals((Object)StiIcon.None)) {
            BufferedImage image = StiIconSetHelper.getIconImage(indicator.getIcon());
            Double imageWidth = (double)image.getWidth() * zoom;
            Double imageHeight = (double)image.getHeight() * zoom;
            StiRectangle iconRect = rectComp.clone();
            switch (indicator.getAlignment()) {
                case TopLeft: {
                    iconRect = new StiRectangle(iconRect.getX(), iconRect.getY(), imageWidth.doubleValue(), imageHeight.doubleValue());
                    rect.setX(rect.getX() + iconRect.getWidth() + 1.0);
                    rect.setWidth(rect.getWidth() - iconRect.getWidth() + 1.0);
                    break;
                }
                case TopCenter: {
                    iconRect = new StiRectangle(iconRect.getX() + (iconRect.getWidth() - imageWidth) / 2.0, iconRect.getY(), imageWidth.doubleValue(), imageHeight.doubleValue());
                    break;
                }
                case TopRight: {
                    iconRect = new StiRectangle(iconRect.getRight() - (double)image.getWidth(), iconRect.getY(), imageWidth.doubleValue(), imageHeight.doubleValue());
                    rect.setWidth(rect.getWidth() - iconRect.getWidth() + 1.0);
                    break;
                }
                case MiddleLeft: {
                    iconRect = new StiRectangle(iconRect.getX(), iconRect.getY() + (iconRect.getHeight() - imageHeight) / 2.0, imageWidth.doubleValue(), imageHeight.doubleValue());
                    rect.setX(rect.getX() + iconRect.getWidth() + 1.0);
                    rect.setWidth(rect.getWidth() - iconRect.getWidth() + 1.0);
                    break;
                }
                case MiddleCenter: {
                    iconRect = new StiRectangle(iconRect.getX() + (iconRect.getWidth() - imageWidth) / 2.0, iconRect.getY() + (iconRect.getHeight() - imageHeight) / 2.0, imageWidth.doubleValue(), imageHeight.doubleValue());
                    break;
                }
                case MiddleRight: {
                    iconRect = new StiRectangle(iconRect.getRight() - imageWidth, iconRect.getY() + (iconRect.getHeight() - imageHeight) / 2.0, imageWidth.doubleValue(), imageHeight.doubleValue());
                    rect.setWidth(rect.getWidth() - iconRect.getWidth() + 1.0);
                    break;
                }
                case BottomLeft: {
                    iconRect = new StiRectangle(iconRect.getX(), iconRect.getBottom() - imageHeight, imageWidth.doubleValue(), imageHeight.doubleValue());
                    rect.setX(rect.getX() + iconRect.getWidth() + 1.0);
                    rect.setWidth(rect.getWidth() - iconRect.getWidth() + 1.0);
                    break;
                }
                case BottomCenter: {
                    iconRect = new StiRectangle(iconRect.getX() + (iconRect.getWidth() - imageWidth) / 2.0, iconRect.getBottom() - imageHeight, imageWidth.doubleValue(), imageHeight.doubleValue());
                    break;
                }
                case BottomRight: {
                    iconRect = new StiRectangle(iconRect.getRight() - imageWidth, iconRect.getBottom() - imageHeight, imageWidth.doubleValue(), imageHeight.doubleValue());
                    rect.setWidth(rect.getWidth() - iconRect.getWidth() + 1.0);
                }
            }
            g.drawImage(image, iconRect, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), zoom);
        }
        return rect;
    }
}

