/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.styles;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.StiDeserializerControler;
import com.stimulsoft.base.serializing.StiSerializedObject;
import com.stimulsoft.base.serializing.StiSerializerControler;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.lib.commoninterface.IStiName;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.crossTab.StiCrossTab;
import com.stimulsoft.report.enums.StiStyleElements;
import com.stimulsoft.report.styles.StiChartStyle;
import com.stimulsoft.report.styles.StiCrossTabStyle;
import com.stimulsoft.report.styles.StiDialogStyle;
import com.stimulsoft.report.styles.StiStyle;
import com.stimulsoft.report.styles.conditions.StiStyleConditionsCollection;
import java.util.Arrays;

public abstract class StiBaseStyle
extends StiSerializedObject
implements Cloneable,
IStiName,
IStiJsonReportObject {
    private String description = "";
    private String name = "";
    public StiReport report;
    private StiStyleConditionsCollection conditions;
    private String collectionName = "";

    public boolean equals(Object obj, boolean allowEqualName, boolean allowEqualDescription) {
        if (this instanceof StiStyle) {
            StiStyle style1;
            StiStyle stiStyle = style1 = obj instanceof StiStyle ? (StiStyle)obj : null;
            if (style1 == null) {
                return false;
            }
            StiStyle style2 = (StiStyle)this;
            if (!style1.getBorder().equals((Object)style2.getBorder())) {
                return false;
            }
            if (!style1.getBrush().equals(style2.getBrush())) {
                return false;
            }
            if (!style1.getFont().equals((Object)style2.getFont())) {
                return false;
            }
            if (style1.getImage() == null && style1.getImage() != null) {
                return false;
            }
            if (style1.getImage() != null && style1.getImage() == null) {
                return false;
            }
            if (!style1.getTextBrush().equals(style2.getTextBrush())) {
                return false;
            }
            if (!style1.getCollectionName().equals(style2.getCollectionName())) {
                return false;
            }
            if (!style1.getConditions().equals(style2.getConditions())) {
                return false;
            }
            if (style1.getAllowUseBorderFormatting() != style2.getAllowUseBorderFormatting()) {
                return false;
            }
            if (style1.getAllowUseBorderSides() != style2.getAllowUseBorderSides()) {
                return false;
            }
            if (style1.getAllowUseborderSidesFromLocation() != style2.getAllowUseborderSidesFromLocation()) {
                return false;
            }
            if (style1.getAllowUseBrush() != style2.getAllowUseBrush()) {
                return false;
            }
            if (style1.getAllowUseFont() != style2.getAllowUseFont()) {
                return false;
            }
            if (style1.getAllowUseHorAlignment() != style2.getAllowUseHorAlignment()) {
                return false;
            }
            if (style1.getAllowUseImage() != style2.getAllowUseImage()) {
                return false;
            }
            if (style1.getAllowUseTextBrush() != style2.getAllowUseTextBrush()) {
                return false;
            }
            if (style1.getAllowUseVertAlignment() != style2.getAllowUseVertAlignment()) {
                return false;
            }
            if (style1.getHorAlignment() != style2.getHorAlignment()) {
                return false;
            }
            if (style1.getVertAlignment() != style2.getVertAlignment()) {
                return false;
            }
            if (allowEqualName && !StiValidationUtil.equals((Object)style1.getName(), (Object)style2.getName())) {
                return false;
            }
            return !allowEqualDescription || StiValidationUtil.equals((Object)style1.getDescription(), (Object)style2.getDescription());
        }
        if (this instanceof StiChartStyle) {
            StiChartStyle style1;
            StiChartStyle stiChartStyle = style1 = obj instanceof StiChartStyle ? (StiChartStyle)obj : null;
            if (style1 == null) {
                return false;
            }
            StiChartStyle style2 = (StiChartStyle)this;
            if (!style1.getBorder().equals((Object)style2.getBorder())) {
                return false;
            }
            if (!style1.getBrush().equals(style2.getBrush())) {
                return false;
            }
            if (!style1.getBasicStyleColor().equals(style2.getBasicStyleColor())) {
                return false;
            }
            if (!style1.getBrushType().equals((Object)style2.getBrushType())) {
                return false;
            }
            if (!Arrays.equals(style1.getStyleColors(), style2.getStyleColors())) {
                return false;
            }
            if (allowEqualName && !StiValidationUtil.equals((Object)style1.getName(), (Object)style2.getName())) {
                return false;
            }
            return !allowEqualDescription || StiValidationUtil.equals((Object)style1.getDescription(), (Object)style2.getDescription());
        }
        if (this instanceof StiCrossTabStyle) {
            StiCrossTabStyle style1;
            StiCrossTabStyle stiCrossTabStyle = style1 = obj instanceof StiCrossTabStyle ? (StiCrossTabStyle)obj : null;
            if (style1 == null) {
                return false;
            }
            StiCrossTabStyle style2 = (StiCrossTabStyle)this;
            if (!StiValidationUtil.equals((Object)style1.getColor(), (Object)style2.getColor())) {
                return false;
            }
            if (allowEqualName && !StiValidationUtil.equals((Object)style1.getName(), (Object)style2.getName())) {
                return false;
            }
            return !allowEqualDescription || StiValidationUtil.equals((Object)style1.getDescription(), (Object)style2.getDescription());
        }
        if (this instanceof StiDialogStyle) {
            StiDialogStyle style1;
            StiDialogStyle stiDialogStyle = style1 = obj instanceof StiDialogStyle ? (StiDialogStyle)obj : null;
            if (style1 == null) {
                return false;
            }
            StiDialogStyle style2 = (StiDialogStyle)this;
            if (!style1.getForeColor().equals(style2.getForeColor())) {
                return false;
            }
            if (!style1.getBackColor().equals(style2.getBackColor())) {
                return false;
            }
            if (style1.getAllowUseFont() != style2.getAllowUseFont()) {
                return false;
            }
            if (style1.getAllowUseBackColor() != style2.getAllowUseBackColor()) {
                return false;
            }
            if (style1.getAllowUseForeColor() != style2.getAllowUseForeColor()) {
                return false;
            }
            if (allowEqualName && !StiValidationUtil.equals((Object)style1.getName(), (Object)style2.getName())) {
                return false;
            }
            return !allowEqualDescription || StiValidationUtil.equals((Object)style1.getDescription(), (Object)style2.getDescription());
        }
        return false;
    }

    public static StiBaseStyle getStyle(StiComponent component, StiStyleElements styleElements) {
        return StiBaseStyle.getStyle(component, styleElements, null);
    }

    public static StiBaseStyle getStyle(StiComponent component, StiStyleElements styleElements, StiBaseStyle componentStyle) {
        if (!(component instanceof StiChart) && !(component instanceof StiCrossTab)) {
            StiStyle style = new StiStyle();
            style.GetStyleFromComponent(component, styleElements, componentStyle);
            return style;
        }
        return null;
    }

    public static StiBaseStyle getStyle(StiComponent component) {
        return StiBaseStyle.getStyle(component, StiStyleElements.All, null);
    }

    public static StiBaseStyle getStyle(StiComponent component, StiBaseStyle componentStyle) {
        return StiBaseStyle.getStyle(component, StiStyleElements.All, componentStyle);
    }

    public StiBaseStyle(String name, String description, StiReport report) {
        this.report = report;
        this.name = name;
        this.description = description;
    }

    public StiBaseStyle(String name, String description) {
        this(name, description, null);
    }

    public StiBaseStyle(String name) {
        this(name, "");
    }

    public StiBaseStyle() {
        this("");
    }

    public final void GetStyleFromComponents(StiComponentsCollection comps, StiStyleElements styleElements) {
        for (int index = comps.size() - 1; index >= 0; --index) {
            this.GetStyleFromComponent((StiComponent)comps.get(index), styleElements);
        }
    }

    public String toString() {
        if (StiValidationUtil.isNotBlank((String)this.getName())) {
            return this.getName();
        }
        return this.getDescription();
    }

    public abstract void GetStyleFromComponent(StiComponent var1, StiStyleElements var2);

    public abstract void SetStyleToComponent(StiComponent var1);

    @StiDefaulValue(value="")
    @StiSerializable
    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String value) {
        this.description = value;
    }

    @StiSerializable
    public final String getName() {
        return this.name;
    }

    public final void setName(String value) {
        if (this.name != null && !this.name.equals(value) && this.report != null) {
            this.report.RenameStyle(this.name, value);
        }
        this.name = value;
    }

    public void setConditions(StiStyleConditionsCollection conditions) {
        this.conditions = conditions;
    }

    @StiSerializable
    public StiStyleConditionsCollection getConditions() {
        if (this.conditions == null) {
            this.conditions = new StiStyleConditionsCollection();
        }
        return this.conditions;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public String getCollectionName() {
        return this.collectionName;
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyStringNullOfEmpty("CollectionName", this.getCollectionName());
        jObject.AddPropertyJObject("Conditions", this.getConditions().SaveToJsonObject(mode));
        jObject.AddPropertyStringNullOfEmpty("Description", this.getDescription());
        jObject.AddPropertyStringNullOfEmpty("Name", this.getName());
        return jObject;
    }

    public Object clone() {
        return null;
    }

    public static StiBaseStyle loadStyleFromString(String styleStr) {
        StiStyleSaver saver = new StiStyleSaver();
        StiDeserializerControler.deserializeFromString((String)styleStr, (IStiSerializable)saver);
        return saver.getStyle();
    }

    public String saveToString() {
        StiStyleSaver saver = new StiStyleSaver(this);
        return StiSerializerControler.serializedObjectAsString((IStiSerializable)saver);
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("CollectionName")) {
                this.collectionName = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Conditions")) {
                this.getConditions().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("Description")) {
                this.description = (String)property.Value;
                continue;
            }
            if (!property.Name.equals("Name")) continue;
            this.name = (String)property.Value;
        }
    }

    public static class StiStyleSaver
    implements IStiSerializable {
        private StiBaseStyle style;

        @StiSerializable
        public StiBaseStyle getStyle() {
            return this.style;
        }

        public void setStyle(StiBaseStyle style) {
            this.style = style;
        }

        public StiStyleSaver(StiBaseStyle style) {
            this.style = style;
        }

        public StiStyleSaver() {
        }
    }
}

