/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.viewer.visual;

import com.stimulsoft.report.components.StiBookmark;
import java.util.ArrayList;
import java.util.List;

public class StiTreeNode {
    private StiBookmark bookmark;
    private StiTreeNode parent;
    private List<StiTreeNode> children = new ArrayList<StiTreeNode>();

    public StiTreeNode(StiBookmark bookmark) {
        this.bookmark = bookmark;
    }

    public String getPath() {
        String value = "";
        for (StiTreeNode node = this; node != null; node = node.getParent()) {
            value = value.length() == 0 ? node.toString() : node.toString() + "." + value;
        }
        return value;
    }

    public List<StiTreeNode> getItems() {
        ArrayList<StiTreeNode> array = new ArrayList<StiTreeNode>();
        if (this.children != null) {
            for (StiTreeNode node : this.children) {
                array.add(node);
                array.addAll(node.getItems());
            }
        }
        return array;
    }

    public void addNode(StiTreeNode value) {
        value.parent = this;
        this.children.add(value);
    }

    public void removeNode(StiTreeNode value) {
        this.children.remove(value);
    }

    public StiBookmark getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(StiBookmark bookmark) {
        this.bookmark = bookmark;
    }

    public String toString() {
        return this.bookmark.getText();
    }

    public StiTreeNode getParent() {
        return this.parent;
    }

    public void setParent(StiTreeNode parent) {
        this.parent = parent;
    }

    public List<StiTreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<StiTreeNode> children) {
        this.children = children;
    }
}

