/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.tcp;

import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.FileOutputBuffer;
import com.sun.grizzly.tcp.OutputBuffer;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.DataStructures;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.http.HtmlHelper;
import com.sun.grizzly.util.http.MimeType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticResourcesAdapter
implements Adapter {
    private static final String USE_SEND_FILE = "com.sun.grizzly.useSendFile";
    private final Queue<String> rootFolders = DataStructures.getCLQinstance(String.class);
    protected String resourcesContextPath = "";
    protected final Queue<File> fileFolders = DataStructures.getCLQinstance(File.class);
    protected final ConcurrentHashMap<String, File> cache = new ConcurrentHashMap();
    protected Logger logger = LoggerUtils.getLogger();
    private boolean useSendFile = true;
    protected boolean commitErrorResponse = true;
    private final ReentrantLock initializedLock = new ReentrantLock();
    private String defaultContentType = "text/html";

    public StaticResourcesAdapter() {
        this(".");
    }

    public StaticResourcesAdapter(String rootFolder) {
        this.addRootFolder(rootFolder);
        if (System.getProperty("os.name").equalsIgnoreCase("linux") && !StaticResourcesAdapter.linuxSendFileSupported() || System.getProperty("os.name").equalsIgnoreCase("HP-UX")) {
            this.useSendFile = false;
        }
        if (System.getProperty(USE_SEND_FILE) != null) {
            this.useSendFile = Boolean.valueOf(System.getProperty(USE_SEND_FILE));
            this.logger.info("Send-file enabled:" + this.useSendFile);
        }
    }

    @Override
    public void service(Request req, Response res) throws Exception {
        String uri = req.requestURI().toString();
        if (uri.contains("..") || !uri.startsWith(this.resourcesContextPath)) {
            res.setStatus(404);
            if (this.commitErrorResponse) {
                this.customizedErrorPage(req, res);
            }
            return;
        }
        if (uri.contains(".")) {
            uri = uri.substring(this.resourcesContextPath.length());
        }
        this.service(uri, req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(String uri, Request req, Response res) throws Exception {
        FileInputStream fis = null;
        try {
            int rd;
            String substr;
            this.initWebDir();
            boolean found = false;
            File resource = null;
            for (File webDir : this.fileFolders) {
                File f;
                resource = this.cache.get(uri);
                if (resource == null && (resource = new File(webDir, uri)).exists() && resource.isDirectory() && (f = new File(resource, "/index.html")).exists()) {
                    resource = f;
                    found = true;
                    break;
                }
                if (resource.isDirectory() || !resource.exists()) {
                    found = false;
                    continue;
                }
                found = true;
                break;
            }
            this.cache.put(uri, resource);
            if (!found) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "File not found  " + resource);
                }
                res.setStatus(404);
                if (!this.commitErrorResponse) return;
                this.customizedErrorPage(req, res);
                return;
            }
            res.setStatus(200);
            int dot = uri.lastIndexOf(".");
            if (dot < 0) {
                substr = resource.toString();
                dot = substr.lastIndexOf(".");
            } else {
                substr = uri;
            }
            if (dot > 0) {
                String ext = substr.substring(dot + 1);
                String ct = MimeType.get(ext, this.defaultContentType);
                if (ct != null) {
                    res.setContentType(ct);
                }
            } else {
                res.setContentType(this.defaultContentType);
            }
            long length = resource.length();
            res.setContentLengthLong(length);
            res.sendHeaders();
            if (req.method().toString().equalsIgnoreCase("HEAD")) {
                return;
            }
            fis = new FileInputStream(resource);
            OutputBuffer outputBuffer = res.getOutputBuffer();
            if (this.useSendFile && outputBuffer instanceof FileOutputBuffer && ((FileOutputBuffer)((Object)outputBuffer)).isSupportFileSend()) {
                res.flush();
                long nWrite = 0L;
                while (nWrite < length) {
                    nWrite += ((FileOutputBuffer)((Object)outputBuffer)).sendFile(fis.getChannel(), nWrite, length - nWrite);
                }
                return;
            }
            byte[] b = new byte[8192];
            ByteChunk chunk = new ByteChunk();
            while ((rd = fis.read(b)) > 0) {
                chunk.setBytes(b, 0, rd);
                res.doWrite(chunk);
            }
            return;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    protected void customizedErrorPage(Request req, Response res) throws Exception {
        int len;
        int offs;
        byte[] b;
        res.setMessage("Not Found");
        res.setStatus(404);
        ByteBuffer bb = HtmlHelper.getErrorPage("Not Found", "HTTP/1.1 404 Not Found\r\n", "Grizzly");
        res.setContentLength(bb.limit());
        res.setContentType("text/html");
        res.flushHeaders();
        if (bb.hasArray()) {
            b = bb.array();
            offs = bb.arrayOffset();
            len = bb.remaining();
        } else {
            b = new byte[bb.remaining()];
            bb.get(b);
            offs = 0;
            len = b.length;
        }
        ByteChunk chunk = new ByteChunk();
        chunk.setBytes(b, offs, len);
        res.doWrite(chunk);
    }

    @Override
    public void afterService(Request req, Response res) throws Exception {
        if (req.getNote(14) != null) {
            req.setNote(14, null);
            return;
        }
        if (res.getStatus() == 404 && !this.commitErrorResponse) {
            return;
        }
        try {
            req.action(ActionCode.ACTION_POST_REQUEST, null);
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, "afterService unexpected exception: ", t);
        }
        res.finish();
    }

    public String getRootFolder() {
        return this.rootFolders.peek();
    }

    public void setRootFolder(String rootFolder) {
        this.rootFolders.clear();
        this.addRootFolder(rootFolder);
    }

    public Queue<String> getRootFolders() {
        return this.rootFolders;
    }

    public boolean addRootFolder(String rootFolder) {
        return this.rootFolders.offer(rootFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initWebDir() throws IOException {
        try {
            this.initializedLock.lock();
            if (this.fileFolders.isEmpty()) {
                for (String s : this.rootFolders) {
                    File webDir = new File(s);
                    this.fileFolders.offer(webDir);
                }
                this.rootFolders.clear();
                for (File f : this.fileFolders) {
                    this.rootFolders.add(f.getCanonicalPath());
                }
            }
        }
        finally {
            this.initializedLock.unlock();
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isUseSendFile() {
        return this.useSendFile;
    }

    public void setUseSendFile(boolean useSendFile) {
        this.useSendFile = useSendFile;
    }

    public String getResourcesContextPath() {
        return this.resourcesContextPath;
    }

    public void setResourcesContextPath(String resourcesContextPath) {
        this.resourcesContextPath = resourcesContextPath;
    }

    public String getDefaultContentType() {
        return this.defaultContentType;
    }

    public void setDefaultContentType(String defaultContentType) {
        this.defaultContentType = defaultContentType;
    }

    private static boolean linuxSendFileSupported(String jdkVersion) {
        if (jdkVersion.startsWith("1.6")) {
            char c;
            int idx = jdkVersion.indexOf(95);
            if (idx == -1) {
                return false;
            }
            StringBuilder sb = new StringBuilder(3);
            String substr = jdkVersion.substring(idx + 1);
            int len = Math.min(substr.length(), 3);
            for (int i = 0; i < len && Character.isDigit(c = substr.charAt(i)); ++i) {
                sb.append(c);
            }
            if (sb.length() == 0) {
                return false;
            }
            int patchRev = Integer.parseInt(sb.toString());
            return patchRev >= 18;
        }
        return jdkVersion.startsWith("1.7") || jdkVersion.startsWith("1.8");
    }

    private static boolean linuxSendFileSupported() {
        return StaticResourcesAdapter.linuxSendFileSupported(System.getProperty("java.version"));
    }
}

