/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.tcp.http11;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.buf.CharChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.buf.UDecoder;
import com.sun.grizzly.util.http.DispatcherHelper;
import com.sun.grizzly.util.http.HttpRequestURIDecoder;
import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.grizzly.util.http.mapper.MappingData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class GrizzlyAdapterChain
extends GrizzlyAdapter {
    private UDecoder urlDecoder = new UDecoder();
    protected static final int MAPPING_DATA = 12;
    protected static final int MAPPED_ADAPTER = 13;
    protected static final int INVOKED_ADAPTER = 15;
    private final ConcurrentHashMap<String, GrizzlyAdapter> adaptersByName = new ConcurrentHashMap();
    private ConcurrentHashMap<GrizzlyAdapter, String[]> adapters = new ConcurrentHashMap();
    private Mapper mapper = new Mapper();
    private static final String LOCAL_HOST = "localhost";
    private boolean oldMappingAlgorithm = false;
    private boolean isRootConfigured = false;
    private final DispatcherHelper dispatcherHelper;

    public GrizzlyAdapterChain() {
        this.mapper.setDefaultHostName(LOCAL_HOST);
        this.setHandleStaticResources(false);
        this.dispatcherHelper = new DispatcherHelperImpl();
        this.setDecodeUrl(false);
    }

    public void start() {
        for (Map.Entry<GrizzlyAdapter, String[]> entry : this.adapters.entrySet()) {
            entry.getKey().start();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void service(GrizzlyRequest request, GrizzlyResponse response) throws Exception {
        Request req = request.getRequest();
        req.setNote(15, null);
        if (this.oldMappingAlgorithm) {
            int i = 0;
            int size = this.adapters.size();
            for (Map.Entry<GrizzlyAdapter, String[]> entry : this.adapters.entrySet()) {
                GrizzlyAdapter adapter = entry.getKey();
                adapter.service(request, response);
                if (response.getStatus() == 404 && i != size - 1) {
                    response.setStatus(200, "OK");
                    continue;
                }
                req.setNote(15, adapter);
                return;
            }
            return;
        } else {
            MappingData mappingData = null;
            try {
                MessageBytes decodedURI = req.decodedURI();
                decodedURI.duplicate(req.requestURI());
                mappingData = (MappingData)req.getNote(12);
                if (mappingData == null) {
                    mappingData = new MappingData();
                    req.setNote(12, mappingData);
                } else {
                    mappingData.recycle();
                }
                HttpRequestURIDecoder.decode(decodedURI, this.urlDecoder, null, null);
                if (mappingData == null) {
                    mappingData = (MappingData)req.getNote(12);
                }
                this.mapUriWithSemicolon(req.serverName(), decodedURI, 0, mappingData);
                GrizzlyAdapter adapter = null;
                if (mappingData.context != null && mappingData.context instanceof GrizzlyAdapter) {
                    adapter = mappingData.wrapper != null ? (GrizzlyAdapter)mappingData.wrapper : (GrizzlyAdapter)mappingData.context;
                    adapter.setDecodeUrl(false);
                    adapter.service(request.getRequest(), response.getResponse());
                    req.setNote(15, adapter);
                    return;
                }
                response.getResponse().setStatus(404);
                this.customizedErrorPage(req, response.getResponse());
                return;
            }
            catch (Throwable t) {
                try {
                    response.setStatus(404);
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "Invalid URL: " + req.decodedURI(), t);
                    }
                    this.customizedErrorPage(req, response.getResponse());
                    return;
                }
                catch (Exception ex2) {
                    if (!this.logger.isLoggable(Level.WARNING)) return;
                    this.logger.log(Level.WARNING, "Unable to error page", ex2);
                }
            }
        }
    }

    public void afterService(GrizzlyRequest request, GrizzlyResponse response) throws Exception {
        Request req = request.getRequest();
        GrizzlyAdapter adapter = (GrizzlyAdapter)req.getNote(15);
        if (adapter != null) {
            adapter.afterService(request, response);
        }
    }

    public void addGrizzlyAdapter(GrizzlyAdapter adapter) {
        this.oldMappingAlgorithm = true;
        this.adapters.put(adapter, new String[]{""});
    }

    public void addGrizzlyAdapter(GrizzlyAdapter adapter, String[] mappings) {
        if (this.oldMappingAlgorithm) {
            throw new IllegalStateException("Cannot mix addGrizzlyAdapter(GrizzlyAdapter) and addGrizzlyAdapter(GrizzlyAdapter,String[]");
        }
        if (mappings.length == 0) {
            this.addGrizzlyAdapter(adapter);
        } else {
            this.adapters.put(adapter, mappings);
            String name = adapter.getName();
            if (name != null) {
                this.adaptersByName.put(adapter.getName(), adapter);
            }
            for (String mapping : mappings) {
                String ctx = this.getContextPath(mapping);
                String wrapper = this.getWrapperPath(ctx, mapping);
                if (!ctx.equals("")) {
                    this.mapper.addContext(LOCAL_HOST, ctx, adapter, new String[]{"index.html", "index.htm"}, null);
                } else if (!this.isRootConfigured && wrapper.startsWith("*.")) {
                    this.isRootConfigured = true;
                    GrizzlyAdapter a = new GrizzlyAdapter(this.getRootFolder()){
                        {
                            this.setHandleStaticResources(false);
                        }

                        public void service(GrizzlyRequest request, GrizzlyResponse response) {
                            try {
                                this.customizedErrorPage(request.getRequest(), response.getResponse());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    this.mapper.addContext(LOCAL_HOST, ctx, a, new String[]{"index.html", "index.htm"}, null);
                } else {
                    this.mapper.addContext(LOCAL_HOST, ctx, adapter, new String[]{"index.html", "index.htm"}, null);
                }
                this.mapper.addWrapper(LOCAL_HOST, ctx, wrapper, adapter);
                adapter.setDispatcherHelper(this.dispatcherHelper);
            }
        }
    }

    private String getWrapperPath(String ctx, String mapping) {
        if (mapping.indexOf("*.") > 0) {
            return mapping.substring(mapping.lastIndexOf("/") + 1);
        }
        if (!ctx.equals("")) {
            return mapping.substring(ctx.length());
        }
        return mapping;
    }

    private String getContextPath(String mapping) {
        String ctx = "";
        int slash = mapping.indexOf("/", 1);
        ctx = slash != -1 ? mapping.substring(0, slash) : mapping;
        if (ctx.startsWith("/*.") || ctx.startsWith("*.")) {
            ctx = ctx.indexOf("/") == ctx.lastIndexOf("/") ? "" : ctx.substring(1);
        }
        if (ctx.startsWith("/*") || ctx.startsWith("*")) {
            ctx = "";
        }
        if (ctx.equals("/")) {
            ctx = "";
        }
        return ctx;
    }

    public void destroy() {
        for (Map.Entry<GrizzlyAdapter, String[]> adapter : this.adapters.entrySet()) {
            adapter.getKey().destroy();
        }
    }

    public boolean removeAdapter(GrizzlyAdapter adapter) {
        String[] mappings;
        if (adapter == null) {
            throw new IllegalStateException();
        }
        String name = adapter.getName();
        if (name != null) {
            this.adaptersByName.remove(name);
        }
        if ((mappings = this.adapters.remove(adapter)) != null) {
            for (String mapping : mappings) {
                String ctx = this.getContextPath(mapping);
                this.mapper.removeContext(LOCAL_HOST, ctx);
            }
            adapter.destroy();
        }
        return mappings != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapUriWithSemicolon(MessageBytes serverName, MessageBytes decodedURI, int semicolonPos, MappingData mappingData) throws Exception {
        CharChunk charChunk = decodedURI.getCharChunk();
        int oldEnd = charChunk.getEnd();
        if (semicolonPos == 0) {
            semicolonPos = decodedURI.indexOf(';');
        }
        if (semicolonPos == -1) {
            semicolonPos = oldEnd;
        }
        charChunk.setEnd(semicolonPos);
        try {
            this.mapper.map(serverName, decodedURI, mappingData);
        }
        finally {
            charChunk.setEnd(oldEnd);
        }
    }

    private final class DispatcherHelperImpl
    implements DispatcherHelper {
        private DispatcherHelperImpl() {
        }

        public void mapPath(MessageBytes host, MessageBytes path, MappingData mappingData) throws Exception {
            GrizzlyAdapterChain.this.mapper.map(host, path, mappingData);
        }

        public void mapName(MessageBytes name, MappingData mappingData) {
            String nameStr = name.toString();
            GrizzlyAdapter handler = (GrizzlyAdapter)GrizzlyAdapterChain.this.adaptersByName.get(nameStr);
            if (handler != null) {
                mappingData.wrapper = handler;
                mappingData.servletName = nameStr;
            }
        }
    }
}

