/*
 * Copyright 2019 IIT Software GmbH
 *
 * IIT Software GmbH licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.swiftmq.jms.smqp.v750;

/**
 * SMQP-Protocol Version 750, Class: AssociateMessageRequest
 * Automatically generated, don't change!
 * Generation Date: Tue Apr 21 10:39:21 CEST 2009
 * (c) 2009, IIT GmbH, Bremen/Germany, All Rights Reserved
 **/

import com.swiftmq.swiftlet.queue.MessageIndex;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.RequestVisitor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AssociateMessageRequest extends Request {
    private MessageIndex messageIndex;
    private boolean duplicateDelete;

    public AssociateMessageRequest() {
        super(0, true);
    }

    public AssociateMessageRequest(int dispatchId) {
        super(dispatchId, true);
    }

    public AssociateMessageRequest(RequestRetryValidator validator, int dispatchId) {
        super(dispatchId, true, validator);
    }

    public AssociateMessageRequest(int dispatchId, MessageIndex messageIndex, boolean duplicateDelete) {
        super(dispatchId, true);
        this.messageIndex = messageIndex;
        this.duplicateDelete = duplicateDelete;
    }

    public AssociateMessageRequest(RequestRetryValidator validator, int dispatchId, MessageIndex messageIndex, boolean duplicateDelete) {
        super(dispatchId, true, validator);
        this.messageIndex = messageIndex;
        this.duplicateDelete = duplicateDelete;
    }

    public MessageIndex getMessageIndex() {
        return messageIndex;
    }

    public void setMessageIndex(MessageIndex messageIndex) {
        this.messageIndex = messageIndex;
    }

    public boolean isDuplicateDelete() {
        return duplicateDelete;
    }

    public void setDuplicateDelete(boolean duplicateDelete) {
        this.duplicateDelete = duplicateDelete;
    }

    public int getDumpId() {
        return SMQPFactory.DID_ASSOCIATEMESSAGE_REQ;
    }


    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        SMQPUtil.write(messageIndex, out);
        SMQPUtil.write(duplicateDelete, out);
    }

    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        messageIndex = SMQPUtil.read(messageIndex, in);
        duplicateDelete = SMQPUtil.read(duplicateDelete, in);
    }

    protected Reply createReplyInstance() {
        return new AssociateMessageReply();
    }

    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor) visitor).visit(this);
    }

    public String toString() {
        StringBuffer _b = new StringBuffer("[v750/AssociateMessageRequest, ");
        _b.append(super.toString());
        _b.append(", ");
        _b.append("messageIndex=");
        _b.append(messageIndex);
        _b.append(", ");
        _b.append("duplicateDelete=");
        _b.append(duplicateDelete);
        _b.append("]");
        return _b.toString();
    }
}
