/*
 * Copyright 2019 IIT Software GmbH
 *
 * IIT Software GmbH licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.swiftmq.jms.smqp.v750;

/**
 * SMQP-Protocol Version 750, Class: CloseProducerRequest
 * Automatically generated, don't change!
 * Generation Date: Tue Apr 21 10:39:21 CEST 2009
 * (c) 2009, IIT GmbH, Bremen/Germany, All Rights Reserved
 **/

import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.RequestVisitor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CloseProducerRequest extends Request {
    private int queueProducerId;

    public CloseProducerRequest() {
        super(0, true);
    }

    public CloseProducerRequest(int dispatchId) {
        super(dispatchId, true);
    }

    public CloseProducerRequest(RequestRetryValidator validator, int dispatchId) {
        super(dispatchId, true, validator);
    }

    public CloseProducerRequest(int dispatchId, int queueProducerId) {
        super(dispatchId, true);
        this.queueProducerId = queueProducerId;
    }

    public CloseProducerRequest(RequestRetryValidator validator, int dispatchId, int queueProducerId) {
        super(dispatchId, true, validator);
        this.queueProducerId = queueProducerId;
    }

    public int getQueueProducerId() {
        return queueProducerId;
    }

    public void setQueueProducerId(int queueProducerId) {
        this.queueProducerId = queueProducerId;
    }

    public int getDumpId() {
        return SMQPFactory.DID_CLOSEPRODUCER_REQ;
    }


    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        SMQPUtil.write(queueProducerId, out);
    }

    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        queueProducerId = SMQPUtil.read(queueProducerId, in);
    }

    protected Reply createReplyInstance() {
        return new CloseProducerReply();
    }

    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor) visitor).visit(this);
    }

    public String toString() {
        StringBuffer _b = new StringBuffer("[v750/CloseProducerRequest, ");
        _b.append(super.toString());
        _b.append(", ");
        _b.append("queueProducerId=");
        _b.append(queueProducerId);
        _b.append("]");
        return _b.toString();
    }
}
