/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.admin.mgmt;

import com.swiftmq.admin.mgmt.Endpoint;
import com.swiftmq.admin.mgmt.EndpointRegistryClosedException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EndpointRegistry {
    private final Map<String, Endpoint> endpoints = new ConcurrentHashMap<String, Endpoint>();
    private volatile boolean closed = false;

    public void put(String routerName, Endpoint endpoint) throws EndpointRegistryClosedException {
        if (this.closed) {
            throw new EndpointRegistryClosedException("EndpointRegistry already closed!");
        }
        this.endpoints.put(routerName, endpoint);
    }

    public Endpoint get(String routerName) {
        return this.endpoints.get(routerName);
    }

    public Endpoint remove(String routerName) {
        return this.endpoints.remove(routerName);
    }

    public void close() {
        for (Map.Entry<String, Endpoint> o : this.endpoints.entrySet()) {
            Endpoint endpoint = o.getValue();
            endpoint.close();
        }
        this.endpoints.clear();
        this.closed = true;
    }
}

