/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.admin.mgmt.v750;

import com.swiftmq.admin.mgmt.Endpoint;
import com.swiftmq.auth.ChallengeResponseFactory;
import com.swiftmq.jms.BytesMessageImpl;
import com.swiftmq.jms.ReconnectListener;
import com.swiftmq.jms.SwiftMQConnection;
import com.swiftmq.mgmt.Command;
import com.swiftmq.mgmt.CommandExecutor;
import com.swiftmq.mgmt.CommandRegistry;
import com.swiftmq.mgmt.Entity;
import com.swiftmq.mgmt.protocol.ProtocolFactory;
import com.swiftmq.mgmt.protocol.v750.AuthReply;
import com.swiftmq.mgmt.protocol.v750.AuthRequest;
import com.swiftmq.mgmt.protocol.v750.CommandReply;
import com.swiftmq.mgmt.protocol.v750.CommandRequest;
import com.swiftmq.mgmt.protocol.v750.ConnectReply;
import com.swiftmq.mgmt.protocol.v750.ConnectRequest;
import com.swiftmq.mgmt.protocol.v750.LeaseRequest;
import com.swiftmq.mgmt.protocol.v750.RemoveSubscriptionFilterRequest;
import com.swiftmq.mgmt.protocol.v750.SetSubscriptionFilterRequest;
import com.swiftmq.tools.dump.Dumpable;
import com.swiftmq.tools.dump.Dumpalizer;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestHandler;
import com.swiftmq.tools.requestreply.RequestRegistry;
import com.swiftmq.tools.requestreply.RequestService;
import com.swiftmq.tools.requestreply.RequestServiceRegistry;
import com.swiftmq.tools.requestreply.TransportException;
import com.swiftmq.tools.timer.TimerEvent;
import com.swiftmq.tools.timer.TimerListener;
import com.swiftmq.tools.timer.TimerRegistry;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import com.swiftmq.util.SwiftUtilities;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TemporaryQueue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class EndpointImpl
extends RequestServiceRegistry
implements RequestHandler,
TimerListener,
MessageListener,
Endpoint,
ReconnectListener {
    static final String MGMT_QUEUE = "swiftmqmgmt";
    static final LeaseRequest leaseRequest = new LeaseRequest();
    static final ProtocolFactory factory = new ProtocolFactory(new com.swiftmq.mgmt.protocol.v750.ProtocolFactory());
    String routerName = null;
    String[] actContext = null;
    QueueConnection connection = null;
    QueueSession senderSession = null;
    QueueSender sender = null;
    QueueSession receiverSession = null;
    QueueReceiver receiver = null;
    TemporaryQueue replyQueue = null;
    RequestRegistry requestRegistry = null;
    DataByteArrayInputStream dis = new DataByteArrayInputStream();
    DataByteArrayOutputStream dos = new DataByteArrayOutputStream();
    byte[] buffer = null;
    CommandRegistry commandRegistry = null;
    boolean createInternalCommands = false;
    long interval = 0L;
    boolean started = false;
    boolean routeInfos = false;
    boolean subscriptionFilterEnabled = false;
    ConnectReply connectReply = null;
    Map<String, SubscriptionCounter> subscriptions = new ConcurrentHashMap<String, SubscriptionCounter>();
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public EndpointImpl(QueueConnection connection, QueueSession senderSession, QueueSender sender, QueueSession receiverSession, QueueReceiver receiver, TemporaryQueue replyQueue, RequestService requestService, boolean createInternalCommands) throws Exception {
        this.connection = connection;
        this.createInternalCommands = createInternalCommands;
        this.senderSession = senderSession;
        this.sender = sender;
        this.receiverSession = receiverSession;
        this.replyQueue = replyQueue;
        this.receiver = receiver;
        this.receiver.setMessageListener((MessageListener)this);
        this.addRequestService(requestService);
        this.requestRegistry = new RequestRegistry();
        this.requestRegistry.setRequestTimeoutEnabled(true);
        this.requestRegistry.setRequestHandler(this);
        this.commandRegistry = new CommandRegistry("Router Context", null);
        this.createCommands();
        this.createDefaultExecutor();
        ((SwiftMQConnection)connection).addReconnectListener(this);
    }

    private void createCommands() {
        if (this.createInternalCommands) {
            CommandExecutor getPropExecutor = new CommandExecutor(){

                @Override
                public String[] execute(String[] context, Entity entity, String[] cmd) {
                    String[] result = null;
                    try {
                        CommandReply reply = (CommandReply)EndpointImpl.this.requestRegistry.request(new CommandRequest(context, cmd, true));
                        result = reply.isOk() ? reply.getResult() : new String[]{"Error:", reply.getException().getMessage()};
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return result;
                }
            };
            Command getPropCommand = new Command("getcontextprop", "getcontextprop", "Internal use only!", true, getPropExecutor);
            this.commandRegistry.addCommand(getPropCommand);
            CommandExecutor getSubsExecutor = new CommandExecutor(){

                @Override
                public String[] execute(String[] context, Entity entity, String[] cmd) {
                    String[] result = null;
                    try {
                        CommandReply reply = (CommandReply)EndpointImpl.this.requestRegistry.request(new CommandRequest(context, cmd, true));
                        result = reply.isOk() ? reply.getResult() : new String[]{"Error:", reply.getException().getMessage()};
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return result;
                }
            };
            Command getSubsCommand = new Command("getcontextent", "getcontextent", "Internal use only!", true, getPropExecutor);
            this.commandRegistry.addCommand(getSubsCommand);
        }
        CommandExecutor ccExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length != 2) {
                    return new String[]{"Error:", "Invalid command, please try 'cc <context>'"};
                }
                if (cmd[1].equals("..")) {
                    EndpointImpl.this.actContext = SwiftUtilities.cutLast(EndpointImpl.this.actContext);
                    return null;
                }
                String[] result = null;
                try {
                    CommandReply reply = (CommandReply)EndpointImpl.this.requestRegistry.request(new CommandRequest(cmd[1].startsWith("/") ? null : EndpointImpl.this.actContext, cmd, true));
                    if (reply.isOk()) {
                        result = reply.getResult();
                        if (result == null) {
                            EndpointImpl.this.actContext = cmd[1].startsWith("/") ? SwiftUtilities.tokenize(cmd[1], "/") : SwiftUtilities.append(EndpointImpl.this.actContext, SwiftUtilities.tokenize(cmd[1], "/"));
                        }
                    } else {
                        result = new String[]{"Error:", reply.getException().getMessage()};
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return result;
            }
        };
        Command ccCommand = new Command("cc", "cc <context>", "Change to Context <context>", true, ccExecutor);
        this.commandRegistry.addCommand(ccCommand);
        CommandExecutor lcExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                String[] result = null;
                try {
                    CommandReply reply;
                    String[] ctx = EndpointImpl.this.actContext;
                    if (cmd.length == 2) {
                        ctx = cmd[1].startsWith("/") ? SwiftUtilities.tokenize(cmd[1], "/") : SwiftUtilities.append(EndpointImpl.this.actContext, SwiftUtilities.tokenize(cmd[1], "/"));
                    }
                    result = (reply = (CommandReply)EndpointImpl.this.requestRegistry.request(new CommandRequest(ctx, cmd, true))).isOk() ? reply.getResult() : new String[]{"Error:", reply.getException().getMessage()};
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return result;
            }
        };
        Command lcCommand = new Command("lc", "lc [<context>]", "List the Content of <context>", true, lcExecutor);
        this.commandRegistry.addCommand(lcCommand);
        CommandExecutor authExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length != 2) {
                    return new String[]{"Error:", "Invalid command, please try 'authenticate <password>'"};
                }
                try {
                    EndpointImpl.this.authenticate(cmd[1]);
                }
                catch (Exception e) {
                    return new String[]{"Error:", e.getMessage()};
                }
                return null;
            }
        };
        Command authCommand = new Command("authenticate", "authenticate <password>", "Authenticate Access", true, authExecutor);
        this.commandRegistry.addCommand(authCommand);
    }

    private void createDefaultExecutor() {
        CommandExecutor defaultExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] command) {
                String[] result = null;
                try {
                    CommandReply reply = (CommandReply)EndpointImpl.this.requestRegistry.request(new CommandRequest(EndpointImpl.this.actContext, command, false));
                    result = reply.isOk() ? reply.getResult() : new String[]{"Error:", reply.getException().getMessage()};
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return result;
            }
        };
        this.commandRegistry.setDefaultCommand(defaultExecutor);
    }

    @Override
    public void reconnected(String host, int port) {
        this.requestRegistry.cancelAllRequests(new TransportException("Reconnect occured: Request cancelled."));
    }

    @Override
    public void connect(int connectId, String hostname, String toolName, boolean subscribeRouteInfos, boolean subscribeRouterConfig, boolean subscribeChangeEvents) throws Exception {
        ConnectRequest cr = new ConnectRequest(connectId, hostname, toolName, subscribeRouteInfos, subscribeRouterConfig, subscribeChangeEvents);
        ConnectReply reply = (ConnectReply)this.request(cr);
        if (!reply.isOk()) {
            throw reply.getException();
        }
        this.setRouterName(reply.getRouterName());
        this.startLease(reply.getLeaseTimeout() / 2L);
        this.setStarted(true);
        this.connectReply = reply;
    }

    @Override
    public boolean isAuthenticationRequired() {
        return this.connectReply.isAuthRequired();
    }

    @Override
    public void authenticate(String password) throws Exception {
        ChallengeResponseFactory crFactory = (ChallengeResponseFactory)Class.forName(this.connectReply.getCrFactory()).newInstance();
        AuthReply reply = (AuthReply)this.request(new AuthRequest(crFactory.createResponse(this.connectReply.getChallenge(), password)));
        if (!reply.isOk()) {
            throw reply.getException();
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void setStarted(boolean started) {
        this.started = started;
    }

    @Override
    public boolean isRouteInfos() {
        return this.routeInfos;
    }

    @Override
    public void setRouteInfos(boolean routeInfos) {
        this.routeInfos = routeInfos;
    }

    @Override
    public RequestRegistry getRequestRegistry() {
        return this.requestRegistry;
    }

    @Override
    public String getRouterName() {
        return this.routerName;
    }

    @Override
    public void setRouterName(String routerName) {
        this.routerName = routerName;
    }

    @Override
    public String[] getActContext() {
        return this.actContext;
    }

    @Override
    public void setActContext(String[] actContext) {
        this.actContext = actContext;
    }

    @Override
    public boolean isSubscriptionFilterEnabled() {
        return this.subscriptionFilterEnabled;
    }

    @Override
    public void setSubscriptionFilterEnabled(boolean subscriptionFilterEnabled) {
        this.subscriptionFilterEnabled = subscriptionFilterEnabled;
    }

    @Override
    public void contextShown(String[] context, boolean includeNextLevel) {
        if (this.subscriptionFilterEnabled) {
            String s = SwiftUtilities.concat(context, "/") + "?" + includeNextLevel;
            SubscriptionCounter c = this.subscriptions.get(s);
            if (c == null) {
                c = new SubscriptionCounter();
                this.subscriptions.put(s, c);
                this.requestRegistry.request(new SetSubscriptionFilterRequest(context, includeNextLevel));
            }
            ++c.cnt;
        }
    }

    @Override
    public void contextHidden(String[] context, boolean includeNextLevel) {
        String s;
        SubscriptionCounter c;
        if (this.subscriptionFilterEnabled && (c = this.subscriptions.get(s = SwiftUtilities.concat(context, "/") + "?" + includeNextLevel)) != null) {
            --c.cnt;
            if (c.cnt == 0) {
                this.subscriptions.remove(s);
                this.requestRegistry.request(new RemoveSubscriptionFilterRequest(context, includeNextLevel));
            }
        }
    }

    @Override
    public void startLease(long interval) {
        this.interval = interval;
        TimerRegistry.Singleton().addTimerListener(interval, (TimerListener)this);
    }

    @Override
    public Reply request(Request request) throws Exception {
        return this.requestRegistry.request(request);
    }

    @Override
    public void performRequest(Request request) {
        this.lock.writeLock().lock();
        try {
            try {
                this.dos.rewind();
                Dumpalizer.dump(this.dos, request);
                BytesMessageImpl msg = new BytesMessageImpl();
                msg.writeBytes(this.dos.getBuffer(), 0, this.dos.getCount());
                msg.setJMSReplyTo((Destination)this.replyQueue);
                this.sender.send((Message)msg);
            }
            catch (Exception e) {
                this.close();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public String[] execute(String[] context, Entity entity, String[] command) {
        return this.commandRegistry.executeCommand(context, command);
    }

    @Override
    public void performTimeAction(TimerEvent evt) {
        this.performRequest(leaseRequest);
    }

    public void onMessage(Message message) {
        try {
            BytesMessageImpl msg = (BytesMessageImpl)message;
            int len = (int)msg._getBodyLength();
            if (this.buffer == null || len > this.buffer.length) {
                this.buffer = new byte[len];
            }
            msg.readBytes(this.buffer);
            this.dis.reset();
            this.dis.setBuffer(this.buffer);
            Dumpable d = Dumpalizer.construct(this.dis, factory);
            if (d instanceof Reply) {
                this.requestRegistry.setReply((Reply)d);
            } else {
                this.dispatch((Request)d);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.close();
        }
    }

    @Override
    public void close() {
        ((SwiftMQConnection)this.connection).removeReconnectListener(this);
        this.requestRegistry.cancelAllRequests(new TransportException("Request cancelled."));
        this.requestRegistry.close();
        TimerRegistry.Singleton().removeTimerListener(this.interval, (TimerListener)this);
        try {
            this.receiver.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            this.sender.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            this.receiverSession.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            this.senderSession.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            this.replyQueue.delete();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    private class SubscriptionCounter {
        int cnt = 0;

        private SubscriptionCounter() {
        }
    }
}

