/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.client.thread;

import com.swiftmq.client.thread.ThreadPoolImpl;
import com.swiftmq.swiftlet.threadpool.AsyncTask;

public class PoolExecutor
extends Thread {
    ThreadPoolImpl threadPool;
    long idleTimeout;
    AsyncTask activeTask;
    volatile boolean shouldDie = false;

    PoolExecutor(String name, ThreadGroup threadGroup, ThreadPoolImpl threadPool, long idleTimeout) {
        super(threadGroup, name);
        this.threadPool = threadPool;
        this.idleTimeout = idleTimeout;
    }

    public AsyncTask getActiveTask() {
        return this.activeTask;
    }

    void die() {
        this.shouldDie = true;
        if (this.activeTask != null) {
            this.activeTask.stop();
        }
    }

    @Override
    public void run() {
        this.activeTask = this.threadPool.getNextTask(this, this.idleTimeout);
        while (this.activeTask != null && !this.shouldDie) {
            if (this.activeTask.isValid()) {
                try {
                    this.activeTask.run();
                }
                catch (Throwable e) {
                    this.getThreadGroup().uncaughtException(this, e);
                }
            }
            if (this.shouldDie) continue;
            this.activeTask = this.threadPool.getNextTask(this, this.idleTimeout);
        }
    }
}

