/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms;

import com.swiftmq.jms.MessageImpl;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;

public class BytesMessageImpl
extends MessageImpl
implements BytesMessage {
    static final int WRITE_ONLY = 0;
    static final int READ_ONLY = 1;
    int mode = 0;
    DataByteArrayOutputStream dos = null;
    DataByteArrayInputStream dis = null;
    byte[] array = null;
    int cnt = 0;

    public BytesMessageImpl() {
        this.dos = null;
        this.dis = null;
        this.array = null;
        this.cnt = 0;
        this.mode = 0;
    }

    public BytesMessageImpl(byte[] array, int cnt) {
        this.array = array;
        this.cnt = cnt;
    }

    @Override
    protected int getType() {
        return 1;
    }

    @Override
    protected void writeBody(DataOutput out) throws IOException {
        if (this.dos != null) {
            this.array = this.dos.getBuffer();
            this.cnt = this.dos.getCount();
        }
        out.writeInt(this.cnt);
        if (this.cnt > 0) {
            out.write(this.array, 0, this.cnt);
        }
    }

    @Override
    protected void readBody(DataInput in) throws IOException {
        this.mode = 1;
        this.cnt = in.readInt();
        if (this.cnt > 0) {
            this.array = new byte[this.cnt];
            in.readFully(this.array);
        } else {
            this.array = null;
        }
    }

    private void checkRead() {
        if (this.dis == null) {
            this.dos = null;
            byte[] b = null;
            b = this.array != null && this.cnt > 0 ? this.array : new byte[]{};
            this.dis = new DataByteArrayInputStream(b);
        }
    }

    private void checkWrite() {
        if (this.dos == null) {
            this.dos = new DataByteArrayOutputStream();
            this.cnt = 0;
            this.array = null;
            this.dis = null;
        }
    }

    public long _getBodyLength() {
        if (this.cnt == 0) {
            if (this.mode == 0) {
                this.checkWrite();
                return this.dos.getCount();
            }
            this.checkRead();
            return this.dis.getMax();
        }
        return this.cnt;
    }

    public byte[] _getBody() {
        return this.array;
    }

    public long getBodyLength() throws JMSException {
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        return this._getBodyLength();
    }

    public boolean readBoolean() throws JMSException {
        boolean b;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        this.checkRead();
        try {
            b = this.dis.readBoolean();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.toString());
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
        return b;
    }

    public byte readByte() throws JMSException {
        byte b;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        this.checkRead();
        try {
            b = this.dis.readByte();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.toString());
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
        return b;
    }

    public int readUnsignedByte() throws JMSException {
        int b;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        this.checkRead();
        try {
            b = this.dis.readUnsignedByte();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.toString());
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
        return b;
    }

    public short readShort() throws JMSException {
        short b;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        this.checkRead();
        try {
            b = this.dis.readShort();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.toString());
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
        return b;
    }

    public int readUnsignedShort() throws JMSException {
        int b;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        this.checkRead();
        try {
            b = this.dis.readUnsignedShort();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.toString());
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
        return b;
    }

    public char readChar() throws JMSException {
        char b;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        this.checkRead();
        try {
            b = this.dis.readChar();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.toString());
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
        return b;
    }

    public int readInt() throws JMSException {
        int b;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        this.checkRead();
        try {
            b = this.dis.readInt();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.toString());
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
        return b;
    }

    public long readLong() throws JMSException {
        long b;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        this.checkRead();
        try {
            b = this.dis.readLong();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.toString());
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
        return b;
    }

    public float readFloat() throws JMSException {
        float b;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        this.checkRead();
        try {
            b = this.dis.readFloat();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.toString());
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
        return b;
    }

    public double readDouble() throws JMSException {
        double b;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        this.checkRead();
        try {
            b = this.dis.readDouble();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.toString());
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
        return b;
    }

    public String readUTF() throws JMSException {
        String b;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        this.checkRead();
        try {
            b = this.dis.readUTF();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.toString());
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
        return b;
    }

    public int readBytes(byte[] value) throws JMSException {
        int b;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        this.checkRead();
        try {
            b = this.dis.read(value);
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.toString());
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
        return b;
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        int b;
        if (this.mode == 0) {
            throw new MessageNotReadableException("message is in write-only mode");
        }
        this.checkRead();
        try {
            b = this.dis.read(value, 0, length);
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.toString());
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
        return b;
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkWrite();
        try {
            this.dos.writeBoolean(value);
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
    }

    public void writeByte(byte value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkWrite();
        try {
            this.dos.writeByte(value);
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
    }

    public void writeShort(short value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkWrite();
        try {
            this.dos.writeShort(value);
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
    }

    public void writeChar(char value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkWrite();
        try {
            this.dos.writeChar(value);
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
    }

    public void writeInt(int value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkWrite();
        try {
            this.dos.writeInt(value);
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
    }

    public void writeLong(long value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkWrite();
        try {
            this.dos.writeLong(value);
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
    }

    public void writeFloat(float value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkWrite();
        try {
            this.dos.writeFloat(value);
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
    }

    public void writeDouble(double value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkWrite();
        try {
            this.dos.writeDouble(value);
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
    }

    public void writeUTF(String value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkWrite();
        try {
            this.dos.writeUTF(value);
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkWrite();
        try {
            this.dos.write(value);
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        this.checkWrite();
        try {
            this.dos.write(value, offset, length);
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (this.mode == 1) {
            throw new MessageNotWriteableException("message is in read-only mode");
        }
        if (value == null) {
            throw new NullPointerException("null values are not support by the JMS spec");
        }
        this.checkWrite();
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else if (value instanceof String) {
            this.writeUTF((String)value);
        } else {
            throw new MessageFormatException("writeObject supports only Boolean, Byte, Short, Integer, Long, Float, Double, byte[], or String");
        }
    }

    @Override
    public void reset() throws JMSException {
        this.mode = 1;
        if (this.dis != null) {
            try {
                this.dis.reset();
            }
            catch (IOException e) {
                throw new JMSException(e.toString());
            }
        } else {
            this.dis = this.dos != null ? new DataByteArrayInputStream(this.dos) : null;
        }
    }

    @Override
    public void clearBody() throws JMSException {
        this.mode = 0;
        this.dis = null;
        this.dos = null;
        this.array = null;
        this.cnt = 0;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer("[BytesMessageImpl ");
        b.append(super.toString());
        b.append(" dis=");
        b.append(this.dis);
        b.append(" dos=");
        b.append(this.dos);
        b.append(" array=");
        b.append(this.array);
        b.append("]");
        return b.toString();
    }
}

