/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms;

import com.swiftmq.jms.ConnectionLostException;
import com.swiftmq.jms.RequestTimeoutException;
import com.swiftmq.tools.requestreply.TimeoutException;
import com.swiftmq.tools.requestreply.TransportException;
import jakarta.jms.JMSException;

public class ExceptionConverter {
    public static JMSException convert(Exception exception) {
        if (exception instanceof JMSException) {
            return (JMSException)((Object)exception);
        }
        if (exception instanceof TimeoutException) {
            return new RequestTimeoutException(exception.getMessage(), exception);
        }
        if (exception instanceof TransportException) {
            return new ConnectionLostException(exception.getMessage(), exception);
        }
        JMSException e = new JMSException(exception.getMessage());
        e.setLinkedException(exception);
        return e;
    }
}

