/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms;

import com.swiftmq.jms.MessageImpl;
import com.swiftmq.jms.MessageProperties;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.MessageNotWriteableException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;

public class MapMessageImpl
extends MessageImpl
implements MapMessage {
    MessageProperties map = null;
    byte[] mapBytes = null;
    boolean bodyReadOnly = false;

    @Override
    protected int getType() {
        return 2;
    }

    @Override
    public void setReadOnly(boolean b) {
        super.setReadOnly(b);
        this.bodyReadOnly = b;
    }

    @Override
    protected void writeBody(DataOutput out) throws IOException {
        if (this.map == null) {
            if (this.mapBytes == null) {
                out.writeByte(0);
            } else {
                out.writeByte(1);
                out.writeInt(this.mapBytes.length);
                out.write(this.mapBytes, 0, this.mapBytes.length);
            }
        } else {
            out.writeByte(1);
            DataByteArrayOutputStream dos = new DataByteArrayOutputStream();
            this.map.writeContent(dos);
            dos.close();
            out.writeInt(dos.getCount());
            out.write(dos.getBuffer(), 0, dos.getCount());
        }
    }

    @Override
    protected void readBody(DataInput in) throws IOException {
        byte set = in.readByte();
        if (set == 0) {
            this.map = null;
            this.mapBytes = null;
        } else {
            this.mapBytes = new byte[in.readInt()];
            in.readFully(this.mapBytes);
        }
    }

    @Override
    protected void unfoldBody() {
        this.checkMap();
    }

    private void checkMap() {
        if (this.map == null) {
            this.map = new MessageProperties();
        }
        if (this.mapBytes != null) {
            try {
                DataByteArrayInputStream dis = new DataByteArrayInputStream(this.mapBytes);
                this.map.readContent(dis);
                this.mapBytes = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean getBoolean(String name) throws JMSException {
        this.checkMap();
        return this.map.getBoolean(name);
    }

    public byte getByte(String name) throws JMSException {
        this.checkMap();
        return this.map.getByte(name);
    }

    public short getShort(String name) throws JMSException {
        this.checkMap();
        return this.map.getShort(name);
    }

    public char getChar(String name) throws JMSException {
        this.checkMap();
        return this.map.getChar(name);
    }

    public int getInt(String name) throws JMSException {
        this.checkMap();
        return this.map.getInt(name);
    }

    public long getLong(String name) throws JMSException {
        this.checkMap();
        return this.map.getLong(name);
    }

    public float getFloat(String name) throws JMSException {
        this.checkMap();
        return this.map.getFloat(name);
    }

    public double getDouble(String name) throws JMSException {
        this.checkMap();
        return this.map.getDouble(name);
    }

    public String getString(String name) throws JMSException {
        this.checkMap();
        return this.map.getString(name);
    }

    public byte[] getBytes(String name) throws JMSException {
        this.checkMap();
        return this.map.getBytes(name);
    }

    public Object getObject(String name) throws JMSException {
        this.checkMap();
        return this.map.getObject(name);
    }

    public Enumeration getMapNames() throws JMSException {
        this.checkMap();
        return this.map.enumeration();
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("Message values are read only");
        }
        this.checkMap();
        this.map.setBoolean(name, value);
    }

    public void setByte(String name, byte value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("Message values are read only");
        }
        this.checkMap();
        this.map.setByte(name, value);
    }

    public void setShort(String name, short value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("Message values are read only");
        }
        this.checkMap();
        this.map.setShort(name, value);
    }

    public void setChar(String name, char value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("Message values are read only");
        }
        this.checkMap();
        this.map.setChar(name, value);
    }

    public void setInt(String name, int value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("Message values are read only");
        }
        this.checkMap();
        this.map.setInt(name, value);
    }

    public void setLong(String name, long value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("Message values are read only");
        }
        this.checkMap();
        this.map.setLong(name, value);
    }

    public void setFloat(String name, float value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("Message values are read only");
        }
        this.checkMap();
        this.map.setFloat(name, value);
    }

    public void setDouble(String name, double value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("Message values are read only");
        }
        this.checkMap();
        this.map.setDouble(name, value);
    }

    public void setString(String name, String value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("Message values are read only");
        }
        this.checkMap();
        this.map.setString(name, value);
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("Message values are read only");
        }
        this.checkMap();
        if (value == null) {
            this.map.remove(name);
        } else {
            this.map.setBytes(name, value);
        }
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("Message values are read only");
        }
        this.checkMap();
        if (value == null) {
            this.map.remove(name);
        } else {
            this.map.setBytes(name, value, offset, length);
        }
    }

    public void setObject(String name, Object value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("Message values are read only");
        }
        this.checkMap();
        if (value == null) {
            this.map.remove(name);
        } else {
            this.map.setObject(name, value, true);
        }
    }

    public boolean itemExists(String name) throws JMSException {
        this.checkMap();
        return this.map.exists(name);
    }

    @Override
    public void clearBody() throws JMSException {
        this.map = null;
        this.mapBytes = null;
        this.bodyReadOnly = false;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer("[MapMessageImpl ");
        b.append(super.toString());
        b.append(" map=");
        b.append(this.map);
        b.append(" mapBytes=");
        b.append(this.mapBytes);
        b.append("]");
        return b.toString();
    }
}

