/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms;

import com.swiftmq.jms.BytesMessageImpl;
import com.swiftmq.jms.MapMessageImpl;
import com.swiftmq.jms.MessageImpl;
import com.swiftmq.jms.ObjectMessageImpl;
import com.swiftmq.jms.StreamMessageImpl;
import com.swiftmq.jms.TextMessageImpl;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageEOFException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.Enumeration;

public class MessageCloner {
    private static void cloneBytesMessage(BytesMessage source, BytesMessage destination) throws JMSException {
        byte[] buffer = new byte[256];
        try {
            int len;
            source.reset();
            while ((len = source.readBytes(buffer)) != -1) {
                destination.writeBytes(buffer, 0, len);
            }
        }
        catch (MessageEOFException messageEOFException) {
            // empty catch block
        }
    }

    private static void cloneMapMessage(MapMessage source, MapMessage destination) throws JMSException {
        Enumeration enumer = source.getMapNames();
        while (enumer.hasMoreElements()) {
            String name = (String)enumer.nextElement();
            if (!source.itemExists(name)) continue;
            destination.setObject(name, source.getObject(name));
        }
    }

    private static void cloneObjectMessage(ObjectMessage source, ObjectMessage destination) throws JMSException {
        Serializable obj = source.getObject();
        if (obj != null) {
            destination.setObject(obj);
        }
    }

    private static void cloneStreamMessage(StreamMessage source, StreamMessage destination) throws JMSException {
        try {
            Object obj;
            source.reset();
            while ((obj = source.readObject()) != null) {
                destination.writeObject(obj);
            }
        }
        catch (MessageEOFException messageEOFException) {
            // empty catch block
        }
    }

    private static void cloneTextMessage(TextMessage source, TextMessage destination) throws JMSException {
        String text = source.getText();
        if (text != null) {
            destination.setText(text);
        }
    }

    private static Message cloneContent(Message source, Message destination) throws JMSException {
        if (source.getJMSCorrelationID() != null) {
            destination.setJMSCorrelationID(source.getJMSCorrelationID());
        }
        if (source.getJMSType() != null) {
            destination.setJMSType(source.getJMSType());
        }
        destination.setJMSRedelivered(false);
        Enumeration enumer = source.getPropertyNames();
        while (enumer.hasMoreElements()) {
            String name = (String)enumer.nextElement();
            if (name.toUpperCase().startsWith("JMS_") || name.toUpperCase().startsWith("JMSX")) continue;
            destination.setObjectProperty(name, source.getObjectProperty(name));
        }
        return destination;
    }

    public static Message cloneMessage(Message source) throws JMSException {
        MessageImpl destination = null;
        if (source instanceof BytesMessage) {
            destination = new BytesMessageImpl();
            MessageCloner.cloneBytesMessage((BytesMessage)source, destination);
        } else if (source instanceof StreamMessage) {
            destination = new StreamMessageImpl();
            MessageCloner.cloneStreamMessage((StreamMessage)source, (StreamMessage)destination);
        } else if (source instanceof TextMessage) {
            destination = new TextMessageImpl();
            MessageCloner.cloneTextMessage((TextMessage)source, (TextMessage)destination);
        } else if (source instanceof ObjectMessage) {
            destination = new ObjectMessageImpl();
            MessageCloner.cloneObjectMessage((ObjectMessage)source, (ObjectMessage)destination);
        } else if (source instanceof MapMessage) {
            destination = new MapMessageImpl();
            MessageCloner.cloneMapMessage((MapMessage)source, (MapMessage)destination);
        } else {
            destination = new MessageImpl();
        }
        return MessageCloner.cloneContent(source, destination);
    }

    public static Message cloneMessage(Message source, Session session) throws JMSException {
        BytesMessage destination = null;
        if (source instanceof BytesMessage) {
            destination = session.createBytesMessage();
            MessageCloner.cloneBytesMessage((BytesMessage)source, destination);
        } else if (source instanceof StreamMessage) {
            destination = session.createStreamMessage();
            MessageCloner.cloneStreamMessage((StreamMessage)source, (StreamMessage)destination);
        } else if (source instanceof TextMessage) {
            destination = session.createTextMessage();
            MessageCloner.cloneTextMessage((TextMessage)source, (TextMessage)destination);
        } else if (source instanceof ObjectMessage) {
            destination = session.createObjectMessage();
            MessageCloner.cloneObjectMessage((ObjectMessage)source, (ObjectMessage)destination);
        } else if (source instanceof MapMessage) {
            destination = session.createMapMessage();
            MessageCloner.cloneMapMessage((MapMessage)source, (MapMessage)destination);
        } else {
            destination = session.createMessage();
        }
        return MessageCloner.cloneContent(source, (Message)destination);
    }
}

