/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms;

import com.swiftmq.jms.BytesMessageImpl;
import com.swiftmq.jms.DestinationFactory;
import com.swiftmq.jms.DestinationImpl;
import com.swiftmq.jms.MapMessageImpl;
import com.swiftmq.jms.MessageProperties;
import com.swiftmq.jms.ObjectMessageImpl;
import com.swiftmq.jms.QueueImpl;
import com.swiftmq.jms.StreamMessageImpl;
import com.swiftmq.jms.SwiftMQMessageConsumer;
import com.swiftmq.jms.SwiftMQSession;
import com.swiftmq.jms.TextMessageImpl;
import com.swiftmq.jms.ToClientSerializer;
import com.swiftmq.swiftlet.queue.MessageIndex;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import com.swiftmq.tools.util.LazyUTF8String;
import com.swiftmq.tools.util.LengthCaptureDataInput;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageNotWriteableException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;

public class MessageImpl
implements Message,
Serializable {
    public static final String PROP_DELIVERY_COUNT = "JMSXDeliveryCount";
    public static final String PROP_USER_ID = "JMSXUserID";
    public static final String PROP_CLIENT_ID = "JMS_SWIFTMQ_CID";
    public static final String PROP_UNROUTABLE_REASON = "JMS_SWIFTMQ_UR_REASON";
    public static final String PROP_DOUBT_DUPLICATE = "JMS_SWIFTMQ_DOUBT_DUPLICATE";
    public static final int MAX_PRIORITY = 9;
    public static final int MIN_PRIORITY = 1;
    public static final int DEFAULT_PRIORITY = 4;
    static final int MIN_COMPRESSION_SIZE = 2048;
    static final int TYPE_MESSAGE = 0;
    static final int TYPE_BYTESMESSAGE = 1;
    static final int TYPE_MAPMESSAGE = 2;
    static final int TYPE_OBJECTMESSAGE = 3;
    static final int TYPE_STREAMMESSAGE = 4;
    static final int TYPE_TEXTMESSAGE = 5;
    boolean readOnly = false;
    LazyUTF8String messageId = null;
    long timeStamp = 0L;
    LazyUTF8String correlationId = null;
    Destination replyTo = null;
    Destination destination = null;
    int deliveryMode = 1;
    boolean redelivered = false;
    LazyUTF8String type = null;
    MessageIndex messageIndex = null;
    long expiration = 0L;
    int priority = 0;
    int deliveryCount = 0;
    MessageProperties props = null;
    byte[] propBytes = null;
    LazyUTF8String userId = null;
    LazyUTF8String clientId = null;
    transient SwiftMQMessageConsumer myConsumer = null;
    transient SwiftMQSession mySession = null;
    volatile transient boolean cancelled = false;
    volatile transient String duplicateId = null;
    transient long messageLength = -1L;
    volatile transient Object persistentKey = null;
    volatile transient Object streamPKey = null;
    LazyUTF8String sourceRouter = null;
    LazyUTF8String destRouter = null;
    LazyUTF8String destQueue = null;

    public static MessageImpl createInstance(int type) {
        MessageImpl msg = null;
        switch (type) {
            case 0: {
                msg = new MessageImpl();
                break;
            }
            case 1: {
                msg = new BytesMessageImpl();
                break;
            }
            case 2: {
                msg = new MapMessageImpl();
                break;
            }
            case 3: {
                msg = new ObjectMessageImpl();
                break;
            }
            case 4: {
                msg = new StreamMessageImpl();
                break;
            }
            case 5: {
                msg = new TextMessageImpl();
            }
        }
        return msg;
    }

    protected int getType() {
        return 0;
    }

    public Object getPersistentKey() {
        return this.persistentKey;
    }

    public void setPersistentKey(Object persistentKey) {
        this.persistentKey = persistentKey;
    }

    public Object getStreamPKey() {
        return this.streamPKey;
    }

    public void setStreamPKey(Object streamPKey) {
        this.streamPKey = streamPKey;
    }

    public long getMessageLength() {
        return this.messageLength;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getDuplicateId() {
        return this.duplicateId;
    }

    public void setDuplicateId(String duplicateId) {
        this.duplicateId = duplicateId;
    }

    private void writeHeader(DataOutput out) throws IOException {
        out.writeLong(this.expiration);
        out.writeInt(this.priority);
        out.writeLong(this.timeStamp);
        out.writeInt(this.deliveryCount);
        out.writeInt(this.deliveryMode);
        out.writeBoolean(this.redelivered);
        if (this.messageId == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            this.messageId.writeContent(out);
        }
        if (this.userId == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            this.userId.writeContent(out);
        }
        if (this.clientId == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            this.clientId.writeContent(out);
        }
        if (this.correlationId == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            this.correlationId.writeContent(out);
        }
        if (this.type == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            this.type.writeContent(out);
        }
        if (this.replyTo == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            DestinationFactory.dumpDestination((DestinationImpl)this.replyTo, out);
        }
        if (this.destination == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            DestinationFactory.dumpDestination((DestinationImpl)this.destination, out);
        }
    }

    private void writeProperties(DataOutput out) throws IOException {
        if (this.propBytes != null) {
            out.writeByte(1);
            out.writeInt(this.propBytes.length);
            out.write(this.propBytes, 0, this.propBytes.length);
        } else if (this.props == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            DataByteArrayOutputStream dos = new DataByteArrayOutputStream(128);
            this.props.writeContent(dos);
            dos.close();
            out.writeInt(dos.getCount());
            out.write(dos.getBuffer(), 0, dos.getCount());
        }
    }

    private void writeRouting(DataOutput out) throws IOException {
        if (this.sourceRouter == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            this.sourceRouter.writeContent(out);
        }
        if (this.destRouter == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            this.destRouter.writeContent(out);
        }
        if (this.destQueue == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            this.destQueue.writeContent(out);
        }
    }

    private void writeEmptyRouting(DataOutput out) throws IOException {
        out.writeByte(0);
        out.writeByte(0);
        out.writeByte(0);
    }

    protected void writeBody(DataOutput out) throws IOException {
    }

    public void writeContent(DataOutput out) throws IOException {
        out.writeInt(this.getType());
        this.writeHeader(out);
        this.writeProperties(out);
        this.writeRouting(out);
        this.writeBody(out);
    }

    public void writeContent(ToClientSerializer serializer) throws IOException {
        DataOutput out = serializer.getDataOutput();
        out.writeInt(this.getType());
        this.writeHeader(out);
        this.writeProperties(out);
        this.writeEmptyRouting(out);
        this.writeBody(out);
    }

    private void readHeader(DataInput in) throws IOException {
        this.expiration = in.readLong();
        this.priority = in.readInt();
        this.timeStamp = in.readLong();
        this.deliveryCount = in.readInt();
        this.deliveryMode = in.readInt();
        this.redelivered = in.readBoolean();
        byte set = in.readByte();
        this.messageId = set == 1 ? new LazyUTF8String(in) : null;
        set = in.readByte();
        this.userId = set == 1 ? new LazyUTF8String(in) : null;
        set = in.readByte();
        this.clientId = set == 1 ? new LazyUTF8String(in) : null;
        set = in.readByte();
        this.correlationId = set == 1 ? new LazyUTF8String(in) : null;
        set = in.readByte();
        this.type = set == 1 ? new LazyUTF8String(in) : null;
        set = in.readByte();
        this.replyTo = set == 1 ? DestinationFactory.createDestination(in) : null;
        set = in.readByte();
        this.destination = set == 1 ? DestinationFactory.createDestination(in) : null;
    }

    private void readProperties(DataInput in) throws IOException {
        byte set = in.readByte();
        if (set == 0) {
            this.props = null;
            this.propBytes = null;
        } else {
            this.propBytes = new byte[in.readInt()];
            in.readFully(this.propBytes);
        }
    }

    private void readRouting(DataInput in) throws IOException {
        byte set = in.readByte();
        this.sourceRouter = set == 1 ? new LazyUTF8String(in) : null;
        set = in.readByte();
        this.destRouter = set == 1 ? new LazyUTF8String(in) : null;
        set = in.readByte();
        this.destQueue = set == 1 ? new LazyUTF8String(in) : null;
    }

    protected void readBody(DataInput in) throws IOException {
    }

    public void readContent(LengthCaptureDataInput in) throws IOException {
        in.startCaptureLength();
        this.readHeader(in);
        this.readProperties(in);
        this.readRouting(in);
        this.readBody(in);
        this.messageLength = in.stopCaptureLength();
    }

    public void readContent(DataInput in) throws IOException {
        try {
            this.readContent((LengthCaptureDataInput)in);
        }
        catch (ClassCastException e) {
            this.readHeader(in);
            this.readProperties(in);
            this.readRouting(in);
            this.readBody(in);
        }
    }

    public void setUseThreadContextCL(boolean b) {
    }

    private void unfold(LazyUTF8String lazyUTF8String) {
        if (lazyUTF8String != null) {
            lazyUTF8String.getString(true);
        }
    }

    private void unfold(Destination destination) {
        if (destination != null) {
            ((DestinationImpl)destination).unfoldBuffers();
        }
    }

    public void unfoldBuffers() {
        this.unfold(this.messageId);
        this.unfold(this.correlationId);
        this.unfold(this.type);
        this.unfold(this.userId);
        this.unfold(this.clientId);
        this.unfold(this.destQueue);
        this.unfold(this.destRouter);
        this.unfold(this.sourceRouter);
        this.unfold(this.destination);
        this.unfold(this.replyTo);
        this.checkProps();
        this.propBytes = null;
        this.unfoldBody();
    }

    protected void unfoldBody() {
    }

    public Object getField(String name) {
        Object obj = null;
        try {
            obj = name.equals("JMSMessageID") ? (this.messageId != null ? this.messageId.getString() : null) : (name.equals("JMSPriority") ? new Integer(this.priority) : (name.equals("JMSTimestamp") ? new Long(this.timeStamp) : (name.equals("JMSCorrelationID") ? (this.correlationId != null ? this.correlationId.getString() : null) : (name.equals("JMSDeliveryMode") ? (this.deliveryMode == 2 ? "PERSISTENT" : "NON_PERSISTENT") : (name.equals("JMSType") ? (this.type != null ? this.type.getString() : null) : (name.equals("JMSDestination") ? (this.destination != null ? this.destination.toString() : null) : this.getObjectProperty(name)))))));
            if (obj != null && obj instanceof Number) {
                obj = new Double(((Number)obj).doubleValue());
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return obj;
    }

    public void clearSwiftMQProps() {
    }

    public void clearSwiftMQAllProps() {
        this.sourceRouter = null;
        this.destRouter = null;
        this.messageIndex = null;
        this.userId = null;
        this.clientId = null;
        this.deliveryCount = 0;
    }

    private void checkProps() {
        if (this.props == null) {
            this.props = new MessageProperties();
            if (this.propBytes != null) {
                try {
                    DataByteArrayInputStream dis = new DataByteArrayInputStream(this.propBytes);
                    this.props.readContent(dis);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void verifyName(String name) throws JMSException {
        if (name != null && name.length() > 0) {
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (i == 0) {
                    if (Character.isJavaIdentifierStart(c)) continue;
                    throw new JMSException("'" + name + "' doesn't start with a valid Java Identifier Start Character!");
                }
                if (Character.isJavaIdentifierPart(c)) continue;
                throw new JMSException("'" + name + "' includes an invalid character!");
            }
        }
    }

    public void setMessageConsumerImpl(SwiftMQMessageConsumer myConsumer) {
        this.myConsumer = myConsumer;
    }

    public void setSessionImpl(SwiftMQSession mySession) {
        this.mySession = mySession;
    }

    public void setReadOnly(boolean b) {
        this.readOnly = b;
    }

    public MessageIndex getMessageIndex() {
        return this.messageIndex;
    }

    public void setMessageIndex(MessageIndex messageIndex) {
        this.messageIndex = messageIndex;
    }

    public String getSourceRouter() {
        return this.sourceRouter != null ? this.sourceRouter.getString() : null;
    }

    public void setSourceRouter(String sourceRouter) {
        this.sourceRouter = sourceRouter != null ? new LazyUTF8String(sourceRouter) : null;
    }

    public String getDestRouter() {
        return this.destRouter != null ? this.destRouter.getString() : null;
    }

    public void setDestRouter(String destRouter) {
        this.destRouter = destRouter != null ? new LazyUTF8String(destRouter) : null;
    }

    public String getDestQueue() {
        return this.destQueue != null ? this.destQueue.getString() : null;
    }

    public void setDestQueue(String destQueue) {
        this.destQueue = destQueue != null ? new LazyUTF8String(destQueue) : null;
    }

    public void removeProperty(String name) {
        if (this.props != null) {
            this.props.remove(name);
        }
    }

    public String getJMSMessageID() throws JMSException {
        return this.messageId != null ? this.messageId.getString() : null;
    }

    public void setJMSMessageID(String id) throws JMSException {
        if (id != null) {
            StringBuffer b = new StringBuffer(id.length() + 5);
            b.append("ID:");
            b.append(id);
            this.messageId = new LazyUTF8String(b.toString());
        } else {
            this.messageId = null;
        }
    }

    public long getJMSTimestamp() throws JMSException {
        return this.timeStamp;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.timeStamp = timestamp;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.correlationId == null ? null : this.correlationId.getString().getBytes();
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        this.correlationId = correlationID != null ? new LazyUTF8String(new String(correlationID)) : null;
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.correlationId != null ? this.correlationId.getString() : null;
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.correlationId = correlationID != null ? new LazyUTF8String(correlationID) : null;
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.replyTo;
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this.replyTo = replyTo;
    }

    public Destination getJMSDestination() throws JMSException {
        return this.destination;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        if (destination == null) {
            throw new JMSException("Invalid destination - null!");
        }
        this.destination = destination;
        this.setDestQueue(((QueueImpl)destination).getQueueName());
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.deliveryMode;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this.deliveryMode = deliveryMode;
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.redelivered;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.redelivered = redelivered;
    }

    public String getJMSType() throws JMSException {
        return this.type != null ? this.type.getString() : null;
    }

    public void setJMSType(String type) throws JMSException {
        this.type = type != null ? new LazyUTF8String(type) : null;
    }

    public long getJMSExpiration() throws JMSException {
        return this.expiration;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.expiration = expiration;
    }

    public long getJMSDeliveryTime() throws JMSException {
        return 0L;
    }

    public void setJMSDeliveryTime(long l) throws JMSException {
    }

    public int getJMSPriority() throws JMSException {
        return this.priority;
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.priority = priority;
    }

    public void clearProperties() throws JMSException {
        this.props = null;
        this.propBytes = null;
        this.readOnly = false;
    }

    public boolean propertyExists(String name) throws JMSException {
        this.checkProps();
        return this.props.exists(name);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        this.checkProps();
        return this.props.getBoolean(name);
    }

    public byte getByteProperty(String name) throws JMSException {
        this.checkProps();
        return this.props.getByte(name);
    }

    public short getShortProperty(String name) throws JMSException {
        this.checkProps();
        return this.props.getShort(name);
    }

    public int getIntProperty(String name) throws JMSException {
        if (name.equals(PROP_DELIVERY_COUNT)) {
            return this.deliveryCount;
        }
        this.checkProps();
        return this.props.getInt(name);
    }

    public long getLongProperty(String name) throws JMSException {
        if (name.equals(PROP_DELIVERY_COUNT)) {
            return this.deliveryCount;
        }
        this.checkProps();
        return this.props.getLong(name);
    }

    public float getFloatProperty(String name) throws JMSException {
        this.checkProps();
        return this.props.getFloat(name);
    }

    public double getDoubleProperty(String name) throws JMSException {
        this.checkProps();
        return this.props.getDouble(name);
    }

    public String getStringProperty(String name) throws JMSException {
        if (name.equals(PROP_USER_ID)) {
            return this.userId != null ? this.userId.getString() : null;
        }
        if (name.equals(PROP_CLIENT_ID)) {
            return this.clientId != null ? this.clientId.getString() : null;
        }
        this.checkProps();
        return this.props.getString(name);
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (name.equals(PROP_USER_ID)) {
            return this.userId != null ? this.userId.getString() : null;
        }
        if (name.equals(PROP_CLIENT_ID)) {
            return this.clientId != null ? this.clientId.getString() : null;
        }
        if (name.equals(PROP_DELIVERY_COUNT)) {
            return String.valueOf(this.deliveryCount);
        }
        this.checkProps();
        return this.props.getObject(name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        this.checkProps();
        return this.props.enumeration();
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        if (this.readOnly) {
            throw new MessageNotWriteableException("Message properties are read only");
        }
        this.verifyName(name);
        this.checkProps();
        this.props.setBoolean(name, value);
        this.propBytes = null;
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        if (this.readOnly) {
            throw new MessageNotWriteableException("Message properties are read only");
        }
        this.verifyName(name);
        this.checkProps();
        this.props.setByte(name, value);
        this.propBytes = null;
    }

    public void setShortProperty(String name, short value) throws JMSException {
        if (this.readOnly) {
            throw new MessageNotWriteableException("Message properties are read only");
        }
        this.verifyName(name);
        this.checkProps();
        this.props.setShort(name, value);
        this.propBytes = null;
    }

    public void setIntProperty(String name, int value) throws JMSException {
        if (this.readOnly) {
            throw new MessageNotWriteableException("Message properties are read only");
        }
        this.verifyName(name);
        if (name != null && name.equals(PROP_DELIVERY_COUNT)) {
            this.deliveryCount = value;
        } else {
            this.checkProps();
            this.props.setInt(name, value);
            this.propBytes = null;
        }
    }

    public void setLongProperty(String name, long value) throws JMSException {
        if (this.readOnly) {
            throw new MessageNotWriteableException("Message properties are read only");
        }
        this.verifyName(name);
        this.checkProps();
        this.props.setLong(name, value);
        this.propBytes = null;
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        if (this.readOnly) {
            throw new MessageNotWriteableException("Message properties are read only");
        }
        this.verifyName(name);
        this.checkProps();
        this.props.setFloat(name, value);
        this.propBytes = null;
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        if (this.readOnly) {
            throw new MessageNotWriteableException("Message properties are read only");
        }
        this.verifyName(name);
        this.checkProps();
        this.props.setDouble(name, value);
        this.propBytes = null;
    }

    public void setStringProperty(String name, String value) throws JMSException {
        if (this.readOnly) {
            throw new MessageNotWriteableException("Message properties are read only");
        }
        this.verifyName(name);
        if (value != null && value.length() > 65535) {
            throw new JMSException("Maximum length of a String property is 65535! This value has a length of " + value.length());
        }
        if (name != null && name.equals(PROP_USER_ID)) {
            this.userId = value != null ? new LazyUTF8String(value) : null;
        } else if (name != null && name.equals(PROP_CLIENT_ID)) {
            this.clientId = value != null ? new LazyUTF8String(value) : null;
        } else {
            this.checkProps();
            if (value == null) {
                this.props.remove(name);
            } else {
                this.props.setString(name, value);
            }
            this.propBytes = null;
        }
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (this.readOnly) {
            throw new MessageNotWriteableException("Message properties are read only");
        }
        this.verifyName(name);
        this.checkProps();
        if (value == null) {
            this.props.remove(name);
        } else {
            if (value instanceof String && ((String)value).length() > 65535) {
                throw new JMSException("Maximum length of a String property is 65535! This value has a length of " + ((String)value).length());
            }
            this.props.setObject(name, value, false);
        }
        this.propBytes = null;
    }

    public void acknowledge() throws JMSException {
        if (this.myConsumer != null) {
            this.cancelled = this.myConsumer.acknowledgeMessage(this);
        } else if (this.mySession != null) {
            this.cancelled = this.mySession.acknowledgeMessage(this.messageIndex);
        }
    }

    public void clearBody() throws JMSException {
    }

    public <T> T getBody(Class<T> aClass) throws JMSException {
        return null;
    }

    public boolean isBodyAssignableTo(Class aClass) throws JMSException {
        return false;
    }

    public void reset() throws JMSException {
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString());
        s.append("\nmessageIndex = ");
        s.append(this.messageIndex);
        s.append("\nmessageId = ");
        s.append(this.messageId);
        s.append("\nuserId = ");
        s.append(this.userId);
        s.append("\nclientId = ");
        s.append(this.clientId);
        s.append("\ntimeStamp = ");
        s.append(this.timeStamp);
        s.append("\ncorrelationId = ");
        s.append(this.correlationId);
        s.append("\nreplyTo = ");
        s.append(this.replyTo);
        s.append("\ndestination = ");
        s.append(this.destination);
        s.append("\ndeliveryMode = ");
        s.append(this.deliveryMode);
        s.append("\nredelivered = ");
        s.append(this.redelivered);
        s.append("\ndeliveryCount = ");
        s.append(this.deliveryCount);
        s.append("\ntype = ");
        s.append(this.type);
        s.append("\nexpiration = ");
        s.append(this.expiration);
        s.append("\npriority = ");
        s.append(this.priority);
        s.append("\nprops = ");
        s.append(this.props);
        s.append("\nreadOnly = ");
        s.append(this.readOnly);
        s.append("\nsourceRouter = ");
        s.append(this.sourceRouter);
        s.append("\ndestRouter = ");
        s.append(this.destRouter);
        s.append("\ndestQueue = ");
        s.append(this.destQueue);
        return s.toString();
    }
}

