/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms;

import com.swiftmq.jms.primitives.Primitive;
import com.swiftmq.jms.primitives.PrimitiveFactory;
import com.swiftmq.jms.primitives._Boolean;
import com.swiftmq.jms.primitives._Byte;
import com.swiftmq.jms.primitives._Bytes;
import com.swiftmq.jms.primitives._Char;
import com.swiftmq.jms.primitives._Double;
import com.swiftmq.jms.primitives._Float;
import com.swiftmq.jms.primitives._Int;
import com.swiftmq.jms.primitives._Long;
import com.swiftmq.jms.primitives._Short;
import com.swiftmq.jms.primitives._String;
import com.swiftmq.tools.dump.Dumpable;
import jakarta.jms.JMSException;
import jakarta.jms.MessageFormatException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class MessageProperties
implements Enumeration {
    static ThreadLocal iterHolder = new ThreadLocal();
    Map<String, Dumpable> map = new TreeMap<String, Dumpable>();

    public void writeContent(DataOutput out) throws IOException {
        out.writeInt(this.map.size());
        for (Map.Entry<String, Dumpable> stringDumpableEntry : this.map.entrySet()) {
            out.writeUTF(stringDumpableEntry.getKey());
            Dumpable d = stringDumpableEntry.getValue();
            out.writeInt(d.getDumpId());
            d.writeContent(out);
        }
    }

    public void readContent(DataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String name = in.readUTF();
            Dumpable d = this.createDumpable(in.readInt());
            d.readContent(in);
            this.map.put(name, d);
        }
    }

    private void checkName(String name) throws IllegalArgumentException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name is null");
        }
    }

    private Dumpable createDumpable(int dumpId) {
        return (Dumpable)((Object)PrimitiveFactory.createInstance(dumpId));
    }

    void setBoolean(String name, boolean value) throws JMSException {
        this.checkName(name);
        this.map.put(name, new _Boolean(value));
    }

    void setShort(String name, short value) throws JMSException {
        this.checkName(name);
        this.map.put(name, new _Short(value));
    }

    void setInt(String name, int value) throws JMSException {
        this.checkName(name);
        this.map.put(name, new _Int(value));
    }

    void setLong(String name, long value) throws JMSException {
        this.checkName(name);
        this.map.put(name, new _Long(value));
    }

    void setDouble(String name, double value) throws JMSException {
        this.checkName(name);
        this.map.put(name, new _Double(value));
    }

    void setFloat(String name, float value) throws JMSException {
        this.checkName(name);
        this.map.put(name, new _Float(value));
    }

    void setChar(String name, char value) throws JMSException {
        this.checkName(name);
        this.map.put(name, new _Char(value));
    }

    void setByte(String name, byte value) throws JMSException {
        this.checkName(name);
        this.map.put(name, new _Byte(value));
    }

    void setBytes(String name, byte[] value) throws JMSException {
        this.checkName(name);
        this.map.put(name, new _Bytes(value));
    }

    void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        this.checkName(name);
        this.map.put(name, new _Bytes(value, offset, length));
    }

    void setString(String name, String value) throws JMSException {
        this.checkName(name);
        this.map.put(name, new _String(value));
    }

    void setObject(String name, Object value, boolean withBytes) throws JMSException {
        this.checkName(name);
        if (value instanceof Boolean) {
            this.setBoolean(name, (Boolean)value);
        } else if (value instanceof Byte) {
            this.setByte(name, (Byte)value);
        } else if (value instanceof Short) {
            this.setShort(name, (Short)value);
        } else if (value instanceof Integer) {
            this.setInt(name, (Integer)value);
        } else if (value instanceof Character) {
            this.setChar(name, ((Character)value).charValue());
        } else if (value instanceof Long) {
            this.setLong(name, (Long)value);
        } else if (value instanceof Float) {
            this.setFloat(name, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.setDouble(name, (Double)value);
        } else if (value instanceof String) {
            this.setString(name, (String)value);
        } else if (value instanceof byte[] && withBytes) {
            this.setBytes(name, (byte[])value);
        } else {
            throw new MessageFormatException("Invalid object format. Only primitives are supported.");
        }
    }

    private Object getValue(String name) {
        Primitive primitive = (Primitive)((Object)this.map.get(name));
        if (primitive != null) {
            return primitive.getObject();
        }
        return null;
    }

    boolean getBoolean(String name) throws JMSException {
        Object obj = this.getValue(name);
        if (obj == null) {
            return Boolean.valueOf((String)obj);
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.valueOf((String)obj);
        }
        throw new MessageFormatException("can't convert message value to boolean");
    }

    byte getByte(String name) throws JMSException {
        Object obj = this.getValue(name);
        if (obj == null) {
            return Byte.valueOf((String)obj);
        }
        if (obj instanceof Byte) {
            return (Byte)obj;
        }
        if (obj instanceof String) {
            return Byte.valueOf((String)obj);
        }
        throw new MessageFormatException("can't convert message value to byte");
    }

    short getShort(String name) throws JMSException {
        Object obj = this.getValue(name);
        if (obj == null) {
            return Short.valueOf((String)obj);
        }
        if (obj instanceof Byte) {
            return ((Byte)obj).byteValue();
        }
        if (obj instanceof Short) {
            return (Short)obj;
        }
        if (obj instanceof String) {
            return Short.valueOf((String)obj);
        }
        throw new MessageFormatException("can't convert property value to short");
    }

    char getChar(String name) throws JMSException {
        Object obj = this.getValue(name);
        if (obj == null) {
            throw new NullPointerException();
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue();
        }
        throw new MessageFormatException("can't convert message value to char");
    }

    int getInt(String name) throws JMSException {
        Object obj = this.getValue(name);
        if (obj == null) {
            return Integer.valueOf((String)obj);
        }
        if (obj instanceof Byte) {
            return ((Byte)obj).intValue();
        }
        if (obj instanceof Short) {
            return ((Short)obj).intValue();
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof String) {
            return Integer.valueOf((String)obj);
        }
        throw new MessageFormatException("can't convert message value to int");
    }

    long getLong(String name) throws JMSException {
        Object obj = this.getValue(name);
        if (obj == null) {
            return Long.valueOf((String)obj);
        }
        if (obj instanceof Byte) {
            return ((Byte)obj).intValue();
        }
        if (obj instanceof Short) {
            return ((Short)obj).intValue();
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).intValue();
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof String) {
            return Long.valueOf((String)obj);
        }
        throw new MessageFormatException("can't convert message value to long");
    }

    float getFloat(String name) throws JMSException {
        Object obj = this.getValue(name);
        if (obj == null) {
            return Float.valueOf((String)obj).floatValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        if (obj instanceof String) {
            return Float.valueOf((String)obj).floatValue();
        }
        throw new MessageFormatException("can't convert message value to float");
    }

    double getDouble(String name) throws JMSException {
        Object obj = this.getValue(name);
        if (obj == null) {
            return Double.valueOf((String)obj);
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        if (obj instanceof String) {
            return Double.valueOf((String)obj);
        }
        throw new MessageFormatException("can't convert message value to double");
    }

    byte[] getBytes(String name) throws JMSException {
        Object obj = this.getValue(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        throw new MessageFormatException("can't convert message value to byte[]");
    }

    String getString(String name) throws JMSException {
        Object obj = this.getValue(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            throw new MessageFormatException("can't convert byte[] to String");
        }
        return obj.toString();
    }

    Object getObject(String name) throws JMSException {
        return this.getValue(name);
    }

    boolean exists(String name) {
        return this.map.containsKey(name);
    }

    void remove(String name) {
        this.map.remove(name);
    }

    void clear() {
        this.map.clear();
    }

    Enumeration enumeration() {
        iterHolder.set(this.map.keySet().iterator());
        return this;
    }

    @Override
    public boolean hasMoreElements() {
        Iterator iter = (Iterator)iterHolder.get();
        boolean b = iter.hasNext();
        if (!b) {
            iterHolder.set(null);
        }
        return b;
    }

    public Object nextElement() {
        Iterator iter = (Iterator)iterHolder.get();
        if (iter == null || !iter.hasNext()) {
            return null;
        }
        return (String)iter.next();
    }

    public String toString() {
        return this.map.toString();
    }
}

