/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms;

import com.swiftmq.jms.MessageImpl;
import com.swiftmq.tools.util.LazyUTF8String;
import jakarta.jms.JMSException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.TextMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class TextMessageImpl
extends MessageImpl
implements TextMessage {
    private static int CHUNK_SIZE = 20480;
    boolean bodyReadOnly = false;
    LazyUTF8String[] lazy = null;

    @Override
    protected int getType() {
        return 5;
    }

    @Override
    protected void unfoldBody() {
        if (this.lazy != null) {
            for (int i = 0; i < this.lazy.length; ++i) {
                this.lazy[i].getString(true);
            }
        }
    }

    @Override
    protected void writeBody(DataOutput out) throws IOException {
        if (this.lazy == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeInt(this.lazy.length);
            for (int i = 0; i < this.lazy.length; ++i) {
                this.lazy[i].writeContent(out);
            }
        }
    }

    @Override
    protected void readBody(DataInput in) throws IOException {
        byte set = in.readByte();
        if (set == 0) {
            this.lazy = null;
        } else {
            int nChunks = in.readInt();
            this.lazy = new LazyUTF8String[nChunks];
            for (int i = 0; i < nChunks; ++i) {
                this.lazy[i] = new LazyUTF8String(in);
            }
        }
    }

    public String getText() throws JMSException {
        if (this.lazy == null) {
            return null;
        }
        if (this.lazy.length == 1) {
            return this.lazy[0].getString();
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < this.lazy.length; ++i) {
            b.append(this.lazy[i].getString());
        }
        return b.toString();
    }

    public void setText(String s) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("Message is read only");
        }
        if (s != null) {
            int nChunks = s.length() / CHUNK_SIZE + 1;
            this.lazy = new LazyUTF8String[nChunks];
            int pos = 0;
            for (int i = 0; i < nChunks; ++i) {
                String part = s.substring(pos, Math.min(pos + CHUNK_SIZE, s.length()));
                this.lazy[i] = new LazyUTF8String(part);
                pos += CHUNK_SIZE;
            }
        } else {
            this.lazy = null;
        }
    }

    @Override
    public void setReadOnly(boolean b) {
        super.setReadOnly(b);
        this.bodyReadOnly = b;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.lazy = null;
        this.bodyReadOnly = false;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer("[TextMessageImpl ");
        b.append(super.toString());
        b.append("\n");
        b.append("lazy=");
        b.append(this.lazy);
        b.append("\n");
        if (this.lazy != null) {
            b.append("lazy.length=");
            b.append(this.lazy.length);
            b.append("\n");
            for (int i = 0; i < this.lazy.length; ++i) {
                b.append("lazy[" + i + "]=");
                b.append(this.lazy[i]);
                b.append("\n");
            }
        }
        b.append("]");
        return b.toString();
    }
}

