/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.smqp.v750;

import com.swiftmq.jms.XidImpl;
import com.swiftmq.jms.smqp.v750.SMQPUtil;
import com.swiftmq.jms.smqp.v750.SMQPVisitor;
import com.swiftmq.jms.smqp.v750.XAResRollbackReply;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.RequestVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

public class XAResRollbackRequest
extends Request {
    private XidImpl xid;
    private boolean retry;
    private List recoverRequestList;
    private int recoveryEpoche;

    public XAResRollbackRequest() {
        super(0, true);
    }

    public XAResRollbackRequest(int dispatchId) {
        super(dispatchId, true);
    }

    public XAResRollbackRequest(RequestRetryValidator validator, int dispatchId) {
        super(dispatchId, true, validator);
    }

    public XAResRollbackRequest(int dispatchId, XidImpl xid, boolean retry, List recoverRequestList, int recoveryEpoche) {
        super(dispatchId, true);
        this.xid = xid;
        this.retry = retry;
        this.recoverRequestList = recoverRequestList;
        this.recoveryEpoche = recoveryEpoche;
    }

    public XAResRollbackRequest(RequestRetryValidator validator, int dispatchId, XidImpl xid, boolean retry, List recoverRequestList, int recoveryEpoche) {
        super(dispatchId, true, validator);
        this.xid = xid;
        this.retry = retry;
        this.recoverRequestList = recoverRequestList;
        this.recoveryEpoche = recoveryEpoche;
    }

    public XidImpl getXid() {
        return this.xid;
    }

    public void setXid(XidImpl xid) {
        this.xid = xid;
    }

    public boolean isRetry() {
        return this.retry;
    }

    public void setRetry(boolean retry) {
        this.retry = retry;
    }

    public List getRecoverRequestList() {
        return this.recoverRequestList;
    }

    public void setRecoverRequestList(List recoverRequestList) {
        this.recoverRequestList = recoverRequestList;
    }

    public int getRecoveryEpoche() {
        return this.recoveryEpoche;
    }

    public void setRecoveryEpoche(int recoveryEpoche) {
        this.recoveryEpoche = recoveryEpoche;
    }

    @Override
    public int getDumpId() {
        return 177;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        super.writeContent(out);
        SMQPUtil.write(this.xid, out);
        SMQPUtil.write(this.retry, out);
        if (this.recoverRequestList != null) {
            out.writeBoolean(true);
            SMQPUtil.writeRequest(this.recoverRequestList, out);
        } else {
            out.writeBoolean(false);
        }
        SMQPUtil.write(this.recoveryEpoche, out);
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        super.readContent(in);
        this.xid = SMQPUtil.read(this.xid, in);
        this.retry = SMQPUtil.read(this.retry, in);
        boolean recoverRequestList_set = in.readBoolean();
        if (recoverRequestList_set) {
            this.recoverRequestList = SMQPUtil.readRequest(this.recoverRequestList, in);
        }
        this.recoveryEpoche = SMQPUtil.read(this.recoveryEpoche, in);
    }

    @Override
    protected Reply createReplyInstance() {
        return new XAResRollbackReply();
    }

    @Override
    public void accept(RequestVisitor visitor) {
        ((SMQPVisitor)visitor).visit(this);
    }

    @Override
    public String toString() {
        StringBuffer _b = new StringBuffer("[v750/XAResRollbackRequest, ");
        _b.append(super.toString());
        _b.append(", ");
        _b.append("xid=");
        _b.append(this.xid);
        _b.append(", ");
        _b.append("retry=");
        _b.append(this.retry);
        _b.append(", ");
        _b.append("recoverRequestList=");
        _b.append(this.recoverRequestList);
        _b.append(", ");
        _b.append("recoveryEpoche=");
        _b.append(this.recoveryEpoche);
        _b.append("]");
        return _b.toString();
    }
}

