/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.springsupport;

import com.swiftmq.admin.cli.CLI;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;

public class CLIHelper {
    QueueConnectionFactory connectionFactory = null;
    QueueConnection connection = null;
    CLI cli = null;
    String userName = null;
    String password = null;
    String router = null;
    String[] initCommands = null;
    String[] destroyCommands = null;

    public QueueConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(QueueConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRouter() {
        return this.router;
    }

    public void setRouter(String router) {
        this.router = router;
    }

    public String[] getInitCommands() {
        return this.initCommands;
    }

    public void setInitCommands(String[] initCommands) {
        this.initCommands = initCommands;
    }

    public String[] getDestroyCommands() {
        return this.destroyCommands;
    }

    public void setDestroyCommands(String[] destroyCommands) {
        this.destroyCommands = destroyCommands;
    }

    public void initialize() throws Exception {
        if (this.connectionFactory == null) {
            throw new Exception("connectionFactory has not been set");
        }
        if (this.router == null) {
            throw new Exception("router not specified");
        }
        if (this.initCommands == null) {
            throw new Exception("No init commands specified");
        }
        this.connection = this.connectionFactory.createQueueConnection(this.userName, this.password);
        this.cli = new CLI(this.connection);
        this.cli.waitForRouter(this.router);
        this.cli.executeCommand("sr " + this.router);
        for (int i = 0; i < this.initCommands.length; ++i) {
            this.cli.executeCommand(this.initCommands[i]);
        }
    }

    public void destroy() throws Exception {
        if (this.connectionFactory == null) {
            throw new Exception("connectionFactory has not been set");
        }
        if (this.router == null) {
            throw new Exception("router not specified");
        }
        if (this.destroyCommands == null) {
            throw new Exception("No destroy commands specified");
        }
        if (this.connection == null) {
            this.connection = this.connectionFactory.createQueueConnection(this.userName, this.password);
            this.cli = new CLI(this.connection);
        }
        this.cli.executeCommand("sr " + this.router);
        this.cli.waitForRouter(this.router);
        for (int i = 0; i < this.destroyCommands.length; ++i) {
            this.cli.executeCommand(this.destroyCommands[i]);
        }
        this.cli.close();
        this.connection.close();
        this.cli = null;
        this.connection = null;
    }
}

