/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.springsupport;

import com.swiftmq.jms.springsupport.ConsumerKey;
import com.swiftmq.jms.springsupport.PooledSession;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.QueueReceiver;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;

public class PooledConsumer
implements QueueReceiver,
TopicSubscriber {
    static final boolean DEBUG = Boolean.valueOf(System.getProperty("swiftmq.springsupport.debug", "false"));
    PooledSession pooledSession = null;
    MessageConsumer internalConsumer = null;
    long checkInTime = -1L;
    ConsumerKey key = null;
    Destination dest = null;
    boolean noLocal = true;

    public PooledConsumer(PooledSession pooledSession, MessageConsumer internalConsumer, Destination dest, boolean noLocal, ConsumerKey key) {
        this.pooledSession = pooledSession;
        this.internalConsumer = internalConsumer;
        this.dest = dest;
        this.noLocal = noLocal;
        this.key = key;
        if (DEBUG) {
            System.out.println(this.toString() + "/created");
        }
    }

    public ConsumerKey getKey() {
        return this.key;
    }

    public long getCheckInTime() {
        return this.checkInTime;
    }

    public String getMessageSelector() throws JMSException {
        return this.internalConsumer.getMessageSelector();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.internalConsumer.getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/setMessageListener, ml=" + String.valueOf(messageListener));
        }
        this.internalConsumer.setMessageListener(messageListener);
    }

    public Message receive() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/receive");
        }
        return this.internalConsumer.receive();
    }

    public Message receive(long l) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/receive, to=" + l);
        }
        return this.internalConsumer.receive(l);
    }

    public Message receiveNoWait() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/receiveNoWait");
        }
        return this.internalConsumer.receiveNoWait();
    }

    protected void closeInternal() {
        if (DEBUG) {
            System.out.println(this.toString() + "/closeInternal");
        }
        try {
            this.internalConsumer.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void close() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/close");
        }
        this.checkInTime = System.currentTimeMillis();
        this.pooledSession.checkIn(this);
    }

    public Queue getQueue() throws JMSException {
        return (Queue)this.dest;
    }

    public Topic getTopic() throws JMSException {
        return (Topic)this.dest;
    }

    public boolean getNoLocal() throws JMSException {
        return this.noLocal;
    }

    public String toString() {
        return "/PooledConsumer, key=" + String.valueOf(this.key);
    }
}

