/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.springsupport;

import com.swiftmq.jms.springsupport.PooledSession;
import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueSender;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;

public class PooledProducer
implements QueueSender,
TopicPublisher {
    static final boolean DEBUG = Boolean.valueOf(System.getProperty("swiftmq.springsupport.debug", "false"));
    PooledSession pooledSession = null;
    MessageProducer internalProducer = null;
    Destination internalDestination = null;
    long checkInTime = -1L;

    public PooledProducer(PooledSession pooledSession, MessageProducer internalProducer, Destination internalDestination) {
        this.pooledSession = pooledSession;
        this.internalProducer = internalProducer;
        this.internalDestination = internalDestination;
        if (DEBUG) {
            System.out.println(this.toString() + "/created");
        }
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.internalProducer.getDisableMessageID();
    }

    public void setDisableMessageID(boolean b) throws JMSException {
        this.internalProducer.setDisableMessageID(b);
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.internalProducer.getDisableMessageTimestamp();
    }

    public void setDisableMessageTimestamp(boolean b) throws JMSException {
        this.internalProducer.setDisableMessageTimestamp(b);
    }

    public int getDeliveryMode() throws JMSException {
        return this.internalProducer.getDeliveryMode();
    }

    public void setDeliveryMode(int i) throws JMSException {
        this.internalProducer.setDeliveryMode(i);
    }

    public int getPriority() throws JMSException {
        return this.internalProducer.getPriority();
    }

    public void setPriority(int i) throws JMSException {
        this.internalProducer.setPriority(i);
    }

    public long getTimeToLive() throws JMSException {
        return this.internalProducer.getTimeToLive();
    }

    public void setDeliveryDelay(long l) throws JMSException {
    }

    public long getDeliveryDelay() throws JMSException {
        return 0L;
    }

    public void setTimeToLive(long l) throws JMSException {
        this.internalProducer.setTimeToLive(l);
    }

    public Destination getDestination() throws JMSException {
        return this.internalDestination;
    }

    public long getCheckInTime() {
        return this.checkInTime;
    }

    protected void closeInternal() {
        if (DEBUG) {
            System.out.println(this.toString() + "/closeInternal");
        }
        try {
            this.internalProducer.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void close() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/close");
        }
        this.checkInTime = System.currentTimeMillis();
        this.pooledSession.checkIn(this);
    }

    public void send(Destination destination, Message message) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/send, destination=" + String.valueOf(destination) + ", message=" + String.valueOf(message));
        }
        this.internalProducer.send(destination, message);
    }

    public void send(Destination destination, Message message, int i, int i1, long l) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/send, destination=" + String.valueOf(destination) + ", message=" + String.valueOf(message) + ", i=" + i + ", i1=" + i1 + ", l=" + l);
        }
        this.internalProducer.send(destination, message, i, i1, l);
    }

    public void send(Message message, CompletionListener completionListener) throws JMSException {
    }

    public void send(Message message, int i, int i1, long l, CompletionListener completionListener) throws JMSException {
    }

    public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
    }

    public void send(Destination destination, Message message, int i, int i1, long l, CompletionListener completionListener) throws JMSException {
    }

    public Queue getQueue() throws JMSException {
        return (Queue)this.internalDestination;
    }

    public void send(Message message) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/send, message=" + String.valueOf(message));
        }
        this.internalProducer.send(message);
    }

    public void send(Message message, int i, int i1, long l) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/send, message=" + String.valueOf(message) + ", i=" + i + ", i1=" + i1 + ", l=" + l);
        }
        this.internalProducer.send(message, i, i1, l);
    }

    public void send(Queue queue, Message message) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/send, queue=" + String.valueOf(queue) + ", message=" + String.valueOf(message));
        }
        this.internalProducer.send((Destination)queue, message);
    }

    public void send(Queue queue, Message message, int i, int i1, long l) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/send, queue=" + String.valueOf(queue) + ", message=" + String.valueOf(message) + ", i=" + i + ", i1=" + i1 + ", l=" + l);
        }
        this.internalProducer.send((Destination)queue, message, i, i1, l);
    }

    public Topic getTopic() throws JMSException {
        return (Topic)this.internalDestination;
    }

    public void publish(Message message) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/publish, message=" + String.valueOf(message));
        }
        this.internalProducer.send(message);
    }

    public void publish(Message message, int i, int i1, long l) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/publish, message=" + String.valueOf(message) + ", i=" + i + ", i1=" + i1 + ", l=" + l);
        }
        this.internalProducer.send(message, i, i1, l);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/publish, topic=" + String.valueOf(topic) + ", message=" + String.valueOf(message));
        }
        this.internalProducer.send((Destination)topic, message);
    }

    public void publish(Topic topic, Message message, int i, int i1, long l) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/publish, topic=" + String.valueOf(topic) + ", message=" + String.valueOf(message) + ", i=" + i + ", i1=" + i1 + ", l=" + l);
        }
        this.internalProducer.send((Destination)topic, message, i, i1, l);
    }

    public String toString() {
        return "/PooledProducer, internalDestination=" + String.valueOf(this.internalDestination);
    }
}

