/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.springsupport;

import com.swiftmq.jms.springsupport.ConsumerKey;
import com.swiftmq.jms.springsupport.PooledConsumer;
import com.swiftmq.jms.springsupport.PooledProducer;
import com.swiftmq.jms.springsupport.SharedJMSConnection;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PooledSession
implements Session,
QueueSession,
TopicSession {
    static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("swiftmq.springsupport.debug", "false"));
    private static final String NULL_DESTINATION = "_NULL_";
    SharedJMSConnection internalConnection;
    Session internalSession;
    Map<String, PooledConsumer> consumerPool = new ConcurrentHashMap<String, PooledConsumer>();
    Map<String, PooledProducer> producerPool = new ConcurrentHashMap<String, PooledProducer>();

    public PooledSession(SharedJMSConnection internalConnection, Session internalSession) {
        this.internalConnection = internalConnection;
        this.internalSession = internalSession;
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/created");
        }
    }

    protected void checkIn(PooledConsumer pooledConsumer) {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/checkIn, pooledConsumer=" + String.valueOf(pooledConsumer));
        }
        this.consumerPool.put(pooledConsumer.getKey().getKey(), pooledConsumer);
    }

    protected void checkIn(PooledProducer pooledProducer) {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/checkIn, pooledProducer=" + String.valueOf(pooledProducer));
        }
        try {
            Destination dest = pooledProducer.getDestination();
            String name = dest != null ? dest.toString() : NULL_DESTINATION;
            this.producerPool.put(name, pooledProducer);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void checkExpired() {
        if (this.consumerPool.size() == 0 && this.producerPool.size() == 0) {
            return;
        }
        Iterator<Map.Entry<String, Object>> iter = this.consumerPool.entrySet().iterator();
        while (iter.hasNext()) {
            PooledConsumer pc = iter.next().getValue();
            if (pc.getCheckInTime() + this.internalConnection.getPoolExpiration() > System.currentTimeMillis()) continue;
            if (DEBUG) {
                System.out.println(String.valueOf(this) + "/checkExpired, expired=" + String.valueOf(pc));
            }
            pc.closeInternal();
            iter.remove();
        }
        iter = this.producerPool.entrySet().iterator();
        while (iter.hasNext()) {
            PooledProducer pp = (PooledProducer)iter.next().getValue();
            if (pp.getCheckInTime() + this.internalConnection.getPoolExpiration() > System.currentTimeMillis()) continue;
            if (DEBUG) {
                System.out.println(String.valueOf(this) + "/checkExpired, expired=" + String.valueOf(pp));
            }
            pp.closeInternal();
            iter.remove();
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createBytesMessage");
        }
        return this.internalSession.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createMapMessage");
        }
        return this.internalSession.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createMessage");
        }
        return this.internalSession.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createObjectMessage");
        }
        return this.internalSession.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createObjectMessage2");
        }
        return this.internalSession.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createStreamMessage");
        }
        return this.internalSession.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createTextMessage");
        }
        return this.internalSession.createTextMessage();
    }

    public TextMessage createTextMessage(String s) throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createTextMessage2");
        }
        return this.internalSession.createTextMessage(s);
    }

    public boolean getTransacted() throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/getTransacted");
        }
        return this.internalSession.getTransacted();
    }

    public int getAcknowledgeMode() throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/getAcknowledgeMode");
        }
        return this.internalSession.getAcknowledgeMode();
    }

    public void commit() throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/commit");
        }
        this.internalSession.commit();
    }

    public void rollback() throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/rollback");
        }
        this.internalSession.rollback();
    }

    public void close() throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/close");
        }
        this.internalConnection.checkIn(this);
    }

    protected void closeInternal() throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/closeInternal");
        }
        Iterator<Map.Entry<String, Object>> iter = this.consumerPool.entrySet().iterator();
        while (iter.hasNext()) {
            PooledConsumer pc = iter.next().getValue();
            if (DEBUG) {
                System.out.println(String.valueOf(this) + "/closeInternal, close=" + String.valueOf(pc));
            }
            pc.closeInternal();
            iter.remove();
        }
        iter = this.producerPool.entrySet().iterator();
        while (iter.hasNext()) {
            PooledProducer pp = (PooledProducer)iter.next().getValue();
            if (DEBUG) {
                System.out.println(String.valueOf(this) + "/closeInternal, close=" + String.valueOf(pp));
            }
            pp.closeInternal();
            iter.remove();
        }
        this.internalSession.close();
    }

    public void recover() throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/recover");
        }
        this.internalSession.recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/getMessageListener");
        }
        return this.internalSession.getMessageListener();
    }

    public void setMessageListener(MessageListener ml) throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/setMessageListener, ml=" + String.valueOf(ml));
        }
        this.internalSession.setMessageListener(ml);
    }

    public void run() {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/run");
        }
        this.internalSession.run();
    }

    public Queue createQueue(String s) throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createQueue, s=" + s);
        }
        return this.internalSession.createQueue(s);
    }

    public Topic createTopic(String s) throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createTopic, s=" + s);
        }
        return this.internalSession.createTopic(s);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createBrowser, queue=" + String.valueOf(queue));
        }
        return this.internalSession.createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createBrowser, queue=" + String.valueOf(queue) + ", sel=" + string);
        }
        return this.internalSession.createBrowser(queue, string);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createTemporaryQueue");
        }
        return this.internalSession.createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createTemporaryTopic");
        }
        return this.internalSession.createTemporaryTopic();
    }

    public void unsubscribe(String string) throws JMSException {
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/unsubscribe, s=" + string);
        }
        this.internalSession.unsubscribe(string);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        String name = queue != null ? queue.toString() : NULL_DESTINATION;
        PooledProducer pp = this.producerPool.remove(name);
        if (pp != null) {
            if (DEBUG) {
                System.out.println(String.valueOf(this) + "/createSender, queue=" + name + ", return from pool");
            }
            return pp;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createSender, queue=" + name + ", creating new");
        }
        return new PooledProducer(this, this.internalSession.createProducer((Destination)queue), (Destination)queue);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        String name = topic != null ? topic.toString() : NULL_DESTINATION;
        PooledProducer pp = this.producerPool.remove(name);
        if (pp != null) {
            if (DEBUG) {
                System.out.println(String.valueOf(this) + "/createPublisher, topic=" + name + ", return from pool");
            }
            return pp;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createPublisher, topic=" + name + ", creating new");
        }
        return new PooledProducer(this, this.internalSession.createProducer((Destination)topic), (Destination)topic);
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        String name = destination != null ? destination.toString() : NULL_DESTINATION;
        PooledProducer pp = this.producerPool.remove(name);
        if (pp != null) {
            if (DEBUG) {
                System.out.println(String.valueOf(this) + "/createProducer, destination=" + name + ", return from pool");
            }
            return pp;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createProducer, destination=" + name + ", creating new");
        }
        return new PooledProducer(this, this.internalSession.createProducer(destination), destination);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        ConsumerKey key = new ConsumerKey(queue.getQueueName(), null, true, null);
        PooledConsumer pc = this.consumerPool.remove(key.getKey());
        if (pc != null) {
            if (DEBUG) {
                System.out.println(String.valueOf(this) + "/createReceiver, key=" + String.valueOf(key) + ", return from pool");
            }
            return pc;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createReceiver, key=" + String.valueOf(key) + ", creating new");
        }
        return new PooledConsumer(this, this.internalSession.createConsumer((Destination)queue), (Destination)queue, true, key);
    }

    public QueueReceiver createReceiver(Queue queue, String s) throws JMSException {
        ConsumerKey key = new ConsumerKey(queue.getQueueName(), s, true, null);
        PooledConsumer pc = this.consumerPool.remove(key.getKey());
        if (pc != null) {
            if (DEBUG) {
                System.out.println(String.valueOf(this) + "/createReceiver, key=" + String.valueOf(key) + ", return from pool");
            }
            return pc;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createReceiver, key=" + String.valueOf(key) + ", creating new");
        }
        return new PooledConsumer(this, this.internalSession.createConsumer((Destination)queue, s), (Destination)queue, true, key);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        ConsumerKey key = new ConsumerKey(topic.getTopicName(), null, true, null);
        PooledConsumer pc = this.consumerPool.remove(key.getKey());
        if (pc != null) {
            if (DEBUG) {
                System.out.println(String.valueOf(this) + "/createSubscriber, key=" + String.valueOf(key) + ", return from pool");
            }
            return pc;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createSubscriber, key=" + String.valueOf(key) + ", creating new");
        }
        return new PooledConsumer(this, this.internalSession.createConsumer((Destination)topic), (Destination)topic, true, key);
    }

    public TopicSubscriber createSubscriber(Topic topic, String s, boolean b) throws JMSException {
        ConsumerKey key = new ConsumerKey(topic.getTopicName(), s, b, null);
        PooledConsumer pc = this.consumerPool.remove(key.getKey());
        if (pc != null) {
            if (DEBUG) {
                System.out.println(String.valueOf(this) + "/createSubscriber, key=" + String.valueOf(key) + ", return from pool");
            }
            return pc;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createSubscriber, key=" + String.valueOf(key) + ", creating new");
        }
        return new PooledConsumer(this, this.internalSession.createConsumer((Destination)topic, s, b), (Destination)topic, b, key);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String s) throws JMSException {
        ConsumerKey key = new ConsumerKey(topic.getTopicName(), null, true, s);
        PooledConsumer pc = this.consumerPool.remove(key.getKey());
        if (pc != null) {
            if (DEBUG) {
                System.out.println(String.valueOf(this) + "/createDurableSubscriber, key=" + String.valueOf(key) + ", return from pool");
            }
            return pc;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createDurableSubscriber, key=" + String.valueOf(key) + ", creating new");
        }
        return new PooledConsumer(this, (MessageConsumer)this.internalSession.createDurableSubscriber(topic, s), (Destination)topic, true, key);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String s, String s1, boolean b) throws JMSException {
        ConsumerKey key = new ConsumerKey(topic.getTopicName(), s1, b, s);
        PooledConsumer pc = this.consumerPool.remove(key.getKey());
        if (pc != null) {
            if (DEBUG) {
                System.out.println(String.valueOf(this) + "/createDurableSubscriber, key=" + String.valueOf(key) + ", return from pool");
            }
            return pc;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createDurableSubscriber, key=" + String.valueOf(key) + ", creating new");
        }
        return new PooledConsumer(this, (MessageConsumer)this.internalSession.createDurableSubscriber(topic, s, s1, b), (Destination)topic, b, key);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String s) throws JMSException {
        return null;
    }

    public MessageConsumer createDurableConsumer(Topic topic, String s, String s1, boolean b) throws JMSException {
        return null;
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String s) throws JMSException {
        return null;
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String s, String s1) throws JMSException {
        return null;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        ConsumerKey key = new ConsumerKey(destination.toString(), null, true, null);
        PooledConsumer pc = this.consumerPool.remove(key.getKey());
        if (pc != null) {
            if (DEBUG) {
                System.out.println(String.valueOf(this) + "/createConsumer, key=" + String.valueOf(key) + ", return from pool");
            }
            return pc;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createConsumer, key=" + String.valueOf(key) + ", creating new");
        }
        return new PooledConsumer(this, this.internalSession.createConsumer(destination), destination, true, key);
    }

    public MessageConsumer createConsumer(Destination destination, String s) throws JMSException {
        ConsumerKey key = new ConsumerKey(destination.toString(), s, true, null);
        PooledConsumer pc = this.consumerPool.remove(key.getKey());
        if (pc != null) {
            if (DEBUG) {
                System.out.println(String.valueOf(this) + "/createConsumer, key=" + String.valueOf(key) + ", return from pool");
            }
            return pc;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createConsumer, key=" + String.valueOf(key) + ", creating new");
        }
        return new PooledConsumer(this, this.internalSession.createConsumer(destination, s), destination, true, key);
    }

    public MessageConsumer createConsumer(Destination destination, String s, boolean b) throws JMSException {
        ConsumerKey key = new ConsumerKey(destination.toString(), s, b, null);
        PooledConsumer pc = this.consumerPool.remove(key.getKey());
        if (pc != null) {
            if (DEBUG) {
                System.out.println(String.valueOf(this) + "/createConsumer, key=" + String.valueOf(key) + ", return from pool");
            }
            return pc;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this) + "/createConsumer, key=" + String.valueOf(key) + ", creating new");
        }
        return new PooledConsumer(this, this.internalSession.createConsumer(destination, s, b), destination, b, key);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String s) throws JMSException {
        return null;
    }

    public MessageConsumer createSharedConsumer(Topic topic, String s, String s1) throws JMSException {
        return null;
    }

    public String toString() {
        return "/PooledSession, internalSession=" + String.valueOf(this.internalSession);
    }
}

