/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.springsupport;

import com.swiftmq.jms.springsupport.PooledSession;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueSession;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicSession;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SharedJMSConnection
implements Connection,
QueueConnection,
TopicConnection {
    static final boolean DEBUG = Boolean.valueOf(System.getProperty("swiftmq.springsupport.debug", "false"));
    Connection internalConnection = null;
    long poolExpiration = 0L;
    boolean firstTransacted = false;
    int firstAckMode = -1;
    private final ConcurrentLinkedQueue<PoolEntry> pool = new ConcurrentLinkedQueue();
    private final Timer timer = new Timer(true);
    TimerTask expiryChecker = null;

    public SharedJMSConnection(Connection internalConnection, long poolExpiration) {
        this.internalConnection = internalConnection;
        this.poolExpiration = poolExpiration;
        if (poolExpiration > 0L) {
            long delay = poolExpiration + 500L;
            this.expiryChecker = new TimerTask(){

                @Override
                public void run() {
                    SharedJMSConnection.this.checkExpired();
                }
            };
            this.timer.schedule(this.expiryChecker, delay, delay);
        }
        if (DEBUG) {
            System.out.println(this.toString() + "/created");
        }
    }

    public long getPoolExpiration() {
        return this.poolExpiration;
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        PoolEntry entry;
        if (DEBUG) {
            System.out.println(this.toString() + "/createSession, poolSize=" + this.pool.size());
        }
        if ((entry = this.pool.poll()) != null) {
            if (DEBUG) {
                System.out.println(this.toString() + "/createSession, returning session from pool: " + String.valueOf(entry));
            }
            return entry.pooledSession;
        }
        if (this.firstAckMode == -1) {
            this.firstTransacted = transacted;
            this.firstAckMode = ackMode;
        } else if (transacted != this.firstTransacted || ackMode != this.firstAckMode) {
            throw new IllegalStateException("SharedJMSConnection: all JMS session must have the same transacted flag and ackMode!");
        }
        if (DEBUG) {
            System.out.println(this.toString() + "/createSession, returning a new session");
        }
        return new PooledSession(this, this.internalConnection.createSession(transacted, ackMode));
    }

    public Session createSession(int i) throws JMSException {
        return null;
    }

    public Session createSession() throws JMSException {
        return null;
    }

    protected void checkIn(PooledSession pooledSession) {
        this.pool.offer(new PoolEntry(System.currentTimeMillis(), pooledSession));
        if (DEBUG) {
            System.out.println(this.toString() + "/checkIn, poolSize=" + this.pool.size());
        }
    }

    public void checkExpired() {
        PoolEntry entry;
        if (DEBUG) {
            System.out.println(this.toString() + "/checkExpired, poolSize=" + this.pool.size());
        }
        long now = System.currentTimeMillis();
        while ((entry = this.pool.peek()) != null && entry.poolInsertionTime + this.poolExpiration <= now) {
            if (DEBUG) {
                System.out.println(this.toString() + "/checkExpired, now=" + now + ", expTime=" + (entry.poolInsertionTime + this.poolExpiration));
                entry.pooledSession.checkExpired();
                System.out.println(this.toString() + "/checkExpired, closing session=" + String.valueOf(entry.pooledSession));
            }
            try {
                entry.pooledSession.closeInternal();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            this.pool.poll();
        }
    }

    public QueueSession createQueueSession(boolean transacted, int ackMode) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createQueueSession");
        }
        return (QueueSession)this.createSession(transacted, ackMode);
    }

    public TopicSession createTopicSession(boolean transacted, int ackMode) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createTopicSession");
        }
        return (TopicSession)this.createSession(transacted, ackMode);
    }

    public String getClientID() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/getClientID");
        }
        return this.internalConnection.getClientID();
    }

    public void setClientID(String cid) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/setClientID, id=" + cid);
        }
        this.internalConnection.setClientID(cid);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/getMetaData");
        }
        return this.internalConnection.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/getExceptionListener");
        }
        return this.internalConnection.getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/setExceptionListener");
        }
        this.internalConnection.setExceptionListener(exceptionListener);
    }

    public void start() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/start");
        }
        this.internalConnection.start();
    }

    public void stop() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/stop");
        }
        this.internalConnection.stop();
    }

    public void close() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/close (ignore)");
        }
    }

    public void destroy() throws Exception {
        PoolEntry entry;
        if (DEBUG) {
            System.out.println(this.toString() + "/destroy");
        }
        while ((entry = this.pool.poll()) != null) {
            if (DEBUG) {
                System.out.println(this.toString() + "/destroy, closing session=" + String.valueOf(entry.pooledSession));
            }
            entry.pooledSession.closeInternal();
        }
        this.internalConnection.close();
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int i) throws JMSException {
        throw new IllegalStateException("SharedJMSConnection: operation is not supported!");
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String s, String s1, ServerSessionPool serverSessionPool, int i) throws JMSException {
        return null;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string1, ServerSessionPool serverSessionPool, int i) throws JMSException {
        throw new IllegalStateException("SharedJMSConnection: operation is not supported!");
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String s, String s1, ServerSessionPool serverSessionPool, int i) throws JMSException {
        return null;
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int i) throws JMSException {
        throw new IllegalStateException("SharedJMSConnection: operation is not supported!");
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int i) throws JMSException {
        throw new IllegalStateException("SharedJMSConnection: operation is not supported!");
    }

    public String toString() {
        return "/SharedJMSConnection";
    }

    private class PoolEntry {
        long poolInsertionTime = 0L;
        PooledSession pooledSession = null;

        public PoolEntry(long poolInsertionTime, PooledSession pooledSession) {
            this.poolInsertionTime = poolInsertionTime;
            this.pooledSession = pooledSession;
        }

        public String toString() {
            return "/PoolEntry, insertionTime=" + this.poolInsertionTime + ", pooledSession=" + String.valueOf(this.pooledSession);
        }
    }
}

