/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.springsupport;

import com.swiftmq.jms.springsupport.SharedJMSConnection;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;

public class SingleSharedConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory {
    static final boolean DEBUG = Boolean.valueOf(System.getProperty("swiftmq.springsupport.debug", "false"));
    private volatile ConnectionFactory targetConnectionFactory = null;
    private volatile SharedJMSConnection sharedConnection = null;
    private long poolExpiration = 60000L;
    private String clientId = null;

    public SingleSharedConnectionFactory() {
        if (DEBUG) {
            System.out.println(this.toString() + "/created");
        }
    }

    public SingleSharedConnectionFactory(ConnectionFactory targetConnectionFactory) {
        if (DEBUG) {
            System.out.println(this.toString() + "/created");
        }
        this.targetConnectionFactory = targetConnectionFactory;
    }

    public ConnectionFactory getTargetConnectionFactory() {
        return this.targetConnectionFactory;
    }

    public void setTargetConnectionFactory(ConnectionFactory targetConnectionFactory) {
        this.targetConnectionFactory = targetConnectionFactory;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public long getPoolExpiration() {
        return this.poolExpiration;
    }

    public void setPoolExpiration(long poolExpiration) {
        this.poolExpiration = poolExpiration;
    }

    private void ensureConnection() throws JMSException {
        if (this.sharedConnection == null) {
            if (DEBUG) {
                System.out.println(this.toString() + "/ensureConnection, create connection ...");
            }
            if (this.targetConnectionFactory == null) {
                throw new IllegalStateException("SingleSharedConnectionFactory: targetConnectionFactory has not been set!");
            }
            this.sharedConnection = new SharedJMSConnection(this.targetConnectionFactory.createConnection(), this.poolExpiration);
            if (this.clientId != null) {
                this.sharedConnection.setClientID(this.clientId);
            }
            if (DEBUG) {
                System.out.println(this.toString() + "/ensureConnection, create connection done");
            }
        }
    }

    public Connection createConnection() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createConnection");
        }
        this.ensureConnection();
        return this.sharedConnection;
    }

    public Connection createConnection(String user, String password) throws JMSException {
        throw new IllegalStateException("SingleSharedConnectionFactory: operation not supported!");
    }

    public JMSContext createContext() {
        return null;
    }

    public JMSContext createContext(String s, String s1) {
        return null;
    }

    public JMSContext createContext(String s, String s1, int i) {
        return null;
    }

    public JMSContext createContext(int i) {
        return null;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createQueueConnection");
        }
        this.ensureConnection();
        return this.sharedConnection;
    }

    public QueueConnection createQueueConnection(String user, String password) throws JMSException {
        throw new IllegalStateException("SingleSharedConnectionFactory: operation not supported!");
    }

    public TopicConnection createTopicConnection() throws JMSException {
        if (DEBUG) {
            System.out.println(this.toString() + "/createTopicConnection");
        }
        this.ensureConnection();
        return this.sharedConnection;
    }

    public TopicConnection createTopicConnection(String user, String password) throws JMSException {
        throw new IllegalStateException("SingleSharedConnectionFactory: operation not supported!");
    }

    public void destroy() throws Exception {
        if (DEBUG) {
            System.out.println(this.toString() + "/destroy");
        }
        if (this.sharedConnection != null) {
            if (DEBUG) {
                System.out.println(this.toString() + "/destroy, close shared connection ...");
            }
            this.sharedConnection.destroy();
            this.sharedConnection = null;
            if (DEBUG) {
                System.out.println(this.toString() + "/destroy, close shared connection done");
            }
        }
    }

    public String toString() {
        return "/SingleSharedConnectionFactory";
    }
}

