/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.v750;

import com.swiftmq.client.thread.PoolManager;
import com.swiftmq.jms.ExceptionConverter;
import com.swiftmq.jms.MessageImpl;
import com.swiftmq.jms.smqp.v750.AsyncMessageDeliveryRequest;
import com.swiftmq.jms.smqp.v750.CloseSessionRequest;
import com.swiftmq.jms.smqp.v750.StartConsumerRequest;
import com.swiftmq.jms.v750.ConnectionImpl;
import com.swiftmq.jms.v750.Recreatable;
import com.swiftmq.jms.v750.SessionImpl;
import com.swiftmq.jms.v750.XASessionImpl;
import com.swiftmq.swiftlet.queue.MessageEntry;
import com.swiftmq.swiftlet.threadpool.AsyncTask;
import com.swiftmq.swiftlet.threadpool.ThreadPool;
import com.swiftmq.tools.queue.SingleProcessorQueue;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRegistry;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.RequestService;
import com.swiftmq.tools.requestreply.ValidationException;
import com.swiftmq.tools.util.IdGenerator;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.JMSException;
import jakarta.jms.ServerSession;
import jakarta.jms.ServerSessionPool;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ConnectionConsumerImpl
implements ConnectionConsumer,
RequestService,
Recreatable,
RequestRetryValidator {
    public static final String DISPATCH_TOKEN = "sys$jms.client.session.connectionconsumer.queuetask";
    private static final long CC_SS_DELAY = Long.parseLong(System.getProperty("swiftmq.cc.ss.delay", "100"));
    static final boolean DEBUG = Boolean.valueOf(System.getProperty("swiftmq.reconnect.debug", "false"));
    String uniqueConsumerId = IdGenerator.getInstance().nextId('/');
    ConnectionImpl myConnection = null;
    int dispatchId = 0;
    int myDispatchId = 0;
    RequestRegistry requestRegistry = null;
    ThreadPool sessionPool = null;
    DeliveryQueue deliveryQueue = null;
    QueueTask queueTask = null;
    ServerSessionPool serverSessionPool;
    int maxMessages = 0;
    volatile ServerSession currentServerSession = null;
    volatile SessionImpl currentSession = null;
    volatile int nCurrent = 0;
    volatile boolean closed = false;
    volatile boolean resetInProgress = false;
    Set<String> messagesInProgress = ConcurrentHashMap.newKeySet();

    public ConnectionConsumerImpl(ConnectionImpl myConnection, int dispatchId, RequestRegistry requestRegistry, ServerSessionPool serverSessionPool, int maxMessages) {
        this.myConnection = myConnection;
        this.dispatchId = dispatchId;
        this.requestRegistry = requestRegistry;
        this.serverSessionPool = serverSessionPool;
        this.maxMessages = maxMessages;
        this.sessionPool = PoolManager.getInstance().getSessionPool();
        this.queueTask = new QueueTask();
        this.deliveryQueue = new DeliveryQueue();
    }

    public void setResetInProgress(boolean resetInProgress) {
        if (DEBUG) {
            System.out.println(String.valueOf(new Date()) + " " + this.toString() + ", setResetInProgress=" + resetInProgress);
        }
        this.resetInProgress = resetInProgress;
        if (resetInProgress) {
            this.deliveryQueue.stopQueue();
            this.deliveryQueue.clear();
            this.deliveryQueue.setCurrentCallInvalid(true);
        } else {
            this.deliveryQueue.clear();
            this.deliveryQueue.startQueue();
            this.fillCache();
        }
    }

    @Override
    public void validate(Request request) throws ValidationException {
        request.setDispatchId(this.dispatchId);
    }

    void startConsumer() {
        this.deliveryQueue.startQueue();
    }

    void stopConsumer() {
        this.deliveryQueue.stopQueue();
    }

    void fillCache() {
        if (DEBUG) {
            System.out.println(String.valueOf(new Date()) + " " + this.toString() + ", fillCache");
        }
        this.requestRegistry.request(new StartConsumerRequest(this, this.dispatchId, 0, this.myDispatchId, 0, this.myConnection.getSmqpConsumerCacheSize(), this.myConnection.getSmqpConsumerCacheSizeKB()));
    }

    protected abstract String getQueueName();

    public void setMyDispatchId(int myDispatchId) {
        this.myDispatchId = myDispatchId;
    }

    int getMsgNo(AsyncMessageDeliveryRequest request) {
        int n = 0;
        try {
            n = request.getMessageEntry().getMessage().getIntProperty("no");
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        return n;
    }

    @Override
    public void serviceRequest(Request request) {
        this.deliveryQueue.enqueue(request);
    }

    public boolean isDuplicate(MessageImpl msg) {
        if (!this.myConnection.isDuplicateMessageDetection()) {
            return false;
        }
        msg.setDuplicateId(SessionImpl.buildId(this.uniqueConsumerId, msg));
        return this.myConnection.isDuplicate(msg.getDuplicateId());
    }

    public void removeFromDuplicateLog(MessageImpl msg) {
        this.myConnection.removeFromDuplicateLog(msg.getDuplicateId());
    }

    public void markInProgress(MessageImpl msg, String messageId) {
        if (!this.myConnection.isDuplicateMessageDetection()) {
            return;
        }
        if (messageId != null) {
            this.messagesInProgress.add(messageId);
        }
    }

    public void unmarkInProgress(MessageImpl msg, String messageId) {
        if (!this.myConnection.isDuplicateMessageDetection()) {
            return;
        }
        if (messageId != null) {
            this.messagesInProgress.remove(messageId);
        }
    }

    private void checkInProgress(MessageImpl msg, String messageId) {
        if (!this.myConnection.isDuplicateMessageDetection()) {
            return;
        }
        boolean inProgress = false;
        do {
            if (!(inProgress = this.messagesInProgress.contains(messageId))) continue;
            try {
                Thread.sleep(CC_SS_DELAY);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (inProgress && !this.resetInProgress && !this.deliveryQueue.isCurrentCallInvalid());
    }

    public void processRequest(AsyncMessageDeliveryRequest request, boolean hasNext) {
        if (this.resetInProgress || this.deliveryQueue.isCurrentCallInvalid()) {
            return;
        }
        if (request.getConnectionId() != this.myConnection.getConnectionId()) {
            return;
        }
        try {
            if (this.currentServerSession == null) {
                this.currentServerSession = this.serverSessionPool.getServerSession();
                this.currentSession = this.currentServerSession.getSession() instanceof XASessionImpl ? ((XASessionImpl)this.currentServerSession.getSession()).session : (SessionImpl)this.currentServerSession.getSession();
                this.nCurrent = 0;
                if (!this.currentSession.isShadowConsumerCreated()) {
                    this.currentSession.createShadowConsumer(this.getQueueName());
                }
                this.currentSession.setConnectionConsumer(this);
                if (this.resetInProgress || this.deliveryQueue.isCurrentCallInvalid()) {
                    return;
                }
            }
            MessageEntry me = request.getMessageEntry();
            this.checkInProgress(me.getMessage(), me.getMessage().getJMSMessageID());
            if (this.resetInProgress || this.deliveryQueue.isCurrentCallInvalid()) {
                return;
            }
            me.setConnectionId(request.getConnectionId());
            this.currentSession.addMessageChunk(me);
            ++this.nCurrent;
            if (this.nCurrent == this.maxMessages || !hasNext) {
                this.currentServerSession.start();
                this.currentServerSession = null;
                this.currentSession = null;
                this.nCurrent = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (request.isRequiresRestart()) {
            this.fillCache();
        }
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        return this.serverSessionPool;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() throws JMSException {
        if (this.closed) {
            return;
        }
        Reply reply = null;
        try {
            reply = this.requestRegistry.request(new CloseSessionRequest(this, 0, this.dispatchId));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        this.deliveryQueue.stopQueue();
        this.deliveryQueue.close();
        this.myConnection.removeRequestService(this.myDispatchId);
        this.myConnection.removeConnectionConsumer(this);
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
    }

    void cancel() {
        this.closed = true;
        this.deliveryQueue.stopQueue();
        this.deliveryQueue.close();
    }

    private class DeliveryQueue
    extends SingleProcessorQueue {
        volatile boolean currentCallInvalid;

        public DeliveryQueue() {
            super(ConnectionConsumerImpl.this.myConnection.smqpConsumerCacheSize);
            this.currentCallInvalid = false;
        }

        public boolean isCurrentCallInvalid() {
            return this.currentCallInvalid;
        }

        public void setCurrentCallInvalid(boolean currentCallInvalid) {
            this.currentCallInvalid = currentCallInvalid;
        }

        @Override
        protected void startProcessor() {
            if (!ConnectionConsumerImpl.this.closed) {
                ConnectionConsumerImpl.this.sessionPool.dispatchTask(ConnectionConsumerImpl.this.queueTask);
            }
        }

        private boolean valid() {
            return !ConnectionConsumerImpl.this.resetInProgress && this.isStarted();
        }

        @Override
        protected void process(Object[] bulk, int n) {
            if (this.currentCallInvalid) {
                this.currentCallInvalid = false;
            }
            for (int i = 0; i < n; ++i) {
                ConnectionConsumerImpl.this.processRequest((AsyncMessageDeliveryRequest)bulk[i], i + 1 < n);
                if (this.valid() && !this.currentCallInvalid) continue;
                return;
            }
        }
    }

    private class QueueTask
    implements AsyncTask {
        private QueueTask() {
        }

        @Override
        public boolean isValid() {
            return !ConnectionConsumerImpl.this.closed;
        }

        @Override
        public String getDispatchToken() {
            return ConnectionConsumerImpl.DISPATCH_TOKEN;
        }

        @Override
        public String getDescription() {
            return ConnectionConsumerImpl.this.myConnection.myHostname + "/ConnectionConsumer/QueueTask";
        }

        @Override
        public void run() {
            if (!ConnectionConsumerImpl.this.closed && ConnectionConsumerImpl.this.deliveryQueue.dequeue()) {
                ConnectionConsumerImpl.this.sessionPool.dispatchTask(this);
            }
        }

        @Override
        public void stop() {
        }
    }
}

