/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.v750;

import com.swiftmq.client.thread.PoolManager;
import com.swiftmq.jms.CompoundConnectionFactory;
import com.swiftmq.jms.v750.ConnectionImpl;
import com.swiftmq.jms.v750.QueueConnectionImpl;
import com.swiftmq.jms.v750.TopicConnectionImpl;
import com.swiftmq.jms.v750.XAConnectionImpl;
import com.swiftmq.jms.v750.XAQueueConnectionImpl;
import com.swiftmq.jms.v750.XATopicConnectionImpl;
import com.swiftmq.jndi.v400.SwiftMQObjectFactory;
import com.swiftmq.net.SocketFactory;
import com.swiftmq.net.SocketFactory2;
import com.swiftmq.net.client.BlockingReconnector;
import com.swiftmq.net.client.IntraVMReconnector;
import com.swiftmq.net.client.Reconnector;
import com.swiftmq.net.client.ServerEntry;
import com.swiftmq.tools.dump.Dumpable;
import jakarta.jms.Connection;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.QueueConnection;
import jakarta.jms.TopicConnection;
import jakarta.jms.XAConnection;
import jakarta.jms.XAJMSContext;
import jakarta.jms.XAQueueConnection;
import jakarta.jms.XATopicConnection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class ConnectionFactoryImpl
implements CompoundConnectionFactory,
Referenceable,
Serializable,
Dumpable {
    String listenerName = null;
    String socketFactoryClass = null;
    SocketFactory socketFactory = null;
    String hostname = null;
    int port = 0;
    long keepaliveInterval = 0L;
    String clientId = null;
    int smqpProducerReplyInterval = 0;
    int smqpConsumerCacheSize = 0;
    int smqpConsumerCacheSizeKB = -1;
    int jmsDeliveryMode = 0;
    int jmsPriority = 0;
    long jmsTTL = 0L;
    boolean jmsMessageIdEnabled = false;
    boolean jmsMessageTimestampEnabled = false;
    boolean useThreadContextCL = false;
    int inputBufferSize = 0;
    int inputExtendSize = 0;
    int outputBufferSize = 0;
    int outputExtendSize = 0;
    boolean intraVM = false;
    String hostname2 = null;
    int port2 = 0;
    boolean reconnectEnabled = false;
    int maxRetries = 0;
    long retryDelay = 0L;
    boolean duplicateMessageDetection = false;
    int duplicateBacklogSize = 500;

    public ConnectionFactoryImpl(String listenerName, String socketFactoryClass, String hostname, int port, long keepaliveInterval, String clientId, int smqpProducerReplyInterval, int smqpConsumerCacheSize, int smqpConsumerCacheSizeKB, int jmsDeliveryMode, int jmsPriority, long jmsTTL, boolean jmsMessageIdEnabled, boolean jmsMessageTimestampEnabled, boolean useThreadContextCL, int inputBufferSize, int inputExtendSize, int outputBufferSize, int outputExtendSize, boolean intraVM) {
        this.listenerName = listenerName;
        this.socketFactoryClass = socketFactoryClass;
        this.hostname = hostname;
        this.port = port;
        this.keepaliveInterval = keepaliveInterval;
        this.clientId = clientId;
        this.smqpProducerReplyInterval = smqpProducerReplyInterval;
        this.smqpConsumerCacheSize = smqpConsumerCacheSize;
        this.smqpConsumerCacheSizeKB = smqpConsumerCacheSizeKB;
        this.jmsDeliveryMode = jmsDeliveryMode;
        this.jmsPriority = jmsPriority;
        this.jmsTTL = jmsTTL;
        this.jmsMessageIdEnabled = jmsMessageIdEnabled;
        this.jmsMessageTimestampEnabled = jmsMessageTimestampEnabled;
        this.useThreadContextCL = useThreadContextCL;
        this.inputBufferSize = inputBufferSize;
        this.inputExtendSize = inputExtendSize;
        this.outputBufferSize = outputBufferSize;
        this.outputExtendSize = outputExtendSize;
        this.intraVM = intraVM;
    }

    public ConnectionFactoryImpl(String socketFactoryClass, String hostname, int port, long keepaliveInterval) {
        this(null, socketFactoryClass, hostname, port, keepaliveInterval, null, 20, 500, -1, 2, 4, 0L, true, true, false, 131072, 65536, 131072, 65536, false);
    }

    public ConnectionFactoryImpl() {
    }

    public String getHostname2() {
        return this.hostname2;
    }

    public void setHostname2(String hostname2) {
        this.hostname2 = hostname2;
    }

    public int getPort2() {
        return this.port2;
    }

    public void setPort2(int port2) {
        this.port2 = port2;
    }

    public boolean isReconnectEnabled() {
        return this.reconnectEnabled;
    }

    public void setReconnectEnabled(boolean reconnectEnabled) {
        this.reconnectEnabled = reconnectEnabled;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    public boolean isDuplicateMessageDetection() {
        return this.duplicateMessageDetection;
    }

    public void setDuplicateMessageDetection(boolean duplicateMessageDetection) {
        this.duplicateMessageDetection = duplicateMessageDetection;
    }

    public int getDuplicateBacklogSize() {
        return this.duplicateBacklogSize;
    }

    public void setDuplicateBacklogSize(int duplicateBacklogSize) {
        this.duplicateBacklogSize = duplicateBacklogSize;
    }

    @Override
    public int getDumpId() {
        return 0;
    }

    private void writeDump(DataOutput out, String s) throws IOException {
        if (s != null) {
            out.writeByte(1);
            out.writeUTF(s);
        } else {
            out.writeByte(0);
        }
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        this.writeDump(out, this.listenerName);
        this.writeDump(out, this.socketFactoryClass);
        this.writeDump(out, this.hostname);
        out.writeInt(this.port);
        out.writeLong(this.keepaliveInterval);
        this.writeDump(out, this.clientId);
        out.writeInt(this.smqpProducerReplyInterval);
        out.writeInt(this.smqpConsumerCacheSize);
        out.writeInt(this.smqpConsumerCacheSizeKB);
        out.writeInt(this.jmsDeliveryMode);
        out.writeInt(this.jmsPriority);
        out.writeLong(this.jmsTTL);
        out.writeBoolean(this.jmsMessageIdEnabled);
        out.writeBoolean(this.jmsMessageTimestampEnabled);
        out.writeBoolean(this.useThreadContextCL);
        out.writeInt(this.inputBufferSize);
        out.writeInt(this.inputExtendSize);
        out.writeInt(this.outputBufferSize);
        out.writeInt(this.outputExtendSize);
        out.writeBoolean(this.intraVM);
        this.writeDump(out, this.hostname2);
        out.writeInt(this.port2);
        out.writeBoolean(this.reconnectEnabled);
        out.writeLong(this.retryDelay);
        out.writeInt(this.maxRetries);
        out.writeBoolean(this.duplicateMessageDetection);
        out.writeInt(this.duplicateBacklogSize);
    }

    private String readDump(DataInput in) throws IOException {
        String s = null;
        if (in.readByte() == 1) {
            s = in.readUTF();
        }
        return s;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        this.listenerName = this.readDump(in);
        this.socketFactoryClass = this.readDump(in);
        this.hostname = this.readDump(in);
        this.port = in.readInt();
        this.keepaliveInterval = in.readLong();
        this.clientId = this.readDump(in);
        this.smqpProducerReplyInterval = in.readInt();
        this.smqpConsumerCacheSize = in.readInt();
        this.smqpConsumerCacheSizeKB = in.readInt();
        this.jmsDeliveryMode = in.readInt();
        this.jmsPriority = in.readInt();
        this.jmsTTL = in.readLong();
        this.jmsMessageIdEnabled = in.readBoolean();
        this.jmsMessageTimestampEnabled = in.readBoolean();
        this.useThreadContextCL = in.readBoolean();
        this.inputBufferSize = in.readInt();
        this.inputExtendSize = in.readInt();
        this.outputBufferSize = in.readInt();
        this.outputExtendSize = in.readInt();
        this.intraVM = in.readBoolean();
        this.hostname2 = this.readDump(in);
        this.port2 = in.readInt();
        this.reconnectEnabled = in.readBoolean();
        this.retryDelay = in.readLong();
        this.maxRetries = in.readInt();
        this.duplicateMessageDetection = in.readBoolean();
        this.duplicateBacklogSize = in.readInt();
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(ConnectionFactoryImpl.class.getName(), new StringRefAddr("listenerName", this.listenerName), SwiftMQObjectFactory.class.getName(), null);
        ref.add(new StringRefAddr("socketFactoryClass", this.socketFactoryClass));
        ref.add(new StringRefAddr("hostname", this.hostname));
        ref.add(new StringRefAddr("port", String.valueOf(this.port)));
        ref.add(new StringRefAddr("keepaliveInterval", String.valueOf(this.keepaliveInterval)));
        if (this.clientId != null) {
            ref.add(new StringRefAddr("clientId", this.clientId));
        }
        ref.add(new StringRefAddr("smqpProducerReplyInterval", String.valueOf(this.smqpProducerReplyInterval)));
        ref.add(new StringRefAddr("smqpConsumerCacheSize", String.valueOf(this.smqpConsumerCacheSize)));
        ref.add(new StringRefAddr("smqpConsumerCacheSizeKB", String.valueOf(this.smqpConsumerCacheSizeKB)));
        ref.add(new StringRefAddr("jmsDeliveryMode", String.valueOf(this.jmsDeliveryMode)));
        ref.add(new StringRefAddr("jmsPriority", String.valueOf(this.jmsPriority)));
        ref.add(new StringRefAddr("jmsTTL", String.valueOf(this.jmsTTL)));
        ref.add(new StringRefAddr("jmsMessageIdEnabled", String.valueOf(this.jmsMessageIdEnabled)));
        ref.add(new StringRefAddr("jmsMessageTimestampEnabled", String.valueOf(this.jmsMessageTimestampEnabled)));
        ref.add(new StringRefAddr("useThreadContextCL", String.valueOf(this.useThreadContextCL)));
        ref.add(new StringRefAddr("inputBufferSize", String.valueOf(this.inputBufferSize)));
        ref.add(new StringRefAddr("inputExtendSize", String.valueOf(this.inputExtendSize)));
        ref.add(new StringRefAddr("outputBufferSize", String.valueOf(this.outputBufferSize)));
        ref.add(new StringRefAddr("outputExtendSize", String.valueOf(this.outputExtendSize)));
        ref.add(new StringRefAddr("intraVM", String.valueOf(this.intraVM)));
        ref.add(new StringRefAddr("reconnectEnabled", String.valueOf(this.reconnectEnabled)));
        ref.add(new StringRefAddr("retryDelay", String.valueOf(this.retryDelay)));
        ref.add(new StringRefAddr("maxRetries", String.valueOf(this.maxRetries)));
        if (this.hostname2 != null) {
            ref.add(new StringRefAddr("hostname2", this.hostname2));
            ref.add(new StringRefAddr("port2", String.valueOf(this.port2)));
        }
        ref.add(new StringRefAddr("duplicateMessageDetection", String.valueOf(this.duplicateMessageDetection)));
        ref.add(new StringRefAddr("duplicateBacklogSize", String.valueOf(this.duplicateBacklogSize)));
        return ref;
    }

    public String getListenerName() {
        return this.listenerName;
    }

    private Reconnector createReconnector() throws JMSException {
        PoolManager.setIntraVM(this.intraVM);
        Reconnector reconnector = null;
        if (this.intraVM) {
            try {
                ArrayList<ServerEntry> servers = new ArrayList<ServerEntry>();
                servers.add(new ServerEntry("intravm", 0));
                reconnector = new IntraVMReconnector(servers, null, false, 0, 0L, Boolean.valueOf(System.getProperty("swiftmq.reconnect.debug", "false")));
            }
            catch (Exception e) {
                throw new JMSException("error creating intraVM connection, message: " + e.getMessage());
            }
        }
        try {
            ArrayList<ServerEntry> servers = new ArrayList<ServerEntry>();
            servers.add(new ServerEntry(this.hostname, this.port));
            if (this.reconnectEnabled && this.hostname2 != null) {
                servers.add(new ServerEntry(this.hostname2, this.port2));
            }
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("tcp_no_delay", Boolean.valueOf(System.getProperty("swiftmq.tcp.no.delay", "true")));
            parameters.put("input_buffer_size", new Integer(this.inputBufferSize));
            parameters.put("input_extend_size", new Integer(this.inputExtendSize));
            parameters.put("output_buffer_size", new Integer(this.outputBufferSize));
            parameters.put("output_extend_size", new Integer(this.outputExtendSize));
            SocketFactory sf = (SocketFactory)Class.forName(this.socketFactoryClass).newInstance();
            if (sf instanceof SocketFactory2) {
                ((SocketFactory2)sf).setReceiveBufferSize(this.inputBufferSize);
            }
            parameters.put("socketfactory", sf);
            reconnector = new BlockingReconnector(servers, parameters, this.reconnectEnabled, this.maxRetries, this.retryDelay, Boolean.valueOf(System.getProperty("swiftmq.reconnect.debug", "false")));
        }
        catch (Exception e) {
            throw new JMSException("error creating socket connection to " + this.hostname + ":" + this.port + ", message: " + e.getMessage());
        }
        return reconnector;
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        ConnectionImpl qc = new ConnectionImpl(userName == null ? "anonymous" : userName, password, this.createReconnector());
        qc.assignClientId(this.clientId);
        qc.setSmqpProducerReplyInterval(this.smqpProducerReplyInterval);
        qc.setSmqpConsumerCacheSize(this.smqpConsumerCacheSize);
        qc.setSmqpConsumerCacheSizeKB(this.smqpConsumerCacheSizeKB);
        qc.setJmsDeliveryMode(this.jmsDeliveryMode);
        qc.setJmsPriority(this.jmsPriority);
        qc.setJmsTTL(this.jmsTTL);
        qc.setJmsMessageIdEnabled(this.jmsMessageIdEnabled);
        qc.setJmsMessageTimestampEnabled(this.jmsMessageTimestampEnabled);
        qc.setUseThreadContextCL(this.useThreadContextCL);
        qc.setDuplicateMessageDetection(this.duplicateMessageDetection);
        qc.setDuplicateBacklogSize(this.duplicateBacklogSize);
        if (this.keepaliveInterval > 0L) {
            qc.startKeepAlive(this.keepaliveInterval);
        }
        return qc;
    }

    public JMSContext createContext() {
        return null;
    }

    public JMSContext createContext(String s, String s1) {
        return null;
    }

    public JMSContext createContext(String s, String s1, int i) {
        return null;
    }

    public JMSContext createContext(int i) {
        return null;
    }

    public XAConnection createXAConnection() throws JMSException {
        return this.createXAConnection(null, null);
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        XAConnectionImpl qc = new XAConnectionImpl(userName == null ? "anonymous" : userName, password, this.createReconnector());
        qc.assignClientId(this.clientId);
        qc.setSmqpProducerReplyInterval(this.smqpProducerReplyInterval);
        qc.setSmqpConsumerCacheSize(this.smqpConsumerCacheSize);
        qc.setSmqpConsumerCacheSizeKB(this.smqpConsumerCacheSizeKB);
        qc.setJmsDeliveryMode(this.jmsDeliveryMode);
        qc.setJmsPriority(this.jmsPriority);
        qc.setJmsTTL(this.jmsTTL);
        qc.setJmsMessageIdEnabled(this.jmsMessageIdEnabled);
        qc.setJmsMessageTimestampEnabled(this.jmsMessageTimestampEnabled);
        qc.setUseThreadContextCL(this.useThreadContextCL);
        qc.setDuplicateMessageDetection(this.duplicateMessageDetection);
        qc.setDuplicateBacklogSize(this.duplicateBacklogSize);
        if (this.keepaliveInterval > 0L) {
            qc.startKeepAlive(this.keepaliveInterval);
        }
        return qc;
    }

    public XAJMSContext createXAContext() {
        return null;
    }

    public XAJMSContext createXAContext(String s, String s1) {
        return null;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(null, null);
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        QueueConnectionImpl qc = new QueueConnectionImpl(userName == null ? "anonymous" : userName, password, this.createReconnector());
        qc.assignClientId(this.clientId);
        qc.setSmqpProducerReplyInterval(this.smqpProducerReplyInterval);
        qc.setSmqpConsumerCacheSize(this.smqpConsumerCacheSize);
        qc.setSmqpConsumerCacheSizeKB(this.smqpConsumerCacheSizeKB);
        qc.setJmsDeliveryMode(this.jmsDeliveryMode);
        qc.setJmsPriority(this.jmsPriority);
        qc.setJmsTTL(this.jmsTTL);
        qc.setJmsMessageIdEnabled(this.jmsMessageIdEnabled);
        qc.setJmsMessageTimestampEnabled(this.jmsMessageTimestampEnabled);
        qc.setUseThreadContextCL(this.useThreadContextCL);
        qc.setDuplicateMessageDetection(this.duplicateMessageDetection);
        qc.setDuplicateBacklogSize(this.duplicateBacklogSize);
        if (this.keepaliveInterval > 0L) {
            qc.startKeepAlive(this.keepaliveInterval);
        }
        return qc;
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return this.createXAQueueConnection(null, null);
    }

    public XAQueueConnection createXAQueueConnection(String userName, String password) throws JMSException {
        XAQueueConnectionImpl qc = new XAQueueConnectionImpl(userName == null ? "anonymous" : userName, password, this.createReconnector());
        qc.assignClientId(this.clientId);
        qc.setSmqpProducerReplyInterval(this.smqpProducerReplyInterval);
        qc.setSmqpConsumerCacheSize(this.smqpConsumerCacheSize);
        qc.setSmqpConsumerCacheSizeKB(this.smqpConsumerCacheSizeKB);
        qc.setJmsDeliveryMode(this.jmsDeliveryMode);
        qc.setJmsPriority(this.jmsPriority);
        qc.setJmsTTL(this.jmsTTL);
        qc.setJmsMessageIdEnabled(this.jmsMessageIdEnabled);
        qc.setJmsMessageTimestampEnabled(this.jmsMessageTimestampEnabled);
        qc.setUseThreadContextCL(this.useThreadContextCL);
        qc.setDuplicateMessageDetection(this.duplicateMessageDetection);
        qc.setDuplicateBacklogSize(this.duplicateBacklogSize);
        if (this.keepaliveInterval > 0L) {
            qc.startKeepAlive(this.keepaliveInterval);
        }
        return qc;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createTopicConnection(null, null);
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        TopicConnectionImpl qc = new TopicConnectionImpl(userName == null ? "anonymous" : userName, password, this.createReconnector());
        qc.assignClientId(this.clientId);
        qc.setSmqpProducerReplyInterval(this.smqpProducerReplyInterval);
        qc.setSmqpConsumerCacheSize(this.smqpConsumerCacheSize);
        qc.setSmqpConsumerCacheSizeKB(this.smqpConsumerCacheSizeKB);
        qc.setJmsDeliveryMode(this.jmsDeliveryMode);
        qc.setJmsPriority(this.jmsPriority);
        qc.setJmsTTL(this.jmsTTL);
        qc.setJmsMessageIdEnabled(this.jmsMessageIdEnabled);
        qc.setJmsMessageTimestampEnabled(this.jmsMessageTimestampEnabled);
        qc.setUseThreadContextCL(this.useThreadContextCL);
        qc.setDuplicateMessageDetection(this.duplicateMessageDetection);
        qc.setDuplicateBacklogSize(this.duplicateBacklogSize);
        if (this.keepaliveInterval > 0L) {
            qc.startKeepAlive(this.keepaliveInterval);
        }
        return qc;
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        return this.createXATopicConnection(null, null);
    }

    public XATopicConnection createXATopicConnection(String userName, String password) throws JMSException {
        XATopicConnectionImpl qc = new XATopicConnectionImpl(userName == null ? "anonymous" : userName, password, this.createReconnector());
        qc.assignClientId(this.clientId);
        qc.setSmqpProducerReplyInterval(this.smqpProducerReplyInterval);
        qc.setSmqpConsumerCacheSize(this.smqpConsumerCacheSize);
        qc.setSmqpConsumerCacheSizeKB(this.smqpConsumerCacheSizeKB);
        qc.setJmsDeliveryMode(this.jmsDeliveryMode);
        qc.setJmsPriority(this.jmsPriority);
        qc.setJmsTTL(this.jmsTTL);
        qc.setJmsMessageIdEnabled(this.jmsMessageIdEnabled);
        qc.setJmsMessageTimestampEnabled(this.jmsMessageTimestampEnabled);
        qc.setUseThreadContextCL(this.useThreadContextCL);
        qc.setDuplicateMessageDetection(this.duplicateMessageDetection);
        qc.setDuplicateBacklogSize(this.duplicateBacklogSize);
        if (this.keepaliveInterval > 0L) {
            qc.startKeepAlive(this.keepaliveInterval);
        }
        return qc;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[ConnectionFactoryImpl, socketFactoryClass=");
        s.append(this.socketFactoryClass);
        s.append(", hostname=");
        s.append(this.hostname);
        s.append(", port=");
        s.append(this.port);
        s.append(", keepaliveInterval=");
        s.append(this.keepaliveInterval);
        s.append(", clientId=");
        s.append(this.clientId);
        s.append(", smqpProducerReplyInterval=");
        s.append(this.smqpProducerReplyInterval);
        s.append(", smqpConsumerCacheSize=");
        s.append(this.smqpConsumerCacheSize);
        s.append(", smqpConsumerCacheSizeKB=");
        s.append(this.smqpConsumerCacheSizeKB);
        s.append(", jmsDeliveryMode=");
        s.append(this.jmsDeliveryMode);
        s.append(", jmsPriority=");
        s.append(this.jmsPriority);
        s.append(", jmsTTL=");
        s.append(this.jmsTTL);
        s.append(", jmsMessageIdEnabled=");
        s.append(this.jmsMessageIdEnabled);
        s.append(", jmsMessageTimestampEnabled=");
        s.append(this.jmsMessageTimestampEnabled);
        s.append(", useThreadContextCL=");
        s.append(this.useThreadContextCL);
        s.append(", inputBufferSize=");
        s.append(this.inputBufferSize);
        s.append(", inputExtendSize=");
        s.append(this.inputExtendSize);
        s.append(", outputBufferSize=");
        s.append(this.outputBufferSize);
        s.append(", outputExtendSize=");
        s.append(this.outputExtendSize);
        s.append(", intraVM=");
        s.append(this.intraVM);
        s.append(", hostname2=");
        s.append(this.hostname2);
        s.append(", port2=");
        s.append(this.port2);
        s.append(", reconnectEnabled=");
        s.append(this.reconnectEnabled);
        s.append(", retryDelay=");
        s.append(this.retryDelay);
        s.append(", maxRetries=");
        s.append(this.maxRetries);
        s.append(", duplicateMessageDetection=");
        s.append(this.duplicateMessageDetection);
        s.append(", duplicateBacklogSize=");
        s.append(this.duplicateBacklogSize);
        s.append("]");
        return s.toString();
    }
}

