/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jms.v750;

import com.swiftmq.client.thread.PoolManager;
import com.swiftmq.jms.BytesMessageImpl;
import com.swiftmq.jms.DestinationImpl;
import com.swiftmq.jms.ExceptionConverter;
import com.swiftmq.jms.MapMessageImpl;
import com.swiftmq.jms.MessageImpl;
import com.swiftmq.jms.ObjectMessageImpl;
import com.swiftmq.jms.QueueImpl;
import com.swiftmq.jms.SessionExtended;
import com.swiftmq.jms.StreamMessageImpl;
import com.swiftmq.jms.SwiftMQSession;
import com.swiftmq.jms.TemporaryQueueImpl;
import com.swiftmq.jms.TemporaryTopicImpl;
import com.swiftmq.jms.TextMessageImpl;
import com.swiftmq.jms.TopicImpl;
import com.swiftmq.jms.smqp.v750.AcknowledgeMessageRequest;
import com.swiftmq.jms.smqp.v750.AssociateMessageRequest;
import com.swiftmq.jms.smqp.v750.AsyncMessageDeliveryRequest;
import com.swiftmq.jms.smqp.v750.CloseSessionRequest;
import com.swiftmq.jms.smqp.v750.CommitReply;
import com.swiftmq.jms.smqp.v750.CommitRequest;
import com.swiftmq.jms.smqp.v750.CreateBrowserReply;
import com.swiftmq.jms.smqp.v750.CreateBrowserRequest;
import com.swiftmq.jms.smqp.v750.CreateConsumerReply;
import com.swiftmq.jms.smqp.v750.CreateConsumerRequest;
import com.swiftmq.jms.smqp.v750.CreateDurableReply;
import com.swiftmq.jms.smqp.v750.CreateDurableRequest;
import com.swiftmq.jms.smqp.v750.CreateProducerReply;
import com.swiftmq.jms.smqp.v750.CreateProducerRequest;
import com.swiftmq.jms.smqp.v750.CreatePublisherReply;
import com.swiftmq.jms.smqp.v750.CreatePublisherRequest;
import com.swiftmq.jms.smqp.v750.CreateSessionReply;
import com.swiftmq.jms.smqp.v750.CreateSessionRequest;
import com.swiftmq.jms.smqp.v750.CreateShadowConsumerRequest;
import com.swiftmq.jms.smqp.v750.CreateSubscriberReply;
import com.swiftmq.jms.smqp.v750.CreateSubscriberRequest;
import com.swiftmq.jms.smqp.v750.CreateTmpQueueReply;
import com.swiftmq.jms.smqp.v750.CreateTmpQueueRequest;
import com.swiftmq.jms.smqp.v750.DeleteDurableReply;
import com.swiftmq.jms.smqp.v750.DeleteDurableRequest;
import com.swiftmq.jms.smqp.v750.DeleteMessageRequest;
import com.swiftmq.jms.smqp.v750.RecoverSessionRequest;
import com.swiftmq.jms.smqp.v750.RollbackRequest;
import com.swiftmq.jms.smqp.v750.SMQPUtil;
import com.swiftmq.jms.v750.CloseConsumer;
import com.swiftmq.jms.v750.CloseSession;
import com.swiftmq.jms.v750.ConnectionConsumerImpl;
import com.swiftmq.jms.v750.ConnectionImpl;
import com.swiftmq.jms.v750.DurableTopicSubscriberImpl;
import com.swiftmq.jms.v750.MessageConsumerImpl;
import com.swiftmq.jms.v750.MessageProducerImpl;
import com.swiftmq.jms.v750.QueueBrowserImpl;
import com.swiftmq.jms.v750.QueueReceiverImpl;
import com.swiftmq.jms.v750.QueueSenderImpl;
import com.swiftmq.jms.v750.Recreatable;
import com.swiftmq.jms.v750.SessionVisitorAdapter;
import com.swiftmq.jms.v750.TopicPublisherImpl;
import com.swiftmq.jms.v750.TopicSubscriberImpl;
import com.swiftmq.jms.v750.TriggerConsumerInvocation;
import com.swiftmq.ms.MessageSelector;
import com.swiftmq.swiftlet.queue.MessageEntry;
import com.swiftmq.swiftlet.queue.MessageIndex;
import com.swiftmq.swiftlet.threadpool.AsyncTask;
import com.swiftmq.swiftlet.threadpool.ThreadPool;
import com.swiftmq.tools.collection.RingBuffer;
import com.swiftmq.tools.concurrent.Semaphore;
import com.swiftmq.tools.queue.SingleProcessorQueue;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRegistry;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.RequestService;
import com.swiftmq.tools.requestreply.ValidationException;
import com.swiftmq.util.SwiftUtilities;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SessionImpl
implements Session,
RequestService,
QueueSession,
TopicSession,
SwiftMQSession,
SessionExtended,
Recreatable,
RequestRetryValidator {
    public static final String DISPATCH_TOKEN = "sys$jms.client.session.sessiontask";
    static final int TYPE_SESSION = 0;
    static final int TYPE_QUEUE_SESSION = 1;
    static final int TYPE_TOPIC_SESSION = 2;
    static final boolean DEBUG = Boolean.valueOf(System.getProperty("swiftmq.reconnect.debug", "false"));
    public ConnectionImpl myConnection = null;
    volatile boolean ignoreClose = false;
    volatile boolean closed = false;
    boolean transacted = false;
    int acknowledgeMode = 0;
    volatile int dispatchId = 0;
    volatile int myDispatchId = 0;
    String clientId = null;
    RequestRegistry requestRegistry = null;
    String myHostname = null;
    String userName = null;
    ExceptionListener exceptionListener = null;
    Map consumerMap = new HashMap();
    List producers = new ArrayList();
    List browsers = new ArrayList();
    int lastConsumerId = -1;
    ArrayList transactedRequestList = new ArrayList();
    Set rollbackIdLog = new HashSet();
    Set currentTxLog = new HashSet();
    MessageListener messageListener = null;
    RingBuffer messageChunk = new RingBuffer(32);
    volatile boolean shadowConsumerCreated = false;
    MessageEntry lastMessage = null;
    boolean autoAssign = true;
    ThreadPool sessionPool = null;
    SessionDeliveryQueue sessionQueue = null;
    SessionTask sessionTask = null;
    volatile int recoveryEpoche = 0;
    volatile boolean recoveryInProgress = false;
    int type = 0;
    boolean useThreadContextCL = false;
    volatile boolean resetInProgress = false;
    ConnectionConsumerImpl connectionConsumer = null;
    volatile String shadowConsumerQueueName = null;
    List delayedClosedProducers = new ArrayList();
    volatile boolean withinOnMessage = false;
    MessageImpl onMessageMessage = null;
    MessageConsumerImpl onMessageConsumer = null;
    volatile boolean isRunning = false;
    boolean xaMode = false;
    volatile int minConnectionId = Integer.MAX_VALUE;
    volatile boolean txCancelled = false;
    volatile Semaphore blockSem = null;
    volatile boolean consumerDirty = false;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    protected SessionImpl(int type, ConnectionImpl myConnection, boolean transacted, int acknowledgeMode, int dispatchId, RequestRegistry requestRegistry, String myHostname, String clientId) {
        this.type = type;
        this.myConnection = myConnection;
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.dispatchId = dispatchId;
        this.requestRegistry = requestRegistry;
        this.myHostname = myHostname;
        this.clientId = clientId;
        this.sessionPool = PoolManager.getInstance().getSessionPool();
        this.useThreadContextCL = myConnection.isUseThreadContextCL();
        this.sessionTask = new SessionTask();
        this.sessionQueue = new SessionDeliveryQueue();
    }

    static String buildId(String uniqueConsumerId, MessageImpl msg) {
        String jmsMsgId = null;
        try {
            jmsMsgId = msg.getJMSMessageID();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        if (jmsMsgId == null) {
            return null;
        }
        StringBuffer id = new StringBuffer();
        id.append(uniqueConsumerId);
        id.append('-');
        id.append(jmsMsgId);
        return id.toString();
    }

    public void setBlocked(boolean blocked) {
        if (blocked) {
            this.blockSem = new Semaphore();
        } else if (this.blockSem != null) {
            this.blockSem.notifyAllWaiters();
        }
    }

    Reply requestBlockable(Request request) throws Exception {
        if (this.blockSem != null) {
            this.blockSem.waitHere();
        }
        return this.requestRegistry.request(request);
    }

    public void setRunning(boolean running) {
        this.lock.writeLock().lock();
        try {
            this.isRunning = running;
            if (!running) {
                this.clearMessageChunks();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setXaMode(boolean xaMode) {
        this.lock.writeLock().lock();
        try {
            this.xaMode = xaMode;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int getRecoveryEpoche() {
        return this.recoveryEpoche;
    }

    @Override
    public Request getRecreateRequest() {
        CreateSessionRequest request = null;
        switch (this.type) {
            case 0: {
                request = new CreateSessionRequest(0, this.transacted, this.acknowledgeMode, 2, this.recoveryEpoche);
                break;
            }
            case 1: {
                request = new CreateSessionRequest(0, this.transacted, this.acknowledgeMode, 0, this.recoveryEpoche);
                break;
            }
            case 2: {
                request = new CreateSessionRequest(0, this.transacted, this.acknowledgeMode, 1, this.recoveryEpoche);
            }
        }
        return request;
    }

    @Override
    public void setRecreateReply(Reply reply) {
        CreateSessionReply r = (CreateSessionReply)reply;
        this.dispatchId = r.getSessionDispatchId();
    }

    @Override
    public List getRecreatables() {
        int i;
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator iter = this.consumerMap.entrySet().iterator();
        while (iter.hasNext()) {
            list.add(iter.next().getValue());
        }
        for (i = 0; i < this.producers.size(); ++i) {
            list.add(this.producers.get(i));
        }
        for (i = 0; i < this.browsers.size(); ++i) {
            list.add(this.browsers.get(i));
        }
        if (this.shadowConsumerCreated) {
            list.add(new ShadowConsumerRecreator());
        }
        return list;
    }

    @Override
    public void validate(Request request) throws ValidationException {
        request.setDispatchId(this.dispatchId);
        if (request instanceof AcknowledgeMessageRequest || request instanceof AssociateMessageRequest || request instanceof DeleteMessageRequest || request instanceof RecoverSessionRequest || request instanceof RollbackRequest) {
            request.setCancelledByValidator(true);
        }
    }

    public boolean isTxCancelled() {
        return this.txCancelled;
    }

    public void setTxCancelled(boolean txCancelled) {
        this.txCancelled = txCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResetInProgress(boolean resetInProgress) {
        this.lock.writeLock().lock();
        try {
            this.resetInProgress = resetInProgress;
            if (DEBUG) {
                System.out.println(String.valueOf(new Date()) + " " + this.toString() + ", setResetInProgress=" + resetInProgress);
            }
            if (resetInProgress) {
                this.sessionQueue.stopQueue();
                this.sessionQueue.clear();
                this.sessionQueue.setCurrentCallInvalid(true);
                Iterator iter = this.consumerMap.entrySet().iterator();
                while (iter.hasNext()) {
                    MessageConsumerImpl c = (MessageConsumerImpl)iter.next().getValue();
                    c.clearCache();
                }
                this.clearMessageChunks();
            } else {
                if (DEBUG) {
                    System.out.println(String.valueOf(new Date()) + " " + this.toString() + ", setResetInProgress, c.size=" + String.valueOf(this.consumerMap) + ", recoveryInProgress=" + this.recoveryInProgress);
                }
                this.sessionQueue.clear();
                Iterator iterator = this.consumerMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = iterator.next();
                    MessageConsumerImpl c = (MessageConsumerImpl)entry.getValue();
                    if (DEBUG) {
                        System.out.println(String.valueOf(new Date()) + " " + this.toString() + ", setResetInProgress, c=" + String.valueOf(c) + ", recoveryInProgress=" + this.recoveryInProgress + ", started=" + c.isConsumerStarted() + ", fillCachePending=" + String.valueOf(c.fillCachePending) + ", closed=" + c.isClosed());
                    }
                    if (this.recoveryInProgress || !c.isConsumerStarted()) continue;
                    if (DEBUG) {
                        System.out.println(String.valueOf(new Date()) + " " + this.toString() + ", setResetInProgress, c=" + String.valueOf(c) + ", call fill cache");
                    }
                    c.fillCache(true);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setConnectionConsumer(ConnectionConsumerImpl connectionConsumer) {
        this.connectionConsumer = connectionConsumer;
    }

    void startSession() {
        if (this.messageListener == null) {
            this.sessionQueue.startQueue();
            this.sessionQueue.triggerInvocation();
        }
    }

    void stopSession() {
        this.sessionQueue.stopQueue();
    }

    boolean isSessionStarted() {
        return this.sessionQueue.isStarted();
    }

    String getUserName() {
        return this.userName;
    }

    void setUserName(String userName) {
        this.userName = userName;
    }

    public ConnectionImpl getMyConnection() {
        return this.myConnection;
    }

    void verifyState() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Session is closed");
        }
    }

    public boolean isIgnoreClose() {
        return this.ignoreClose;
    }

    @Override
    public void setIgnoreClose(boolean ignoreClose) {
        this.ignoreClose = ignoreClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTransactedMessage(MessageProducerImpl producer, MessageImpl msg) {
        this.lock.writeLock().lock();
        try {
            this.minConnectionId = Math.min(this.minConnectionId, this.myConnection.getConnectionId());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                msg.writeContent(dos);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.transactedRequestList.add(new Object[]{producer, bos.toByteArray()});
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Reply requestTransaction(CommitRequest req) {
        this.lock.writeLock().lock();
        try {
            req.setMessages((List)this.transactedRequestList.clone());
            this.transactedRequestList.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.requestRegistry.request(req);
    }

    public int getMinConnectionId() {
        return this.minConnectionId;
    }

    public List getAndClearCurrentTransaction() {
        this.lock.writeLock().lock();
        try {
            List clone = null;
            this.minConnectionId = Integer.MAX_VALUE;
            clone = (List)this.transactedRequestList.clone();
            this.transactedRequestList.clear();
            List list = clone;
            return list;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void dropTransaction() {
        this.lock.writeLock().lock();
        try {
            this.transactedRequestList.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    int getMyDispatchId() {
        return this.myDispatchId;
    }

    void setMyDispatchId(int myDispatchId) {
        this.myDispatchId = myDispatchId;
    }

    void addMessageConsumerImpl(MessageConsumerImpl consumer) {
        this.lock.writeLock().lock();
        try {
            if (this.lastConsumerId == Integer.MAX_VALUE) {
                this.lastConsumerId = -1;
            }
            ++this.lastConsumerId;
            this.consumerMap.put(new Integer(this.lastConsumerId), consumer);
            this.consumerDirty = true;
            consumer.setConsumerId(this.lastConsumerId);
            this.myConnection.increaseDuplicateLogSize(this.myConnection.getSmqpConsumerCacheSize());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void removeMessageConsumerImpl(MessageConsumerImpl consumer) {
        this.lock.writeLock().lock();
        try {
            this.consumerMap.remove(new Integer(consumer.getConsumerId()));
            this.myConnection.decreaseDuplicateLogSize(this.myConnection.getSmqpConsumerCacheSize());
            this.consumerDirty = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void addMessageProducerImpl(MessageProducerImpl producer) {
        this.lock.writeLock().lock();
        try {
            this.producers.add(producer);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void removeMessageProducerImpl(MessageProducerImpl producer) {
        this.lock.writeLock().lock();
        try {
            this.producers.remove(producer);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void addQueueBrowserImpl(QueueBrowserImpl browser) {
        this.lock.writeLock().lock();
        try {
            this.browsers.add(browser);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void removeQueueBrowserImpl(QueueBrowserImpl browser) {
        this.lock.writeLock().lock();
        try {
            this.browsers.remove(browser);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.verifyState();
        return this.createReceiver(queue, null);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        this.verifyState();
        if (queue == null) {
            throw new InvalidDestinationException("createReceiver, queue is null!");
        }
        if (queue instanceof TemporaryQueueImpl && !((TemporaryQueueImpl)queue).isCreatungSession(this)) {
            throw new JMSException("A receiver on a TemporaryQueue can only be created from the session the temporary queue was created from");
        }
        QueueReceiverImpl qr = null;
        CreateConsumerReply reply = null;
        try {
            String ms = messageSelector;
            if (messageSelector != null && messageSelector.trim().length() == 0) {
                ms = null;
            }
            if (ms != null) {
                MessageSelector msel = new MessageSelector(ms);
                msel.compile();
            }
            reply = (CreateConsumerReply)this.requestRegistry.request(new CreateConsumerRequest(this, this.dispatchId, (QueueImpl)queue, ms));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        int qcId = reply.getQueueConsumerId();
        qr = new QueueReceiverImpl(this.transacted, this.acknowledgeMode, this.requestRegistry, queue, messageSelector, this);
        qr.setServerQueueConsumerId(qcId);
        qr.setDoAck(!this.transacted && this.acknowledgeMode != 2);
        this.addMessageConsumerImpl(qr);
        return qr;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        this.verifyState();
        if (queue == null) {
            return new QueueSenderImpl(this, queue, -1, this.requestRegistry, this.myHostname);
        }
        QueueSenderImpl queueSender = null;
        CreateProducerReply reply = null;
        try {
            reply = (CreateProducerReply)this.requestRegistry.request(new CreateProducerRequest(this, this.dispatchId, (QueueImpl)queue));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        queueSender = new QueueSenderImpl(this, queue, reply.getQueueProducerId(), this.requestRegistry, this.myHostname);
        queueSender.setDestinationImpl((Destination)queue);
        this.addMessageProducerImpl(queueSender);
        return queueSender;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.createSubscriber(topic, null, false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.verifyState();
        if (topic == null) {
            throw new InvalidDestinationException("createSubscriber, topic is null!");
        }
        if (topic instanceof TemporaryTopicImpl && !((TemporaryTopicImpl)topic).isCreatingSession(this)) {
            throw new JMSException("A receiver on a TemporaryTopic can only be created from the session the temporary topic was created from");
        }
        TopicSubscriberImpl ts = null;
        CreateSubscriberReply reply = null;
        try {
            String ms = messageSelector;
            if (messageSelector != null && messageSelector.trim().length() == 0) {
                ms = null;
            }
            if (ms != null) {
                MessageSelector msel = new MessageSelector(ms);
                msel.compile();
            }
            reply = (CreateSubscriberReply)this.requestRegistry.request(new CreateSubscriberRequest(this, this.dispatchId, (TopicImpl)topic, ms, noLocal, true));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        int tsId = reply.getTopicSubscriberId();
        ts = new TopicSubscriberImpl(this.transacted, this.acknowledgeMode, this.requestRegistry, topic, messageSelector, this, noLocal);
        ts.setServerQueueConsumerId(tsId);
        ts.setDoAck(false);
        ts.setRecordLog(false);
        this.addMessageConsumerImpl(ts);
        return ts;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.verifyState();
        if (topic == null) {
            throw new InvalidDestinationException("createDurableSubscriber, topic is null!");
        }
        if (name == null) {
            throw new NullPointerException("createDurableSubscriber, name is null!");
        }
        if (this.myConnection.getClientID() == null) {
            throw new IllegalStateException("unable to create durable subscriber, no client ID has been set");
        }
        try {
            SwiftUtilities.verifyDurableName(name);
        }
        catch (Exception e) {
            throw new JMSException(e.getMessage());
        }
        DurableTopicSubscriberImpl ts = null;
        CreateDurableReply reply = null;
        try {
            String ms = messageSelector;
            if (messageSelector != null && messageSelector.trim().length() == 0) {
                ms = null;
            }
            if (ms != null) {
                MessageSelector msel = new MessageSelector(ms);
                msel.compile();
            }
            reply = (CreateDurableReply)this.requestRegistry.request(new CreateDurableRequest(this, this.dispatchId, (TopicImpl)topic, ms, noLocal, name));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        int tsId = reply.getTopicSubscriberId();
        ts = new DurableTopicSubscriberImpl(this.transacted, this.acknowledgeMode, this.requestRegistry, topic, messageSelector, this, noLocal, name);
        ts.setServerQueueConsumerId(tsId);
        ts.setDoAck(!this.transacted && this.acknowledgeMode != 2);
        this.addMessageConsumerImpl(ts);
        return ts;
    }

    public MessageConsumer createDurableConsumer(Topic topic, String s) throws JMSException {
        return null;
    }

    public MessageConsumer createDurableConsumer(Topic topic, String s, String s1, boolean b) throws JMSException {
        return null;
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String s) throws JMSException {
        return null;
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String s, String s1) throws JMSException {
        return null;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.verifyState();
        if (topic == null) {
            return new TopicPublisherImpl(this, topic, -1, this.requestRegistry, this.myHostname, this.clientId);
        }
        TopicPublisherImpl topicPublisher = null;
        CreatePublisherReply reply = null;
        try {
            reply = (CreatePublisherReply)this.requestRegistry.request(new CreatePublisherRequest(this, this.dispatchId, (TopicImpl)topic));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        topicPublisher = new TopicPublisherImpl(this, topic, reply.getTopicPublisherId(), this.requestRegistry, this.myHostname, this.clientId);
        topicPublisher.setDestinationImpl((Destination)topic);
        this.addMessageProducerImpl(topicPublisher);
        return topicPublisher;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (destination == null) {
            return this.createSender(null);
        }
        DestinationImpl destImpl = (DestinationImpl)destination;
        QueueSender producer = null;
        switch (destImpl.getType()) {
            case 0: 
            case 3: {
                producer = this.createSender((Queue)destination);
                break;
            }
            case 1: 
            case 2: {
                producer = this.createPublisher((Topic)destination);
            }
        }
        return producer;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null, false);
    }

    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        return this.createConsumer(destination, selector, false);
    }

    public MessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        if (destination == null) {
            throw new InvalidDestinationException("createConsumer, destination is null!");
        }
        DestinationImpl destImpl = (DestinationImpl)destination;
        QueueReceiver consumer = null;
        switch (destImpl.getType()) {
            case 0: 
            case 3: {
                consumer = this.createReceiver((Queue)destination, selector);
                break;
            }
            case 1: 
            case 2: {
                consumer = this.createSubscriber((Topic)destination, selector, noLocal);
            }
        }
        return consumer;
    }

    public MessageConsumer createSharedConsumer(Topic topic, String s) throws JMSException {
        return null;
    }

    public MessageConsumer createSharedConsumer(Topic topic, String s, String s1) throws JMSException {
        return null;
    }

    public Queue createQueue(String queueName) throws JMSException {
        this.verifyState();
        if (this.type == 2) {
            throw new IllegalStateException("Operation not allowed on this session type");
        }
        if (queueName == null) {
            throw new InvalidDestinationException("createQueue, queueName is null!");
        }
        return new QueueImpl(queueName);
    }

    public Topic createTopic(String topicName) throws JMSException {
        this.verifyState();
        if (this.type == 1) {
            throw new IllegalStateException("Operation not allowed on this session type");
        }
        if (topicName == null) {
            throw new InvalidDestinationException("createTopic, topicName is null!");
        }
        if (topicName.indexOf(64) != -1) {
            throw new InvalidDestinationException("Invalid character '@' in topic name! Hint: a topic name must NOT be qualified with the router name!");
        }
        return new TopicImpl(topicName);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.verifyState();
        if (this.type == 2) {
            throw new IllegalStateException("Operation not allowed on this session type");
        }
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        this.verifyState();
        if (this.type == 2) {
            throw new IllegalStateException("Operation not allowed on this session type");
        }
        if (queue == null) {
            throw new InvalidDestinationException("createBrowser, queue is null!");
        }
        QueueBrowserImpl queueBrowser = null;
        CreateBrowserReply reply = null;
        try {
            String ms = messageSelector;
            if (messageSelector != null && messageSelector.trim().length() == 0) {
                ms = null;
            }
            if (ms != null) {
                MessageSelector msel = new MessageSelector(ms);
                msel.compile();
            }
            reply = (CreateBrowserReply)this.requestRegistry.request(new CreateBrowserRequest(this, this.dispatchId, (QueueImpl)queue, ms));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        queueBrowser = new QueueBrowserImpl(this, queue, messageSelector, this.dispatchId, reply.getQueueBrowserId(), this.requestRegistry);
        this.addQueueBrowserImpl(queueBrowser);
        return queueBrowser;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.verifyState();
        if (this.type == 2) {
            throw new IllegalStateException("Operation not allowed on this session type");
        }
        TemporaryQueueImpl tempQueue = null;
        CreateTmpQueueReply reply = null;
        try {
            reply = (CreateTmpQueueReply)this.requestRegistry.request(new CreateTmpQueueRequest(this, 0));
            tempQueue = new TemporaryQueueImpl(reply.getQueueName(), this.myConnection);
            tempQueue.setCreatingSession(this);
            this.myConnection.addTmpQueue(tempQueue);
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        return tempQueue;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.verifyState();
        if (this.type == 1) {
            throw new IllegalStateException("Operation not allowed on this session type");
        }
        TemporaryTopicImpl tempTopic = null;
        CreateTmpQueueReply reply = null;
        try {
            reply = (CreateTmpQueueReply)this.requestRegistry.request(new CreateTmpQueueRequest(this, 0));
            tempTopic = new TemporaryTopicImpl(reply.getQueueName(), this.myConnection);
            tempTopic.setCreatingSession(this);
            this.myConnection.addTmpQueue(tempTopic);
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        return tempTopic;
    }

    public void unsubscribe(String name) throws JMSException {
        this.verifyState();
        if (this.type == 1) {
            throw new IllegalStateException("Operation not allowed on this session type");
        }
        if (name == null) {
            throw new NullPointerException("unsubscribe, name is null!");
        }
        DeleteDurableReply reply = null;
        try {
            reply = (DeleteDurableReply)this.requestRegistry.request(new DeleteDurableRequest(this, this.dispatchId, name));
        }
        catch (Exception e) {
            throw ExceptionConverter.convert(e);
        }
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
    }

    public int getAcknowledgeMode() throws JMSException {
        this.verifyState();
        return this.acknowledgeMode;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.verifyState();
        return new BytesMessageImpl();
    }

    public MapMessage createMapMessage() throws JMSException {
        this.verifyState();
        return new MapMessageImpl();
    }

    public Message createMessage() throws JMSException {
        this.verifyState();
        return new MessageImpl();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.verifyState();
        return new ObjectMessageImpl();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.verifyState();
        ObjectMessage msg = this.createObjectMessage();
        msg.setObject(object);
        return msg;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.verifyState();
        return new StreamMessageImpl();
    }

    public TextMessage createTextMessage() throws JMSException {
        this.verifyState();
        return new TextMessageImpl();
    }

    public TextMessage createTextMessage(String s) throws JMSException {
        this.verifyState();
        TextMessage msg = this.createTextMessage();
        msg.setText(s);
        return msg;
    }

    public boolean getTransacted() throws JMSException {
        this.verifyState();
        return this.transacted;
    }

    public void commit() throws JMSException {
        this.verifyState();
        if (this.transacted) {
            CommitReply reply = null;
            try {
                CommitRequest req = new CommitRequest(this, this.dispatchId);
                reply = (CommitReply)this.requestTransaction(req);
                this.txCancelled = req.isCancelledByValidator() || req.isWasRetry();
            }
            catch (Exception e) {
                throw ExceptionConverter.convert(e);
            }
            if (!reply.isOk()) {
                throw ExceptionConverter.convert(reply.getException());
            }
            this.afterCommit();
            long delay = reply.getDelay();
            if (delay > 0L) {
                try {
                    Thread.sleep(delay);
                }
                catch (Exception exception) {}
            }
        } else {
            throw new IllegalStateException("Session is not transacted - commit not allowed");
        }
    }

    void afterCommit() throws JMSException {
        this.closeDelayedProducers();
        this.addCurrentTxToDuplicateLog();
        this.removeCurrentTxFromRollbackLog();
        this.clearCurrentTxLog();
    }

    void delayClose(MessageProducerImpl producer) {
        this.delayedClosedProducers.add(producer);
    }

    void closeDelayedProducers() throws JMSException {
        for (int i = 0; i < this.delayedClosedProducers.size(); ++i) {
            ((MessageProducerImpl)this.delayedClosedProducers.get(i))._close(false);
        }
        this.delayedClosedProducers.clear();
    }

    void startRecoverConsumers() {
        this.lock.writeLock().lock();
        try {
            this.sessionQueue.stopQueue();
            this.recoveryInProgress = true;
            ++this.recoveryEpoche;
            Iterator iter = this.consumerMap.entrySet().iterator();
            while (iter.hasNext()) {
                MessageConsumerImpl c = (MessageConsumerImpl)iter.next().getValue();
                c.setWasRecovered(true);
                c.clearCache();
            }
            this.sessionQueue.clear();
            if (this.connectionConsumer != null && this.xaMode) {
                this.connectionConsumer.removeFromDuplicateLog(this.lastMessage.getMessage());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void endRecoverConsumers() {
        this.addCurrentTxToRollbackLog();
        this.clearCurrentTxLog();
        this.recoveryInProgress = false;
        if (!this.resetInProgress) {
            this.sessionQueue.startQueue();
            Iterator iter = this.consumerMap.entrySet().iterator();
            while (iter.hasNext()) {
                MessageConsumerImpl c = (MessageConsumerImpl)iter.next().getValue();
                if (!c.isConsumerStarted()) continue;
                c.fillCache(true);
            }
        }
    }

    void endRecoverConsumersXA() {
        this.addCurrentTxToRollbackLog();
        this.clearCurrentTxLog();
        this.recoveryInProgress = false;
        if (!this.resetInProgress && !this.txCancelled) {
            this.sessionQueue.startQueue();
            Iterator iter = this.consumerMap.entrySet().iterator();
            while (iter.hasNext()) {
                MessageConsumerImpl c = (MessageConsumerImpl)iter.next().getValue();
                if (!c.isConsumerStarted()) continue;
                c.fillCache(true);
            }
        }
    }

    public void rollback() throws JMSException {
        this.verifyState();
        if (this.transacted) {
            this.startRecoverConsumers();
            this.dropTransaction();
            Reply reply = null;
            try {
                RollbackRequest req = new RollbackRequest(this, this.dispatchId, this.recoveryEpoche);
                reply = this.requestRegistry.request(req);
                this.txCancelled = req.isCancelledByValidator();
            }
            catch (Exception e) {
                throw ExceptionConverter.convert(e);
            }
            if (!reply.isOk()) {
                throw ExceptionConverter.convert(reply.getException());
            }
        } else {
            throw new IllegalStateException("Session is not transacted - rollback not allowed");
        }
        this.endRecoverConsumers();
        this.closeDelayedProducers();
    }

    boolean isClosed() {
        return this.closed;
    }

    public void close() throws JMSException {
        if (this.closed) {
            return;
        }
        if (this.messageListener == null && !this.isSessionStarted()) {
            this._close();
            return;
        }
        CloseSession request = new CloseSession();
        request._sem = new Semaphore();
        if (this.messageListener == null) {
            this.serviceRequest(request);
        } else {
            this.addMessageChunk(request);
        }
        request._sem.waitHere(5000L);
        if (!request._sem.isNotified()) {
            this._close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _close() {
        if (this.ignoreClose || this.closed) {
            return;
        }
        this.sessionQueue.stopQueue();
        this.sessionQueue.clear();
        this.lock.writeLock().lock();
        try {
            this.closed = true;
            if (this.consumerMap.size() > 0) {
                this.myConnection.decreaseDuplicateLogSize(this.myConnection.getSmqpConsumerCacheSize() * this.consumerMap.size());
                for (Map.Entry o : this.consumerMap.entrySet()) {
                    MessageConsumerImpl consumer = (MessageConsumerImpl)o.getValue();
                    consumer.cancel();
                }
                this.consumerMap.clear();
            }
            this.consumerDirty = true;
            this.producers.clear();
            if (this.transacted) {
                this.dropTransaction();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        try {
            this.requestRegistry.request(new CloseSessionRequest(0, this.dispatchId));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myConnection.removeRequestService(this.myDispatchId);
        this.myConnection.removeSession(this);
    }

    void cancel() {
        this.closed = true;
        this.sessionQueue.stopQueue();
        this.sessionQueue.clear();
        Iterator iter = this.consumerMap.entrySet().iterator();
        while (iter.hasNext()) {
            MessageConsumerImpl consumer = (MessageConsumerImpl)iter.next().getValue();
            consumer.cancel();
        }
        this.consumerMap.clear();
        this.consumerDirty = true;
        this.producers.clear();
        if (this.transacted) {
            this.dropTransaction();
        }
    }

    public void recover() throws JMSException {
        this.verifyState();
        if (!this.transacted) {
            if (this.acknowledgeMode == 1 && this.withinOnMessage && this.onMessageConsumer != null && this.onMessageMessage != null) {
                this.onMessageConsumer.reportDelivered(this.onMessageMessage, false);
                this.onMessageConsumer = null;
            }
            this.startRecoverConsumers();
            Reply reply = null;
            try {
                RecoverSessionRequest req = new RecoverSessionRequest(this, this.dispatchId, this.recoveryEpoche);
                reply = this.requestRegistry.request(req);
                this.txCancelled = req.isCancelledByValidator();
            }
            catch (Exception e) {
                throw ExceptionConverter.convert(e);
            }
            if (!reply.isOk()) {
                throw ExceptionConverter.convert(reply.getException());
            }
        } else {
            throw new IllegalStateException("Session is transacted - recover not allowed");
        }
        this.endRecoverConsumers();
    }

    public MessageListener getMessageListener() throws JMSException {
        this.verifyState();
        return this.messageListener;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.lock.writeLock().lock();
        try {
            this.verifyState();
            this.messageListener = messageListener;
            if (messageListener != null) {
                this.sessionQueue.stopQueue();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    boolean isShadowConsumerCreated() {
        return this.shadowConsumerCreated;
    }

    void createShadowConsumer(String queueName) throws Exception {
        this.lock.writeLock().lock();
        try {
            this.shadowConsumerQueueName = queueName;
            Reply reply = this.requestRegistry.request(new CreateShadowConsumerRequest(this, this.dispatchId, queueName));
            if (!reply.isOk()) {
                throw reply.getException();
            }
            this.shadowConsumerCreated = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void addMessageChunk(Object obj) {
        this.lock.writeLock().lock();
        try {
            if (obj instanceof CloseSession && !this.isRunning) {
                this._close();
                ((CloseSession)obj)._sem.notifySingleWaiter();
                return;
            }
            this.messageChunk.add(obj);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void clearMessageChunks() {
        this.lock.writeLock().lock();
        try {
            this.messageChunk.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private MessageEntry nextMessageChunk() {
        this.lock.writeLock().lock();
        try {
            if (this.messageChunk.getSize() == 0) {
                MessageEntry messageEntry = null;
                return messageEntry;
            }
            Object o = this.messageChunk.remove();
            if (o instanceof CloseSession) {
                this._close();
                ((CloseSession)o)._sem.notifySingleWaiter();
                MessageEntry messageEntry = null;
                return messageEntry;
            }
            MessageEntry messageEntry = (MessageEntry)o;
            return messageEntry;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    boolean assignLastMessage() throws Exception {
        return this.assignLastMessage(false);
    }

    boolean assignLastMessage(boolean duplicate) throws Exception {
        if (this.lastMessage != null) {
            AssociateMessageRequest request = new AssociateMessageRequest(this, this.dispatchId, this.lastMessage.getMessageIndex(), duplicate);
            Reply reply = this.requestRegistry.request(request);
            if (!reply.isOk()) {
                throw reply.getException();
            }
            return request.isCancelledByValidator();
        }
        return false;
    }

    void deleteMessage(MessageEntry messageEntry, boolean fromReadTx) {
        DeleteMessageRequest request = new DeleteMessageRequest(this, this.dispatchId, this.lastMessage.getMessageIndex(), fromReadTx);
        this.requestRegistry.request(request);
    }

    void setAutoAssign(boolean autoAssign) {
        this.autoAssign = autoAssign;
    }

    @Override
    public boolean acknowledgeMessage(MessageIndex messageIndex) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Connection is closed");
        }
        AcknowledgeMessageRequest request = new AcknowledgeMessageRequest(this, this.dispatchId, 0, messageIndex);
        Reply reply = this.requestRegistry.request(request);
        if (!reply.isOk()) {
            throw ExceptionConverter.convert(reply.getException());
        }
        this.addCurrentTxToDuplicateLog();
        this.removeCurrentTxFromRollbackLog();
        this.clearCurrentTxLog();
        return request.isCancelledByValidator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.closed || this.resetInProgress) {
            return;
        }
        if (this.messageListener == null) {
            throw new RuntimeException("No MessageListener has been set!");
        }
        this.setRunning(true);
        while ((this.lastMessage = this.nextMessageChunk()) != null) {
            MessageImpl message = this.lastMessage.getMessage();
            String messageId = null;
            try {
                messageId = message.getJMSMessageID();
                this.connectionConsumer.markInProgress(message, messageId);
                if (this.closed || this.resetInProgress) {
                    this.setRunning(false);
                    return;
                }
                if (this.lastMessage.getConnectionId() != this.myConnection.getConnectionId()) continue;
                this.lastMessage.moveMessageAttributes();
                boolean cancelled = false;
                try {
                    if (this.autoAssign) {
                        cancelled = this.assignLastMessage();
                    }
                }
                catch (Exception e) {
                    this.setRunning(false);
                    this.connectionConsumer.unmarkInProgress(message, messageId);
                    return;
                }
                if (cancelled) {
                    this.setRunning(false);
                    return;
                }
                boolean duplicate = this.connectionConsumer.isDuplicate(message);
                if (this.autoAssign && duplicate) {
                    this.deleteMessage(this.lastMessage, this.acknowledgeMode != 2);
                    continue;
                }
                message.setSessionImpl(this);
                message.setReadOnly(true);
                message.reset();
                message.setUseThreadContextCL(this.useThreadContextCL);
                if (this.xaMode && duplicate) {
                    cancelled = this.assignLastMessage(true);
                    if (cancelled) {
                        this.connectionConsumer.removeFromDuplicateLog(message);
                    }
                } else {
                    this.withinOnMessage = true;
                    this.onMessageMessage = message;
                    this.messageListener.onMessage((Message)message);
                    this.onMessageMessage = null;
                    this.withinOnMessage = false;
                }
                if (!cancelled && !this.transacted && this.acknowledgeMode != 2 && (cancelled = this.acknowledgeMessage(this.lastMessage.getMessageIndex()))) {
                    this.setRunning(false);
                    return;
                }
            }
            catch (Exception e) {
                this.withinOnMessage = false;
                this.setRunning(false);
                return;
            }
            finally {
                this.connectionConsumer.unmarkInProgress(message, messageId);
                continue;
            }
            this.lastMessage = null;
        }
        this.setRunning(false);
    }

    void addCurrentTxLog(String id) {
        if (id != null) {
            this.currentTxLog.add(id);
        }
    }

    void clearCurrentTxLog() {
        this.currentTxLog.clear();
    }

    void addCurrentTxToDuplicateLog() {
        this.myConnection.addToDuplicateLog(this.currentTxLog);
    }

    void addCurrentTxToRollbackLog() {
        this.rollbackIdLog.addAll(this.currentTxLog);
    }

    void removeCurrentTxFromRollbackLog() {
        this.rollbackIdLog.removeAll(this.currentTxLog);
    }

    void addRollbackLogToDuplicateLog() {
        this.myConnection.addToDuplicateLog(this.rollbackIdLog);
    }

    boolean isDuplicate(String id) {
        if (id == null) {
            return false;
        }
        boolean duplicate = this.myConnection.isDuplicate(id);
        if (this.currentTxLog.contains(id)) {
            duplicate = true;
        } else if (this.rollbackIdLog.contains(id)) {
            duplicate = false;
        }
        return duplicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeliverMessage(AsyncMessageDeliveryRequest request) {
        this.lock.writeLock().lock();
        try {
            if (this.closed || this.resetInProgress || this.recoveryInProgress || request.getRecoveryEpoche() != this.recoveryEpoche) {
                return;
            }
            int consumerId = request.getListenerId();
            MessageConsumerImpl consumer = (MessageConsumerImpl)this.consumerMap.get(new Integer(consumerId));
            if (consumer != null) {
                if (SMQPUtil.isBulk(request)) {
                    AsyncMessageDeliveryRequest[] requests = SMQPUtil.createRequests(request);
                    consumer.addToCache(requests, request.isRequiresRestart());
                } else {
                    consumer.addToCache(request);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void triggerInvocation() {
        this.sessionQueue.triggerInvocation();
    }

    @Override
    public void serviceRequest(Request request) {
        this.sessionQueue.enqueue(request);
    }

    private class SessionDeliveryQueue
    extends SingleProcessorQueue {
        Visitor visitor;
        TriggerConsumerInvocation trigger;
        MessageConsumerImpl[] consumerCopy;
        boolean currentCallInvalid;

        public SessionDeliveryQueue() {
            super(100);
            this.visitor = new Visitor();
            this.trigger = new TriggerConsumerInvocation();
            this.consumerCopy = null;
            this.currentCallInvalid = false;
        }

        public boolean isCurrentCallInvalid() {
            return this.currentCallInvalid;
        }

        public void setCurrentCallInvalid(boolean currentCallInvalid) {
            this.currentCallInvalid = currentCallInvalid;
        }

        @Override
        protected void startProcessor() {
            if (!SessionImpl.this.closed) {
                SessionImpl.this.sessionPool.dispatchTask(SessionImpl.this.sessionTask);
            }
        }

        void triggerInvocation() {
            this.enqueue(this.trigger);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void copyConsumers() {
            SessionImpl.this.lock.readLock().lock();
            try {
                if (SessionImpl.this.consumerDirty) {
                    this.consumerCopy = new MessageConsumerImpl[SessionImpl.this.consumerMap.size()];
                    int i = 0;
                    for (Map.Entry o : SessionImpl.this.consumerMap.entrySet()) {
                        this.consumerCopy[i++] = (MessageConsumerImpl)o.getValue();
                    }
                    SessionImpl.this.consumerDirty = false;
                }
            }
            finally {
                SessionImpl.this.lock.readLock().unlock();
            }
        }

        private boolean valid() {
            return !SessionImpl.this.resetInProgress && !SessionImpl.this.recoveryInProgress && this.isStarted() && !SessionImpl.this.closed;
        }

        @Override
        protected boolean validateClearElement(Object obj) {
            return !(obj instanceof CloseSession) && !(obj instanceof CloseConsumer);
        }

        @Override
        protected void process(Object[] bulk, int n) {
            if (this.currentCallInvalid) {
                this.currentCallInvalid = false;
            }
            if (!this.valid()) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                ((Request)bulk[i]).accept(this.visitor);
                if (this.valid() && !this.currentCallInvalid) continue;
                return;
            }
            boolean moreToDeliver = false;
            this.copyConsumers();
            if (this.consumerCopy != null) {
                for (int i = 0; i < this.consumerCopy.length && this.valid(); ++i) {
                    MessageConsumerImpl c = this.consumerCopy[i];
                    boolean b = c.invokeConsumer();
                    if (!this.valid() || this.currentCallInvalid) {
                        return;
                    }
                    if (!b) continue;
                    moreToDeliver = true;
                }
            }
            if (moreToDeliver && this.valid()) {
                this.triggerInvocation();
            }
        }
    }

    private class SessionTask
    implements AsyncTask {
        private SessionTask() {
        }

        @Override
        public boolean isValid() {
            return !SessionImpl.this.closed;
        }

        @Override
        public String getDispatchToken() {
            return SessionImpl.DISPATCH_TOKEN;
        }

        @Override
        public String getDescription() {
            return SessionImpl.this.myConnection.myHostname + "/Session/SessionTask";
        }

        @Override
        public void run() {
            if (!SessionImpl.this.closed && SessionImpl.this.sessionQueue.dequeue()) {
                SessionImpl.this.sessionPool.dispatchTask(this);
            }
        }

        @Override
        public void stop() {
        }
    }

    private class ShadowConsumerRecreator
    implements Recreatable {
        private ShadowConsumerRecreator() {
        }

        @Override
        public Request getRecreateRequest() {
            return new CreateShadowConsumerRequest(SessionImpl.this, SessionImpl.this.dispatchId, SessionImpl.this.shadowConsumerQueueName);
        }

        @Override
        public void setRecreateReply(Reply reply) {
            if (reply.isOk()) {
                SessionImpl.this.shadowConsumerCreated = true;
            }
        }

        @Override
        public List getRecreatables() {
            return null;
        }
    }

    private class Visitor
    extends SessionVisitorAdapter {
        private Visitor() {
        }

        @Override
        public void visit(TriggerConsumerInvocation request) {
        }

        @Override
        public void visit(AsyncMessageDeliveryRequest req) {
            if (req.getConnectionId() == SessionImpl.this.myConnection.getConnectionId()) {
                SessionImpl.this.doDeliverMessage(req);
            }
        }

        @Override
        public void visit(CloseConsumer request) {
            try {
                MessageConsumerImpl c = (MessageConsumerImpl)SessionImpl.this.consumerMap.get(new Integer(request.getId()));
                if (c != null) {
                    c.close(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            request._sem.notifySingleWaiter();
        }

        @Override
        public void visit(CloseSession request) {
            SessionImpl.this._close();
            request._sem.notifySingleWaiter();
        }
    }
}

