/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jndi;

import com.swiftmq.jms.SwiftMQConnectionFactory;
import com.swiftmq.jndi.InitialContextFactoryImpl;
import com.swiftmq.jndi.StopRetryException;
import com.swiftmq.tools.concurrent.Semaphore;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class ReconnectContext
implements Context {
    List envList = null;
    int maxRetries = 0;
    long retryDelay = 0L;
    final AtomicReference<Context> current = new AtomicReference();
    final AtomicInteger currentPos = new AtomicInteger(-1);
    final AtomicBoolean closed = new AtomicBoolean(false);
    boolean debug = false;
    String connectURL = null;
    Semaphore waitSem = new Semaphore();

    public ReconnectContext(List envList, int maxRetries, long retryDelay) {
        this.envList = envList;
        this.maxRetries = maxRetries;
        this.retryDelay = retryDelay;
        new SwiftMQConnectionFactory();
        if (this.debug) {
            System.out.println(String.valueOf(new Date()) + " " + this.toString() + "/created: envList=" + String.valueOf(envList) + ", maxRetries=" + maxRetries + ", retryDelay=" + retryDelay);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private void reconnect() throws CommunicationException {
        if (this.debug) {
            System.out.println(String.valueOf(new Date()) + " " + this.toString() + "/reconnect, current=" + String.valueOf(this.current));
        }
        int retries = this.maxRetries;
        do {
            if (this.debug) {
                System.out.println(String.valueOf(new Date()) + " " + this.toString() + "/reconnect, current=" + String.valueOf(this.current) + ", retries=" + retries);
            }
            if (retries < this.maxRetries && this.retryDelay > 0L) {
                if (this.debug) {
                    System.out.println(String.valueOf(new Date()) + " " + this.toString() + "/reconnect, current=" + String.valueOf(this.current) + ", waiting " + this.retryDelay);
                }
                this.waitSem.waitHere(this.retryDelay);
                this.waitSem.reset();
                if (this.debug) {
                    System.out.println(String.valueOf(new Date()) + " " + this.toString() + "/reconnect, current=" + String.valueOf(this.current) + ", continue...");
                }
                if (this.closed.get()) {
                    return;
                }
            }
            if (this.current.get() != null) {
                try {
                    if (this.debug) {
                        System.out.println(String.valueOf(new Date()) + " " + this.toString() + "/reconnect, current=" + String.valueOf(this.current) + ", closing old one");
                    }
                    this.current.get().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.current.set(null);
            }
            if (this.currentPos.get() == this.envList.size() - 1) {
                this.currentPos.set(-1);
            }
            this.currentPos.getAndIncrement();
            try {
                if (this.debug) {
                    System.out.println(String.valueOf(new Date()) + " " + this.toString() + "/reconnect, current=" + String.valueOf(this.current) + ", trying: " + String.valueOf(this.envList.get(this.currentPos.get())));
                }
                this.current.set(new InitialContextFactoryImpl().getInitialContext((Hashtable)this.envList.get(this.currentPos.get())));
                if (this.current.get() != null) {
                    this.connectURL = (String)((Hashtable)this.envList.get(this.currentPos.get())).get("java.naming.provider.url");
                }
                if (!this.debug) continue;
                System.out.println(String.valueOf(new Date()) + " " + this.toString() + "/reconnect, connectURL=" + this.connectURL);
            }
            catch (Exception e) {
                if (!(e instanceof StopRetryException)) continue;
                throw new CommunicationException(e.getMessage());
            }
        } while (--retries > 0 && this.current.get() == null);
        if (this.current.get() == null) {
            throw new CommunicationException("Unable to connect, maximum retries (" + this.maxRetries + ") reached, giving up!");
        }
        if (this.debug) {
            System.out.println(String.valueOf(new Date()) + " " + this.toString() + "/reconnect done, current=" + String.valueOf(this.current));
        }
    }

    private Object runWrapped(Delegation delegation, Object[] parameters) throws NamingException {
        if (this.debug) {
            System.out.println(String.valueOf(new Date()) + " " + this.toString() + "/runWrapped, current=" + String.valueOf(this.current));
        }
        Object obj = null;
        do {
            if (this.current.get() == null) {
                this.reconnect();
            }
            if (this.current.get() == null) continue;
            try {
                if (this.debug) {
                    System.out.println(String.valueOf(new Date()) + " " + this.toString() + "/runWrapped, execute...");
                }
                obj = delegation.execute(parameters);
                if (!this.debug) continue;
                System.out.println(String.valueOf(new Date()) + " " + this.toString() + "/runWrapped, execute done, result=" + String.valueOf(obj));
            }
            catch (CommunicationException e) {
                if (this.debug) {
                    System.out.println(String.valueOf(new Date()) + " " + this.toString() + "/runWrapped, CommunicationException=" + String.valueOf(e));
                }
                this.current.set(null);
            }
            catch (NamingException e1) {
                if (!this.debug) continue;
                System.out.println(String.valueOf(new Date()) + " " + this.toString() + "/runWrapped, NamingException=" + String.valueOf(e1));
            }
        } while (!this.closed.get() && this.current.get() == null);
        if (this.debug) {
            System.out.println(String.valueOf(new Date()) + " " + this.toString() + "/runWrapped, returning=" + String.valueOf(obj));
        }
        return obj;
    }

    public String getConnectURL() {
        return this.connectURL;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.get(0));
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.get().lookup((String)parameter[0]);
            }
        }, new Object[]{name});
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.get(0), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                ReconnectContext.this.current.get().bind((String)parameter[0], parameter[1]);
                return null;
            }
        }, new Object[]{name, obj});
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.get(0), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                ReconnectContext.this.current.get().rebind((String)parameter[0], parameter[1]);
                return null;
            }
        }, new Object[]{name, obj});
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.get(0));
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                ReconnectContext.this.current.get().unbind((String)parameter[0]);
                return null;
            }
        }, new Object[]{name});
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.get(0), newName.get(0));
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                ReconnectContext.this.current.get().rename((String)parameter[0], (String)parameter[1]);
                return null;
            }
        }, new Object[]{oldName, newName});
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.get(0));
    }

    public NamingEnumeration list(String name) throws NamingException {
        return (NamingEnumeration)this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.get().list((String)parameter[0]);
            }
        }, new Object[]{name});
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.get(0));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return (NamingEnumeration)this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.get().listBindings((String)parameter[0]);
            }
        }, new Object[]{name});
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.get(0));
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                ReconnectContext.this.current.get().destroySubcontext((String)parameter[0]);
                return null;
            }
        }, new Object[]{name});
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.get(0));
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return (Context)this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.get().createSubcontext((String)parameter[0]);
            }
        }, new Object[]{name});
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.get(0));
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.get().lookupLink((String)parameter[0]);
            }
        }, new Object[]{name});
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.get(0));
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return (NameParser)this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.get().getNameParser((String)parameter[0]);
            }
        }, new Object[]{name});
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return (Name)this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.get().composeName((Name)parameter[0], (Name)parameter[1]);
            }
        }, new Object[]{name, prefix});
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return (String)this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.get().composeName((String)parameter[0], (String)parameter[1]);
            }
        }, new Object[]{name, prefix});
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.get().addToEnvironment((String)parameter[0], (String)parameter[1]);
            }
        }, new Object[]{propName, propVal});
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.get().removeFromEnvironment((String)parameter[0]);
            }
        }, new Object[]{propName});
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.get().getEnvironment();
            }
        }, null);
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return (String)this.runWrapped(new Delegation(){

            @Override
            public Object execute(Object[] parameter) throws NamingException {
                return ReconnectContext.this.current.get().getNameInNamespace();
            }
        }, null);
    }

    @Override
    public void close() throws NamingException {
        this.closed.set(true);
        if (this.current.get() != null) {
            this.current.get().close();
        }
        this.current.set(null);
        this.waitSem.notifySingleWaiter();
    }

    public String toString() {
        return "[ReconnectContext, closed=" + String.valueOf(this.closed) + "]";
    }

    private static interface Delegation {
        public Object execute(Object[] var1) throws NamingException;
    }
}

