/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jndi.fs;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.Dom4JDriver;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public class ContextImpl
implements Context,
Serializable,
NameParser {
    File contextDir = null;
    XStream xStream = null;

    ContextImpl(File contextDir) {
        this.contextDir = contextDir;
        this.xStream = new XStream((HierarchicalStreamDriver)new Dom4JDriver());
        this.xStream.addPermission(AnyTypePermission.ANY);
        this.xStream.allowTypesByWildcard(new String[]{".*"});
    }

    @Override
    public Name parse(String s) throws NamingException {
        return new CompositeName(s);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.get(0));
    }

    @Override
    public Object lookup(String s) throws NamingException {
        if (s == null || s.equals("") || s.equals("/")) {
            return this;
        }
        Object o = null;
        File file = new File(this.contextDir, s + ".xml");
        if (file.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                o = this.xStream.fromXML((Reader)bufferedReader);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return o;
    }

    @Override
    public void bind(Name name, Object o) throws NamingException {
        this.bind(name.get(0), o);
    }

    @Override
    public void bind(String s, Object o) throws NamingException {
        try {
            File file = new File(this.contextDir, s + ".xml");
            if (file.exists()) {
                throw new NameAlreadyBoundException("Name already bound: " + s);
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            this.xStream.toXML(o, (Writer)bufferedWriter);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException e) {
            throw new NamingException(e.toString());
        }
    }

    @Override
    public void rebind(Name name, Object o) throws NamingException {
        this.rebind(name.get(0), o);
    }

    @Override
    public void rebind(String s, Object o) throws NamingException {
        this.unbind(s);
        this.bind(s, o);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.get(0));
    }

    @Override
    public void unbind(String s) throws NamingException {
        File file = new File(this.contextDir, s + ".xml");
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public void rename(Name name, Name name1) throws NamingException {
        this.rename(name.get(0), name1.get(0));
    }

    @Override
    public void rename(String s, String s1) throws NamingException {
        File file = new File(this.contextDir, s + ".xml");
        if (!file.exists()) {
            throw new NameNotFoundException("Name not found: " + s);
        }
        file.renameTo(new File(s1 + ".xml"));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String s) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String s) throws NamingException {
        return null;
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
    }

    @Override
    public void destroySubcontext(String s) throws NamingException {
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this;
    }

    @Override
    public Context createSubcontext(String s) throws NamingException {
        return this;
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public Object lookupLink(String s) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this;
    }

    @Override
    public NameParser getNameParser(String s) throws NamingException {
        return this;
    }

    @Override
    public Name composeName(Name name, Name name1) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public String composeName(String s, String s1) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public Object addToEnvironment(String s, Object o) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public Object removeFromEnvironment(String s) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }
}

