/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jndi.fs;

import com.swiftmq.jndi.fs.ContextImpl;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public class InitialContextFactoryImpl
implements InitialContextFactory,
Serializable {
    public Context getInitialContext(Hashtable env) throws NamingException {
        if (env == null) {
            throw new NamingException("Environment is null");
        }
        String dirName = (String)env.get("java.naming.provider.url");
        if (dirName == null) {
            throw new NamingException("Missing environment property java.naming.provider.url");
        }
        try {
            File dir = new File(new URI(dirName));
            if (!dir.exists()) {
                throw new NamingException("Directory does not exist: " + dirName);
            }
            return new ContextImpl(dir);
        }
        catch (URISyntaxException e) {
            throw new NamingException(e.getMessage());
        }
    }
}

