/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jndi.v400;

import com.swiftmq.client.Versions;
import com.swiftmq.jms.BytesMessageImpl;
import com.swiftmq.jms.InvalidVersionException;
import com.swiftmq.jms.MessageImpl;
import com.swiftmq.jms.ObjectMessageImpl;
import com.swiftmq.jms.QueueImpl;
import com.swiftmq.jms.SwiftMQConnection;
import com.swiftmq.jms.SwiftMQConnectionFactory;
import com.swiftmq.jms.SwiftMQMessageConsumer;
import com.swiftmq.jms.TemporaryQueueImpl;
import com.swiftmq.jms.TemporaryTopicImpl;
import com.swiftmq.jndi.StopRetryException;
import com.swiftmq.jndi.protocol.v400.BindRequest;
import com.swiftmq.jndi.protocol.v400.JNDIRequest;
import com.swiftmq.jndi.protocol.v400.LookupRequest;
import com.swiftmq.jndi.protocol.v400.RebindRequest;
import com.swiftmq.jndi.protocol.v400.UnbindRequest;
import com.swiftmq.jndi.v400.JNDIInfo;
import com.swiftmq.jndi.v400.URLParser;
import com.swiftmq.tools.dump.Dumpalizer;
import com.swiftmq.tools.timer.TimerEvent;
import com.swiftmq.tools.timer.TimerListener;
import com.swiftmq.tools.timer.TimerRegistry;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import com.swiftmq.tools.versioning.Versionable;
import com.swiftmq.tools.versioning.Versioned;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public class ContextImpl
implements Context,
Serializable,
AutoCloseable,
TimerListener {
    Hashtable env = null;
    JNDIInfo jndiInfo = null;
    ConnectionFactory cf = null;
    final AtomicReference<Connection> connection = new AtomicReference();
    final AtomicReference<Session> session = new AtomicReference();
    final AtomicReference<MessageProducer> producer = new AtomicReference();
    final AtomicBoolean closed = new AtomicBoolean(true);
    boolean debug = false;
    final AtomicLong lastAccessTime = new AtomicLong();
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public ContextImpl(Hashtable env) throws NamingException {
        this.env = env;
        String url = (String)env.get("java.naming.provider.url");
        if (url == null) {
            throw new NamingException("missing JNDI environment property: Context.PROVIDER_URL (java.naming.provider.url)");
        }
        this.jndiInfo = URLParser.parseURL(url);
        this.debug = this.jndiInfo.isDebug();
        HashMap<String, String> props = new HashMap<String, String>();
        if (this.jndiInfo.isIntraVM()) {
            try {
                props.put("intravm", "true");
            }
            catch (Exception e) {
                throw new NamingException("unable to connect, exception = " + String.valueOf(e));
            }
        }
        String factoryClass = this.jndiInfo.getFactory();
        try {
            Class.forName(factoryClass);
        }
        catch (Exception e) {
            throw new NamingException("socket factory not found: " + factoryClass);
        }
        try {
            props.put("socketfactory", factoryClass);
            props.put("hostname", this.jndiInfo.getHostname());
            props.put("port", String.valueOf(this.jndiInfo.getPort()));
            props.put("keepaliveinterval", String.valueOf(this.jndiInfo.getKeepalive()));
        }
        catch (Exception e) {
            throw new NamingException("unable to connect, exception = " + String.valueOf(e));
        }
        try {
            this.cf = SwiftMQConnectionFactory.create(props);
            this.createConnection();
            if (this.jndiInfo.getIdleclose() > 0L) {
                TimerRegistry.Singleton().addTimerListener(1000L, (TimerListener)this);
            }
            this.closed.set(false);
        }
        catch (Exception e) {
            if (this.connection.get() != null) {
                try {
                    this.connection.get().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.closed.set(true);
            if (e instanceof JMSSecurityException || e instanceof InvalidVersionException) {
                throw new StopRetryException(e.getMessage());
            }
            throw new NamingException("unable to connect, exception = " + String.valueOf(e));
        }
    }

    private void createConnection() throws JMSException {
        this.connection.set(this.cf.createConnection(this.jndiInfo.getUsername(), this.jndiInfo.getPassword()));
        this.session.set(this.connection.get().createSession(false, 0));
        this.producer.set(this.session.get().createProducer(null));
        this.connection.get().start();
        this.lastAccessTime.set(System.currentTimeMillis());
        if (this.debug) {
            System.out.println(String.valueOf(new Date()) + " " + this.toString() + "/createConnection: " + String.valueOf(this.env.get("java.naming.provider.url")));
        }
    }

    private void checkConnection() throws JMSException {
        this.lock.writeLock().lock();
        try {
            if (!this.closed.get() && this.connection.get() == null) {
                this.createConnection();
            }
            this.lastAccessTime.set(System.currentTimeMillis());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void performTimeAction(TimerEvent evt) {
        long delta = System.currentTimeMillis() - this.lastAccessTime.get() - this.jndiInfo.getIdleclose();
        if (this.debug) {
            System.out.println(String.valueOf(new Date()) + " " + this.toString() + "/performTimeAction, connection=" + String.valueOf(this.connection) + ", delta=" + delta + ", lastAccessTime=" + String.valueOf(this.lastAccessTime));
        }
        if (this.connection.get() != null && this.lastAccessTime.get() + this.jndiInfo.getIdleclose() < System.currentTimeMillis()) {
            if (this.debug) {
                System.out.println(String.valueOf(new Date()) + " " + this.toString() + "/createConnection, close connection (idle close)");
            }
            ((SwiftMQConnection)this.connection.get()).cancel(true);
            this.connection.set(null);
        }
    }

    @Override
    public Object addToEnvironment(String name, Object value) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    private Versioned createVersioned(int version, JNDIRequest request) throws Exception {
        DataByteArrayOutputStream dos = new DataByteArrayOutputStream();
        Dumpalizer.dump(dos, request);
        return new Versioned(version, dos.getBuffer(), dos.getCount());
    }

    private BytesMessageImpl createMessage(Versionable versionable, Destination replyTo) throws Exception {
        BytesMessageImpl msg = new BytesMessageImpl();
        versionable.transferToMessage(msg);
        if (replyTo != null) {
            msg.setJMSReplyTo(replyTo);
        }
        return msg;
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        if (this.closed.get()) {
            throw new NamingException("context is closed!");
        }
        if (!(obj instanceof TemporaryTopicImpl) && !(obj instanceof TemporaryQueueImpl)) {
            throw new OperationNotSupportedException("bind is only supported for TemporaryQueues/TemporaryTopics!");
        }
        try {
            this.checkConnection();
            TemporaryTopic tt = this.session.get().createTemporaryTopic();
            MessageConsumer consumer = this.session.get().createConsumer((Destination)tt);
            Versionable versionable = new Versionable();
            versionable.addVersioned(400, this.createVersioned(400, new BindRequest(name, (QueueImpl)obj)), "com.swiftmq.jndi.protocol.v400.JNDIRequestFactory");
            BytesMessageImpl request = this.createMessage(versionable, (Destination)tt);
            this.producer.get().send((Destination)this.session.get().createTopic("swiftmq.jndi"), (Message)request, 1, 9, 0L);
            TextMessage reply = (TextMessage)consumer.receive();
            String text = reply.getText();
            consumer.close();
            tt.delete();
            if (text != null) {
                throw new Exception(text);
            }
        }
        catch (Exception e) {
            throw new NamingException("exception occurred during bind: " + String.valueOf(e));
        }
    }

    @Override
    public void bind(Name p0, Object p1) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public void close() throws NamingException {
        try {
            if (this.connection.get() != null) {
                if (this.debug) {
                    System.out.println(String.valueOf(new Date()) + " " + this.toString() + "/close");
                }
                this.connection.get().close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.jndiInfo.isIntraVM() && this.jndiInfo.getIdleclose() > 0L) {
            TimerRegistry.Singleton().removeTimerListener(1000L, (TimerListener)this);
        }
        this.closed.set(true);
    }

    @Override
    public String composeName(String p0, String p1) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public Name composeName(Name p0, Name p1) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public Context createSubcontext(String p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public Context createSubcontext(Name p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public void destroySubcontext(String p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public void destroySubcontext(Name p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public NameParser getNameParser(String p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public NameParser getNameParser(Name p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    public NamingEnumeration list(String p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    public NamingEnumeration list(Name p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    public NamingEnumeration listBindings(String p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    public NamingEnumeration listBindings(Name p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    private Destination getLookupDestination(Session session) throws JMSException {
        if (Versions.JMS_CURRENT < 630) {
            return session.createTopic("swiftmq.jndi");
        }
        return session.createQueue("sys$jndi");
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (this.closed.get()) {
            throw new NamingException("context is closed!");
        }
        if (name == null) {
            throw new OperationNotSupportedException("context cloning is not supported!");
        }
        boolean connectionClosed = false;
        Object obj = null;
        try {
            this.checkConnection();
            TemporaryQueue tq = this.session.get().createTemporaryQueue();
            MessageConsumer consumer = this.session.get().createConsumer((Destination)tq);
            Versionable versionable = new Versionable();
            versionable.addVersioned(400, this.createVersioned(400, new LookupRequest(name)), "com.swiftmq.jndi.protocol.v400.JNDIRequestFactory");
            BytesMessageImpl request = this.createMessage(versionable, (Destination)tq);
            this.producer.get().send(this.getLookupDestination(this.session.get()), (Message)request, 1, 9, 0L);
            MessageImpl reply = null;
            reply = this.jndiInfo.getTimeout() == 0L ? (MessageImpl)consumer.receive() : (MessageImpl)consumer.receive(this.jndiInfo.getTimeout());
            if (reply != null) {
                if (reply instanceof ObjectMessageImpl) {
                    obj = ((ObjectMessageImpl)reply).getObject();
                } else {
                    BytesMessageImpl msg = (BytesMessageImpl)reply;
                    Versionable vreply = Versionable.toVersionable(msg);
                    vreply.selectVersions(Versions.cutAfterIndex(Versions.getSelectedIndex(Versions.JMS_CURRENT, Versions.JMS), Versions.JMS));
                    obj = vreply.createVersionedObject();
                }
            }
            if (!((SwiftMQMessageConsumer)consumer).isClosed()) {
                consumer.close();
                tq.delete();
            } else {
                connectionClosed = true;
            }
        }
        catch (Exception e) {
            throw new CommunicationException("exception occurred during lookup: " + String.valueOf(e));
        }
        if (connectionClosed) {
            throw new CommunicationException("Connection lost!");
        }
        if (obj == null) {
            throw new NameNotFoundException("Name '" + name + "' not found (timeout occured)!");
        }
        return obj;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.get(0));
    }

    @Override
    public Object lookupLink(String p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public Object lookupLink(Name p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        if (this.closed.get()) {
            throw new NamingException("context is closed!");
        }
        if (!(obj instanceof TemporaryTopicImpl) && !(obj instanceof TemporaryQueueImpl)) {
            throw new OperationNotSupportedException("rebind is only supported for TemporaryQueues/TemporaryTopics!");
        }
        try {
            this.checkConnection();
            TemporaryTopic tt = this.session.get().createTemporaryTopic();
            MessageConsumer consumer = this.session.get().createConsumer((Destination)tt);
            Versionable versionable = new Versionable();
            versionable.addVersioned(400, this.createVersioned(400, new RebindRequest(name, (QueueImpl)obj)), "com.swiftmq.jndi.protocol.v400.JNDIRequestFactory");
            BytesMessageImpl request = this.createMessage(versionable, (Destination)tt);
            this.producer.get().send((Destination)this.session.get().createTopic("swiftmq.jndi"), (Message)request, 1, 9, 0L);
            TextMessage reply = (TextMessage)consumer.receive();
            String text = reply.getText();
            consumer.close();
            tt.delete();
            if (text != null) {
                throw new Exception(text);
            }
        }
        catch (Exception e) {
            throw new NamingException("exception occurred during rebind: " + String.valueOf(e));
        }
    }

    @Override
    public void rebind(Name p0, Object p1) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public Object removeFromEnvironment(String p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public void rename(String p0, String p1) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public void rename(Name p0, Name p1) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }

    @Override
    public void unbind(String name) throws NamingException {
        if (this.closed.get()) {
            throw new NamingException("context is closed!");
        }
        try {
            this.checkConnection();
            Versionable versionable = new Versionable();
            versionable.addVersioned(400, this.createVersioned(400, new UnbindRequest(name)), "com.swiftmq.jndi.protocol.v400.JNDIRequestFactory");
            BytesMessageImpl request = this.createMessage(versionable, null);
            this.producer.get().send((Destination)this.session.get().createTopic("swiftmq.jndi"), (Message)request, 1, 9, 0L);
        }
        catch (Exception e) {
            throw new NamingException("exception occurred during unbind: " + String.valueOf(e));
        }
    }

    @Override
    public void unbind(Name p0) throws NamingException {
        throw new OperationNotSupportedException("not supported");
    }
}

