/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.jndi.v400;

import java.io.Serializable;

public class JNDIInfo
implements Serializable {
    String username;
    String password;
    String hostname;
    int port;
    String factory;
    long timeout;
    long keepalive;
    long idleclose;
    boolean intraVM = false;
    boolean reconnect = false;
    long reconnectDelay = 0L;
    int maxRetries = 0;
    String hostname2 = null;
    int port2 = 0;
    boolean debug = false;
    boolean hasParameters = false;

    protected JNDIInfo(String username, String password, String hostname, int port, String factory, long timeout, long keepalive, long idleclose, boolean intraVM, boolean reconnect, long reconnectDelay, int maxRetries, String hostname2, int port2, boolean debug, boolean hasParameters) {
        this.username = username;
        this.password = password;
        this.hostname = hostname;
        this.port = port;
        this.factory = factory;
        this.timeout = timeout;
        this.keepalive = keepalive;
        this.idleclose = idleclose;
        this.intraVM = intraVM;
        this.reconnect = reconnect;
        this.reconnectDelay = reconnectDelay;
        this.maxRetries = maxRetries;
        this.hostname2 = hostname2;
        this.port2 = port2;
        this.debug = debug;
        this.hasParameters = hasParameters;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getFactory() {
        return this.factory;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getKeepalive() {
        return this.keepalive;
    }

    public long getIdleclose() {
        return this.idleclose;
    }

    public boolean isIntraVM() {
        return this.intraVM;
    }

    public boolean isReconnect() {
        return this.reconnect;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public String getHostname2() {
        return this.hostname2;
    }

    public int getPort2() {
        return this.port2;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String getProviderURL(String host, int port) {
        StringBuffer b = new StringBuffer("smqp://");
        if (this.username != null) {
            b.append(this.username);
            if (this.password != null) {
                b.append(":");
                b.append(this.password);
            }
            b.append("@");
        }
        if (host.equals("intravm")) {
            b.append("intravm");
        } else {
            b.append(host);
            b.append(":");
            b.append(port);
            if (this.hasParameters) {
                b.append("/");
                boolean semiRequired = false;
                if (this.factory != null) {
                    b.append("type=");
                    b.append(this.factory);
                    semiRequired = true;
                }
                if (this.timeout != 0L) {
                    if (semiRequired) {
                        b.append(";");
                    }
                    b.append("timeout=");
                    b.append(this.timeout);
                    semiRequired = true;
                }
                if (this.keepalive != 0L) {
                    if (semiRequired) {
                        b.append(";");
                    }
                    b.append("keepalive=");
                    b.append(this.keepalive);
                    semiRequired = true;
                }
                if (this.idleclose != 0L) {
                    if (semiRequired) {
                        b.append(";");
                    }
                    b.append("idleclose=");
                    b.append(this.idleclose);
                }
            }
        }
        return b.toString();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[JNDIInfo, username=");
        s.append(this.username);
        s.append(", password=");
        s.append(this.password);
        s.append(", hostname=");
        s.append(this.hostname);
        s.append(", port=");
        s.append(this.port);
        s.append(", factory=");
        s.append(this.factory);
        s.append(", timeout=");
        s.append(this.timeout);
        s.append(", keepalive=");
        s.append(this.keepalive);
        s.append(", idleclose=");
        s.append(this.idleclose);
        s.append(", intraVM=");
        s.append(this.intraVM);
        s.append(", reconnect=");
        s.append(this.reconnect);
        s.append(", reconnectDelay=");
        s.append(this.reconnectDelay);
        s.append(", maxRetries=");
        s.append(this.maxRetries);
        s.append(", hostname2=");
        s.append(this.hostname2);
        s.append(", port2=");
        s.append(this.port2);
        s.append(", debug=");
        s.append(this.debug);
        s.append(", hasParameters=");
        s.append(this.hasParameters);
        s.append("]");
        return s.toString();
    }
}

